/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.dao.IndexDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.AssertionCodes;
import au.org.ala.biocache.dto.BreakdownRequestDTO;
import au.org.ala.biocache.dto.DataProviderCountDTO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadHeaders;
import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.biocache.dto.ErrorCode;
import au.org.ala.biocache.dto.FacetDTO;
import au.org.ala.biocache.dto.FacetPivotResultDTO;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FacetThemes;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.FieldStatsItem;
import au.org.ala.biocache.dto.HeatmapDTO;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.dto.OccurrencePoint;
import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.dto.RecordJackKnifeStats;
import au.org.ala.biocache.dto.SearchRequestDTO;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SensitiveOccurrenceIndex;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.dto.TaxaRankCountDTO;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.ListsService;
import au.org.ala.biocache.service.SpeciesCountsService;
import au.org.ala.biocache.service.SpeciesImageService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.stream.EndemicFacet;
import au.org.ala.biocache.stream.ProcessDownload;
import au.org.ala.biocache.stream.ProcessInterface;
import au.org.ala.biocache.stream.StreamFacet;
import au.org.ala.biocache.stream.StreamTaxaAsCSV;
import au.org.ala.biocache.stream.StreamTaxaAsTSVCircle;
import au.org.ala.biocache.stream.StreamTaxaCount;
import au.org.ala.biocache.util.CollectionsCache;
import au.org.ala.biocache.util.ColorUtil;
import au.org.ala.biocache.util.DownloadCallable;
import au.org.ala.biocache.util.DownloadFields;
import au.org.ala.biocache.util.LegendItem;
import au.org.ala.biocache.util.OccurrenceUtils;
import au.org.ala.biocache.util.QidMissingException;
import au.org.ala.biocache.util.QueryFormatUtils;
import au.org.ala.biocache.util.RangeBasedFacets;
import au.org.ala.biocache.util.RecordWriter;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.biocache.util.solr.FieldMappingUtil;
import au.org.ala.biocache.writer.CSVRecordWriter;
import au.org.ala.biocache.writer.TSVRecordWriter;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.PivotField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;

@Component(value="searchDao")
public class SearchDAOImpl
implements SearchDAO {
    private static final Logger logger = Logger.getLogger(SearchDAOImpl.class);
    public static final String DECADE_FACET_START_DATE = "1850-01-01T00:00:00Z";
    public static final String DECADE_PRE_1850_LABEL = "before";
    public static final String SOLR_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    @Inject
    protected IndexDAO indexDao;
    @Inject
    protected OccurrenceUtils occurrenceUtils;
    @Value(value="${download.max:500000}")
    public Integer MAX_DOWNLOAD_SIZE = 500000;
    @Value(value="${solr.export.handler.threshold:10000}")
    public Integer EXPORT_THRESHOLD = 10000;
    @Value(value="${download.throttle.ms:50}")
    protected Integer throttle = 50;
    @Value(value="${download.batch.size:500}")
    protected Integer downloadBatchSize = 500;
    @Value(value="${download.internal.queue.size:100}")
    protected Integer resultsQueueLength;
    @Value(value="${download.max.execute.time:604800000}")
    protected Long downloadMaxTime = 604800000L;
    @Value(value="${download.max.completion.time:300000}")
    protected Long downloadMaxCompletionTime = 300000L;
    @Value(value="${download.excluded.misc.fields:_root_,geospatialIssues,assertions,geohash,label,lat_long,lft,names_and_lsid,nick,null,packedQuad,point-0.0001,point-0.001,point-0.01,point-0.02,point-0.1,point-1,quad,rgt,aust_conservation,state_conservation,species_group,species_subgroup}")
    protected String downloadExcludedMiscFields;
    protected Pattern clpField = Pattern.compile("(,|^)cl.p(,|$)");
    protected Pattern elpField = Pattern.compile("(,|^)el.p(,|$)");
    protected Pattern allDwcField = Pattern.compile("(,|^)allDwc(,|$)");
    @Value(value="${download.unzipped.limit:10000}")
    public Integer unzippedLimit;
    protected DownloadFields downloadFields;
    @Inject
    protected SearchUtils searchUtils;
    @Inject
    protected QueryFormatUtils queryFormatUtils;
    @Inject
    public FieldMappingUtil fieldMappingUtil;
    @Inject
    public CollectionsCache collectionCache;
    @Inject
    public AbstractMessageSource messageSource;
    @Inject
    public SpeciesLookupService speciesLookupService;
    @Inject
    protected AuthService authService;
    @Inject
    protected LayersService layersService;
    @Inject
    protected RangeBasedFacets rangeBasedFacets;
    @Inject
    protected SpeciesCountsService speciesCountsService;
    @Inject
    protected SpeciesImageService speciesImageService;
    @Inject
    public ListsService listsService;
    @Inject
    protected DownloadService downloadService;
    @Value(value="${media.store.local:true}")
    protected Boolean usingLocalMediaRepo = true;
    @Value(value="${solr.downloadquery.maxthreads:30}")
    protected Integer maxSolrDownloadThreads = 30;
    @Value(value="${solr.downloadquery.writertimeout:60000}")
    protected Long writerTimeoutWaitMillis = 60000L;
    @Value(value="${solr.downloadquery.busywaitsleep:100}")
    protected Long downloadCheckBusyWaitSleep = 100L;
    @Value(value="${wms.legendMaxItems:30}")
    private int wmslegendMaxItems;
    private volatile ExecutorService solrOnlineExecutor = null;
    @Value(value="${check.download.limits:false}")
    protected boolean checkDownloadLimits = false;
    @Value(value="${term.query.limit:1000}")
    protected Integer termQueryLimit = 1000;
    @Value(value="${media.url:https://biocache.ala.org.au/biocache-media/}")
    public String biocacheMediaUrl = "https://biocache.ala.org.au/biocache-media/";
    @Value(value="${index.fields.tohide:collector_text,location_determined,row_key,matched_name,decimal_latitudelatitude,collectors,default_values_used,generalisation_to_apply_in_metres,geohash,ibra_subregion,identifier_by,occurrence_details,text,photo_page_url,photographer,places,portal_id,quad,rem_text,occurrence_status_s,identification_qualifier_s}")
    protected String indexFieldsToHide;
    @Value(value="${default.download.fields:id,dataResourceUid,dataResourceName,license,catalogNumber,taxonConceptID,raw_scientificName,raw_vernacularName,scientificName,taxonRank,vernacularName,kingdom,phylum,class,order,family,genus,species,subspecies,institutionCode,collectionCode,raw_locality,raw_decimalLatitude,raw_decimalLongitude,raw_geodeticDatum,decimalLatitude,decimalLongitude,coordinatePrecision,coordinateUncertaintyInMeters,country,stateProvince,cl959,minimumElevationInMeters,maximumElevationInMeters,minimumDepthInMeters,maximumDepthInMeters,individualCount,recordedBy,year,month,day,verbatimEventDate,basisOfRecord,raw_basisOfRecord,sex,preparations,informationWithheld,dataGeneralizations,outlierLayer}")
    protected String defaultDownloadFields;
    @Value(value="${wms.colour:0x00000000}")
    protected int DEFAULT_COLOUR;
    @Value(value="${dwc.url:http://rs.tdwg.org/dwc/terms/}")
    protected String dwcUrl = "http://rs.tdwg.org/dwc/terms/";
    @Value(value="${max.boolean.clauses:1024}")
    private int maxBooleanClauses;
    @Value(value="${layers.service.url:https://spatial.ala.org.au/ws}")
    protected String layersServiceUrl;
    @Value(value="${solr.collection:biocache1}")
    protected String solrCollection;
    Map<String, String[]> sensitiveFieldMapping = new HashMap();

    @PostConstruct
    public void init() throws Exception {
        logger.debug((Object)"Initialising SearchDAOImpl");
        Set indexedFields = this.indexDao.getIndexedFields(true);
        this.indexDao.getSchemaFields(true);
        if (this.downloadFields == null) {
            this.downloadFields = new DownloadFields(this.fieldMappingUtil, indexedFields, this.messageSource, this.layersService, this.listsService);
        } else {
            this.downloadFields.update(indexedFields);
        }
        this.getMaxBooleanClauses();
        this.initSensitiveFieldMapping();
    }

    public void refreshCaches() {
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.collectionCache.updateCache();
        try {
            this.downloadFields.update(this.indexDao.getIndexedFields(true));
        }
        catch (Exception e) {
            logger.error((Object)"Unable to refresh cache.", (Throwable)e);
        }
        this.speciesImageService.resetCache();
        this.speciesCountsService.resetCache();
        this.listsService.refreshCache();
        this.layersService.refreshCache();
    }

    public List<FieldResultDTO> getSubquerySpeciesOnly(SpatialSearchRequestDTO subQuery, SpatialSearchRequestDTO parentQuery) throws Exception {
        SolrQuery subset = this.initSolrQuery(subQuery, false, null);
        SolrQuery superset = this.initSolrQuery(parentQuery, false, null);
        ArrayList<FieldResultDTO> output = new ArrayList<FieldResultDTO>();
        this.indexDao.streamingQuery(subset, null, (ProcessInterface)new EndemicFacet(output, subQuery.getFacets()[0]), superset);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEndemicFacetToStream(SpatialSearchRequestDTO subQuery, SpatialSearchRequestDTO parentQuery, boolean includeCount, boolean lookupName, boolean includeSynonyms, boolean includeLists, OutputStream out) throws Exception {
        List list = this.getSubquerySpeciesOnly(subQuery, parentQuery);
        String facet = parentQuery.getFacets()[0];
        boolean shouldLookup = lookupName && (facet.contains("_guid") || facet.contains("_lsid") || facet.endsWith("ID"));
        Object[] header = new String[]{facet};
        if (shouldLookup) {
            header = this.speciesLookupService.getHeaderDetails(this.fieldMappingUtil.translateFieldName(facet), includeCount, includeSynonyms);
        } else if (includeCount) {
            header = (String[])ArrayUtils.add((Object[])header, (Object)"count");
        }
        if (includeLists) {
            header = (String[])ArrayUtils.addAll((Object[])header, (Object[])this.listsService.getTypes().toArray(new String[0]));
        }
        CSVRecordWriter writer = new CSVRecordWriter(out, (String[])header);
        try {
            writer.initialise();
            boolean addedNullFacet = false;
            ArrayList<String> guids = new ArrayList<String>();
            ArrayList<Long> counts = new ArrayList<Long>();
            for (FieldResultDTO ff : list) {
                String[] stringArray;
                String name;
                if (ff.getLabel() == null) {
                    addedNullFacet = true;
                }
                if (ff.getCount() == 0L || ff.getLabel() == null && addedNullFacet) continue;
                if (shouldLookup) {
                    guids.add(ff.getLabel());
                    if (includeCount) {
                        counts.add(ff.getCount());
                    }
                    if (guids.size() != 30) continue;
                    this.writeTaxonDetailsToStream(guids, counts, includeCount, includeSynonyms, includeLists, writer);
                    guids.clear();
                    counts.clear();
                    continue;
                }
                String string = name = ff.getLabel() != null ? ff.getLabel() : "";
                if (includeCount) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = name;
                    stringArray = stringArray2;
                    stringArray2[1] = Long.toString(ff.getCount());
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = name;
                }
                String[] row = stringArray;
                writer.write(row);
            }
            if (shouldLookup) {
                this.writeTaxonDetailsToStream(guids, counts, includeCount, includeSynonyms, includeLists, writer);
            }
        }
        finally {
            writer.finalise();
        }
    }

    public List<FieldResultDTO> getValuesForFacet(SpatialSearchRequestDTO requestParams) throws Exception {
        String[] line;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.writeFacetToStream(requestParams, true, false, false, false, (OutputStream)outputStream, null);
        outputStream.flush();
        outputStream.close();
        CSVReader csvReader = new CSVReader((Reader)new StringReader(outputStream.toString(StandardCharsets.UTF_8)));
        ArrayList<FieldResultDTO> list = new ArrayList<FieldResultDTO>();
        boolean first = true;
        while ((line = csvReader.readNext()) != null) {
            if (first) {
                first = false;
                continue;
            }
            if (line.length != 2) continue;
            String name = line[0];
            list.add(new FieldResultDTO(name, name, Long.parseLong(line[1])));
        }
        return list;
    }

    public SearchResultDTO findByFulltextSpatialQuery(SpatialSearchRequestDTO searchParams, boolean includeSensitive, Map<String, String[]> extraParams) throws Exception {
        SearchResultDTO searchResults = new SearchResultDTO();
        SpatialSearchRequestDTO original = new SpatialSearchRequestDTO();
        BeanUtils.copyProperties((Object)searchParams, (Object)original);
        Map[] fqMaps = this.queryFormatUtils.formatSearchQuery(searchParams, true);
        SolrQuery solrQuery = this.initSolrQuery(searchParams, true, extraParams);
        QueryResponse qr = this.indexDao.runSolrQuery(solrQuery);
        Class resultClass = includeSensitive ? SensitiveOccurrenceIndex.class : OccurrenceIndex.class;
        searchResults = this.processSolrResponse((SearchRequestDTO)original, qr, solrQuery, resultClass);
        searchResults.setQueryTitle(searchParams.getDisplayString());
        searchResults.setUrlParameters(original.getUrlParams());
        searchResults.setActiveFacetMap(fqMaps[0]);
        searchResults.setActiveFacetObj(fqMaps[1]);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("spatial search query: " + solrQuery.toQueryString()));
        }
        return searchResults;
    }

    public int writeSpeciesCountByCircleToStream(SpatialSearchRequestDTO searchParams, String speciesGroup, ServletOutputStream out) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Writing CSV file for species count by circle");
        }
        searchParams.setFlimit(Integer.valueOf(-1));
        this.getSpeciesCountsTSVCircle(searchParams, (OutputStream)out);
        return 0;
    }

    public void writeFacetToStream(SpatialSearchRequestDTO searchParams, boolean includeCount, boolean lookupName, boolean includeSynonyms, boolean includeLists, OutputStream out, DownloadDetailsDTO dd) throws Exception {
        searchParams.setFlimit(Integer.valueOf(-1));
        SolrQuery solrQuery = this.initSolrQuery(searchParams, false, null);
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacetLimit(searchParams.getFlimit().intValue());
        if (dd != null) {
            dd.resetCounts();
        }
        StreamFacet procFacet = new StreamFacet(this, dd, searchParams, lookupName, includeCount, includeSynonyms, includeLists, 0L, out);
        this.indexDao.streamingQuery(solrQuery, null, (ProcessInterface)procFacet, null);
    }

    public void writeTaxonDetailsToStream(List<String> guids, List<Long> counts, boolean includeCounts, boolean includeSynonyms, boolean includeLists, CSVRecordWriter writer) throws Exception {
        List values = this.speciesLookupService.getSpeciesDetails(guids, counts, includeCounts, includeSynonyms, includeLists);
        for (String[] value : values) {
            writer.write(value);
        }
    }

    @Deprecated
    public void writeCoordinatesToStream(SpatialSearchRequestDTO searchParams, OutputStream out) throws Exception {
        FacetField ff;
        SolrQuery solrQuery = this.initSolrQuery(searchParams, false, null);
        solrQuery.setFacetLimit(-1);
        solrQuery.setFacetSort("count");
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery(searchParams.getQ());
        QueryResponse qr = this.indexDao.runSolrQuery(solrQuery);
        if (qr.getResults().size() > 0 && (ff = qr.getFacetField(searchParams.getFacets()[0])) != null && ff.getValueCount() > 0) {
            out.write("latitude,longitude\n".getBytes(StandardCharsets.UTF_8));
            for (FacetField.Count value : ff.getValues()) {
                if (value.getName() == null || value.getCount() <= 0L) continue;
                out.write(value.getName().getBytes(StandardCharsets.UTF_8));
                out.write("\n".getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public DownloadHeaders writeResultsFromIndexToStream(DownloadRequestDTO downloadParams, OutputStream out, ConcurrentMap<String, AtomicInteger> uidStats, DownloadDetailsDTO dd, boolean checkLimit, ExecutorService nextExecutor) throws Exception {
        if (this.downloadFields == null) {
            throw new Exception("PostConstruct not finished, downloadFields==null");
        }
        dd.resetCounts();
        boolean hasSensitiveRecordAccess = this.downloadService.getSensitiveFq(dd.getAlaUser() == null ? Collections.emptySet() : dd.getAlaUser().getRoles()) != null;
        this.prepareRequestedFields(downloadParams, hasSensitiveRecordAccess);
        DownloadHeaders downloadHeaders = this.prepareHeaders(downloadParams);
        RecordWriter recordWriter = this.createRecordWriter(downloadParams, downloadHeaders, out);
        if (nextExecutor != null) {
            Future future = nextExecutor.submit(this.prepareDownloadRunner(downloadParams, downloadHeaders, dd, uidStats, recordWriter));
            boolean waitAgain = false;
            do {
                waitAgain = false;
                if (!future.isDone()) {
                    waitAgain = true;
                }
                if (!waitAgain) continue;
                Thread.sleep(this.downloadCheckBusyWaitSleep);
            } while (waitAgain);
        } else {
            this.prepareDownloadRunner(downloadParams, downloadHeaders, dd, uidStats, recordWriter).call();
        }
        recordWriter.finalise();
        return downloadHeaders;
    }

    private RecordWriter createRecordWriter(DownloadRequestDTO downloadParams, DownloadHeaders downloadHeaders, OutputStream out) {
        CSVRecordWriter recordWriter = downloadParams.getFileType().equals("csv") ? new CSVRecordWriter(out, downloadHeaders.joinedHeader(), downloadParams.getSep().charValue(), downloadParams.getEsc().charValue()) : new TSVRecordWriter(out, downloadHeaders.joinedHeader());
        recordWriter.initialise();
        return recordWriter;
    }

    private Callable prepareDownloadRunner(DownloadRequestDTO downloadParams, DownloadHeaders downloadHeaders, DownloadDetailsDTO dd, ConcurrentMap<String, AtomicInteger> uidStats, RecordWriter recordWriter) throws QidMissingException {
        this.queryFormatUtils.formatSearchQuery((SpatialSearchRequestDTO)downloadParams);
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(downloadParams.getFormattedQuery());
        solrQuery.setFilterQueries(downloadParams.getFormattedFq());
        solrQuery.setRows(Integer.valueOf(-1));
        solrQuery.setStart(Integer.valueOf(0));
        String sensitiveFq = this.downloadService.getSensitiveFq(dd.getAlaUser() == null ? Collections.emptySet() : dd.getAlaUser().getRoles());
        ArrayList<SolrQuery> queries = new ArrayList<SolrQuery>();
        if (sensitiveFq != null) {
            queries.addAll(this.splitQueries(solrQuery, sensitiveFq, downloadHeaders.included, Arrays.stream(downloadHeaders.included).filter(field -> !ArrayUtils.contains((Object[])OccurrenceIndex.sensitiveSOLRHdr, (Object)field)).collect(Collectors.toList()).toArray(new String[0])));
        } else {
            solrQuery.setFields(Arrays.stream(downloadHeaders.included).filter(field -> !ArrayUtils.contains((Object[])OccurrenceIndex.sensitiveSOLRHdr, (Object)field)).collect(Collectors.toList()).toArray(new String[0]));
            queries.add(solrQuery);
        }
        ProcessDownload procDownload = new ProcessDownload(uidStats, downloadHeaders, recordWriter, dd, this.checkDownloadLimits, (long)this.downloadService.dowloadOfflineMaxSize.intValue(), this.listsService, this.layersService);
        return new DownloadCallable(queries, this.indexDao, procDownload);
    }

    private void initSensitiveFieldMapping() {
        this.sensitiveFieldMapping.put("longitude", new String[]{"sensitive_decimalLongitude"});
        this.sensitiveFieldMapping.put("decimalLongitude", new String[]{"sensitive_decimalLongitude"});
        this.sensitiveFieldMapping.put("latitude", new String[]{"sensitive_decimalLatitude"});
        this.sensitiveFieldMapping.put("decimalLatitude", new String[]{"sensitive_decimalLatitude"});
        this.sensitiveFieldMapping.put("locality", new String[]{"sensitive_locality"});
        this.sensitiveFieldMapping.put("footprint_wkt", new String[]{"sensitive_footprintWKT"});
        this.sensitiveFieldMapping.put("footprintWKT", new String[]{"sensitive_footprintWKT"});
        this.sensitiveFieldMapping.put("location_remarks", new String[]{"sensitive_locationRemarks"});
        this.sensitiveFieldMapping.put("locationRemarks", new String[]{"sensitive_locationRemarks"});
        this.sensitiveFieldMapping.put("verbatim_coordinates", new String[]{"sensitive_verbatimCoordinates"});
        this.sensitiveFieldMapping.put("verbatimCoordinates", new String[]{"sensitive_verbatimCoordinates"});
        this.sensitiveFieldMapping.put("verbatim_latitude", new String[]{"sensitive_verbatimLatitude"});
        this.sensitiveFieldMapping.put("verbatimLatitude", new String[]{"sensitive_verbatimLatitude"});
        this.sensitiveFieldMapping.put("verbatim_locality", new String[]{"sensitive_verbatimLocality"});
        this.sensitiveFieldMapping.put("verbatimLocality", new String[]{"sensitive_verbatimLocality"});
        this.sensitiveFieldMapping.put("verbatim_longitude", new String[]{"sensitive_verbatimLongitude"});
        this.sensitiveFieldMapping.put("verbatimLongitude", new String[]{"sensitive_verbatimLongitude"});
        this.sensitiveFieldMapping.put("day", new String[]{"sensitive_day"});
        this.sensitiveFieldMapping.put("occurrence_date", new String[]{"sensitive_eventDate"});
        this.sensitiveFieldMapping.put("eventDate", new String[]{"sensitive_eventDate"});
        this.sensitiveFieldMapping.put("event_id", new String[]{"sensitive_eventID"});
        this.sensitiveFieldMapping.put("eventID", new String[]{"sensitive_eventID"});
        this.sensitiveFieldMapping.put("event_time", new String[]{"sensitive_eventTime"});
        this.sensitiveFieldMapping.put("eventTime", new String[]{"sensitive_eventTime"});
        this.sensitiveFieldMapping.put("month", new String[]{"sensitive_month"});
        this.sensitiveFieldMapping.put("verbatim_event_date", new String[]{"sensitive_verbatimEventDate"});
        this.sensitiveFieldMapping.put("verbatimEventDate", new String[]{"sensitive_verbatimEventDate"});
    }

    private void insertSensitiveFields(DownloadRequestDTO downloadParams) {
        String[] originalFields = downloadParams.getFields().split(",");
        ArrayList<String> fieldsWithSensitive = new ArrayList<String>();
        HashSet fieldsWithSensitiveSet = new HashSet();
        for (String field : originalFields) {
            field = StringUtils.trim((String)field);
            fieldsWithSensitive.add(field);
            if (!this.sensitiveFieldMapping.containsKey(field)) continue;
            fieldsWithSensitive.addAll(Arrays.stream((String[])this.sensitiveFieldMapping.get(field)).filter(it -> !fieldsWithSensitiveSet.contains(it)).collect(Collectors.toList()));
            fieldsWithSensitiveSet.addAll(Arrays.stream((String[])this.sensitiveFieldMapping.get(field)).filter(it -> !fieldsWithSensitiveSet.contains(it)).collect(Collectors.toList()));
        }
        downloadParams.setFields(String.join((CharSequence)",", fieldsWithSensitive));
    }

    private void prepareRequestedFields(DownloadRequestDTO downloadParams, boolean includeSensitive) {
        this.expandRequestedFields(downloadParams, true);
        if (includeSensitive) {
            this.insertSensitiveFields(downloadParams);
        }
    }

    private void requestFields(DownloadHeaders downloadHeaders, String[] fields) {
        for (String field : fields) {
            if (ArrayUtils.contains((Object[])downloadHeaders.included, (Object)field)) continue;
            downloadHeaders.included = (String[])ArrayUtils.add((Object[])downloadHeaders.included, (Object)field);
        }
    }

    private DownloadHeaders prepareHeaders(DownloadRequestDTO downloadParams) {
        DownloadHeaders downloadHeaders = this.downloadFields.newDownloadHeader(downloadParams, Arrays.asList(this.downloadExcludedMiscFields.split(",")));
        this.addPostProcessingFields(downloadParams, downloadHeaders);
        return downloadHeaders;
    }

    private void addPostProcessingFields(DownloadRequestDTO downloadParams, DownloadHeaders downloadHeaders) {
        if (StringUtils.isNotBlank((String)downloadParams.getQa()) && !"none".equals(downloadParams.getQa())) {
            this.requestFields(downloadHeaders, new String[]{"assertions"});
            if ("includeall".equals(downloadParams.getQa())) {
                downloadHeaders.qaIds = this.getAllQAFields().toString().split(",");
            } else if ("all".equals(downloadParams.getQa())) {
                try {
                    downloadHeaders.qaIds = this.getFacet((SpatialSearchRequestDTO)downloadParams, "assertions").getValues().stream().filter(count -> count.getCount() > 0L).map(count -> count.getName()).filter(s -> s != null).collect(Collectors.toList()).toArray(new String[0]);
                }
                catch (Exception e) {
                    logger.error((Object)("error getting assertions facet for download: " + downloadParams), (Throwable)e);
                }
            } else {
                downloadHeaders.qaIds = (String[])Arrays.stream(downloadParams.getQa().split(",")).map(qa -> this.fieldMappingUtil.translateFieldValue("assertions", qa)).toArray(String[]::new);
            }
            String headingPrefix = downloadParams.getDwcHeaders() != false ? "headings.assertions." : "assertions.";
            downloadHeaders.qaLabels = Arrays.stream(downloadHeaders.qaIds).map(id -> this.messageSource.getMessage(headingPrefix + id, null, id, null)).collect(Collectors.toList()).toArray(new String[0]);
        }
        this.requestFields(downloadHeaders, new String[]{"dataProviderUid", "institutionUid", "collectionUid", "dataResourceUid"});
        if (downloadHeaders.speciesListIds.length > 0) {
            this.requestFields(downloadHeaders, new String[]{"lft", "rgt"});
        }
        if (downloadParams.getIncludeMisc().booleanValue()) {
            this.requestFields(downloadHeaders, new String[]{"sensitive", "dynamicProperties"});
        }
    }

    private void expandRequestedFields(DownloadRequestDTO downloadParams, boolean isSolr) {
        String fields = this.getDownloadFields(downloadParams);
        try {
            StringBuilder sb;
            Matcher matcher = this.clpField.matcher(fields);
            if (matcher.find()) {
                sb = new StringBuilder();
                for (IndexFieldDTO field : this.indexDao.getIndexedFields()) {
                    if (!field.getName().matches("cl[0-9]*")) continue;
                    if (sb.length() > 0 || matcher.start() > 0) {
                        sb.append(",");
                    }
                    sb.append(field.getName());
                }
                if (sb.length() > 0 && matcher.end() < fields.length()) {
                    sb.append(",");
                }
                fields = matcher.replaceFirst(sb.toString());
            }
            if ((matcher = this.elpField.matcher(fields)).find()) {
                sb = new StringBuilder();
                for (IndexFieldDTO field : this.indexDao.getIndexedFields()) {
                    if (!field.getName().matches("el[0-9]*")) continue;
                    if (sb.length() > 0 || matcher.start() > 0) {
                        sb.append(",");
                    }
                    sb.append(field.getName());
                }
                if (sb.length() > 0 && matcher.end() < fields.length()) {
                    sb.append(",");
                }
                fields = matcher.replaceFirst(sb.toString());
            }
            if ((matcher = this.allDwcField.matcher(fields)).find()) {
                sb = new StringBuilder();
                for (IndexFieldDTO field : this.indexDao.getIndexedFields()) {
                    if (!StringUtils.isNotEmpty((String)field.getDwcTerm()) || isSolr && !field.isStored()) continue;
                    if (sb.length() > 0 || matcher.start() > 0) {
                        sb.append(",");
                    }
                    if (isSolr) {
                        sb.append(field.getName());
                        continue;
                    }
                    sb.append(field.getDownloadName());
                }
                if (sb.length() > 0 && matcher.end() < fields.length()) {
                    sb.append(",");
                }
                fields = matcher.replaceFirst(sb.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to substitute fields", (Throwable)e);
        }
        downloadParams.setFields(fields);
    }

    private String getDownloadFields(DownloadRequestDTO downloadParams) {
        String extra;
        Object dFields = downloadParams.getFields();
        if (StringUtils.isEmpty((String)dFields)) {
            dFields = this.defaultDownloadFields;
        }
        if (!StringUtils.isEmpty((String)(extra = downloadParams.getExtra()))) {
            dFields = (String)dFields + "," + extra;
        }
        return dFields;
    }

    private List<SolrQuery> splitQueries(SolrQuery query, String fq, String[] fqFields, String[] notFqFields) {
        ArrayList<SolrQuery> queries = new ArrayList<SolrQuery>();
        SolrQuery nsq = query.getCopy().addFilterQuery(new String[]{"-(" + fq + ")"});
        if (notFqFields != null) {
            Arrays.stream(notFqFields).forEach(arg_0 -> ((SolrQuery)nsq).addField(arg_0));
        }
        queries.add(nsq);
        SolrQuery sq = query.getCopy().addFilterQuery(new String[]{fq});
        if (fqFields != null) {
            Arrays.stream(fqFields).forEach(arg_0 -> ((SolrQuery)sq).addField(arg_0));
        }
        queries.add(sq);
        return queries;
    }

    public static void incrementCount(ConcurrentMap<String, AtomicInteger> values, Object uid) {
        if (uid != null) {
            String nextKey = uid.toString();
            if (values.containsKey(nextKey)) {
                ((AtomicInteger)values.get(nextKey)).incrementAndGet();
            } else {
                AtomicInteger putIfAbsent = values.putIfAbsent(nextKey, new AtomicInteger(1));
                if (putIfAbsent != null) {
                    putIfAbsent.incrementAndGet();
                }
            }
        }
    }

    @Deprecated
    public List<OccurrencePoint> getFacetPoints(SpatialSearchRequestDTO searchParams, PointType pointType) throws Exception {
        return this.getPoints(searchParams, pointType, -1);
    }

    @Deprecated
    private List<OccurrencePoint> getPoints(SpatialSearchRequestDTO searchParams, PointType pointType, int max) throws Exception {
        ArrayList<OccurrencePoint> points = new ArrayList<OccurrencePoint>();
        SolrQuery solrQuery = this.initSolrQuery(searchParams, false, null);
        this.emptyFacetRequest(solrQuery, max, 0, false);
        solrQuery.addFacetField(new String[]{pointType.getLabel()});
        QueryResponse qr = this.indexDao.runSolrQuery(solrQuery);
        List facets = qr.getFacetFields();
        if (facets != null) {
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                if (!facet.getName().contains(pointType.getLabel()) || facetEntries == null || facetEntries.size() <= 0) continue;
                for (FacetField.Count fcount : facetEntries) {
                    if (!StringUtils.isNotEmpty((String)fcount.getName()) || fcount.getCount() <= 0L) continue;
                    OccurrencePoint point = new OccurrencePoint(pointType);
                    point.setCount(Long.valueOf(fcount.getCount()));
                    String[] pointsDelimited = StringUtils.split((String)fcount.getName(), (char)',');
                    ArrayList<Float> coords = new ArrayList<Float>();
                    for (String coord : pointsDelimited) {
                        try {
                            Float decimalCoord = Float.valueOf(Float.parseFloat(coord));
                            coords.add(decimalCoord);
                        }
                        catch (NumberFormatException numberFormatException) {
                            logger.warn((Object)("Error parsing Float for Lat/Long: " + numberFormatException.getMessage()), (Throwable)numberFormatException);
                        }
                    }
                    if (coords.isEmpty()) continue;
                    Collections.reverse(coords);
                    point.setCoordinates(coords);
                    points.add(point);
                }
            }
        }
        return points;
    }

    @Deprecated
    public List<OccurrencePoint> findRecordsForLocation(SpatialSearchRequestDTO requestParams, PointType pointType) throws Exception {
        return this.getPoints(requestParams, pointType, this.MAX_DOWNLOAD_SIZE.intValue());
    }

    public TaxaRankCountDTO calculateBreakdown(BreakdownRequestDTO queryParams) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to find the counts for " + queryParams));
        }
        TaxaRankCountDTO trDTO = null;
        queryParams.setPageSize(Integer.valueOf(0));
        queryParams.setFacet(Boolean.valueOf(true));
        queryParams.setFsort("count");
        queryParams.setFlimit(Integer.valueOf(-1));
        SolrQuery solrQuery = this.initSolrQuery((SpatialSearchRequestDTO)queryParams, false, null);
        solrQuery.setFacetMissing(Boolean.valueOf(false));
        if (StringUtils.isNotEmpty((String)queryParams.getName()) && StringUtils.isNotEmpty((String)queryParams.getRank())) {
            solrQuery.addFilterQuery(new String[]{queryParams.getRank() + ":" + queryParams.getName()});
        }
        if (queryParams.getLevel() == null) {
            List ranks;
            List list = queryParams.getRank() != null ? this.searchUtils.getNextRanks(queryParams.getRank(), queryParams.getName() == null) : (ranks = this.searchUtils.getRanks());
            if (queryParams.getMax() != null && queryParams.getMax() > 0) {
                Collections.reverse(ranks);
            }
            for (String r : ranks) {
                long count = this.estimateUniqueValues((SpatialSearchRequestDTO)queryParams, r);
                if ((queryParams.getMax() == null || queryParams.getMax() <= 0 || count > (long)queryParams.getMax().intValue()) && (queryParams.getRank() == null || count <= 0L)) continue;
                solrQuery.addFacetField(new String[]{r});
                break;
            }
        } else {
            solrQuery.addFacetField(new String[]{queryParams.getLevel()});
        }
        QueryResponse qr = this.indexDao.runSolrQuery(solrQuery);
        if (qr.getResults().getNumFound() > 0L && qr.getFacetFields().size() > 0) {
            FacetField ff = (FacetField)qr.getFacetFields().get(0);
            trDTO = new TaxaRankCountDTO(ff.getName());
            ArrayList<FieldResultDTO> fDTOs = new ArrayList<FieldResultDTO>();
            for (FacetField.Count count : ff.getValues()) {
                if (count.getCount() <= 0L) continue;
                FieldResultDTO f = new FieldResultDTO(count.getName(), count.getFacetField().getName() + "." + count.getName(), count.getCount());
                fDTOs.add(f);
            }
            trDTO.setTaxa(fDTOs);
        }
        return trDTO;
    }

    private SearchResultDTO processSolrResponse(SearchRequestDTO params, QueryResponse qr, SolrQuery solrQuery, Class resultClass) {
        SearchResultDTO searchResult = new SearchResultDTO();
        SolrDocumentList sdl = qr.getResults();
        List facets = qr.getFacetFields();
        List facetDates = qr.getFacetDates();
        Map facetQueries = qr.getFacetQuery();
        if (facetDates != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Facet dates size: " + facetDates.size()));
            }
            facets.addAll(facetDates);
        }
        List results = qr.getBeans(resultClass);
        searchResult.setTotalRecords(sdl.getNumFound());
        searchResult.setStartIndex(sdl.getStart());
        searchResult.setPageSize((long)solrQuery.getRows().intValue());
        searchResult.setStatus("OK");
        Object[] solrSort = StringUtils.split((String)solrQuery.getSortField(), (String)" ");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sortField post-split: " + StringUtils.join((Object[])solrSort, (String)"|")));
        }
        if (solrSort != null && solrSort.length == 2) {
            searchResult.setSort((String)solrSort[0]);
            searchResult.setDir((String)solrSort[1]);
        }
        searchResult.setQuery(params.getUrlParams());
        searchResult.setOccurrences(results);
        List facetResults = this.buildFacetResults(facets);
        if (facetQueries != null && !facetQueries.isEmpty()) {
            Map rangeMap = this.rangeBasedFacets.getRangeMap("coordinateUncertaintyInMeters");
            ArrayList<FieldResultDTO> fqr = new ArrayList<FieldResultDTO>();
            for (String value : facetQueries.keySet()) {
                if ((Integer)facetQueries.get(value) <= 0) continue;
                fqr.add(new FieldResultDTO((String)rangeMap.get(value), (String)rangeMap.get(value), (long)((Integer)facetQueries.get(value)).intValue(), value));
            }
            facetResults.add(new FacetResultDTO("coordinateUncertaintyInMeters", fqr));
        }
        if (qr.getFacetRanges() != null) {
            for (RangeFacet rfacet : qr.getFacetRanges()) {
                ArrayList<FieldResultDTO> fqr = new ArrayList<FieldResultDTO>();
                if (rfacet instanceof RangeFacet.Numeric) {
                    RangeFacet.Numeric nrfacet = (RangeFacet.Numeric)rfacet;
                    List counts = nrfacet.getCounts();
                    if (nrfacet.getBefore().intValue() > 0) {
                        String name = "[* TO " + this.getUpperRange(((Number)nrfacet.getStart()).toString(), (Number)nrfacet.getGap(), false) + "]";
                        fqr.add(new FieldResultDTO(name, name, (long)nrfacet.getBefore().intValue()));
                    }
                    for (RangeFacet.Count count : counts) {
                        String title = this.getRangeValue(count.getValue(), (Number)nrfacet.getGap());
                        fqr.add(new FieldResultDTO(title, title, (long)count.getCount()));
                    }
                    if (nrfacet.getAfter().intValue() > 0) {
                        fqr.add(new FieldResultDTO("[" + ((Number)nrfacet.getEnd()).toString() + " TO *]", "[" + ((Number)nrfacet.getEnd()).toString() + " TO *]", (long)nrfacet.getAfter().intValue()));
                    }
                    facetResults.add(new FacetResultDTO(nrfacet.getName(), fqr));
                    continue;
                }
                List facetEntries = rfacet.getCounts();
                String facetName = rfacet.getName();
                this.addFacetResultsFromSolrFacets(facetResults, facetEntries, facetName);
            }
        }
        for (OccurrenceIndex oi : results) {
            this.updateImageUrls(oi);
        }
        searchResult.setFacetResults(facetResults);
        searchResult.setQr(qr);
        return searchResult;
    }

    private List<FacetResultDTO> buildFacetResults(List<FacetField> facets) {
        ArrayList<FacetResultDTO> facetResults = new ArrayList<FacetResultDTO>();
        if (facets != null) {
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                String facetName = facet.getName();
                this.addFacetResultsFromSolrFacets(facetResults, facetEntries, facetName);
            }
        }
        return facetResults;
    }

    private void addFacetResultsFromSolrFacets(List<FacetResultDTO> facetResults, List<?> facetEntries, String facetName) {
        if (facetEntries != null && facetEntries.size() > 0) {
            ArrayList<FieldResultDTO> r = new ArrayList<FieldResultDTO>();
            for (Object facetCountEntryObject : facetEntries) {
                String countEntryName;
                long entryCount;
                if (facetCountEntryObject instanceof FacetField.Count) {
                    FacetField.Count facetCountEntry = (FacetField.Count)facetCountEntryObject;
                    entryCount = facetCountEntry.getCount();
                    countEntryName = facetCountEntry.getName();
                } else if (facetCountEntryObject instanceof RangeFacet.Count) {
                    RangeFacet.Count raengeFacetCountEntry = (RangeFacet.Count)facetCountEntryObject;
                    entryCount = raengeFacetCountEntry.getCount();
                    countEntryName = raengeFacetCountEntry.getValue();
                } else {
                    throw new IllegalArgumentException("facetCountEntry is not an instance of FacetField.Count nor RangeFacet.Count: " + facetCountEntryObject.getClass());
                }
                if (entryCount == 0L) continue;
                if (countEntryName == null) {
                    String label = "";
                    if (this.messageSource != null) {
                        label = this.messageSource.getMessage(this.fieldMappingUtil.translateFieldName(facetName) + ".novalue", null, "Not supplied", null);
                    }
                    r.add(new FieldResultDTO(label, facetName + ".novalue", entryCount, "-" + facetName + ":*"));
                    continue;
                }
                if (countEntryName.equals(DECADE_PRE_1850_LABEL)) {
                    r.add(0, new FieldResultDTO(this.getFacetValueDisplayName(this.fieldMappingUtil.translateFieldName(facetName), countEntryName), facetName + "." + countEntryName, entryCount, this.getFormattedFqQuery(facetName, countEntryName)));
                    continue;
                }
                r.add(new FieldResultDTO(this.getFacetValueDisplayName(this.fieldMappingUtil.translateFieldName(facetName), countEntryName), facetName + "." + countEntryName, entryCount, this.getFormattedFqQuery(facetName, countEntryName)));
            }
            if (r.size() > 0) {
                FacetResultDTO fr = new FacetResultDTO(facetName, r);
                facetResults.add(fr);
            }
        }
    }

    private void updateImageUrls(OccurrenceIndex oi) {
        if (!StringUtils.isNotBlank((String)oi.getImage())) {
            return;
        }
        try {
            Map formats = this.occurrenceUtils.getImageFormats(oi.getImage());
            oi.setImageUrl((String)formats.get("raw"));
            oi.setThumbnailUrl((String)formats.get("thumb"));
            oi.setSmallImageUrl((String)formats.get("small"));
            oi.setLargeImageUrl((String)formats.get("large"));
            String[] images = oi.getImages();
            if (images != null && images.length > 0) {
                String[] imageUrls = new String[images.length];
                for (int i = 0; i < images.length; ++i) {
                    try {
                        Map availableFormats = this.occurrenceUtils.getImageFormats(images[i]);
                        imageUrls[i] = (String)availableFormats.get("large");
                        continue;
                    }
                    catch (Exception ex) {
                        logger.warn((Object)("Unable to update image URL for " + images[i] + ": " + ex.getMessage()));
                    }
                }
                oi.setImageUrls(imageUrls);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("Unable to update image URL for " + oi.getImage() + ": " + ex.getMessage()));
        }
    }

    private String getRangeValue(String lower, Number gap) {
        StringBuilder value = new StringBuilder("[");
        value.append(lower).append(" TO ").append(this.getUpperRange(lower, gap, true));
        return value.append("]").toString();
    }

    private String getUpperRange(String lower, Number gap, boolean addGap) {
        if (gap instanceof Integer) {
            int upper = Integer.parseInt(lower) - 1;
            if (addGap) {
                upper += ((Integer)gap).intValue();
            }
            return Integer.toString(upper);
        }
        if (gap instanceof Double) {
            BigDecimal upper = new BigDecimal(lower).add(new BigDecimal(-0.001));
            if (addGap) {
                upper = upper.add(new BigDecimal(gap.doubleValue()));
            }
            return upper.setScale(3, RoundingMode.HALF_UP).toString();
        }
        return lower;
    }

    protected void initDecadeBasedFacet(SolrQuery solrQuery, String field) {
        solrQuery.add("facet.range", new String[]{field});
        solrQuery.add("facet.range.start", new String[]{DECADE_FACET_START_DATE});
        solrQuery.add("facet.range.end", new String[]{"NOW/DAY"});
        solrQuery.add("facet.range.gap", new String[]{"+10YEAR"});
        solrQuery.add("facet.range.other", new String[]{DECADE_PRE_1850_LABEL});
        solrQuery.add("facet.range.include", new String[]{"lower"});
    }

    public SolrQuery initSolrQuery(SpatialSearchRequestDTO searchParams, boolean substituteDefaultFacetOrder, Map<String, String[]> extraSolrParams) throws QidMissingException {
        this.queryFormatUtils.formatSearchQuery(searchParams);
        String occurrenceDate = "eventDate";
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(searchParams.getFormattedQuery());
        if (searchParams.getFormattedFq() != null) {
            for (String fq : searchParams.getFormattedFq()) {
                if (!StringUtils.isNotEmpty((String)fq)) continue;
                solrQuery.addFilterQuery(new String[]{fq});
            }
        }
        solrQuery.setRequestHandler("standard");
        boolean rangeAdded = false;
        solrQuery.setFacet(searchParams.getFacet().booleanValue());
        if (searchParams.getFacet().booleanValue()) {
            for (String facet : searchParams.getFacets()) {
                if (facet.equals("decade") || facet.equals("date")) {
                    String fname = facet.equals("decade") ? "occurrenceYear" : occurrenceDate;
                    this.initDecadeBasedFacet(solrQuery, fname);
                    rangeAdded = true;
                    continue;
                }
                if (facet.equals("uncertainty")) {
                    Map rangeMap = this.rangeBasedFacets.getRangeMap("uncertainty");
                    for (String range : rangeMap.keySet()) {
                        solrQuery.add("facet.query", new String[]{range});
                    }
                    continue;
                }
                solrQuery.addFacetField(new String[]{facet});
                if (!"".equals(searchParams.getFsort()) || !substituteDefaultFacetOrder || !FacetThemes.getFacetsMap().containsKey(facet)) continue;
                String thisSort = ((FacetDTO)FacetThemes.getFacetsMap().get(facet)).getSort();
                if (searchParams.getFsort().equalsIgnoreCase(thisSort)) continue;
                solrQuery.add("f." + this.fieldMappingUtil.translateFieldName(facet) + ".facet.sort", new String[]{thisSort});
            }
            solrQuery.setFacetMinCount(1);
            solrQuery.setFacetLimit(searchParams.getFlimit().intValue());
            String fsort = StringUtils.isEmpty((String)searchParams.getFsort()) ? "count" : searchParams.getFsort();
            solrQuery.setFacetSort(fsort);
            if (searchParams.getFoffset() > 0) {
                solrQuery.add("facet.offset", new String[]{Integer.toString(searchParams.getFoffset())});
            }
            if (StringUtils.isNotEmpty((String)searchParams.getFprefix())) {
                solrQuery.add("facet.prefix", new String[]{searchParams.getFprefix()});
            }
        }
        solrQuery.setRows(searchParams.getPageSize());
        solrQuery.setStart(searchParams.getStart());
        if (StringUtils.isNotEmpty((String)searchParams.getDir()) && StringUtils.isNotEmpty((String)searchParams.getSort())) {
            solrQuery.setSort(searchParams.getSort(), SolrQuery.ORDER.valueOf((String)searchParams.getDir()));
        }
        if (searchParams.getFl().length() > 0) {
            solrQuery.setFields(new String[]{searchParams.getFl()});
        }
        if (extraSolrParams != null) {
            if (!rangeAdded) {
                solrQuery.add("facet.range.other", new String[]{DECADE_PRE_1850_LABEL});
                solrQuery.add("facet.range.other", new String[]{"after"});
            }
            for (String key : extraSolrParams.keySet()) {
                String[] values = extraSolrParams.get(key);
                solrQuery.add(key, values);
            }
        }
        return solrQuery;
    }

    protected void getSpeciesCountsJSON(SpatialSearchRequestDTO requestParams, OutputStream outputStream) throws Exception {
        SolrQuery solrQuery = this.initSolrQuery(requestParams, false, null);
        solrQuery.setFacetMissing(Boolean.valueOf(false));
        StreamTaxaCount procFacet = new StreamTaxaCount(this, this.searchUtils, requestParams, outputStream);
        this.indexDao.streamingQuery(solrQuery, null, (ProcessInterface)procFacet, null);
    }

    protected void getSpeciesCountsCSV(SpatialSearchRequestDTO requestParams, OutputStream outputStream) throws Exception {
        SolrQuery solrQuery = this.initSolrQuery(requestParams, false, null);
        solrQuery.setFacetMissing(Boolean.valueOf(false));
        StreamTaxaAsCSV procFacet = new StreamTaxaAsCSV(this, this.searchUtils, requestParams, outputStream);
        this.indexDao.streamingQuery(solrQuery, null, (ProcessInterface)procFacet, null);
    }

    protected void getSpeciesCountsTSVCircle(SpatialSearchRequestDTO requestParams, OutputStream outputStream) throws Exception {
        SolrQuery solrQuery = this.initSolrQuery(requestParams, false, null);
        solrQuery.setFacetMissing(Boolean.valueOf(false));
        StreamTaxaAsTSVCircle procFacet = new StreamTaxaAsTSVCircle(this, this.searchUtils, requestParams, outputStream);
        this.indexDao.streamingQuery(solrQuery, null, (ProcessInterface)procFacet, null);
    }

    public Map<String, Integer> getSourcesForQuery(SpatialSearchRequestDTO searchParams) throws Exception {
        HashMap<String, Integer> uidStats = new HashMap<String, Integer>();
        SolrQuery solrQuery = this.initSolrQuery(searchParams, false, null);
        this.emptyFacetRequest(solrQuery, -1, 0, false);
        solrQuery.addFacetField(new String[]{"institutionUid", "collectionUid", "dataResourceUid", "dataProviderUid"});
        QueryResponse qr = this.indexDao.runSolrQuery(solrQuery);
        List facets = qr.getFacetFields();
        for (FacetField facet : facets) {
            if (facet.getValues() == null) continue;
            for (FacetField.Count ffc : facet.getValues()) {
                if (ffc.getCount() <= 0L) continue;
                uidStats.put(ffc.getName() != null ? ffc.getName() : "", new Integer((int)ffc.getCount()));
            }
        }
        return uidStats;
    }

    public List<FacetResultDTO> getFacetCounts(SpatialSearchRequestDTO searchParams) throws Exception {
        searchParams.setFacet(Boolean.valueOf(true));
        searchParams.setPageSize(Integer.valueOf(0));
        SolrQuery facetQuery = this.initSolrQuery(searchParams, false, null);
        facetQuery.setFields(new String[0]);
        ArrayList fqList = new ArrayList();
        if (searchParams != null && searchParams.getFormattedFq() != null && searchParams.getFormattedFq().length > 0) {
            CollectionUtils.addAll(fqList, (Object[])searchParams.getFormattedFq());
        }
        facetQuery.setFilterQueries((String[])fqList.stream().toArray(String[]::new));
        if (searchParams.getFlimit() == 0) {
            ArrayList<FacetResultDTO> facetResults = new ArrayList<FacetResultDTO>();
            for (String facetName : searchParams.getFacets()) {
                FacetResultDTO frDTO = new FacetResultDTO();
                frDTO.setFieldName(facetName);
                frDTO.setCount(Integer.valueOf((int)this.estimateUniqueValues(searchParams, facetName)));
                frDTO.setFieldResult(new ArrayList());
                facetResults.add(frDTO);
            }
            return facetResults;
        }
        QueryResponse qr = this.query((SolrParams)facetQuery);
        SearchResultDTO searchResults = this.processSolrResponse((SearchRequestDTO)searchParams, qr, facetQuery, OccurrenceIndex.class);
        List facetResults = searchResults.getFacetResults();
        if (facetResults != null) {
            for (FacetResultDTO fr : facetResults) {
                FacetResultDTO frDTO = new FacetResultDTO();
                frDTO.setCount(fr.getCount());
                frDTO.setFieldName(fr.getFieldName());
                if (searchParams.getFoffset() == 0 && searchParams.getFlimit() >= 0) {
                    fr.setCount(Integer.valueOf((int)this.estimateUniqueValues(searchParams, searchParams.getFacets()[0])));
                } else if (fr.getCount() == null) {
                    fr.setCount(Integer.valueOf(fr.getFieldResult().size()));
                }
                if (searchParams.getFlimit() == null || searchParams.getFlimit() >= fr.getFieldResult().size() || searchParams.getFlimit() < 0) continue;
                fr.setFieldResult(fr.getFieldResult().subList(0, searchParams.getFlimit()));
            }
        }
        return facetResults;
    }

    public SolrDocumentList findByFulltext(SpatialSearchRequestDTO searchParams) throws Exception {
        SolrDocumentList sdl = null;
        try {
            searchParams.setFacet(Boolean.valueOf(false));
            SolrQuery solrQuery = this.initSolrQuery(searchParams, false, null);
            sdl = this.indexDao.runSolrQuery(solrQuery).getResults();
        }
        catch (SolrServerException ex) {
            this.logError("Problem communicating with SOLR server. ", ex.getMessage());
        }
        return sdl;
    }

    private void logError(String description, String message) {
        String requestID = MDC.get((String)"X-Request-ID");
        if (requestID != null) {
            logger.error((Object)(description + ", RequestID:" + requestID + " Error : " + message));
        } else {
            logger.error((Object)(description + " : " + message));
        }
    }

    public List<LegendItem> getLegend(SpatialSearchRequestDTO searchParams, String facetField, String[] cutpoints) throws Exception {
        return this.getLegend(searchParams, facetField, cutpoints, false);
    }

    @Cacheable(value={"legendCache"})
    public List<LegendItem> getLegend(SpatialSearchRequestDTO searchParams, String facetField, String[] cutpoints, boolean skipI18n) throws Exception {
        List facetDates;
        ArrayList<LegendItem> legend = new ArrayList<LegendItem>();
        this.queryFormatUtils.formatSearchQuery(searchParams);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("getLegend -search query: " + searchParams.getFormattedQuery()));
        }
        SolrQuery solrQuery = this.initSolrQuery(searchParams, false, null);
        this.emptyFacetRequest(solrQuery, this.wmslegendMaxItems - 1, 0, true);
        if (cutpoints == null) {
            solrQuery.addFacetField(new String[]{facetField});
        } else {
            solrQuery.addFacetQuery("-" + facetField + ":*");
            for (int i = 0; i < cutpoints.length; i += 2) {
                solrQuery.addFacetQuery(facetField + ":[" + cutpoints[i] + " TO " + cutpoints[i + 1] + "]");
            }
        }
        if ("year".equals(facetField) || "decade".equals(facetField)) {
            solrQuery.setFacetSort("index");
            solrQuery.setFacetLimit(-1);
        } else {
            solrQuery.setFacetSort("count");
        }
        QueryResponse qr = this.indexDao.runSolrQuery(solrQuery);
        long remainderCount = qr.getResults().getNumFound();
        List facets = qr.getFacetFields();
        if (facets != null) {
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                if (!facet.getName().contains(facetField) || facetEntries == null || facetEntries.isEmpty()) continue;
                ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                for (int i = 0; i < facetEntries.size(); ++i) {
                    FacetField.Count fcount = (FacetField.Count)facetEntries.get(i);
                    if (fcount.getCount() <= 0L) continue;
                    remainderCount -= fcount.getCount();
                    String fq = facetField + ":\"" + fcount.getName() + "\"";
                    if (fcount.getName() == null) {
                        fq = "-" + facetField + ":*";
                        arrayList.add((CallSite)((Object)(facetField + ":*")));
                    } else {
                        arrayList.add((CallSite)((Object)("-" + fq)));
                    }
                    if (skipI18n) {
                        legend.add(new LegendItem(fcount.getName(), null, fcount.getName(), fcount.getCount(), fq));
                        continue;
                    }
                    String i18nCode = null;
                    i18nCode = StringUtils.isNotBlank((String)fcount.getName()) ? this.fieldMappingUtil.translateFieldName(facetField) + "." + fcount.getName() : this.fieldMappingUtil.translateFieldName(facetField) + ".novalue";
                    legend.add(new LegendItem(this.getFacetValueDisplayName(facetField, fcount.getName()), i18nCode, fcount.getName(), fcount.getCount(), fq));
                }
                if (remainderCount <= 0L) break;
                String theFq = "-(" + StringUtils.join(arrayList, (String)" AND ") + ")";
                legend.add(legend.size(), new LegendItem("Other " + this.messageSource.getMessage("facet." + facetField, null, this.messageSource.getMessage(facetField, null, facetField, null), null), facetField + ".other", "", remainderCount, theFq, true));
                break;
            }
        }
        if (cutpoints == null) {
            if (facetField.equals("month")) {
                Collections.sort(legend, new /* Unavailable Anonymous Inner Class!! */);
            } else if (facetField.equals("year") || facetField.equals("decade")) {
                Collections.sort(legend, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        String tFacetField = this.fieldMappingUtil.translateFieldName(facetField);
        Map facetq = qr.getFacetQuery();
        if (facetq != null && facetq.size() > 0) {
            for (Map.Entry entry : facetq.entrySet()) {
                legend.add(new LegendItem(this.getFacetValueDisplayName(tFacetField, (String)entry.getKey()), tFacetField + "." + (String)entry.getKey(), (String)entry.getKey(), (long)((Integer)entry.getValue()).intValue(), (String)entry.getKey()));
            }
        }
        if ((facetDates = qr.getFacetDates()) != null && !facetDates.isEmpty()) {
            FacetField facetField2 = (FacetField)facetDates.get(0);
            String firstDate = null;
            for (FacetField.Count facetEntry : facetField2.getValues()) {
                Object finishDate;
                String startDate = facetEntry.getName();
                if (firstDate == null) {
                    firstDate = startDate;
                }
                if (DECADE_PRE_1850_LABEL.equals(startDate)) {
                    startDate = "*";
                    finishDate = firstDate;
                } else {
                    int startYear = Integer.parseInt(startDate.substring(0, 4));
                    finishDate = startYear - 1 + "-12-31T23:59:59Z";
                }
                legend.add(new LegendItem(this.getFacetValueDisplayName(facetEntry.getFacetField().getName(), facetEntry.getName()), facetEntry.getFacetField().getName() + "." + facetEntry.getName(), facetEntry.getFacetField().getName(), facetEntry.getCount(), "occurrenceYear:[" + startDate + " TO " + (String)finishDate + "]"));
            }
        }
        this.addColours(legend, cutpoints);
        return legend;
    }

    private void addColours(List<LegendItem> legend, String[] cutpoints) {
        int offset = 0;
        for (int i = 0; i < legend.size(); ++i) {
            LegendItem li = legend.get(i);
            int colour = this.DEFAULT_COLOUR;
            if (cutpoints == null) {
                colour = ColorUtil.colourList[Math.min(i, ColorUtil.colourList.length - 1)];
            } else if (cutpoints != null && i - offset < cutpoints.length) {
                if (StringUtils.isEmpty((String)legend.get(i).getName()) || legend.get(i).getName().equals("Unknown") || legend.get(i).getName().startsWith("-")) {
                    ++offset;
                } else {
                    colour = ColorUtil.getRangedColour((int)(i - offset), (int)(cutpoints.length / 2));
                }
            }
            li.setColour(colour);
        }
    }

    private void emptyFacetRequest(SolrQuery solrQuery, int facetLimit, int facetOffset, boolean includeMissing) {
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(facetLimit);
        solrQuery.set("facet.offset", facetOffset);
        solrQuery.setFacetMissing(Boolean.valueOf(includeMissing));
        if (solrQuery.getFacetFields() != null) {
            Arrays.stream(solrQuery.getFacetFields()).forEach(arg_0 -> ((SolrQuery)solrQuery).removeFacetField(arg_0));
        }
        if (solrQuery.getFacetQuery() != null) {
            Arrays.stream(solrQuery.getFacetQuery()).forEach(arg_0 -> ((SolrQuery)solrQuery).removeFacetQuery(arg_0));
        }
    }

    public FacetField getFacet(SpatialSearchRequestDTO searchParams, String facet) throws Exception {
        SolrQuery solrQuery = this.initSolrQuery(searchParams, false, null);
        this.emptyFacetRequest(solrQuery, -1, 0, false);
        solrQuery.addFacetField(new String[]{facet});
        QueryResponse qr = this.indexDao.runSolrQuery(solrQuery);
        return (FacetField)qr.getFacetFields().get(0);
    }

    public List<DataProviderCountDTO> getDataProviderList(SpatialSearchRequestDTO requestParams) throws Exception {
        List facetEntries;
        ArrayList<DataProviderCountDTO> dataProviderList = new ArrayList<DataProviderCountDTO>();
        String dataProviderUid = "dataProviderUid";
        FacetField facet = this.getFacet(requestParams, dataProviderUid);
        String[] oldFq = requestParams.getFacets();
        if (facet != null && (facetEntries = facet.getValues()) != null && facetEntries.size() > 0) {
            for (int i = 0; i < facetEntries.size(); ++i) {
                FacetField.Count fcount = (FacetField.Count)facetEntries.get(i);
                String dataProviderName = this.collectionCache.getNameForCode(fcount.getName());
                if (!StringUtils.isNotEmpty((String)dataProviderName)) continue;
                dataProviderList.add(new DataProviderCountDTO(fcount.getName(), dataProviderName, fcount.getCount()));
            }
        }
        requestParams.setFacets(oldFq);
        return dataProviderList;
    }

    public void findAllSpeciesJSON(SpatialSearchRequestDTO requestParams, OutputStream outputStream) throws Exception {
        if (requestParams.getFacets() == null || requestParams.getFacets().length != 1) {
            requestParams.setFacets(new String[]{"names_and_lsid"});
        }
        this.getSpeciesCountsJSON(requestParams, outputStream);
    }

    public void findAllSpeciesCSV(SpatialSearchRequestDTO requestParams, OutputStream outputStream) throws Exception {
        if (requestParams.getFacets() == null || requestParams.getFacets().length != 1) {
            requestParams.setFacets(new String[]{"names_and_lsid"});
        }
        this.getSpeciesCountsCSV(requestParams, outputStream);
    }

    public Map<String, Integer> getOccurrenceCountsForTaxa(List<String> taxa, String[] filterQueries) throws Exception {
        SolrQuery solrQuery = new SolrQuery();
        this.emptyFacetRequest(solrQuery, taxa.size(), 0, false);
        if (filterQueries != null && filterQueries.length > 0) {
            solrQuery.setFilterQueries(filterQueries);
        }
        StringBuilder sb = new StringBuilder();
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        HashMap<String, String> lftToGuid = new HashMap<String, String>();
        for (String lsid : taxa) {
            String[] values = this.searchUtils.getTaxonSearch(lsid);
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(values[0]);
            lftToGuid.put(values[0], lsid);
            solrQuery.add("facet.query", new String[]{values[0]});
        }
        solrQuery.setQuery(sb.toString());
        QueryResponse qr = this.indexDao.runSolrQuery(solrQuery);
        Map facetQueries = qr.getFacetQuery();
        for (String facet : facetQueries.keySet()) {
            String lsid = (String)lftToGuid.get(facet);
            Integer count = (Integer)facetQueries.get(facet);
            if (lsid == null || count == null) continue;
            counts.put(lsid, count);
        }
        logger.debug((Object)facetQueries);
        return counts;
    }

    public Integer getMaxSolrOnlineDownloadThreads() {
        return this.maxSolrDownloadThreads;
    }

    private QueryResponse query(SolrParams query) throws Exception {
        return this.indexDao.query(query);
    }

    public int getMaxBooleanClauses() {
        if (this.maxBooleanClauses == 0) {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setFacet(false);
            solrQuery.setRows(Integer.valueOf(0));
            int value = 1024;
            boolean ok = false;
            int step = -1;
            while (step != 0 || !ok) {
                String q = "1" + StringUtils.repeat((String)" AND 1", (int)(value - 1));
                solrQuery.setQuery(q);
                try {
                    this.query((SolrParams)solrQuery);
                    if (step == -1) {
                        value *= 2;
                    } else {
                        step /= 2;
                    }
                    ok = true;
                }
                catch (Exception e) {
                    if (step == -1) {
                        step = value / 2;
                    } else if (!ok && step > 1) {
                        step /= 2;
                    }
                    ok = false;
                }
                if (step == -1) continue;
                if (ok) {
                    value += step;
                    continue;
                }
                value -= step;
            }
            this.maxBooleanClauses = value;
        }
        this.queryFormatUtils.setMaxBooleanClauses(this.maxBooleanClauses);
        return this.maxBooleanClauses;
    }

    public QueryResponse searchGroupedFacets(SpatialSearchRequestDTO searchParams) throws Exception {
        searchParams.setPageSize(Integer.valueOf(0));
        searchParams.setFacet(Boolean.valueOf(false));
        SolrQuery solrQuery = this.initSolrQuery(searchParams, false, null);
        StringBuilder sb = new StringBuilder("{");
        int facets = 0;
        for (String facet : searchParams.getFacets()) {
            if (!StringUtils.isNotEmpty((String)searchParams.getFl())) continue;
            if (facets > 0) {
                sb.append(",");
            }
            ++facets;
            sb.append(facet).append(":{type:terms,limit:-1,sort:index,field:").append(this.fieldMappingUtil.translateFieldName(facet)).append(",facet:{");
            int fls = 0;
            for (String fl : searchParams.getFl().split(",")) {
                if (fls > 0) {
                    sb.append(",");
                }
                ++fls;
                sb.append(this.fieldMappingUtil.translateFieldName(fl)).append(":{type:terms,limit:1,sort:index,field:").append(this.fieldMappingUtil.translateFieldName(fl)).append("}");
            }
            sb.append("}}}");
        }
        solrQuery.add("json.facet", new String[]{sb.toString()});
        return this.query((SolrParams)solrQuery);
    }

    String getFormattedFqQuery(String facet, String value) {
        if (facet.equals("occurrenceYear")) {
            if (value.equals(DECADE_PRE_1850_LABEL)) {
                return facet + ":[* TO 1850-01-01T00:00:00Z]";
            }
            SimpleDateFormat sdf = new SimpleDateFormat(SOLR_DATE_FORMAT);
            try {
                Date date = sdf.parse(value);
                Date endDate = DateUtils.addYears((Date)date, (int)10);
                endDate = DateUtils.addMilliseconds((Date)endDate, (int)-1);
                return facet + ":[" + value + " TO " + sdf.format(endDate) + "]";
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return facet + ":\"" + value.replace("\"", "\\\"") + "\"";
    }

    String getFacetValueDisplayName(String facet, String value) {
        String tFacet = this.fieldMappingUtil.translateFieldName(facet);
        String tValue = this.fieldMappingUtil.translateFieldValue(tFacet, value);
        if (facet.endsWith("_uid") || facet.endsWith("Uid")) {
            return this.searchUtils.getUidDisplayString(tFacet, tValue, false);
        }
        if ("occurrenceYear".equals(facet) && value != null) {
            try {
                if (DECADE_PRE_1850_LABEL.equals(value)) {
                    return this.messageSource.getMessage("decade.pre.start", null, "pre 1850", null);
                }
                SimpleDateFormat sdf = new SimpleDateFormat(SOLR_DATE_FORMAT);
                Date date = sdf.parse(value);
                SimpleDateFormat df = new SimpleDateFormat("yyyy");
                String year = df.format(date);
                return year + "-" + (Integer.parseInt(year) + 9);
            }
            catch (ParseException pe) {
                return facet;
            }
        }
        if (this.searchUtils.getAuthIndexFields().contains(tFacet)) {
            return this.authService.getDisplayNameFor(value);
        }
        if (this.messageSource != null) {
            if (StringUtils.isNotBlank((String)value)) {
                return this.messageSource.getMessage(tFacet + "." + tValue, null, value, (Locale)null);
            }
            return this.messageSource.getMessage(this.fieldMappingUtil.translateFieldName(facet) + ".novalue", null, "Not supplied", (Locale)null);
        }
        return value;
    }

    public List<FacetPivotResultDTO> searchPivot(SpatialSearchRequestDTO searchParams) throws Exception {
        ArrayList<FacetPivotResultDTO> output;
        block0: {
            Map.Entry pfl;
            List list;
            String pivot = StringUtils.join((Object[])searchParams.getFacets(), (String)",");
            searchParams.setFacets(new String[0]);
            searchParams.setFacet(Boolean.valueOf(true));
            searchParams.setPageSize(Integer.valueOf(0));
            SolrQuery query = this.initSolrQuery(searchParams, false, null);
            query.setFields(new String[0]);
            query.add("facet.pivot", new String[]{pivot});
            query.add("facet.pivot.mincount", new String[]{"1"});
            query.add("facet.missing", new String[]{"true"});
            QueryResponse response = this.indexDao.runSolrQuery(query);
            NamedList result = response.getFacetPivot();
            output = new ArrayList<FacetPivotResultDTO>();
            Iterator iterator = result.iterator();
            if (!iterator.hasNext() || (list = (List)(pfl = (Map.Entry)iterator.next()).getValue()) == null || list.size() <= 0) break block0;
            output.add(new FacetPivotResultDTO(((PivotField)list.get(0)).getField(), this.getFacetPivotResults(list), null, Integer.valueOf((int)response.getResults().getNumFound())));
        }
        return output;
    }

    private List<FacetPivotResultDTO> getFacetPivotResults(List<PivotField> pfl) {
        if (pfl == null || pfl.size() == 0) {
            return null;
        }
        ArrayList<FacetPivotResultDTO> list = new ArrayList<FacetPivotResultDTO>();
        for (PivotField pf : pfl) {
            String value;
            String string = value = pf.getValue() != null ? pf.getValue().toString() : null;
            if (pf.getPivot() != null && pf.getPivot().size() != 0) continue;
            list.add(new FacetPivotResultDTO(null, null, value, Integer.valueOf(pf.getCount())));
        }
        return list;
    }

    public StringBuilder getAllQAFields() {
        StringBuilder qasb = new StringBuilder();
        ErrorCode[] errorCodes = AssertionCodes.getAll();
        Arrays.sort(errorCodes, new /* Unavailable Anonymous Inner Class!! */);
        for (ErrorCode assertionCode : errorCodes) {
            if (qasb.length() > 0) {
                qasb.append(",");
            }
            qasb.append(assertionCode.getName());
        }
        return qasb;
    }

    public List<FieldStatsItem> searchStat(SpatialSearchRequestDTO searchParams, String field, String facet, Collection<String> statType) throws Exception {
        searchParams.setFacets(new String[0]);
        if (facet != null) {
            searchParams.setFacet(Boolean.valueOf(true));
        }
        searchParams.setFacets(new String[0]);
        SolrQuery query = this.initSolrQuery(searchParams, false, null);
        query.setRows(Integer.valueOf(0));
        query.setFields(new String[0]);
        query.add("stats", new String[]{"true"});
        if (facet != null) {
            query.add("stats.facet", new String[]{facet});
        }
        query.add("stats.field", new String[]{"{!" + StringUtils.join(statType, (String)"=true ") + "=true}" + this.fieldMappingUtil.translateFieldName(field)});
        QueryResponse response = this.indexDao.runSolrQuery(query);
        ArrayList<FieldStatsItem> output = new ArrayList<FieldStatsItem>();
        if (facet != null && response.getFieldStatsInfo().size() > 0) {
            for (FieldStatsInfo f : (List)((FieldStatsInfo)response.getFieldStatsInfo().values().iterator().next()).getFacets().values().iterator().next()) {
                FieldStatsItem item = new FieldStatsItem(f);
                if (f.getName() == null) {
                    item.setFq("-" + facet + ":*");
                } else {
                    item.setFq(facet + ":\"" + f.getName() + "\"");
                }
                item.setLabel(f.getName());
                output.add(item);
            }
        } else if (response.getFieldStatsInfo().size() > 0) {
            output.add(new FieldStatsItem((FieldStatsInfo)response.getFieldStatsInfo().values().iterator().next()));
        }
        return output;
    }

    @Cacheable(value={"getColours"})
    public List<LegendItem> getColours(SpatialSearchRequestDTO request, String colourMode) throws Exception {
        List<Object> colours = new ArrayList<LegendItem>();
        if (colourMode.equals("grid")) {
            for (int i = 0; i <= 500; i += 100) {
                LegendItem li = i == 0 ? new LegendItem(">0", "", "", 0L, null) : new LegendItem(String.valueOf(i), "", "", 0L, null);
                li.setColour((500 - i) / 2 << 8 | 0xFF0000);
                colours.add(li);
            }
        } else {
            String[] s = colourMode.split(",");
            String[] cutpoints = null;
            if (s.length > 1) {
                cutpoints = new String[s.length - 1];
                System.arraycopy(s, 1, cutpoints, 0, cutpoints.length);
            }
            if (s[0].equals("-1") || s[0].equals("grid")) {
                return null;
            }
            colours = this.getLegend(request, s[0], cutpoints, true);
        }
        return colours;
    }

    public double[] getBBox(SpatialSearchRequestDTO requestParams) throws Exception {
        SolrQuery query = this.initSolrQuery(requestParams, false, null);
        query.setRows(Integer.valueOf(0));
        query.setFacet(false);
        query.add("json.facet", new String[]{"{x2:\"max(decimalLongitude)\",x1:\"min(decimalLongitude)\",y2:\"max(decimalLatitude)\",y1:\"min(decimalLatitude)\"}"});
        QueryResponse qr = this.indexDao.query((SolrParams)query);
        SimpleOrderedMap facets = SearchUtils.getMap((Object)qr.getResponse(), (Object[])new Object[]{"facets"});
        return new double[]{this.toDouble(facets.get("x1")), this.toDouble(facets.get("y1")), this.toDouble(facets.get("x2")), this.toDouble(facets.get("y2"))};
    }

    public long estimateUniqueValues(SpatialSearchRequestDTO requestParams, String facet) throws Exception {
        SolrQuery query = this.initSolrQuery(requestParams, false, null);
        query.setRows(Integer.valueOf(0));
        query.setFacet(false);
        query.add("json.facet", new String[]{"{unique:\"hll(" + this.fieldMappingUtil.translateFieldName(facet) + ")\"}"});
        QueryResponse qr = this.indexDao.query((SolrParams)query);
        SimpleOrderedMap facets = SearchUtils.getMap((Object)qr.getResponse(), (Object[])new Object[]{"facets"});
        Object value = facets.get("unique");
        if (value == null) {
            return 0L;
        }
        return this.toLong(value);
    }

    private long toLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        return Long.parseLong(o.toString());
    }

    private double toDouble(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        return Double.parseDouble(o.toString());
    }

    @Deprecated
    public List<String> listFacets(SpatialSearchRequestDTO searchParams) throws Exception {
        searchParams.setFacet(Boolean.valueOf(true));
        searchParams.setFacets(new String[0]);
        SolrQuery solrQuery = this.initSolrQuery(searchParams, false, null);
        solrQuery.setFacetLimit(-1);
        solrQuery.setRows(Integer.valueOf(0));
        ArrayList<String> found = new ArrayList<String>();
        for (IndexFieldDTO s : this.indexDao.getIndexedFields()) {
            if (s.isDeprecated() || s.getDataType() == null || s.getDataType().startsWith("t")) continue;
            solrQuery.set("facet.field", new String[]{"{!facet.method=enum facet.exists=true}" + s.getName()});
            QueryResponse qr = this.query((SolrParams)solrQuery);
            for (FacetField f : qr.getFacetFields()) {
                if (f.getValues().isEmpty()) continue;
                found.add(f.getName());
            }
        }
        return found;
    }

    @Cacheable(value={"heatmapCache"})
    public HeatmapDTO getHeatMap(String query, String[] filterQueries, Double minx, Double miny, Double maxx, Double maxy, List<LegendItem> legend, int gridSizeInPixels) throws Exception {
        ArrayList<List> layers = new ArrayList<List>();
        if (miny < -90.0) {
            miny = -90.0;
        }
        if (maxy > 90.0) {
            maxy = 90.0;
        }
        while (maxx > 180.0) {
            maxx = maxx - 360.0;
        }
        while (minx < -180.0) {
            minx = minx + 360.0;
        }
        if (gridSizeInPixels > 1 || legend == null || legend.isEmpty()) {
            QueryResponse qr = null;
            SolrQuery solrQuery = this.createHeatmapQuery(query, filterQueries, minx, miny, maxx, maxy);
            qr = this.query((SolrParams)solrQuery);
            SimpleOrderedMap facetHeatMaps = (SimpleOrderedMap)((SimpleOrderedMap)qr.getResponse().get("facet_counts")).get("facet_heatmaps");
            Integer gridLevel = -1;
            if (facetHeatMaps != null) {
                SimpleOrderedMap heatmap = (SimpleOrderedMap)facetHeatMaps.get("quad");
                gridLevel = (Integer)heatmap.get("gridLevel");
                Integer rows = (Integer)heatmap.get("rows");
                Integer columns = (Integer)heatmap.get("columns");
                List layer = (List)heatmap.get("counts_ints2D");
                Double hminx = (Double)heatmap.get("minX");
                Double hminy = (Double)heatmap.get("minY");
                Double hmaxx = (Double)heatmap.get("maxX");
                Double hmaxy = (Double)heatmap.get("maxY");
                layers.add(layer);
                return new HeatmapDTO(gridLevel, layers, legend, gridSizeInPixels, rows, columns, hminx, hminy, hmaxx, hmaxy);
            }
        } else {
            Integer gridLevel = -1;
            Integer rows = 0;
            Integer columns = 0;
            Double hminx = minx;
            Double hminy = miny;
            Double hmaxx = maxx;
            Double hmaxy = maxy;
            boolean zoomOffset = false;
            for (int legendIdx = 0; legendIdx < legend.size(); ++legendIdx) {
                LegendItem legendItem = legend.get(legendIdx);
                QueryResponse qr = null;
                SolrQuery solrQuery = this.createHeatmapQuery(query, filterQueries, minx, miny, maxx, maxy);
                String[] fqs = Arrays.copyOf(solrQuery.getFilterQueries(), solrQuery.getFilterQueries().length + 1);
                fqs[fqs.length - 1] = legendItem.getFq();
                solrQuery.setFilterQueries(fqs);
                qr = this.query((SolrParams)solrQuery);
                if (qr != null) {
                    SimpleOrderedMap facetHeatMaps = (SimpleOrderedMap)((SimpleOrderedMap)qr.getResponse().get("facet_counts")).get("facet_heatmaps");
                    if (facetHeatMaps != null) {
                        SimpleOrderedMap heatmap = (SimpleOrderedMap)facetHeatMaps.get("quad");
                        gridLevel = (Integer)heatmap.get("gridLevel");
                        List layer = (List)heatmap.get("counts_ints2D");
                        rows = (Integer)heatmap.get("rows");
                        columns = (Integer)heatmap.get("columns");
                        hminx = (Double)heatmap.get("minX");
                        hminy = (Double)heatmap.get("minY");
                        hmaxx = (Double)heatmap.get("maxX");
                        hmaxy = (Double)heatmap.get("maxY");
                        layers.add(layer);
                        continue;
                    }
                    layers.add(null);
                    continue;
                }
                layers.add(null);
            }
            return new HeatmapDTO(gridLevel, layers, legend, gridSizeInPixels, rows, columns, hminx, hminy, hmaxx, hmaxy);
        }
        return null;
    }

    private SolrQuery createHeatmapQuery(String query, String[] filterQueries, Double minx, Double miny, Double maxx, Double maxy) {
        int zoomLevelByWidth;
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        solrQuery.set("facet.heatmap", new String[]{"quad"});
        if (minx < -180.0) {
            minx = minx + 360.0;
        }
        if (maxx > 180.0) {
            maxx = maxx - 360.0;
        }
        String geom = "[\"" + minx + " " + miny + "\" TO \"" + maxx + " " + maxy + "\"]";
        solrQuery.set("facet.heatmap.geom", new String[]{geom});
        double tileWidth = maxx > minx ? maxx - minx : maxx - (minx - 360.0);
        double[] solrGridLevelMap = new double[]{360.0, 180.0, 90.0, 45.0, 22.5, 11.25, 5.625, 2.8125, 1.40625, 0.703125, 0.3515625, 0.17578125, 0.087890625, 0.0439453125, 0.02197265625, 0.010986328125, 0.0054931640625, 0.00274658203125, 0.001373291015625, 6.866455078125E-4};
        for (zoomLevelByWidth = 0; zoomLevelByWidth < solrGridLevelMap.length && tileWidth < solrGridLevelMap[zoomLevelByWidth]; ++zoomLevelByWidth) {
        }
        int zoomLevelByHeight = 0;
        while (zoomLevelByHeight + 1 < solrGridLevelMap.length && maxy - miny < solrGridLevelMap[zoomLevelByHeight + 1]) {
            ++zoomLevelByHeight;
        }
        int gridLevel = Math.min(zoomLevelByWidth, zoomLevelByHeight) + 7;
        solrQuery.set("facet.heatmap.gridLevel", new String[]{String.valueOf(gridLevel)});
        solrQuery.setFacetLimit(-1);
        solrQuery.setFacet(true);
        solrQuery.setFilterQueries(filterQueries);
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery(query);
        return solrQuery;
    }

    public List<RecordJackKnifeStats> getOutlierStatsFor(String uuid) throws Exception {
        SolrQuery query = new SolrQuery();
        query.setQuery("id: \"" + uuid + "\"");
        query.setFields(new String[]{"taxonConceptID", "outlierLayer", "el*"});
        query.setRows(Integer.valueOf(1));
        QueryResponse qr = this.query((SolrParams)query);
        if (qr.getResults() == null || qr.getResults().isEmpty()) {
            return new ArrayList<RecordJackKnifeStats>();
        }
        SolrDocument doc = (SolrDocument)qr.getResults().get(0);
        Collection outlierLayers = doc.getFieldValues("outlierLayer");
        String taxonConceptID = (String)doc.getFieldValue("taxonConceptID");
        if (outlierLayers == null || outlierLayers.isEmpty() || taxonConceptID == null) {
            return new ArrayList<RecordJackKnifeStats>();
        }
        ArrayList<RecordJackKnifeStats> statsList = new ArrayList<RecordJackKnifeStats>();
        for (Object layerId : outlierLayers) {
            RecordJackKnifeStats stats = new RecordJackKnifeStats();
            SolrQuery layerQuery = new SolrQuery();
            layerQuery.setQuery("taxonConceptID: \"" + taxonConceptID + "\" AND outlierLayer:\"" + layerId + "\"");
            layerQuery.setFacet(true);
            layerQuery.addFacetField(new String[]{(String)layerId});
            layerQuery.setRows(Integer.valueOf(0));
            QueryResponse facetQr = this.query((SolrParams)layerQuery);
            FacetField ff = (FacetField)facetQr.getFacetFields().get(0);
            List outlierFieldValues = ff.getValues().stream().map(count -> Float.valueOf(Float.parseFloat(count.getName()))).collect(Collectors.toList());
            stats.setOutlierValues(outlierFieldValues);
            stats.setLayerId((String)layerId);
            stats.setRecordLayerValue((Float)doc.getFieldValue((String)layerId));
            statsList.add(stats);
        }
        return statsList;
    }

    public int streamingQuery(SpatialSearchRequestDTO request, ProcessInterface procSearch, ProcessInterface procFacet) throws Exception {
        return this.indexDao.streamingQuery(this.initSolrQuery(request, true, null), procSearch, procFacet, null);
    }
}

