/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dao.StoreDAO;
import au.org.ala.biocache.dto.Qid;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.service.DataQualityService;
import au.org.ala.biocache.util.QidMissingException;
import au.org.ala.biocache.util.QidSizeException;
import au.org.ala.biocache.util.QueryFormatUtils;
import au.org.ala.biocache.util.SpatialUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component(value="qidCacheDao")
public class QidCacheDAOImpl
implements QidCacheDAO {
    private final Logger logger = Logger.getLogger(QidCacheDAOImpl.class);
    @Value(value="${qid.cache.size.max:104857600}")
    long maxCacheSize;
    @Value(value="${qid.cache.size.min:52428800}")
    long minCacheSize;
    @Value(value="${qid.cache.largestCacheableSize:5242880}")
    long largestCacheableSize;
    @Value(value="${qid.wkt.maxPoints:5000}")
    private int maxWktPoints;
    @Value(value="${qid.wkt.simplification.factor:2.0}")
    private double wktSimplificationFactor;
    @Value(value="${qid.wkt.simplification.initialprecision:0.0001}")
    private double wktSimplificationInitialPrecision;
    @Value(value="${qid.wkt.simplification.maxprecision:10.0}")
    private double wktSimplificationMaxPrecision;
    @Inject
    private DataQualityService dataQualityService;
    @Inject
    protected QueryFormatUtils queryFormatUtils;
    private ConcurrentMap<String, Qid> cache = new ConcurrentHashMap();
    private final Object counterLock = new Object();
    private long cacheSize;
    private CountDownLatch counter;
    private long triggerCleanSize = this.minCacheSize + (this.maxCacheSize - this.minCacheSize) / 2L;
    private Thread cacheCleaner;
    @Inject
    private SearchDAO searchDAO;
    @Inject
    private StoreDAO storeDao;
    Object idLock = new Object();
    long lastId = 0L;

    public QidCacheDAOImpl() {
        this.counter = new CountDownLatch(1);
        this.cacheCleaner = new /* Unavailable Anonymous Inner Class!! */;
        this.cacheCleaner.setName("qid-cache-cleaner");
        this.cacheCleaner.start();
        try {
            this.updateTriggerCleanSize();
            this.logger.debug((Object)("maxCacheSize > " + this.maxCacheSize + ", minCacheSize > " + this.minCacheSize));
        }
        catch (Exception e) {
            this.logger.error((Object)"cannot load qid.properties", (Throwable)e);
        }
    }

    public synchronized String put(String q, String displayQ, String wkt, double[] bbox, String[] fqs, long maxAge, String source) throws QidSizeException {
        Qid qid = new Qid(null, q, displayQ, wkt, bbox, Long.valueOf(0L), fqs, Long.valueOf(maxAge), source);
        if (qid.getSize() > this.largestCacheableSize) {
            throw new QidSizeException(qid.getSize().longValue());
        }
        this.save(qid);
        while (!this.put(qid)) {
        }
        return qid.getRowKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean put(Qid qid) {
        boolean runCleaner = false;
        Object object = this.counterLock;
        synchronized (object) {
            this.logger.debug((Object)("new cache size: " + this.cacheSize));
            if (this.cacheSize + qid.getSize() > this.maxCacheSize) {
                runCleaner = true;
                this.logger.debug((Object)"not putting qid");
            } else {
                if (this.cacheSize + qid.getSize() > this.triggerCleanSize) {
                    this.counter.countDown();
                }
                this.cacheSize += qid.getSize().longValue();
                this.logger.debug((Object)"putting qid");
                this.cache.put(qid.getRowKey(), qid);
            }
        }
        if (runCleaner) {
            this.logger.debug((Object)"cleaning qid cache");
            this.cleanCache();
            return false;
        }
        return true;
    }

    public Qid get(String key) throws QidMissingException {
        Qid obj = (Qid)this.cache.get(key);
        if (obj == null && (obj = this.load(key)) != null) {
            obj.setDisplayString(null);
            this.cache.put(key, obj);
            if (obj.getQ() != null && obj.getQ().indexOf(92) >= 0) {
                obj.setQ(this.removeSolrEscaping(obj.getQ()));
            }
        }
        if (obj == null) {
            throw new QidMissingException(key);
        }
        obj.setLastUse(Long.valueOf(System.currentTimeMillis()));
        return obj;
    }

    private String removeSolrEscaping(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        char c = ' ';
        int len = s.length() - 1;
        for (int i = 0; i < len; ++i) {
            char a = s.charAt(i);
            c = s.charAt(i + 1);
            if (a == '\\' && (c == 92 || c == 43 || c == 45 || c == 33 || c == 40 || c == 41 || c == 58 || c == 94 || c == 91 || c == 93 || c == 34 || c == 123 || c == 125 || c == 126 || c == 42 || c == 63 || c == 124 || c == 38 || c == 59 || c == 47 || Character.isWhitespace(c))) continue;
            sb.append(a);
        }
        sb.append(c);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanCache() {
        this.updateTriggerCleanSize();
        if (this.cacheSize < this.triggerCleanSize) {
            return;
        }
        ArrayList entries = new ArrayList(this.cache.entrySet());
        Collections.sort(entries, new /* Unavailable Anonymous Inner Class!! */);
        long size = 0L;
        int numberRemoved = 0;
        for (int i = 0; i < entries.size(); ++i) {
            if (size + ((Qid)((Map.Entry)entries.get(i)).getValue()).getSize() > this.minCacheSize) {
                String key = (String)((Map.Entry)entries.get(i)).getKey();
                this.cache.remove(key);
                ++numberRemoved;
                continue;
            }
            size += ((Qid)((Map.Entry)entries.get(i)).getValue()).getSize().longValue();
        }
        Object object = this.counterLock;
        synchronized (object) {
            this.cacheSize -= this.minCacheSize - size;
            size = this.cacheSize;
        }
        this.logger.debug((Object)("removed " + numberRemoved + " cached qids, new cache size " + size));
    }

    void save(Qid value) {
        value.setRowKey(String.valueOf(this.nextId()));
        try {
            this.storeDao.put(value.getRowKey(), (Object)value);
        }
        catch (Exception e) {
            this.logger.error((Object)"faild to save qid to db", (Throwable)e);
        }
    }

    Qid load(String key) throws QidMissingException {
        try {
            return this.storeDao.get(Qid.class, key).orElse(null);
        }
        catch (Exception e) {
            this.logger.error((Object)("failed to find qid:" + key), (Throwable)e);
            throw new QidMissingException(key);
        }
    }

    public void setMaxCacheSize(long sizeInBytes) {
        this.maxCacheSize = sizeInBytes;
        this.updateTriggerCleanSize();
    }

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMinCacheSize(long sizeInBytes) {
        this.minCacheSize = sizeInBytes;
        this.updateTriggerCleanSize();
    }

    public long getMinCacheSize() {
        return this.minCacheSize;
    }

    public void setLargestCacheableSize(long sizeInBytes) {
        this.largestCacheableSize = sizeInBytes;
    }

    public long getLargestCacheableSize() {
        return this.largestCacheableSize;
    }

    public long getSize() {
        return this.cacheSize;
    }

    void updateTriggerCleanSize() {
        this.triggerCleanSize = this.minCacheSize + (this.maxCacheSize - this.minCacheSize) / 2L;
        this.logger.debug((Object)("triggerCleanSize=" + this.triggerCleanSize + " minCacheSize=" + this.minCacheSize + " maxCacheSize=" + this.maxCacheSize));
    }

    public String[] getFq(SpatialSearchRequestDTO requestParams) {
        int requestParamsFqLength = requestParams.getFq() != null ? requestParams.getFq().length : 0;
        String[] qidFq = null;
        int qidFqLength = 0;
        String q = requestParams.getQ();
        if (q.startsWith("qid:")) {
            try {
                qidFq = this.get(q.substring(4)).getFqs();
                if (qidFq != null) {
                    qidFqLength = qidFq.length;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (requestParamsFqLength + qidFqLength == 0) {
            return null;
        }
        String[] allFqs = new String[requestParamsFqLength + qidFqLength];
        if (requestParamsFqLength > 0) {
            System.arraycopy(requestParams.getFq(), 0, allFqs, 0, requestParamsFqLength);
        }
        if (qidFqLength > 0) {
            System.arraycopy(qidFq, 0, allFqs, requestParamsFqLength, qidFqLength);
        }
        return allFqs;
    }

    @Cacheable(value={"qidGeneration"})
    public String generateQid(SpatialSearchRequestDTO requestParams, String bbox, String title, Long maxage, String source) {
        try {
            String[] fqs;
            String wkt = requestParams.getWkt();
            if (wkt != null && wkt.length() > 0) {
                if ((wkt = this.fixWkt(wkt)) == null) {
                    return null;
                }
                requestParams.setWkt(wkt);
            }
            double[] bb = null;
            if (bbox != null && bbox.equals("true")) {
                try {
                    bb = this.searchDAO.getBBox(requestParams);
                }
                catch (Exception e) {
                    bb = new double[]{-180.0, -90.0, 180.0, 90.0};
                }
            } else {
                requestParams.setPageSize(Integer.valueOf(0));
                requestParams.setFacet(Boolean.valueOf(false));
                this.queryFormatUtils.formatSearchQuery(requestParams);
            }
            if (title == null) {
                title = requestParams.getDisplayString();
            }
            if ((fqs = this.dataQualityService.generateCombinedFqs(requestParams)).length == 0 || fqs.length == 1 && fqs[0].length() == 0) {
                fqs = null;
            }
            String qid = this.put(requestParams.getQ(), title, requestParams.getWkt(), bb, fqs, maxage.longValue(), source);
            return qid;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error generating QID for q = " + requestParams.getQ() + ", fq = " + requestParams.getFq()), (Throwable)e);
            return null;
        }
    }

    @Cacheable(value={"fixWkt"})
    public String fixWkt(String wkt) {
        return SpatialUtils.simplifyWkt((String)wkt, (int)this.maxWktPoints, (double)this.wktSimplificationFactor, (double)this.wktSimplificationInitialPrecision, (double)this.wktSimplificationMaxPrecision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextId() {
        Object object = this.idLock;
        synchronized (object) {
            long id = System.currentTimeMillis();
            if (id == this.lastId) {
                ++id;
            }
            this.lastId = id;
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        Object object = this.counterLock;
        synchronized (object) {
            this.cache.clear();
            this.cacheSize = 0L;
            this.dataQualityService.clearCache();
        }
    }
}

