/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.config;

import au.org.ala.biocache.service.NameMatchSpeciesLookupService;
import au.org.ala.biocache.service.RestartDataService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.util.converter.FqConverter;
import au.org.ala.dataquality.api.QualityServiceRpcApi;
import au.org.ala.dataquality.client.ApiClient;
import au.org.ala.names.ws.client.ALANameUsageMatchServiceClient;
import au.org.ala.ws.ClientConfiguration;
import java.io.IOException;
import java.net.URL;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@Configuration
@EnableCaching
@EnableScheduling
public class AppConfig
implements WebMvcConfigurer {
    private static final Logger logger = Logger.getLogger(AppConfig.class);
    @Inject
    private AbstractMessageSource messageSource;
    @Value(value="${dataquality.baseUrl:https://dataquality.ala.org.au/}")
    protected String dataQualityBaseUrl;
    @Value(value="${namesearch.url:http://localhost:9179}")
    String nameSearchUrl = "http://localhost:9179";
    @Value(value="${namesearch.timeout:30}")
    Integer nameSearchTimeout = 30;
    @Value(value="${namesearch.cache.size:50}")
    Integer nameSearchCacheSize = 50;

    @Value(value="${restart.data.dir:/tmp}")
    public void setDatabase(String dir) {
        logger.debug((Object)("setting RestartDataService.dir: " + dir));
        RestartDataService.dir = dir;
    }

    @Bean(name={"nameUsageMatchService"})
    public ALANameUsageMatchServiceClient nameUsageMatchService() throws IOException {
        ClientConfiguration clientConfiguration = ClientConfiguration.builder().baseUrl(new URL(this.nameSearchUrl)).timeOut((long)(this.nameSearchTimeout * 1000)).cacheSize((long)(this.nameSearchCacheSize * 1024 * 1024)).build();
        return new ALANameUsageMatchServiceClient(clientConfiguration);
    }

    @Bean
    public TomcatServletWebServerFactory tomcatFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected SpeciesLookupService getNameMatchSpeciesLookupService() {
        logger.info((Object)"Initialising name match species lookup services.");
        NameMatchSpeciesLookupService service = new NameMatchSpeciesLookupService();
        service.setMessageSource(this.messageSource);
        return service;
    }

    @Bean(name={"speciesLookupService"})
    public SpeciesLookupService speciesLookupServiceBean() {
        logger.info((Object)"Initialising species lookup services.");
        return this.getNameMatchSpeciesLookupService();
    }

    @Bean(value={"dataQualityApiClient"})
    public ApiClient dataQualityApiClient() {
        ApiClient apiClient = new ApiClient();
        apiClient.getAdapterBuilder().baseUrl(this.dataQualityBaseUrl);
        return apiClient;
    }

    @Bean
    public QualityServiceRpcApi dataQualityApi(@Qualifier(value="dataQualityApiClient") ApiClient dataQualityApiClient) {
        return (QualityServiceRpcApi)dataQualityApiClient.createService(QualityServiceRpcApi.class);
    }

    @Bean
    public ViewResolver internalResourceViewResolver() {
        InternalResourceViewResolver bean = new InternalResourceViewResolver();
        bean.setViewClass(JstlView.class);
        bean.setPrefix("/WEB-INF/jsp/");
        bean.setSuffix(".jsp");
        return bean;
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/", "/swagger-ui.html");
    }

    @Bean
    @ConfigurationPropertiesBinding
    public FqConverter fqConverter() {
        return new FqConverter();
    }
}

