/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.writer;

import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.biocache.writer.RecordWriterError;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RecordWriterException
extends IOException {
    private static final Logger logger = Logger.getLogger(RecordWriterException.class);

    public RecordWriterException() {
        super("RecordWriter Exception");
    }

    public RecordWriterException(String msg) {
        super("RecordWriter Exception: " + msg);
    }

    public RecordWriterException(Throwable cause) {
        super("RecordWriter Exception", cause);
    }

    public RecordWriterException(String msg, Throwable cause) {
        super("RecordWriter Exception: " + msg, cause);
    }

    public static RecordWriterException newRecordWriterException(DownloadDetailsDTO dd, DownloadRequestDTO downloadParams, boolean solr, RecordWriterError writer) {
        Object msg = "";
        if (dd != null) {
            if (dd.getFileLocation() != null) {
                msg = (String)msg + "Offline request: " + dd.getFileLocation();
                logger.error((Object)"msg");
            } else {
                msg = (String)msg + "Online " + (solr ? "SOLR" : "Cassandra") + " download request: " + downloadParams.toString() + ", " + dd.getIpAddress();
            }
        } else if (downloadParams != null) {
            msg = (String)msg + "Online " + (solr ? "SOLR" : "Cassandra") + "  download request: " + downloadParams.toString();
        }
        return new RecordWriterException((String)msg, writer == null || writer.getErrors().isEmpty() ? null : (Throwable)writer.getErrors().get(0));
    }
}

