/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class XRequestIDFilter
extends OncePerRequestFilter {
    private final String mdcTokenKey = "X-Request-ID";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String token = this.extractToken(request);
        if (token != null) {
            MDC.put((String)"X-Request-ID", (String)token);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String extractToken(HttpServletRequest request) {
        return request.getHeader("X-Request-ID");
    }

    protected boolean isAsyncDispatch(HttpServletRequest request) {
        return false;
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }
}

