/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.RecordJackKnifeStats;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OutlierController {
    @Inject
    protected SearchDAO searchDAO;

    @Operation(summary="Retrieves the environmental outlier details for a record", tags={"Outliers"})
    @Tag(name="Outliers", description="Services for reporting on environmental or limital range status of occurrences")
    @RequestMapping(value={"/outlier/record/{recordUuid}"}, method={RequestMethod.GET})
    @ApiParam(value="recordUuid", required=true)
    @ResponseBody
    public List<RecordJackKnifeStats> getOutlierForUUid(@PathVariable(value="recordUuid") String recordUuid) throws Exception {
        return this.searchDAO.getOutlierStatsFor(recordUuid);
    }

    @Deprecated
    @Operation(summary="Deprecated - use /outlier/record/{recordUuid}", tags={"Deprecated"})
    @RequestMapping(value={"/outlier/record/{uuid}.json"}, method={RequestMethod.GET})
    @ApiParam(value="uuid", required=true)
    @ResponseBody
    public List<RecordJackKnifeStats> getOutlierForUUidDeprecated(@PathVariable(value="uuid") String recordUuid) throws Exception {
        return this.searchDAO.getOutlierStatsFor(recordUuid);
    }
}

