/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.IndexDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DuplicateRecordDetails;
import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.util.SearchUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DuplicationController {
    private static final Logger logger = Logger.getLogger(DuplicationController.class);
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected IndexDAO indexDao;
    @Inject
    protected SearchUtils searchUtils;

    @Operation(summary="Retrieves the duplication information for the supplied guid.", tags={"Duplicates"})
    @Tag(name="Duplicates", description="Services for retrieval of duplication information on occurrence records")
    @RequestMapping(value={"/duplicates/{recordUuid}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public DuplicateRecordDetails getDuplicateStats(@PathVariable(value="recordUuid") String recordUuid) throws Exception {
        return this.getDuplicateStatsForGuid(recordUuid);
    }

    private DuplicateRecordDetails getDuplicateStatsForGuid(String guid) {
        try {
            ArrayList<DuplicateRecordDetails> dups;
            SolrDocumentList sdl = this.searchDuplicates("id", guid);
            if (sdl.isEmpty()) {
                return null;
            }
            SolrDocument sd = (SolrDocument)sdl.get(0);
            DuplicateRecordDetails drd = new DuplicateRecordDetails(sd);
            if ("REPRESENTATIVE".equals(drd.getStatus())) {
                dups = new ArrayList<DuplicateRecordDetails>();
                SolrDocumentList list = this.searchDuplicates("isDuplicateOf", guid);
                for (SolrDocument d : list) {
                    dups.add(new DuplicateRecordDetails(d));
                }
            } else {
                if ("ASSOCIATED".equals(drd.getStatus())) {
                    return this.getDuplicateStatsForGuid(drd.getDuplicateOf());
                }
                return null;
            }
            drd.setDuplicates(dups);
            return drd;
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get duplicate details for " + guid), (Throwable)e);
            return new DuplicateRecordDetails();
        }
    }

    private SolrDocumentList searchDuplicates(String field, String value) throws Exception {
        SpatialSearchRequestDTO query = new SpatialSearchRequestDTO();
        query.setFacet(Boolean.valueOf(false));
        query.setQ(field + ":" + value);
        query.setFl(String.join((CharSequence)",", "id", "isDuplicateOf", "duplicateType", "duplicateStatus", "duplicateJustification", "taxonConceptID", PointType.POINT_1.getLabel(), PointType.POINT_01.getLabel(), PointType.POINT_001.getLabel(), PointType.POINT_0001.getLabel(), "lat_long", "raw_scientificName", "recordedBy", "recordNumber", "catalogNumber", "dataResourceUid"));
        return this.searchDAO.findByFulltext(query);
    }

    @Operation(summary="Retrieves the duplication statistics", tags={"Duplicates"})
    @RequestMapping(value={"/stats/{recordUuid}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, FieldStatsInfo> printStats(@PathVariable(value="recordUuid") String recordUuid) throws Exception {
        return this.indexDao.getStatistics(recordUuid);
    }
}

