/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.web.AbstractSecureController;
import au.org.ala.ws.security.profile.AlaUserProfile;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrDocumentList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;

@Controller
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DownloadController
extends AbstractSecureController {
    private static final Logger log = LoggerFactory.getLogger(DownloadController.class);
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected PersistentQueueDAO persistentQueueDAO;
    @Inject
    protected AuthService authService;
    @Inject
    protected DownloadService downloadService;

    @SecurityRequirement(name="JWT")
    @Secured(value={"ROLE_ADMIN"})
    @Operation(summary="Retrieves all the downloads that are on the queue", tags={"Monitoring"})
    @RequestMapping(value={"occurrences/offline/download/stats"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List getCurrentDownloads() {
        JsonConfig config = new JsonConfig();
        config.setJsonPropertyFilter((source, name, value) -> value == null);
        JSONArray ja = JSONArray.fromObject((Object)this.persistentQueueDAO.getAllDownloads(), (JsonConfig)config);
        for (Object jo : ja) {
            String id = (String)((JSONObject)jo).get("uniqueId");
            ((JSONObject)jo).put((Object)"cancelURL", (Object)(this.downloadService.webservicesRoot + "/occurrences/offline/cancel/" + id + "?apiKey=TO_BE_ADDED"));
        }
        return ja;
    }

    @Operation(summary="Asynchronous occurrence download", tags={"Download"})
    @Tag(name="Download", description="Services for downloading occurrences and specimen data")
    @RequestMapping(value={"occurrences/offline/download"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Object occurrenceDownload(@Valid @ParameterObject DownloadRequestParams requestParams, @Parameter(description="Original IP making the request") @RequestParam(value="ip", required=false) String ip, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DownloadRequestDTO downloadRequestDTO = DownloadRequestDTO.create((DownloadRequestParams)requestParams, (HttpServletRequest)request);
        Optional downloadUser = this.authService.getDownloadUser(downloadRequestDTO, request);
        if (!downloadUser.isPresent()) {
            response.sendError(400, "No valid email");
            return null;
        }
        return this.download(downloadRequestDTO, (AlaUserProfile)downloadUser.get(), ip, request.getHeader("user-agent"), request, response, DownloadDetailsDTO.DownloadType.RECORDS_INDEX);
    }

    private Map<String, Object> download(DownloadRequestDTO requestParams, AlaUserProfile alaUser, String ip, String userAgent, HttpServletRequest request, HttpServletResponse response, DownloadDetailsDTO.DownloadType downloadType) throws Exception {
        if (alaUser == null || StringUtils.isEmpty((String)alaUser.getEmail())) {
            response.sendError(412, "Unable to perform an offline download without an email address");
            return null;
        }
        ip = ip == null ? request.getRemoteAddr() : ip;
        DownloadDetailsDTO dd = new DownloadDetailsDTO(requestParams, alaUser, ip, userAgent, downloadType);
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacet(Boolean.valueOf(false));
        SolrDocumentList result = this.searchDAO.findByFulltext((SpatialSearchRequestDTO)requestParams);
        dd.setTotalRecords(result.getNumFound());
        LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
        DownloadDetailsDTO d = this.persistentQueueDAO.isInQueue(dd);
        if (d != null) {
            status.put("message", "Already in queue.");
            status.put("status", "inQueue");
            status.put("queueSize", this.persistentQueueDAO.getTotalDownloads());
            status.put("statusUrl", this.downloadService.webservicesRoot + "/occurrences/offline/status/" + d.getUniqueId());
        } else if (dd.getTotalRecords() > (long)this.downloadService.dowloadOfflineMaxSize.intValue()) {
            File file = new File(this.downloadService.biocacheDownloadDir + File.separator + UUID.nameUUIDFromBytes(dd.getRequestParams().getEmail().getBytes(StandardCharsets.UTF_8)) + File.separator + dd.getStartTime() + File.separator + "tooLarge");
            FileUtils.forceMkdir((File)file.getParentFile());
            FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8");
            status.put("downloadUrl", this.downloadService.biocacheDownloadUrl);
            status.put("status", "skipped");
            status.put("message", this.downloadService.downloadOfflineMsg);
            status.put("error", "Requested to many records (" + dd.getTotalRecords() + "). The maximum is (" + this.downloadService.dowloadOfflineMaxSize + ")");
        } else {
            this.persistentQueueDAO.addDownloadToQueue(dd);
            status.put("status", "inQueue");
            status.put("queueSize", this.persistentQueueDAO.getTotalDownloads());
            status.put("statusUrl", this.downloadService.webservicesRoot + "/occurrences/offline/status/" + dd.getUniqueId());
        }
        status.put("searchUrl", this.downloadService.generateSearchUrl(dd.getRequestParams()));
        this.writeStatusFile(dd.getUniqueId(), status);
        return status;
    }

    @SecurityRequirement(name="JWT")
    @Secured(value={"ROLE_ADMIN"})
    @Operation(summary="List all occurrence downloads", tags={"Monitoring"})
    @RequestMapping(value={"occurrences/offline/status"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Object allOccurrenceDownloadStatus() throws Exception {
        ArrayList allStatus = new ArrayList();
        Map userIdLookup = this.authService.getMapOfEmailToId();
        List downloads = this.persistentQueueDAO.getAllDownloads();
        for (DownloadDetailsDTO dd : downloads) {
            LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
            String id = dd.getUniqueId();
            if (dd.getFileLocation() == null) {
                status.put("status", "inQueue");
            } else {
                status.put("status", "running");
                status.put("records", dd.getRecordsDownloaded());
            }
            status.put("id", id);
            status.put("totalRecords", dd.getTotalRecords());
            status.put("downloadParams", dd.getRequestParams());
            status.put("startDate", dd.getStartDateString());
            status.put("thread", dd.getProcessingThreadName());
            if (userIdLookup != null) {
                status.put("userId", this.authService.getMapOfEmailToId().get(dd.getRequestParams().getEmail()));
            }
            status.put("statusUrl", this.downloadService.webservicesRoot + "/occurrences/offline/status/" + id);
            this.setStatusIfEmpty(id, status);
            allStatus.add(status);
        }
        return allStatus;
    }

    private void setStatusIfEmpty(String id, Map<String, Object> status) throws UnsupportedEncodingException {
        int sep;
        File dir;
        if (!status.containsKey("status") && (dir = new File(this.downloadService.biocacheDownloadDir + File.separator + id.substring(0, sep = id.lastIndexOf(45)) + File.separator + id.substring(sep + 1))).isDirectory() && dir.exists()) {
            for (File file : dir.listFiles()) {
                if (file.isFile() && file.getPath().endsWith(".zip") && file.length() > 0L) {
                    status.put("status", "finished");
                    status.put("downloadUrl", this.downloadService.biocacheDownloadUrl + File.separator + URLEncoder.encode(file.getPath().replace(this.downloadService.biocacheDownloadDir + "/", ""), "UTF-8").replace("%2F", "/").replace("+", "%20"));
                }
                if (!file.isFile() || !"tooLarge".equals(file.getName())) continue;
                status.put("status", "skipped");
                status.put("message", this.downloadService.downloadOfflineMsg);
                status.put("downloadUrl", this.downloadService.dowloadOfflineMaxUrl);
            }
            if (!status.containsKey("status")) {
                status.put("status", "failed");
            }
        }
        if (!status.containsKey("status")) {
            status.put("status", "invalidId");
        }
    }

    private void writeStatusFile(String id, Map status) throws IOException {
        File statusDir = new File(this.downloadService.biocacheDownloadDir + "/" + id.replaceAll("-([0-9]*)$", "/$1"));
        statusDir.mkdirs();
        String json = JSONObject.fromObject((Object)status).toString();
        FileUtils.writeStringToFile((File)new File(statusDir.getPath() + "/status.json"), (String)json, (String)"UTF-8");
    }

    @Operation(summary="Get the status of download", tags={"Download"})
    @RequestMapping(value={"occurrences/offline/status/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiParam(value="id", required=true)
    @ResponseBody
    public Object occurrenceDownloadStatus(@PathVariable(value="id") String id) throws Exception {
        File file;
        LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
        List downloads = this.persistentQueueDAO.getAllDownloads();
        for (DownloadDetailsDTO dd : downloads) {
            if (!id.equals(dd.getUniqueId())) continue;
            if (dd.getFileLocation() == null) {
                status.put("status", "inQueue");
            } else {
                status.put("status", "running");
                status.put("records", dd.getRecordsDownloaded());
            }
            status.put("totalRecords", dd.getTotalRecords());
            status.put("statusUrl", this.downloadService.webservicesRoot + "/occurrences/offline/status/" + id);
            if (this.authService.getMapOfEmailToId() == null) break;
            status.put("userId", this.authService.getMapOfEmailToId().get(dd.getRequestParams().getEmail()));
            break;
        }
        String cleanId = id.replaceAll("[^a-z\\-0-9]", "");
        cleanId = cleanId.replaceAll("-([0-9]*)$", "/$1");
        if (!status.containsKey("status")) {
            File dir = new File(this.downloadService.biocacheDownloadDir + File.separator + cleanId);
            if (dir.isDirectory() && dir.exists()) {
                for (File file2 : dir.listFiles()) {
                    if (file2.isFile() && file2.getPath().endsWith(".zip") && file2.length() > 0L) {
                        status.put("status", "finished");
                        status.put("downloadUrl", this.downloadService.biocacheDownloadUrl + File.separator + URLEncoder.encode(file2.getPath().replace(this.downloadService.biocacheDownloadDir + "/", ""), "UTF-8").replace("%2F", "/").replace("+", "%20"));
                    }
                    if (!file2.isFile() || !"tooLarge".equals(file2.getName())) continue;
                    status.put("status", "skipped");
                    status.put("message", this.downloadService.downloadOfflineMsg);
                    status.put("downloadUrl", this.downloadService.dowloadOfflineMaxUrl);
                    status.put("error", "requested to many records. The upper limit is (" + this.downloadService.dowloadOfflineMaxSize + ")");
                }
                if (!status.containsKey("status")) {
                    status.put("status", "failed");
                }
            }
            if (status.containsKey("status")) {
                this.writeStatusFile(cleanId, status);
            }
        }
        if (!status.containsKey("status") && (file = new File(this.downloadService.biocacheDownloadDir + File.separator + cleanId + "/status.json")).exists()) {
            status.putAll((Map<String, Object>)JSONObject.fromObject((Object)FileUtils.readFileToString((File)file, (String)"UTF-8")));
            status.put("status", "unavailable");
            status.put("message", "This download is unavailable.");
        }
        if (!status.containsKey("status")) {
            status.put("status", "invalidId");
        }
        return status;
    }

    @SecurityRequirement(name="JWT")
    @Secured(value={"ROLE_ADMIN"})
    @Operation(summary="Cancel an offline download", tags={"Monitoring"})
    @RequestMapping(value={"occurrences/offline/cancel/{id}"}, method={RequestMethod.GET})
    @ApiParam(value="id", required=true)
    @ResponseBody
    public Object occurrenceDownloadCancel(@PathVariable(value="id") String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.shouldPerformOperation(request, response)) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN, "Insufficient authentication credentials provided.");
        }
        LinkedHashMap<String, String> status = new LinkedHashMap<String, String>();
        List downloads = this.persistentQueueDAO.getAllDownloads();
        for (DownloadDetailsDTO dd : downloads) {
            if (!id.equals(dd.getUniqueId())) continue;
            this.persistentQueueDAO.removeDownloadFromQueue(dd);
            status.put("cancelled", "true");
            status.put("status", "notInQueue");
            break;
        }
        if (!status.containsKey("status")) {
            status.put("cancelled", "false");
            status.put("status", "notInQueue");
        }
        return status;
    }
}

