/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.AssertionCodes;
import au.org.ala.biocache.dto.AssertionStatus;
import au.org.ala.biocache.dto.QualityAssertion;
import au.org.ala.biocache.util.GISPoint;
import au.org.ala.biocache.util.GISUtil;
import au.org.ala.biocache.util.GridRef;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.geotools.referencing.CRS;
import org.springframework.util.StreamUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class GridUtil {
    private static final Logger logger = Logger.getLogger(SearchDAOImpl.class);
    static Cache<String, GISPoint> lru = CacheBuilder.newBuilder().maximumSize(100000L).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    Pattern osGridRefNoEastingNorthing = Pattern.compile("([A-Z]{2})");
    Pattern osGridRefRegex1Number = Pattern.compile("([A-Z]{2})\\s*([0-9]+)$");
    Pattern osGridRef2kRegex = Pattern.compile("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)\\s*([A-Z]{1})");
    Pattern osGridRefRegex = Pattern.compile("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)$");
    Pattern osGridRefWithQuadRegex = Pattern.compile("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)\\s*([NW|NE|SW|SE]{2})$");
    static char[] irishGridletterscodes = new char[]{'A', 'B', 'C', 'D', 'F', 'G', 'H', 'J', 'L', 'M', 'N', 'O', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y'};
    static String irishGridlettersFlattened = new String(irishGridletterscodes);
    static Pattern irishGridRefNoEastingNorthing = Pattern.compile("(I?[" + irishGridlettersFlattened + "]{1})");
    static Pattern irishGridRefRegex1Number = Pattern.compile("(I?[A-Z]{1})\\s*([0-9]+)$");
    static Pattern irishGridRef2kRegex = Pattern.compile("(I?[A-Z]{1})\\s*([0-9]+)\\s*([0-9]+)\\s*([A-Z]{1})");
    static Pattern irishGridRefRegex = Pattern.compile("(I?[A-Z]{1})\\s*([0-9]+)\\s*([0-9]+)$");
    static Pattern irishGridRefWithQuadRegex = Pattern.compile("(I?[A-Z]{1})\\s*([0-9]+)\\s*([0-9]+)\\s*([NW|NE|SW|SE]{2})$");
    static char[] tetradLetters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static String IRISH_CRS = "EPSG:29902";
    public static String OSGB_CRS = "EPSG:27700";
    private static Map<String, String> crsEpsgCodesMap = null;
    private static Map<String, String> zoneEpsgCodesMap = null;

    public static Map<String, String> getCrsEpsgCodesMap() {
        if (crsEpsgCodesMap == null) {
            try {
                ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
                for (String line : StreamUtils.copyToString((InputStream)GridUtil.class.getResourceAsStream("/crsEpsgCodes.txt"), (Charset)StandardCharsets.UTF_8).split("\n")) {
                    String[] values = line.split("=");
                    map.put(values[0], values[1]);
                }
                crsEpsgCodesMap = map;
            }
            catch (Exception e) {
                logger.error((Object)"failed to read resource /crsEpsgCodes.txt", (Throwable)e);
            }
        }
        return crsEpsgCodesMap;
    }

    public static Map<String, String> getZoneEpsgCodesMap() {
        if (zoneEpsgCodesMap == null) {
            try {
                ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
                for (String line : StreamUtils.copyToString((InputStream)GridUtil.class.getResourceAsStream("/zoneEpsgCodes.txt"), (Charset)StandardCharsets.UTF_8).split("\n")) {
                    String[] values = line.split("=");
                    map.put(values[0], values[1]);
                }
                zoneEpsgCodesMap = map;
            }
            catch (Exception e) {
                logger.error((Object)"failed to read resource /zoneEpsgCodes.txt", (Throwable)e);
            }
        }
        return zoneEpsgCodesMap;
    }

    static Integer getCoordinateUncertaintyFromGridRef(Integer noOfNumericalDigits, Integer noOfSecondaryAlphaChars) {
        Integer accuracy = null;
        switch (noOfNumericalDigits) {
            case 10: {
                accuracy = 1;
                break;
            }
            case 8: {
                accuracy = 10;
                break;
            }
            case 6: {
                accuracy = 100;
                break;
            }
            case 4: {
                accuracy = 1000;
                break;
            }
            case 2: {
                accuracy = 10000;
                break;
            }
            case 0: {
                accuracy = 100000;
                break;
            }
            default: {
                accuracy = null;
            }
        }
        if (noOfSecondaryAlphaChars == 2) {
            return accuracy / 2;
        }
        if (noOfSecondaryAlphaChars == 1) {
            return accuracy / 5;
        }
        return accuracy;
    }

    static String convertReferenceToResolution(String gridReference, String uncertaintyString) {
        String ref = null;
        try {
            Map gridRefs = GridUtil.getGridRefAsResolutions((String)gridReference);
            Integer uncertainty = Integer.parseInt(uncertaintyString);
            String[] gridRefSeq = new String[]{gridRefs.getOrDefault("grid_ref_100000", ""), gridRefs.getOrDefault("grid_ref_10000", ""), gridRefs.getOrDefault("grid_ref_2000", ""), gridRefs.getOrDefault("grid_ref_1000", ""), gridRefs.getOrDefault("grid_ref_100", "")};
            if (uncertainty > 10000) {
                ref = GridUtil.getBestValue((String[])gridRefSeq, (Integer)0);
            } else if (uncertainty <= 10000 && uncertainty > 2000) {
                ref = GridUtil.getBestValue((String[])gridRefSeq, (Integer)1);
            } else if (uncertainty <= 2000 && uncertainty > 1000) {
                ref = GridUtil.getBestValue((String[])gridRefSeq, (Integer)2);
            } else if (uncertainty <= 1000 && uncertainty > 100) {
                ref = GridUtil.getBestValue((String[])gridRefSeq, (Integer)3);
            } else if (uncertainty < 100) {
                ref = GridUtil.getBestValue((String[])gridRefSeq, (Integer)4);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Problem converting grid reference " + gridReference + " to lower resolution of " + uncertaintyString), (Throwable)e);
        }
        return ref;
    }

    static String getBestValue(String[] values, Integer preferredIndex) {
        Integer counter = preferredIndex;
        while (counter >= 0) {
            if (StringUtils.isNotEmpty((String)values[counter])) {
                return values[counter];
            }
            counter = counter - 1;
        }
        return "";
    }

    private static String padWithZeros(String ref, Integer pad) {
        while (((String)ref).length() < pad) {
            ref = "0" + (String)ref;
        }
        return ref;
    }

    public static Map<String, String> getGridRefAsResolutions(String gridRef) {
        HashMap<String, String> map = new HashMap<String, String>();
        GridRef gr = GridUtil.gridReferenceToEastingNorthing((String)gridRef);
        int gridSize = gr.getCoordinateUncertainty();
        map.put("grid_ref_100000", gr.gridLetters);
        if (gridRef.length() > 2) {
            String eastingAsStr = GridUtil.padWithZeros((String)String.valueOf(gr.getEasting() % 100000), (Integer)5);
            String northingAsStr = GridUtil.padWithZeros((String)String.valueOf(gr.getNorthing() % 100000), (Integer)5);
            if (eastingAsStr.length() >= 2 && northingAsStr.length() >= 2) {
                map.put("grid_ref_10000", gr.gridLetters + eastingAsStr.substring(0, 1) + northingAsStr.substring(0, 1));
            }
            if (eastingAsStr.length() >= 3 && northingAsStr.length() >= 3) {
                int eastingWithin10km = Integer.parseInt(eastingAsStr.substring(1, 2));
                int northingWithin10km = Integer.parseInt(northingAsStr.substring(1, 2));
                char tetrad = tetradLetters[eastingWithin10km / 2 * 5 + northingWithin10km / 2];
                if (gridSize != -1 && gridSize <= 2000) {
                    map.put("grid_ref_2000", gr.gridLetters + eastingAsStr.substring(0, 1) + northingAsStr.substring(0, 1) + tetrad);
                }
                if (gridSize != -1 && gridSize <= 1000) {
                    map.put("grid_ref_1000", gr.gridLetters + eastingAsStr.substring(0, 2) + northingAsStr.substring(0, 2));
                }
            }
            if (gridSize != -1 && gridSize <= 100 && eastingAsStr.length() > 3) {
                map.put("grid_ref_100", gr.gridLetters + eastingAsStr.substring(0, 3) + northingAsStr.substring(0, 3));
            }
        }
        return map;
    }

    public static GridRef gridReferenceToEastingNorthing(String gridRef) {
        GridRef result = GridUtil.osGridReferenceToEastingNorthing((String)gridRef);
        if (result != null) {
            return result;
        }
        return GridUtil.irishGridReferenceToEastingNorthing((String)gridRef);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static GridRef irishGridReferenceToEastingNorthing(String gridRef) {
        int cellSize;
        Integer coordinateUncertainty;
        String northing;
        String easting;
        String gridletters;
        String twoKRef = "";
        String quadRef = "";
        Matcher matcher1 = irishGridRefRegex1Number.matcher(gridRef);
        Matcher matcher2 = irishGridRefRegex.matcher(gridRef);
        Matcher matcher3 = irishGridRef2kRegex.matcher(gridRef);
        Matcher matcher4 = irishGridRefWithQuadRegex.matcher(gridRef);
        Matcher matcher5 = irishGridRefNoEastingNorthing.matcher(gridRef);
        if (matcher1.matches()) {
            gridletters = matcher1.group(1);
            String gridDigits = matcher1.group(2);
            easting = gridDigits.substring(0, gridDigits.length() / 2);
            northing = gridDigits.substring(gridDigits.length() / 2);
            coordinateUncertainty = GridUtil.getCoordinateUncertaintyFromGridRef((Integer)gridDigits.length(), (Integer)0);
        } else if (matcher2.matches()) {
            gridletters = matcher2.group(1);
            easting = matcher2.group(2);
            northing = matcher2.group(3);
            twoKRef = matcher2.group(4);
            coordinateUncertainty = GridUtil.getCoordinateUncertaintyFromGridRef((Integer)(easting.length() * 2), (Integer)0);
        } else if (matcher3.matches()) {
            gridletters = matcher3.group(1);
            easting = matcher3.group(2);
            northing = matcher3.group(3);
            twoKRef = matcher3.group(4);
            coordinateUncertainty = GridUtil.getCoordinateUncertaintyFromGridRef((Integer)(easting.length() * 2), (Integer)1);
        } else if (matcher4.matches()) {
            gridletters = matcher4.group(1);
            easting = matcher4.group(2);
            northing = matcher4.group(3);
            quadRef = matcher4.group(4);
            coordinateUncertainty = GridUtil.getCoordinateUncertaintyFromGridRef((Integer)(easting.length() * 2), (Integer)2);
        } else {
            if (!matcher5.matches()) return null;
            gridletters = matcher5.group(1);
            easting = "0";
            northing = "0";
            coordinateUncertainty = GridUtil.getCoordinateUncertaintyFromGridRef((Integer)0, (Integer)0);
        }
        char singleGridLetter = gridletters.charAt(0);
        if (gridletters.length() == 2) {
            singleGridLetter = gridletters.charAt(1);
        }
        int gridIdx = String.valueOf(irishGridletterscodes).indexOf(singleGridLetter);
        int e100km = gridIdx % 4;
        int n100km = 4 - gridIdx / 4;
        String easting10digit = (easting + "00000").substring(0, 5);
        String northing10digit = (northing + "00000").substring(0, 5);
        int e = Integer.parseInt(e100km + easting10digit);
        int n = Integer.parseInt(n100km + northing10digit);
        if (StringUtils.isNotEmpty((String)twoKRef)) {
            cellSize = 0;
            if (easting.length() == 1) {
                cellSize = 2000;
            } else if (easting.length() == 2) {
                cellSize = 200;
            } else if (easting.length() == 3) {
                cellSize = 20;
            } else if (easting.length() == 4) {
                cellSize = 2;
            }
            if (Character.codePointAt(twoKRef, 0) <= 78) {
                e += (Character.codePointAt(twoKRef, 0) - 65) / 5 * cellSize;
                n += (Character.codePointAt(twoKRef, 0) - 65) % 5 * cellSize;
            } else {
                if (Character.codePointAt(twoKRef, 0) < 80) return null;
                e += (Character.codePointAt(twoKRef, 0) - 66) / 5 * cellSize;
                n += (Character.codePointAt(twoKRef, 0) - 66) % 5 * cellSize;
            }
        } else if (StringUtils.isNotEmpty((String)quadRef)) {
            cellSize = 0;
            if (easting.length() == 1) {
                cellSize = 5000;
            } else if (easting.length() == 2) {
                cellSize = 500;
            } else if (easting.length() == 3) {
                cellSize = 50;
            } else if (easting.length() == 4) {
                cellSize = 5;
            }
            if (cellSize > 0) {
                if ("NW".equals(twoKRef)) {
                    e += cellSize / 2;
                    n += cellSize + cellSize / 2;
                } else if ("NE".equals(twoKRef)) {
                    e += cellSize + cellSize / 2;
                    n += cellSize + cellSize / 2;
                } else if ("SW".equals(twoKRef)) {
                    e += cellSize / 2;
                    n += cellSize / 2;
                } else {
                    if (!"SE".equals(twoKRef)) return null;
                    e += cellSize + cellSize / 2;
                    n += cellSize / 2;
                }
            }
        }
        int coordinateUncertaintyOrZero = coordinateUncertainty == null ? 0 : coordinateUncertainty;
        return new GridRef(gridletters, e, n, coordinateUncertaintyOrZero, e, n, e + coordinateUncertaintyOrZero, n + coordinateUncertaintyOrZero, IRISH_CRS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static GridRef osGridReferenceToEastingNorthing(String gridRef) {
        int cellSize;
        String northing;
        String easting;
        String gridletters;
        Integer coordinateUncertainty;
        Pattern osGridRefNoEastingNorthing = Pattern.compile("([A-Z]{2})");
        Pattern osGridRefRegex1Number = Pattern.compile("([A-Z]{2})\\s*([0-9]+)$");
        Pattern osGridRef2kRegex = Pattern.compile("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)\\s*([A-Z]{1})");
        Pattern osGridRefRegex = Pattern.compile("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)$");
        Pattern osGridRefWithQuadRegex = Pattern.compile("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)\\s*([NW|NE|SW|SE]{2})$");
        String twoKRef = null;
        String quadRef = null;
        Matcher matcher1 = osGridRefRegex1Number.matcher(gridRef);
        Matcher matcher2 = osGridRefRegex.matcher(gridRef);
        Matcher matcher3 = osGridRef2kRegex.matcher(gridRef);
        Matcher matcher4 = osGridRefWithQuadRegex.matcher(gridRef);
        Matcher matcher5 = osGridRefNoEastingNorthing.matcher(gridRef);
        if (matcher1.matches()) {
            String gridDigits = matcher1.group(2);
            coordinateUncertainty = GridUtil.getCoordinateUncertaintyFromGridRef((Integer)gridDigits.length(), (Integer)0);
            gridletters = matcher1.group(1);
            easting = gridDigits.substring(0, gridDigits.length() / 2);
            northing = gridDigits.substring(gridDigits.length() / 2);
        } else if (matcher2.matches()) {
            gridletters = matcher2.group(1);
            easting = matcher2.group(2);
            northing = matcher2.group(3);
            coordinateUncertainty = GridUtil.getCoordinateUncertaintyFromGridRef((Integer)(easting.length() * 2), (Integer)0);
        } else if (matcher3.matches()) {
            gridletters = matcher3.group(1);
            easting = matcher3.group(2);
            northing = matcher3.group(3);
            twoKRef = matcher3.group(4);
            coordinateUncertainty = GridUtil.getCoordinateUncertaintyFromGridRef((Integer)(easting.length() * 2), (Integer)1);
        } else if (matcher4.matches()) {
            gridletters = matcher4.group(1);
            easting = matcher4.group(2);
            northing = matcher4.group(3);
            quadRef = matcher4.group(4);
            coordinateUncertainty = GridUtil.getCoordinateUncertaintyFromGridRef((Integer)(easting.length() * 2), (Integer)2);
        } else {
            if (!matcher5.matches()) return null;
            gridletters = matcher5.group(1);
            easting = "0";
            northing = "0";
            coordinateUncertainty = GridUtil.getCoordinateUncertaintyFromGridRef((Integer)0, (Integer)0);
        }
        int value1 = Character.codePointAt(gridletters, 0) - Character.codePointAt("A", 0);
        int l1 = value1 > 7 ? value1 - 1 : value1;
        int value2 = Character.codePointAt(gridletters, 1) - Character.codePointAt("A", 0);
        int l2 = value2 > 7 ? value2 - 1 : value2;
        int e100km = (l1 - 2) % 5 * 5 + l2 % 5;
        int n100km = (int)(19.0 - Math.floor(l1 / 5) * 5.0 - Math.floor(l2 / 5));
        if (e100km < 0 || e100km > 6 || n100km < 0 || n100km > 12) {
            return null;
        }
        if (easting == null || northing == null) {
            return null;
        }
        if (easting.length() != northing.length()) {
            return null;
        }
        String easting10digit = (easting + "00000").substring(0, 5);
        String northing10digit = (northing + "00000").substring(0, 5);
        int e = Integer.parseInt(e100km + easting10digit);
        int n = Integer.parseInt(n100km + northing10digit);
        if (StringUtils.isNotEmpty((String)twoKRef)) {
            cellSize = 0;
            if (easting.length() == 1) {
                cellSize = 2000;
            } else if (easting.length() == 2) {
                cellSize = 200;
            } else if (easting.length() == 3) {
                cellSize = 20;
            } else if (easting.length() == 4) {
                cellSize = 2;
            }
            if (Character.codePointAt(twoKRef, 0) <= 78) {
                e += (Character.codePointAt(twoKRef, 0) - 65) / 5 * cellSize;
                n += (Character.codePointAt(twoKRef, 0) - 65) % 5 * cellSize;
            } else {
                if (Character.codePointAt(twoKRef, 0) < 80) return null;
                e += (Character.codePointAt(twoKRef, 0) - 66) / 5 * cellSize;
                n += (Character.codePointAt(twoKRef, 0) - 66) % 5 * cellSize;
            }
        } else if (StringUtils.isNotEmpty((String)quadRef)) {
            cellSize = 0;
            if (easting.length() == 1) {
                cellSize = 5000;
            } else if (easting.length() == 2) {
                cellSize = 500;
            } else if (easting.length() == 3) {
                cellSize = 50;
            } else if (easting.length() == 4) {
                cellSize = 5;
            }
            if (cellSize > 0) {
                if ("NW".equals(quadRef)) {
                    e += cellSize / 2;
                    n += cellSize + cellSize / 2;
                } else if ("NE".equals(quadRef)) {
                    e += cellSize + cellSize / 2;
                    n += cellSize + cellSize / 2;
                } else if ("SW".equals(quadRef)) {
                    e += cellSize / 2;
                    n += cellSize / 2;
                } else {
                    if (!"SE".equals(quadRef)) return null;
                    e += cellSize + cellSize / 2;
                    n += cellSize / 2;
                }
            }
        }
        int coordinateUncertaintyOrZero = coordinateUncertainty == null ? 0 : coordinateUncertainty;
        return new GridRef(gridletters, e, n, coordinateUncertainty.intValue(), e, n, e + coordinateUncertaintyOrZero, n + coordinateUncertaintyOrZero, OSGB_CRS);
    }

    public static GISPoint processGridReference(String gridReference) {
        GISPoint cachedObject = (GISPoint)lru.getIfPresent((Object)gridReference);
        if (cachedObject != null) {
            return cachedObject;
        }
        GISPoint result = null;
        GridRef gr = GridUtil.gridReferenceToEastingNorthing((String)gridReference);
        double reposition = 0.0;
        if (gr.getCoordinateUncertainty() == null && gr.getCoordinateUncertainty() > 0) {
            reposition = gr.getCoordinateUncertainty() / 2;
        }
        double[] coords = GISUtil.reprojectCoordinatesToWGS84((Double)((double)gr.getEasting().intValue() + reposition), (Double)((double)gr.getNorthing().intValue() + reposition), (String)gr.getDatum(), (Integer)5);
        double[][] bbox = new double[][]{GISUtil.reprojectCoordinatesToWGS84((Double)gr.getMinEasting().doubleValue(), (Double)gr.getMinNorthing().doubleValue(), (String)gr.datum, (Integer)5), GISUtil.reprojectCoordinatesToWGS84((Double)gr.getMaxEasting().doubleValue(), (Double)gr.getMaxNorthing().doubleValue(), (String)gr.datum, (Integer)5)};
        if (coords != null) {
            String uncertaintyToUse = null;
            if (gr.getCoordinateUncertainty() != null) {
                gr.getCoordinateUncertainty().toString();
            }
            result = new GISPoint(coords[0], coords[1], GISUtil.WGS84_EPSG_Code, uncertaintyToUse, gr.getEasting().toString(), gr.getNorthing().toString(), bbox[0][0], bbox[0][1], bbox[1][0], bbox[1][1]);
        } else {
            result = null;
        }
        lru.put((Object)gridReference, result);
        return result;
    }

    String lookupEpsgCode(String crs) {
        if (StringUtils.startsWithIgnoreCase((String)crs, (String)"EPSG:")) {
            try {
                CRS.decode((String)crs.toUpperCase());
                return crs.toUpperCase();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return GridUtil.getCrsEpsgCodesMap().getOrDefault(crs.toUpperCase(), null);
    }

    GISPoint processNorthingEastingZone(String verbatimSRS, String easting, String northing, String zone, List<QualityAssertion> assertions) {
        String epsgCodeKey = verbatimSRS != null ? verbatimSRS.toUpperCase() + "|" + zone : "GDA94|" + zone;
        if (GridUtil.getZoneEpsgCodesMap().containsKey(epsgCodeKey)) {
            String crsEpsgCode = (String)GridUtil.getZoneEpsgCodesMap().get(epsgCodeKey);
            Double eastingAsDouble = null;
            Double northingAsDouble = null;
            try {
                eastingAsDouble = Double.parseDouble(easting);
                northingAsDouble = Double.parseDouble(northing);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (eastingAsDouble != null && northingAsDouble != null) {
                double[] reprojectedCoords = GISUtil.reprojectCoordinatesToWGS84((Double)eastingAsDouble, (Double)northingAsDouble, (String)crsEpsgCode, (Integer)5);
                if (reprojectedCoords == null) {
                    assertions.add(new QualityAssertion(AssertionCodes.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED, "Transformation of verbatim easting and northing to WGS84 failed"));
                    return null;
                }
                assertions.add(new QualityAssertion(AssertionCodes.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED, AssertionStatus.PASSED));
                assertions.add(new QualityAssertion(AssertionCodes.DECIMAL_LAT_LONG_CALCULATED_FROM_EASTING_NORTHING, "Decimal latitude and longitude were calculated using easting, northing and zone."));
                double reprojectedLatitude = reprojectedCoords[0];
                double reprojectedLongitude = reprojectedCoords[1];
                return new GISPoint(reprojectedLatitude, reprojectedLongitude, GISUtil.WGS84_EPSG_Code, null);
            }
            return null;
        }
        if (verbatimSRS == null) {
            assertions.add(new QualityAssertion(AssertionCodes.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED, "Unrecognized zone GDA94 / MGA zone " + zone));
        } else {
            assertions.add(new QualityAssertion(AssertionCodes.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED, "Unrecognized zone " + verbatimSRS + " / zone " + zone));
        }
        return null;
    }
}

