/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.dto.DownloadHeaders;
import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.ListsService;
import au.org.ala.biocache.service.RestartDataService;
import au.org.ala.biocache.util.solr.FieldMappingUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractMessageSource;

public class DownloadFields {
    private static final Logger logger = LoggerFactory.getLogger(DownloadFields.class);
    private AbstractMessageSource messageSource;
    private LayersService layersService;
    private ListsService listsService;
    private Properties layerProperties = (Properties)RestartDataService.get((Object)this, (String)"layerProperties", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, Properties.class);
    private Map<String, IndexFieldDTO> indexFieldMaps;
    private Map<String, IndexFieldDTO> indexByDwcMaps;
    protected FieldMappingUtil fieldMappingUtil;
    private Long lastUpdate = 0L;
    private Thread updateThread = null;

    public DownloadFields(FieldMappingUtil fieldMappingUtil, Set<IndexFieldDTO> indexFields, AbstractMessageSource messageSource, LayersService layersService, ListsService listsService) {
        this.fieldMappingUtil = fieldMappingUtil;
        this.messageSource = messageSource;
        this.layersService = layersService;
        this.listsService = listsService;
        this.update(indexFields);
    }

    private synchronized void updateLayerNames() {
        if (this.layerProperties == null || this.layerProperties.size() == 0 || System.currentTimeMillis() > this.lastUpdate + 3600000L) {
            if (this.updateThread != null && this.updateThread.isAlive()) {
                this.updateThread.interrupt();
            }
            this.lastUpdate = System.currentTimeMillis();
            this.updateThread = new /* Unavailable Anonymous Inner Class!! */;
            if (this.layerProperties == null || this.layerProperties.size() == 0) {
                this.updateThread.run();
            } else {
                this.updateThread.start();
            }
        }
    }

    public void update(Set<IndexFieldDTO> indexedFields) {
        try {
            TreeMap<String, IndexFieldDTO> map = new TreeMap<String, IndexFieldDTO>();
            TreeMap<String, IndexFieldDTO> mapByDwC = new TreeMap<String, IndexFieldDTO>();
            for (IndexFieldDTO field : indexedFields) {
                map.put(field.getName(), field);
                if (field.getDwcTerm() == null) continue;
                mapByDwC.put(field.getDwcTerm(), field);
            }
            this.indexFieldMaps = map;
            this.indexByDwcMaps = mapByDwC;
            this.updateLayerNames();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public DownloadHeaders newDownloadHeader(DownloadRequestDTO downloadParams) {
        String[] fieldNames;
        this.updateLayerNames();
        boolean dwcHeaders = downloadParams.getDwcHeaders();
        String layersServiceUrl = downloadParams.getLayersServiceUrl();
        LinkedList<String> included = new LinkedList<String>();
        LinkedList<String> labels = new LinkedList<String>();
        LinkedList<String> originalName = new LinkedList<String>();
        LinkedList<String> analysisLabels = new LinkedList<String>();
        LinkedList<String> analysisIds = new LinkedList<String>();
        LinkedList speciesListLabels = new LinkedList();
        LinkedList speciesListIds = new LinkedList();
        for (String fieldName : fieldNames = downloadParams.getFields().split(",")) {
            String solrName = this.fieldMappingUtil.translateFieldName(fieldName);
            IndexFieldDTO field = (IndexFieldDTO)this.indexFieldMaps.get(solrName);
            if (field == null) {
                field = (IndexFieldDTO)this.indexByDwcMaps.get(solrName);
            }
            if (field != null && field.isDocvalue() || fieldName.startsWith("sensitive")) {
                String name = field != null ? field.getName() : solrName;
                included.add(name);
                String v = dwcHeaders ? name : this.layerProperties.getProperty(name, this.messageSource.getMessage(name, null, name, Locale.getDefault()));
                String dwc = dwcHeaders ? this.messageSource.getMessage("dwc." + name, null, "", Locale.getDefault()) : null;
                String header = dwc != null && dwc.length() > 0 ? dwc : v;
                labels.add(header);
                originalName.add(fieldName);
                continue;
            }
            if (field == null && layersServiceUrl != null && this.layersService.findAnalysisLayerName(solrName, layersServiceUrl) != null) {
                analysisIds.add(solrName);
                analysisLabels.add(this.layersService.findAnalysisLayerName(solrName, layersServiceUrl));
                continue;
            }
            if (field != null || this.listsService.getKvp(solrName) == null) continue;
            speciesListLabels.addAll(this.listsService.getKvpNames(solrName, this.listsService.getKvp(solrName)));
            speciesListIds.addAll(this.listsService.getKvpFields(solrName, this.listsService.getKvp(solrName)));
        }
        String[] customHeader = downloadParams.getCustomHeader().split(",");
        int i = 0;
        while (i + 1 < customHeader.length) {
            int j;
            for (j = 0; j < included.size(); ++j) {
                if (!customHeader[i].equals(included.get(j)) && !customHeader[i].equals(originalName.get(j))) continue;
                labels.set(j, customHeader[i + 1]);
            }
            for (j = 0; j < analysisIds.size(); ++j) {
                if (!customHeader[i].equals(analysisIds.get(j))) continue;
                analysisLabels.set(j, customHeader[i + 1]);
            }
            i += 2;
        }
        return new DownloadHeaders(included.toArray(new String[0]), labels.toArray(new String[0]), analysisLabels.toArray(new String[0]), analysisIds.toArray(new String[0]), speciesListLabels.toArray(new String[0]), speciesListIds.toArray(new String[0]));
    }
}

