/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dto.SearchRequestDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.dataquality.api.QualityServiceRpcApi;
import au.org.ala.dataquality.model.QualityProfile;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;
import retrofit2.Call;
import retrofit2.HttpException;
import retrofit2.Response;

@Component(value="dataQualityService")
public class DataQualityService {
    private static final Logger logger = Logger.getLogger(DataQualityService.class);
    public static final String DISABLE_ALL_QUALITY_FILTERS_PARAM_NAME = "disableAllQualityFilters";
    public static final String QUALITY_PROFILE_PARAM_NAME = "qualityProfile";
    public static final String DISABLE_QUALITY_FILTER_PARAM_NAME = "disableQualityFilter";
    private final Map<String, Map<String, String>> cache = new ConcurrentHashMap();
    private final Map<String, QualityProfile> cacheProfile = new ConcurrentHashMap();
    @Inject
    private QualityServiceRpcApi qualityServiceRpcApi;
    @Value(value="${dataquality.enabled:false}")
    @VisibleForTesting
    protected boolean dataQualityEnabled;

    @Scheduled(fixedDelay=43200000L)
    public void clearCache() {
        this.cache.clear();
        this.cacheProfile.clear();
    }

    public String getProfileFullName(String profileShortName) {
        if (!this.dataQualityEnabled) {
            return profileShortName;
        }
        QualityProfile profile = (QualityProfile)this.cacheProfile.get(profileShortName);
        if (profile == null) {
            profile = (QualityProfile)this.responseValueOrThrow(this.qualityServiceRpcApi.activeProfile(profileShortName));
            this.cacheProfile.put(profileShortName, profile);
        }
        return profile.getName();
    }

    public Map<String, String> getEnabledFiltersByLabel(SearchRequestDTO searchRequestDTO) {
        if (searchRequestDTO.isDisableAllQualityFilters()) {
            return new LinkedHashMap<String, String>();
        }
        if (!this.dataQualityEnabled) {
            return new LinkedHashMap<String, String>();
        }
        if (StringUtils.isBlank((String)searchRequestDTO.getQualityProfile())) {
            return new LinkedHashMap<String, String>();
        }
        Map filtersByLabel = (Map)this.cache.get(searchRequestDTO.getQualityProfile());
        if (filtersByLabel == null) {
            filtersByLabel = this.getEnabledFiltersByLabel(searchRequestDTO.getQualityProfile());
            this.cache.put(searchRequestDTO.getQualityProfile(), filtersByLabel);
        }
        filtersByLabel.keySet().removeAll(searchRequestDTO.getDisableQualityFilter());
        return filtersByLabel;
    }

    public Map<String, String> getEnabledFiltersByLabel(String qualityProfile) {
        if (!this.dataQualityEnabled) {
            return new LinkedHashMap<String, String>();
        }
        if (StringUtils.isBlank((String)qualityProfile)) {
            return new LinkedHashMap<String, String>();
        }
        Call enabledFiltersByLabelCall = this.qualityServiceRpcApi.getEnabledFiltersByLabel(qualityProfile);
        return (Map)this.responseValueOrThrow(enabledFiltersByLabelCall);
    }

    private <T> T responseValueOrThrow(Call<T> call) {
        Response response = null;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        throw new HttpException(response);
    }

    public String convertDataQualityParameters(String searchUrl, Map<String, String> enabledQualityFiltersByLabel) {
        URI uri;
        if (!this.dataQualityEnabled) {
            return searchUrl;
        }
        try {
            uri = new URI(searchUrl);
        }
        catch (URISyntaxException e) {
            logger.warn((Object)("Search URL " + searchUrl + " can't be parsed, dq filters won't be fixed in DOI!"));
            return searchUrl;
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUri((URI)uri);
        uriBuilder.replaceQuery(uri.getRawQuery().replace("+", "%20"));
        MultiValueMap params = uriBuilder.build(true).getQueryParams();
        if (Boolean.parseBoolean((String)params.getFirst((Object)DISABLE_ALL_QUALITY_FILTERS_PARAM_NAME))) {
            return searchUrl;
        }
        String profile = (String)params.getFirst((Object)QUALITY_PROFILE_PARAM_NAME);
        if (StringUtils.isBlank((String)profile)) {
            return searchUrl;
        }
        uriBuilder.replaceQueryParam(QUALITY_PROFILE_PARAM_NAME, new Object[0]);
        uriBuilder.replaceQueryParam(DISABLE_QUALITY_FILTER_PARAM_NAME, new Object[0]);
        uriBuilder.queryParam(DISABLE_ALL_QUALITY_FILTERS_PARAM_NAME, new Object[]{"true"});
        LinkedHashSet fqs = params.containsKey((Object)"fq") ? Sets.newLinkedHashSet((Iterable)((Iterable)params.get((Object)"fq"))) : Sets.newLinkedHashSet();
        fqs.addAll(enabledQualityFiltersByLabel.values().stream().map(DataQualityService::encode).collect(Collectors.toList()));
        uriBuilder.replaceQueryParam("fq", fqs.toArray());
        return uriBuilder.build(true).encode().toUriString();
    }

    private static String encode(String paramValue) {
        try {
            return URLEncoder.encode(paramValue, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] generateCombinedFqs(SpatialSearchRequestDTO requestParams) {
        String[] fqs = requestParams.getFq();
        if (fqs == null) {
            fqs = new String[]{};
        }
        int fqsLength = fqs.length;
        Collection qualityFilters = this.getEnabledFiltersByLabel((SearchRequestDTO)requestParams).values();
        fqs = Arrays.copyOf(fqs, fqsLength + qualityFilters.size());
        System.arraycopy(qualityFilters.toArray(new String[0]), 0, fqs, fqsLength, qualityFilters.size());
        return fqs;
    }
}

