/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.util.LegendItem;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(name="HeatMap")
public class HeatmapDTO {
    public final Integer gridLevel;
    public final List<List<List<Integer>>> layers;
    public final List<LegendItem> legend;
    public final int gridSizeInPixels;
    public final Integer rows;
    public final Integer columns;
    public final Double minx;
    public final Double miny;
    public final Double maxx;
    public final Double maxy;
    public Double tileMinx;
    public Double tileMiny;
    public Double tileMaxx;
    public Double tileMaxy;

    public HeatmapDTO(Integer gridLevel, List<List<List<Integer>>> layers, List<LegendItem> legend, int gridSizeInPixels, Integer rows, Integer columns, Double minx, Double miny, Double maxx, Double maxy) {
        while (minx >= 180.0) {
            minx = minx - 360.0;
        }
        while (maxx <= -180.0) {
            maxx = maxx + 360.0;
        }
        if (minx > maxx) {
            maxx = maxx + 360.0;
        }
        this.gridLevel = gridLevel;
        this.layers = layers;
        this.legend = legend;
        this.gridSizeInPixels = gridSizeInPixels;
        this.rows = rows;
        this.columns = columns;
        this.minx = minx;
        this.miny = miny;
        this.maxx = maxx;
        this.maxy = maxy;
        this.tileMinx = minx;
        this.tileMiny = miny;
        this.tileMaxx = maxx;
        this.tileMaxy = maxy;
    }

    public Double columnWidth() {
        return (this.maxx - this.minx) / (double)this.columns.intValue();
    }

    public Double rowHeight() {
        return (this.maxy - this.miny) / (double)this.rows.intValue();
    }

    public void setTileExtents(double[] bbox) {
        this.tileMinx = bbox[0];
        this.tileMiny = bbox[1];
        this.tileMaxx = bbox[2];
        this.tileMaxy = bbox[3];
    }
}

