/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.ALAOccurrenceIssue;
import au.org.ala.biocache.dto.ErrorCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gbif.api.vocabulary.InterpretationRemarkSeverity;
import org.gbif.api.vocabulary.OccurrenceIssue;

/*
 * Exception performing whole class analysis ignored.
 */
public class AssertionCodes {
    public static final ErrorCode GEOSPATIAL_ISSUE;
    public static final ErrorCode COORDINATE_HABITAT_MISMATCH;
    public static final ErrorCode DETECTED_OUTLIER;
    public static final ErrorCode DECIMAL_LAT_LONG_CALCULATED_FROM_EASTING_NORTHING;
    public static final ErrorCode DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED;
    public static final ErrorCode TAXONOMIC_ISSUE;
    public static final ErrorCode IDENTIFICATION_INCORRECT;
    public static final ErrorCode USER_ASSERTION_OTHER;
    public static final ErrorCode USER_DUPLICATE_RECORD;
    public static final ErrorCode BIOSECURITY_ISSUE;
    public static final ErrorCode TEMPORAL_ISSUE;
    public static final ErrorCode VERIFIED;
    public static final ErrorCode[] userAssertionCodes;
    public static final List<ErrorCode> allAssertionCodes;

    public static List<ErrorCode> getCodes() {
        return allAssertionCodes;
    }

    public static ErrorCode[] getAll() {
        return AssertionCodes.getCodes().toArray(new ErrorCode[0]);
    }

    public static ErrorCode getByCode(int code) {
        return allAssertionCodes.stream().filter(errorCode -> errorCode.code == code).findFirst().orElse(null);
    }

    public static ErrorCode getByName(String name) {
        Optional<ErrorCode> foundErrorCode = allAssertionCodes.stream().filter(errorCode -> errorCode.getName().equals(name)).findFirst();
        if (foundErrorCode.isPresent()) {
            return foundErrorCode.get();
        }
        return null;
    }

    static {
        ErrorCode.Category c;
        GEOSPATIAL_ISSUE = new ErrorCode("geospatialIssue", Integer.valueOf(0), Boolean.valueOf(true), "Geospatial issue", ErrorCode.Category.Warning);
        COORDINATE_HABITAT_MISMATCH = new ErrorCode("habitatMismatch", Integer.valueOf(19), Boolean.valueOf(true), "Habitat incorrect for species", ErrorCode.Category.Error);
        DETECTED_OUTLIER = new ErrorCode("detectedOutlier", Integer.valueOf(20), Boolean.valueOf(true), "Suspected outlier", ErrorCode.Category.Error);
        DECIMAL_LAT_LONG_CALCULATED_FROM_EASTING_NORTHING = new ErrorCode("decimalLatLongCalculatedFromEastingNorthing", Integer.valueOf(49), Boolean.valueOf(false), "Decimal latitude and longitude were calculated using easting, nothing and zone", ErrorCode.Category.Warning);
        DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED = new ErrorCode("decimalLatLongCalculationFromEastingNorthingFailed", Integer.valueOf(50), Boolean.valueOf(true), "Failed to calculate decimal latitude and longitude using easting, northing and zone", ErrorCode.Category.Error);
        TAXONOMIC_ISSUE = new ErrorCode("taxonomicIssue", Integer.valueOf(10000), Boolean.valueOf(false), "Taxonomic issue", ErrorCode.Category.Error);
        IDENTIFICATION_INCORRECT = new ErrorCode("identificationIncorrect", Integer.valueOf(10007), Boolean.valueOf(false), "Taxon misidentified", ErrorCode.Category.Error);
        USER_ASSERTION_OTHER = new ErrorCode("userAssertionOther", Integer.valueOf(20019), Boolean.valueOf(false), "Other error", ErrorCode.Category.Error);
        USER_DUPLICATE_RECORD = new ErrorCode("userDuplicateRecord", Integer.valueOf(20020), Boolean.valueOf(false), "The occurrence appears to be a duplicate", ErrorCode.Category.Warning);
        BIOSECURITY_ISSUE = new ErrorCode("biosecurityIssue", Integer.valueOf(20021), Boolean.valueOf(false), "Biosecurity issue", ErrorCode.Category.Error);
        TEMPORAL_ISSUE = new ErrorCode("temporalIssue", Integer.valueOf(30000), Boolean.valueOf(false), "Temporal issue", ErrorCode.Category.Error);
        VERIFIED = new ErrorCode("userVerified", Integer.valueOf(50000), Boolean.valueOf(true), "Record Verified by collection manager", ErrorCode.Category.Verified);
        userAssertionCodes = new ErrorCode[]{GEOSPATIAL_ISSUE, COORDINATE_HABITAT_MISMATCH, DETECTED_OUTLIER, TAXONOMIC_ISSUE, IDENTIFICATION_INCORRECT, TEMPORAL_ISSUE, USER_DUPLICATE_RECORD, BIOSECURITY_ISSUE, USER_ASSERTION_OTHER};
        allAssertionCodes = new ArrayList();
        allAssertionCodes.addAll(Arrays.asList(userAssertionCodes));
        ALAOccurrenceIssue[] alaIssues = ALAOccurrenceIssue.values();
        OccurrenceIssue[] issues = OccurrenceIssue.values();
        for (ALAOccurrenceIssue aLAOccurrenceIssue : alaIssues) {
            c = null;
            c = aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.ERROR) ? ErrorCode.Category.Error : (aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.WARNING) ? ErrorCode.Category.Warning : ErrorCode.Category.Comment);
            allAssertionCodes.add(new ErrorCode(aLAOccurrenceIssue.name(), Integer.valueOf(aLAOccurrenceIssue.ordinal() + 1000), Boolean.valueOf(aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.ERROR)), aLAOccurrenceIssue.name().toLowerCase().replaceAll("_", " "), c, aLAOccurrenceIssue.getRelatedTerms().stream().map(term -> term.simpleName()).collect(Collectors.toList())));
        }
        for (ALAOccurrenceIssue aLAOccurrenceIssue : issues) {
            c = null;
            c = aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.ERROR) ? ErrorCode.Category.Error : (aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.WARNING) ? ErrorCode.Category.Warning : ErrorCode.Category.Comment);
            allAssertionCodes.add(new ErrorCode(aLAOccurrenceIssue.name(), Integer.valueOf(aLAOccurrenceIssue.ordinal() + 2000), Boolean.valueOf(aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.ERROR)), aLAOccurrenceIssue.name().toLowerCase().replaceAll("_", " "), c, aLAOccurrenceIssue.getRelatedTerms().stream().map(term -> term.simpleName()).collect(Collectors.toList())));
        }
    }
}

