/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dto.AssertionCodes;
import au.org.ala.biocache.dto.AssertionStatus;
import au.org.ala.biocache.dto.ErrorCode;
import au.org.ala.biocache.dto.QualityAssertion;
import au.org.ala.biocache.dto.UserAssertions;
import au.org.ala.biocache.service.AssertionService;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.util.AssertionUtils;
import au.org.ala.biocache.web.AbstractSecureController;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.gbif.api.vocabulary.InterpretationRemarkSeverity;
import org.gbif.api.vocabulary.NameUsageIssue;
import org.gbif.api.vocabulary.OccurrenceIssue;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AssertionController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(AssertionController.class);
    @Inject
    protected AssertionUtils assertionUtils;
    @Value(value="${registry.url:https://collections.ala.org.au}")
    protected String registryUrl = "https://collections.ala.org.au";
    @Inject
    protected AuthService authService;
    @Inject
    private AbstractMessageSource messageSource;
    @Inject
    private AssertionService assertionService;

    @RequestMapping(value={"/assertions/codes", "/assertions/codes/"}, method={RequestMethod.GET})
    @ResponseBody
    public ErrorCode[] showCodes() throws Exception {
        return this.applyi18n(AssertionCodes.getAll());
    }

    @RequestMapping(value={"/assertions/user/codes", "/assertions/user/codes/"}, method={RequestMethod.GET})
    @ResponseBody
    public ErrorCode[] showUserCodes() throws Exception {
        return this.applyi18n(AssertionCodes.userAssertionCodes);
    }

    @RequestMapping(value={"/occurrences/assertions/add"}, method={RequestMethod.POST})
    public void addAssertionWithParams(@RequestParam(value="recordUuid", required=true) String recordUuid, HttpServletRequest request, @RequestParam(value="apiKey", required=true) String apiKey, @RequestParam(value="code", required=true) String code, @RequestParam(value="comment", required=false) String comment, @RequestParam(value="userId", required=true) String userId, @RequestParam(value="userDisplayName", required=true) String userDisplayName, @RequestParam(value="userAssertionStatus", required=false) String userAssertionStatus, @RequestParam(value="assertionUuid", required=false) String assertionUuid, @RequestParam(value="relatedRecordId", required=false) String relatedRecordId, @RequestParam(value="relatedRecordReason", required=false) String relatedRecordReason, HttpServletResponse response) throws Exception {
        this.addAssertion(recordUuid, request, apiKey, code, comment, userId, userDisplayName, userAssertionStatus, assertionUuid, relatedRecordId, relatedRecordReason, response);
    }

    @RequestMapping(value={"/bulk/assertions/add"}, method={RequestMethod.POST})
    public void addBulkAssertions(HttpServletRequest request, @RequestParam(value="apiKey", required=true) String apiKey, @RequestParam(value="assertions", required=true) String json, @RequestParam(value="userId", required=true) String userId, @RequestParam(value="userDisplayName", required=true) String userDisplayName, HttpServletResponse response) throws Exception {
        if (this.shouldPerformOperation(request, response)) {
            ObjectMapper om = new ObjectMapper();
            List assertions = (List)om.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            logger.debug((Object)("The assertions in a list of maps: " + assertions));
            Map<String, List<Map>> uuidMappedAssertions = assertions.stream().collect(Collectors.groupingBy(assertion -> (String)assertion.get("recordUuid")));
            uuidMappedAssertions.forEach((uuid, maps) -> {
                try {
                    UserAssertions userAssertions = new UserAssertions();
                    for (Map as : maps) {
                        QualityAssertion qa = new QualityAssertion();
                        Integer code = Integer.parseInt((String)as.get("code"));
                        qa.setCode(code);
                        if (code.equals(AssertionCodes.VERIFIED.getCode())) {
                            qa.setRelatedUuid((String)as.get("assertionUuid"));
                            qa.setQaStatus(Integer.valueOf(Integer.parseInt((String)as.get("userAssertionStatus"))));
                        } else {
                            qa.setQaStatus(AssertionStatus.QA_UNCONFIRMED);
                        }
                        qa.setComment((String)as.get("comment"));
                        qa.setUserId(userId);
                        qa.setUserDisplayName(userDisplayName);
                        qa.setReferenceRowKey(uuid);
                        userAssertions.add((Object)qa);
                    }
                    this.assertionService.bulkAddAssertions(uuid, userAssertions);
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to bulk add assertions for record: " + uuid));
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    @RequestMapping(value={"/occurrences/{recordUuid}/assertions/add"}, method={RequestMethod.POST})
    public void addAssertion(@PathVariable(value="recordUuid") String recordUuid, HttpServletRequest request, @RequestParam(value="apiKey", required=true) String apiKey, @RequestParam(value="code", required=true) String code, @RequestParam(value="comment", required=false) String comment, @RequestParam(value="userId", required=true) String userId, @RequestParam(value="userDisplayName", required=true) String userDisplayName, @RequestParam(value="userAssertionStatus", required=false) String userAssertionStatus, @RequestParam(value="assertionUuid", required=false) String assertionUuid, @RequestParam(value="relatedRecordId", required=false) String relatedRecordId, @RequestParam(value="relatedRecordReason", required=false) String relatedRecordReason, HttpServletResponse response) throws Exception {
        if (this.shouldPerformOperation(request, response)) {
            try {
                Optional qa = this.assertionService.addAssertion(recordUuid, code, comment, userId, userDisplayName, userAssertionStatus, assertionUuid, relatedRecordId, relatedRecordReason);
                if (qa.isPresent()) {
                    String server = request.getSession().getServletContext().getInitParameter("serverName");
                    response.setHeader("Location", server + "/occurrences/" + recordUuid + "/assertions/" + ((QualityAssertion)qa.get()).getUuid());
                    response.setStatus(201);
                } else {
                    response.setStatus(400);
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                response.sendError(500, e.getMessage());
            }
        }
    }

    @RequestMapping(value={"/occurrences/assertions/delete"}, method={RequestMethod.POST})
    public void deleteAssertionWithParams(@RequestParam(value="recordUuid", required=true) String recordUuid, @RequestParam(value="apiKey", required=true) String apiKey, @RequestParam(value="assertionUuid", required=true) String assertionUuid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.deleteAssertion(recordUuid, apiKey, assertionUuid, request, response);
    }

    @RequestMapping(value={"/occurrences/{recordUuid}/assertions/delete"}, method={RequestMethod.POST})
    public void deleteAssertion(@PathVariable(value="recordUuid") String recordUuid, @RequestParam(value="apiKey", required=true) String apiKey, @RequestParam(value="assertionUuid", required=true) String assertionUuid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.shouldPerformOperation(request, response)) {
            try {
                if (this.assertionService.deleteAssertion(recordUuid, assertionUuid)) {
                    response.setStatus(200);
                } else {
                    response.sendError(400, "recordUuid " + recordUuid + " or assertionUuid " + assertionUuid + " doesn't exist");
                }
            }
            catch (IOException e) {
                logger.error((Object)("Failed to delete assertion [id: " + assertionUuid + "] for record " + recordUuid));
                logger.error((Object)e.getMessage(), (Throwable)e);
                response.sendError(500, e.getMessage());
            }
        }
    }

    @RequestMapping(value={"/occurrences/assertions", "/occurrences/assertions/"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getAssertionWithParams(@RequestParam(value="recordUuid", required=true) String recordUuid, @RequestParam(value="assertionUuid", required=false) String assertionUuid, HttpServletResponse response) throws Exception {
        if (assertionUuid != null) {
            return this.getAssertion(recordUuid, assertionUuid, response);
        }
        return this.getAssertions(recordUuid, response);
    }

    @RequestMapping(value={"/occurrences/{recordUuid}/assertions/{assertionUuid}", "/occurrences/{recordUuid}/assertions/{assertionUuid}/"}, method={RequestMethod.GET})
    @ResponseBody
    public QualityAssertion getAssertion(@PathVariable(value="recordUuid") String recordUuid, @PathVariable(value="assertionUuid") String assertionUuid, HttpServletResponse response) throws Exception {
        try {
            QualityAssertion assertion = this.assertionService.getAssertion(recordUuid, assertionUuid);
            if (assertion != null) {
                return assertion;
            }
            response.setStatus(404);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to get assertion [id: " + assertionUuid + "] for record " + recordUuid));
            logger.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        return null;
    }

    @RequestMapping(value={"/occurrences/{recordUuid}/assertions", "/occurrences/{recordUuid}/assertions/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<QualityAssertion> getAssertions(@PathVariable(value="recordUuid") String recordUuid, HttpServletResponse response) throws Exception {
        try {
            return this.assertionService.getAssertions(recordUuid);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get assertions for record " + recordUuid));
            logger.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
            return null;
        }
    }

    @Deprecated
    @RequestMapping(value={"/occurrences/{recordUuid}/assertionQueries", "/occurrences/{recordUuid}/assertionQueries/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<QualityAssertion> getAssertionQueries(@PathVariable(value="recordUuid") String recordUuid, HttpServletResponse response) throws Exception {
        return new ArrayList<QualityAssertion>();
    }

    @RequestMapping(value={"/sync"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean showSensitiveOccurrence(@RequestParam(value="apiKey", required=true) String apiKey, HttpServletResponse response) throws Exception {
        if (this.isValidKey(apiKey)) {
            if (this.assertionService.indexAll().booleanValue()) {
                response.setStatus(200);
            } else {
                response.setStatus(200, "An index all user assertions job already running. Your request won't be processed.");
            }
        } else {
            response.sendError(403, "An invalid API Key was provided.");
        }
        return null;
    }

    public void setAssertionUtils(AssertionUtils assertionUtils) {
        this.assertionUtils = assertionUtils;
    }

    private ErrorCode[] applyi18n(ErrorCode[] errorCodes) {
        ErrorCode[] formattedErrorCodes = new ErrorCode[errorCodes.length];
        for (int i = 0; i < errorCodes.length; ++i) {
            formattedErrorCodes[i] = new ErrorCode(errorCodes[i].getName(), errorCodes[i].getCode(), errorCodes[i].getFatal(), this.messageSource.getMessage(errorCodes[i].getName(), null, errorCodes[i].getDescription(), null), ErrorCode.Category.valueOf((String)errorCodes[i].getCategory()));
        }
        return formattedErrorCodes;
    }

    private ErrorCode[] applyi18n(NameUsageIssue[] nameUsageIssues) {
        ErrorCode[] formattedErrorCodes = new ErrorCode[nameUsageIssues.length];
        for (int i = 0; i < nameUsageIssues.length; ++i) {
            formattedErrorCodes[i] = new ErrorCode(nameUsageIssues[i].name(), Integer.valueOf(nameUsageIssues[i].ordinal()), Boolean.valueOf(nameUsageIssues[i].getSeverity().equals((Object)InterpretationRemarkSeverity.ERROR)), this.messageSource.getMessage(nameUsageIssues[i].name(), null, nameUsageIssues[i].name(), null), ErrorCode.Category.Taxonomic);
        }
        return formattedErrorCodes;
    }

    private ErrorCode[] applyi18n(OccurrenceIssue[] occurrenceIssues) {
        ErrorCode[] formattedErrorCodes = new ErrorCode[occurrenceIssues.length];
        for (int i = 0; i < occurrenceIssues.length; ++i) {
            formattedErrorCodes[i] = new ErrorCode(occurrenceIssues[i].name(), Integer.valueOf(occurrenceIssues[i].ordinal()), Boolean.valueOf(occurrenceIssues[i].getSeverity().equals((Object)InterpretationRemarkSeverity.ERROR)), this.messageSource.getMessage(occurrenceIssues[i].name(), null, occurrenceIssues[i].name(), null), ErrorCode.Category.Geospatial);
        }
        return formattedErrorCodes;
    }
}

