/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.ALAOccurrenceIssue;
import au.org.ala.biocache.dto.ErrorCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gbif.api.vocabulary.InterpretationRemarkSeverity;
import org.gbif.api.vocabulary.OccurrenceIssue;

/*
 * Exception performing whole class analysis ignored.
 */
public class AssertionCodes {
    public static final ErrorCode GEOSPATIAL_ISSUE = new ErrorCode("geospatialIssue", Integer.valueOf(0), Boolean.valueOf(true), "Geospatial issue", ErrorCode.Category.Warning);
    public static final ErrorCode COORDINATE_HABITAT_MISMATCH = new ErrorCode("habitatMismatch", Integer.valueOf(19), Boolean.valueOf(true), "Habitat incorrect for species", ErrorCode.Category.Error);
    public static final ErrorCode DETECTED_OUTLIER = new ErrorCode("detectedOutlier", Integer.valueOf(20), Boolean.valueOf(true), "Suspected outlier", ErrorCode.Category.Error);
    public static final ErrorCode DECIMAL_LAT_LONG_CALCULATED_FROM_EASTING_NORTHING = new ErrorCode("decimalLatLongCalculatedFromEastingNorthing", Integer.valueOf(49), Boolean.valueOf(false), "Decimal latitude and longitude were calculated using easting, nothing and zone", ErrorCode.Category.Warning);
    public static final ErrorCode DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED = new ErrorCode("decimalLatLongCalculationFromEastingNorthingFailed", Integer.valueOf(50), Boolean.valueOf(true), "Failed to calculate decimal latitude and longitude using easting, northing and zone", ErrorCode.Category.Error);
    public static final ErrorCode TAXONOMIC_ISSUE = new ErrorCode("taxonomicIssue", Integer.valueOf(10000), Boolean.valueOf(false), "Taxonomic issue", ErrorCode.Category.Error);
    public static final ErrorCode IDENTIFICATION_INCORRECT = new ErrorCode("identificationIncorrect", Integer.valueOf(10007), Boolean.valueOf(false), "Taxon misidentified", ErrorCode.Category.Error);
    public static final ErrorCode USER_ASSERTION_OTHER = new ErrorCode("userAssertionOther", Integer.valueOf(20019), Boolean.valueOf(false), "Other error", ErrorCode.Category.Error);
    public static final ErrorCode USER_DUPLICATE_RECORD = new ErrorCode("userDuplicateRecord", Integer.valueOf(20020), Boolean.valueOf(false), "The occurrence appears to be a duplicate", ErrorCode.Category.Warning);
    public static final ErrorCode TEMPORAL_ISSUE = new ErrorCode("temporalIssue", Integer.valueOf(30000), Boolean.valueOf(false), "Temporal issue", ErrorCode.Category.Error);
    public static final ErrorCode VERIFIED = new ErrorCode("userVerified", Integer.valueOf(50000), Boolean.valueOf(true), "Record Verified by collection manager", ErrorCode.Category.Verified);
    public static final ErrorCode[] userAssertionCodes = new ErrorCode[]{GEOSPATIAL_ISSUE, COORDINATE_HABITAT_MISMATCH, DETECTED_OUTLIER, TAXONOMIC_ISSUE, IDENTIFICATION_INCORRECT, TEMPORAL_ISSUE, USER_DUPLICATE_RECORD, USER_ASSERTION_OTHER};

    public static List<ErrorCode> getCodes() {
        ErrorCode.Category c;
        ArrayList<ErrorCode> codes = new ArrayList<ErrorCode>();
        ALAOccurrenceIssue[] alaIssues = ALAOccurrenceIssue.values();
        OccurrenceIssue[] issues = OccurrenceIssue.values();
        for (ALAOccurrenceIssue aLAOccurrenceIssue : alaIssues) {
            c = null;
            c = aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.ERROR) ? ErrorCode.Category.Error : (aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.WARNING) ? ErrorCode.Category.Warning : ErrorCode.Category.Comment);
            codes.add(new ErrorCode(aLAOccurrenceIssue.name(), Integer.valueOf(aLAOccurrenceIssue.ordinal() + 1000), Boolean.valueOf(aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.ERROR)), aLAOccurrenceIssue.name().toLowerCase().replaceAll("_", " "), c));
        }
        for (ALAOccurrenceIssue aLAOccurrenceIssue : issues) {
            c = null;
            c = aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.ERROR) ? ErrorCode.Category.Error : (aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.WARNING) ? ErrorCode.Category.Warning : ErrorCode.Category.Comment);
            codes.add(new ErrorCode(aLAOccurrenceIssue.name(), Integer.valueOf(aLAOccurrenceIssue.ordinal() + 2000), Boolean.valueOf(aLAOccurrenceIssue.getSeverity().equals((Object)InterpretationRemarkSeverity.ERROR)), aLAOccurrenceIssue.name().toLowerCase().replaceAll("_", " "), c));
        }
        return codes;
    }

    public static ErrorCode[] getAll() {
        return AssertionCodes.getCodes().toArray(new ErrorCode[0]);
    }

    public static ErrorCode getByCode(int code) {
        return Arrays.stream(AssertionCodes.getAll()).filter(errorCode -> errorCode.code == code).findFirst().orElse(null);
    }

    public static ErrorCode getByName(String name) {
        return AssertionCodes.getCodes().stream().filter(errorCode -> errorCode.getName().equals(name)).findFirst().get();
    }
}

