/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.config;

import au.org.ala.biocache.service.BieSpeciesLookupService;
import au.org.ala.biocache.service.NameMatchSpeciesLookupService;
import au.org.ala.biocache.service.RestartDataService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.dataquality.api.QualityServiceRpcApi;
import au.org.ala.dataquality.client.ApiClient;
import au.org.ala.names.ws.client.ALANameUsageMatchServiceClient;
import au.org.ala.ws.ClientConfiguration;
import java.io.IOException;
import java.net.URL;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.web.client.RestOperations;

@Configuration
public class AppConfig {
    private static final Logger logger = Logger.getLogger(AppConfig.class);
    @Inject
    private AbstractMessageSource messageSource;
    @Value(value="${name.index.dir:/data/lucene/namematching}")
    protected String nameIndexLocation;
    @Inject
    @Qualifier(value="restTemplate")
    private RestOperations restTemplate;
    @Value(value="${service.bie.ws.url:https://bie-ws.ala.org.au/ws}")
    protected String bieUriPrefix;
    @Value(value="${service.bie.enabled:false}")
    protected Boolean enabledBie;
    @Value(value="${facet.config:/data/biocache/config/facets.json}")
    protected String facetConfig;
    @Value(value="${facets.max:4}")
    protected Integer facetsMax;
    @Value(value="${facet.default:true}")
    protected Boolean facetDefault;
    @Value(value="${dataquality.baseUrl:https://dataquality.ala.org.au/}")
    protected String dataQualityBaseUrl;
    @Value(value="${namesearch.url:http://localhost:9179}")
    String nameSearchUrl = "http://localhost:9179";
    @Value(value="${namesearch.timeout:30}")
    Integer nameSearchTimeout = 30;
    @Value(value="${namesearch.cache.size:50}")
    Integer nameSearchCacheSize = 50;

    @Value(value="${restart.data.dir:/tmp}")
    public void setDatabase(String dir) {
        logger.debug((Object)("setting RestartDataService.dir: " + dir));
        RestartDataService.dir = dir;
    }

    @Bean(name={"nameUsageMatchService"})
    public ALANameUsageMatchServiceClient nameUsageMatchService() throws IOException {
        ClientConfiguration clientConfiguration = ClientConfiguration.builder().baseUrl(new URL(this.nameSearchUrl)).timeOut((long)(this.nameSearchTimeout * 1000)).cacheSize((long)(this.nameSearchCacheSize * 1024 * 1024)).build();
        return new ALANameUsageMatchServiceClient(clientConfiguration);
    }

    protected SpeciesLookupService getBieSpeciesLookupService() {
        logger.info((Object)"Initialising BIE rest-based species lookup services.");
        BieSpeciesLookupService service = new BieSpeciesLookupService();
        service.setBieUriPrefix(this.bieUriPrefix);
        service.setEnabled(this.enabledBie);
        service.setRestTemplate(this.restTemplate);
        service.setMessageSource(this.messageSource);
        return service;
    }

    protected SpeciesLookupService getNameMatchSpeciesLookupService() {
        logger.info((Object)"Initialising name match species lookup services.");
        NameMatchSpeciesLookupService service = new NameMatchSpeciesLookupService();
        service.setMessageSource(this.messageSource);
        return service;
    }

    @Bean(name={"speciesLookupService"})
    public SpeciesLookupService speciesLookupServiceBean() {
        logger.info((Object)"Initialising species lookup services.");
        if (this.enabledBie.booleanValue()) {
            return this.getBieSpeciesLookupService();
        }
        return this.getNameMatchSpeciesLookupService();
    }

    @Bean(value={"dataQualityApiClient"})
    public ApiClient dataQualityApiClient() {
        ApiClient apiClient = new ApiClient();
        apiClient.getAdapterBuilder().baseUrl(this.dataQualityBaseUrl);
        return apiClient;
    }

    @Bean
    public QualityServiceRpcApi dataQualityApi(@Qualifier(value="dataQualityApiClient") ApiClient dataQualityApiClient) {
        return (QualityServiceRpcApi)dataQualityApiClient.createService(QualityServiceRpcApi.class);
    }
}

