/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
class BuildInfoController {
    private static final Logger logger = Logger.getLogger(BuildInfoController.class);

    BuildInfoController() {
    }

    @RequestMapping(value={"/buildInfo"}, method={RequestMethod.GET})
    public void buildInfo(Model model) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try (InputStream buildInfoStream = classLoader.getResourceAsStream("/buildInfo.properties");
             InputStream runtimeEnvironmentStream = classLoader.getResourceAsStream("/runtimeEnvironment.properties");){
            if (runtimeEnvironmentStream != null) {
                try {
                    Properties runtimeEnvironmentProperties = new Properties();
                    runtimeEnvironmentProperties.load(runtimeEnvironmentStream);
                    runtimeEnvironmentProperties.setProperty("java.version", System.getProperty("java.version"));
                    model.addAttribute("runtimeEnvironment", (Object)runtimeEnvironmentProperties);
                }
                catch (IOException e) {
                    logger.error((Object)"failed to read 'runtimeEnvironment.properties' resource", (Throwable)e);
                }
            }
            if (buildInfoStream != null) {
                try {
                    Properties buildInfoProperties = new Properties();
                    buildInfoProperties.load(buildInfoStream);
                    model.addAttribute("buildInfo", (Object)buildInfoProperties);
                }
                catch (IOException e) {
                    logger.error((Object)"failed to read 'buildInfo.properties' resource", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

