/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dto.Facet;
import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.dto.Qid;
import au.org.ala.biocache.dto.SearchRequestParams;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.DataQualityService;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.ListsService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.util.QidMissingException;
import au.org.ala.biocache.util.RangeBasedFacets;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.biocache.util.SpatialUtils;
import au.org.ala.biocache.util.solr.FieldMappingUtil;
import com.google.common.collect.Iterables;
import com.google.common.html.HtmlEscapers;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="queryFormatUtils")
public class QueryFormatUtils {
    private static final Logger logger = Logger.getLogger(QueryFormatUtils.class);
    @Inject
    protected SearchUtils searchUtils;
    @Inject
    protected AbstractMessageSource messageSource;
    @Inject
    protected SpeciesLookupService speciesLookupService;
    @Inject
    protected LayersService layersService;
    @Inject
    protected QidCacheDAO qidCacheDao;
    @Inject
    protected RangeBasedFacets rangeBasedFacets;
    @Inject
    protected ListsService listsService;
    @Inject
    private AuthService authService;
    @Inject
    private DataQualityService dataQualityService;
    @Inject
    private FieldMappingUtil fieldMappingUtil;
    protected static final String QUOTE = "\"";
    protected static final char[] CHARS = new char[]{' ', ':'};
    private String spatialField = "geohash";
    protected Pattern lsidPattern = Pattern.compile("(^|\\s|\"|\\(|\\[|'|-)taxonConceptID:\"?([a-zA-Z0-9/\\.:\\-_]*)\"?");
    protected Pattern speciesListPattern = Pattern.compile("(^|\\s|\"|\\(|\\[|'|-)species_list:\"?(dr[0-9]*)\"?");
    protected Pattern urnPattern = Pattern.compile("\\burn:[a-zA-Z0-9\\.:-]*");
    protected Pattern httpPattern = Pattern.compile("http:[a-zA-Z0-9/\\.:\\-_]*");
    protected Pattern uidPattern = Pattern.compile("(?:[\"]*)?((?:[a-z_]*_uid:)|(?:[a-zA-Z]*Uid:))(\\w*)(?:[\"]*)?");
    protected Pattern spatialPattern = Pattern.compile(this.spatialField + ":\"Intersects\\([a-zA-Z=\\-\\s0-9\\.\\,():]*\\)\\\"");
    protected Pattern qidPattern = QidCacheDAO.qidPattern;
    protected Pattern termPattern = Pattern.compile("([a-zA-z_]+?):((\".*?\")|(\\\\ |[^: \\)\\(])+)");
    protected Pattern indexFieldPatternMatcher = Pattern.compile("<span.*?</span>|(\\b|-)[\\w*\\(]{1,}:");
    protected Pattern layersPattern = Pattern.compile("(^|\\b)(el|cl)[0-9abc]+:");
    protected Pattern taxaPattern = Pattern.compile("(^|\\s|\"|\\(|\\[|')taxa:\"?([\\w\\s\\(\\)\\.:\\-_]*)\"?");
    private int maxBooleanClauses = 1024;
    @Value(value="${solr.circle.segments:18}")
    int solrCircleSegments = 18;
    @Value(value="${wkt.display.string: - within user defined polygon}")
    protected String wktDisplayString;
    @Value(value="${circle.display.string: - within {0} km of point({1}, {2})}")
    protected String circleDisplayString;

    public int getMaxBooleanClauses() {
        return this.maxBooleanClauses;
    }

    public void setMaxBooleanClauses(int maxBooleanClauses) {
        this.maxBooleanClauses = maxBooleanClauses;
    }

    public Map[] formatSearchQuery(SpatialSearchRequestParams searchParams) throws QidMissingException {
        return this.formatSearchQuery(searchParams, false);
    }

    public Map[] formatSearchQuery(SpatialSearchRequestParams searchParams, boolean forceQueryFormat) throws QidMissingException {
        HashMap<String, Facet> activeFacetMap = new HashMap<String, Facet>();
        HashMap<String, List> activeFacetObj = new HashMap<String, List>();
        Map[] fqMaps = new Map[]{activeFacetMap, activeFacetObj};
        if (forceQueryFormat || StringUtils.isEmpty((String)searchParams.getFormattedQuery())) {
            String[] originalFqs = searchParams.getFq();
            String[] formatted = this.formatQueryTerm(searchParams.getQ(), searchParams);
            searchParams.setDisplayString(formatted[0]);
            searchParams.setFormattedQuery(formatted[1]);
            searchParams.setFormattedFq(null);
            if (searchParams.getFq() != null) {
                for (int i = 0; i < searchParams.getFq().length; ++i) {
                    String fq = searchParams.getFq()[i];
                    if (fq == null || fq.length() <= 0) continue;
                    formatted = this.formatQueryTerm(fq, searchParams);
                    if (StringUtils.isNotEmpty((String)formatted[1])) {
                        this.addFormattedFq(new String[]{formatted[1]}, (SearchRequestParams)searchParams);
                    }
                    if (originalFqs == null || i >= originalFqs.length || formatted[1].contains(this.spatialField + ":")) continue;
                    Facet facet = new Facet();
                    facet.setDisplayName(formatted[0]);
                    String[] fv = fq.split(":");
                    if (fv.length >= 2) {
                        facet.setName(fv[0]);
                        facet.setValue(fq.substring(fv[0].length() + 1));
                    }
                    activeFacetMap.put(facet.getName(), facet);
                    String fqKey = this.parseFQ(fq);
                    if (fqKey == null) continue;
                    Facet fct = new Facet(fqKey, formatted[0]);
                    fct.setValue(fq);
                    List valList = activeFacetObj.getOrDefault(fqKey, new ArrayList());
                    valList.add(fct);
                    activeFacetObj.put(fqKey, valList);
                }
            }
            searchParams.setFq(originalFqs);
            String spatialQuery = this.buildSpatialQueryString(searchParams);
            if (StringUtils.isNotEmpty((String)spatialQuery)) {
                this.addFormattedFq(new String[]{spatialQuery}, (SearchRequestParams)searchParams);
            }
        }
        this.updateQueryContext((SearchRequestParams)searchParams);
        this.updateQualityProfileContext((SearchRequestParams)searchParams);
        return fqMaps;
    }

    private String parseFQ(String fq) {
        String[] fv;
        if (((fq = StringUtils.trimToEmpty((String)fq)).startsWith("-(") || fq.startsWith("(")) && !fq.endsWith(")")) {
            return null;
        }
        boolean globalInclusive = true;
        if (fq.startsWith("-(") && fq.endsWith(")")) {
            fq = fq.substring(2, fq.length() - 1);
            globalInclusive = false;
        } else if (fq.startsWith("(") && fq.endsWith(")")) {
            fq = fq.substring(1, fq.length() - 1);
        }
        if (StringUtils.isNotEmpty((String)fq) && (fv = fq.split(":")).length >= 2 && StringUtils.isNotBlank((String)fv[0]) && StringUtils.isNotBlank((String)fv[1])) {
            boolean localInclusive = fv[0].charAt(0) != '-';
            String key = localInclusive ? fv[0] : fv[0].substring(1);
            return globalInclusive ^ localInclusive ? "-" + key : key;
        }
        return null;
    }

    public void addFqs(String[] fqs, SpatialSearchRequestParams searchParams) {
        if (fqs != null && searchParams != null) {
            Object[] currentFqs = searchParams.getFq();
            if (currentFqs == null || currentFqs.length == 0 || currentFqs.length == 1 && currentFqs[0].length() == 0) {
                searchParams.setFq(fqs);
            } else {
                searchParams.setFq((String[])ArrayUtils.addAll((Object[])currentFqs, (Object[])fqs));
            }
        }
    }

    private void addFormattedFq(String[] fqs, SearchRequestParams searchParams) {
        if (fqs != null && searchParams != null) {
            Object[] currentFqs = searchParams.getFormattedFq();
            if (currentFqs == null || currentFqs.length == 0 || currentFqs.length == 1 && currentFqs[0].length() == 0) {
                searchParams.setFormattedFq(fqs);
            } else {
                searchParams.setFormattedFq((String[])ArrayUtils.addAll((Object[])currentFqs, (Object[])fqs));
            }
        }
    }

    private String[] formatQid(String query, SpatialSearchRequestParams searchParams) throws QidMissingException {
        String q = query;
        String displayString = query;
        if (query != null && query.contains("qid:")) {
            Matcher matcher = this.qidPattern.matcher(query);
            int count = 0;
            while (matcher.find()) {
                String value = matcher.group();
                try {
                    String qidValue = SearchUtils.stripEscapedQuotes((String)value.substring(4));
                    Qid qid = this.qidCacheDao.get(qidValue);
                    if (qid != null) {
                        if (count > 0) {
                            this.addFqs(new String[]{qid.getQ()}, searchParams);
                        } else if (qid.getQ().contains("qid:")) {
                            String[] interior = this.formatQid(qid.getQ(), searchParams);
                            displayString = interior[0];
                            q = interior[1];
                        } else {
                            q = qid.getQ();
                        }
                        this.addFqs(qid.getFqs(), searchParams);
                        if (searchParams != null) {
                            if (StringUtils.isEmpty((String)searchParams.getWkt()) && StringUtils.isNotEmpty((String)qid.getWkt())) {
                                searchParams.setWkt(qid.getWkt());
                            } else if (StringUtils.isNotEmpty((String)searchParams.getWkt()) && StringUtils.isNotEmpty((String)qid.getWkt())) {
                                this.addFqs(new String[]{SpatialUtils.getWKTQuery((String)this.spatialField, (String)qid.getWkt(), (boolean)false)}, searchParams);
                            }
                        }
                        ++count;
                        continue;
                    }
                    throw new QidMissingException("Unrecognised QID: " + searchParams.getQ());
                }
                catch (NumberFormatException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return new String[]{displayString, q};
    }

    private String[] formatTerms(String[] current) {
        if (current != null && current.length >= 2 && current[1] != null && current[1].contains(":")) {
            String taxonName = "scientificName";
            StringBuffer queryString = new StringBuffer();
            Matcher matcher = this.termPattern.matcher(current[1]);
            queryString.setLength(0);
            while (matcher.find()) {
                String guid;
                String queryText;
                String field;
                String value = matcher.group();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("term query: " + value));
                    logger.debug((Object)("groups: " + matcher.group(1) + "|" + matcher.group(2)));
                }
                if ("matched_name".equals(matcher.group(1))) {
                    field = matcher.group(1);
                    queryText = matcher.group(2);
                    if (queryText != null && !queryText.isEmpty()) {
                        guid = this.speciesLookupService.getGuidForName(queryText.replaceAll("\"", ""));
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("GUID for " + queryText + " = " + guid));
                        }
                        if (guid != null && !guid.isEmpty()) {
                            String acceptedName = this.speciesLookupService.getAcceptedNameForGuid(guid);
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("acceptedName for " + queryText + " = " + acceptedName));
                            }
                            if (acceptedName != null && !acceptedName.isEmpty()) {
                                field = taxonName;
                                queryText = acceptedName;
                            }
                        } else {
                            field = taxonName;
                        }
                        current[0] = current[0].replaceAll("matched_name", taxonName);
                    }
                    if (StringUtils.containsAny((String)queryText, (char[])CHARS) && !queryText.startsWith("[") && !queryText.startsWith("\"")) {
                        queryText = "\"" + queryText + "\"";
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("queryText: " + queryText));
                    }
                    matcher.appendReplacement(queryString, Matcher.quoteReplacement(field + ":" + queryText));
                    continue;
                }
                if ("matched_name_children".equals(matcher.group(1))) {
                    field = matcher.group(1);
                    queryText = matcher.group(2);
                    if (queryText != null && !queryText.isEmpty()) {
                        guid = this.speciesLookupService.getGuidForName(queryText.replaceAll("\"", ""));
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("GUID for " + queryText + " = " + guid));
                        }
                        if (guid != null && !guid.isEmpty()) {
                            field = "lsid";
                            queryText = guid;
                        } else {
                            field = taxonName;
                        }
                    }
                    if (StringUtils.containsAny((String)queryText, (char[])CHARS) && !queryText.startsWith("[") && !queryText.startsWith("\"")) {
                        queryText = "\"" + queryText + "\"";
                    }
                    matcher.appendReplacement(queryString, Matcher.quoteReplacement(field + ":" + queryText));
                    continue;
                }
                matcher.appendReplacement(queryString, Matcher.quoteReplacement(value));
            }
            matcher.appendTail(queryString);
            current[1] = queryString.length() > 0 ? queryString.toString() : current[1];
            current[0] = current[1];
        }
        return current;
    }

    private String[] formatTaxa(String[] current) {
        if (current != null && current.length >= 2 && current[1] != null && current[1].contains("taxa:")) {
            StringBuffer queryString = new StringBuffer();
            Matcher matcher = this.taxaPattern.matcher(current[1]);
            queryString.setLength(0);
            while (matcher.find()) {
                String field = matcher.group(1);
                String taxa = matcher.group(2);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("found taxa " + taxa));
                }
                ArrayList<String> taxaQueries = new ArrayList<String>();
                taxaQueries.add(taxa);
                List guidsForTaxa = this.speciesLookupService.getGuidsForTaxa(taxaQueries);
                String q = this.createQueryWithTaxaParam(taxaQueries, guidsForTaxa);
                matcher.appendReplacement(queryString, field + q);
            }
            matcher.appendTail(queryString);
            current[1] = queryString.toString();
            current[0] = current[1];
        } else if (StringUtils.isNotBlank((String)current[1]) && !current[1].contains(":")) {
            ArrayList<String> taxaQueries = new ArrayList<String>();
            taxaQueries.add(current[1]);
            List guidsForTaxa = this.speciesLookupService.getGuidsForTaxa(taxaQueries);
            if (!guidsForTaxa.isEmpty() && guidsForTaxa.size() == 1) {
                String q;
                current[1] = q = this.createQueryWithTaxaParam(taxaQueries, guidsForTaxa);
            }
        }
        return current;
    }

    private void formatSpeciesList(String[] current) {
        String prefix;
        String speciesList;
        if (current == null || current.length < 2 || current[1] == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = this.speciesListPattern.matcher(current[1]);
        int max = this.getMaxBooleanClauses();
        HashSet<String> failedLists = new HashSet<String>();
        while (m.find()) {
            speciesList = m.group(2);
            prefix = m.group(1);
            try {
                List lsids = this.listsService.getListItems(speciesList);
                List strings = lsids.stream().map(arg_0 -> ((SearchUtils)this.searchUtils).getTaxonSearch(arg_0)).filter(t -> ((String[])t).length > 1).map(t -> t[0]).collect(Collectors.toList());
                Iterable partition = Iterables.partition(strings, (int)(max - 10));
                String q = StreamSupport.stream(partition.spliterator(), false).map(part -> part.stream().collect(Collectors.joining(" OR ", "(", ")"))).collect(Collectors.joining(" OR "));
                if (q.length() > 1) {
                    q = "(" + q + ")";
                }
                m.appendReplacement(sb, prefix + q);
            }
            catch (Exception e) {
                logger.error((Object)("failed to get species list: " + speciesList), (Throwable)e);
                m.appendReplacement(sb, prefix + "(NOT *:*)");
                failedLists.add(speciesList);
            }
        }
        m.appendTail(sb);
        current[1] = sb.toString();
        sb = new StringBuffer();
        m = this.speciesListPattern.matcher(current[0]);
        while (m.find()) {
            speciesList = m.group(2);
            prefix = m.group(1);
            if (failedLists.contains(speciesList)) {
                m.appendReplacement(sb, prefix + "<span class=\"species_list failed\" id='" + HtmlEscapers.htmlEscaper().escape(speciesList) + "'>" + HtmlEscapers.htmlEscaper().escape(speciesList) + " (FAILED)</span>");
                continue;
            }
            try {
                ListsService.SpeciesListSearchDTO.SpeciesListDTO dto = this.listsService.getListInfo(speciesList);
                String name = dto.listName;
                m.appendReplacement(sb, prefix + "<span class='species_list' id='" + HtmlEscapers.htmlEscaper().escape(speciesList) + "'>" + HtmlEscapers.htmlEscaper().escape(name) + "</span>");
            }
            catch (Exception e) {
                logger.error((Object)("Couldn't get species list name for " + speciesList), (Throwable)e);
                m.appendReplacement(sb, prefix + "<span class='species_list' id='" + HtmlEscapers.htmlEscaper().escape(speciesList) + "'>Species list</span>");
            }
        }
        m.appendTail(sb);
        current[0] = sb.toString();
    }

    private void formatLsid(String[] current) {
        if (current == null || current.length < 2 || current[1] == null) {
            return;
        }
        String translatedQuery = this.fieldMappingUtil.translateQueryFields(current[1]);
        if (translatedQuery.contains("taxonConceptID:")) {
            StringBuffer queryString = new StringBuffer();
            StringBuffer displaySb = new StringBuffer();
            int last = 0;
            Matcher matcher = this.lsidPattern.matcher(translatedQuery);
            queryString.setLength(0);
            while (matcher.find()) {
                if ((matcher.start() <= 0 || translatedQuery.charAt(matcher.start() - 1) == '_') && matcher.start() != 0) continue;
                String value = matcher.group();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("pre-processing " + value));
                }
                String lsidHeader = matcher.group(1);
                String lsid = matcher.group(2);
                if (lsid.contains("\"")) {
                    lsid = lsid.replaceAll("\"", "");
                }
                if (lsid.contains("\\")) {
                    lsid = lsid.replaceAll("\\\\", "");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("lsid = " + lsid));
                }
                String[] values = this.searchUtils.getTaxonSearch(lsid);
                String taxonConceptId = "taxonConceptID";
                if (value != null && values.length > 0) {
                    matcher.appendReplacement(queryString, lsidHeader + values[0]);
                    displaySb.append(translatedQuery.substring(last, matcher.start()));
                    if (!values[1].startsWith(taxonConceptId + ":")) {
                        displaySb.append(lsidHeader).append("<span class='lsid' id='").append(lsid).append("'>").append(values[1]).append("</span>");
                    } else {
                        displaySb.append(lsidHeader).append(values[1]);
                    }
                    last = matcher.end();
                    continue;
                }
                logger.error((Object)("Unable to match LSID for query expansion : " + lsid));
            }
            if (last > 0) {
                matcher.appendTail(queryString);
                displaySb.append(translatedQuery.substring(last));
                current[0] = displaySb.toString();
                current[1] = queryString.toString();
            }
        }
    }

    private void formatUrn(String[] current) {
        if (current == null || current.length < 2 || current[1] == null) {
            return;
        }
        StringBuffer queryString = new StringBuffer();
        if (current[1].contains("urn")) {
            Matcher matcher = this.urnPattern.matcher(current[1]);
            queryString.setLength(0);
            while (matcher.find()) {
                String value = matcher.group();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("escaping lsid urns  " + value));
                }
                matcher.appendReplacement(queryString, this.prepareSolrStringForReplacement(value, true));
            }
            matcher.appendTail(queryString);
            current[1] = queryString.toString();
        }
    }

    private void formatHttp(String[] current) {
        if (current == null || current.length < 2 || current[1] == null) {
            return;
        }
        StringBuffer queryString = new StringBuffer();
        if (current[1].contains("http")) {
            Matcher matcher = this.httpPattern.matcher(current[1]);
            queryString.setLength(0);
            while (matcher.find()) {
                String value = matcher.group();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("escaping lsid http uris  " + value));
                }
                matcher.appendReplacement(queryString, this.prepareSolrStringForReplacement(value, true));
            }
            matcher.appendTail(queryString);
            current[1] = queryString.toString();
        }
    }

    private boolean formatSpatial(String[] current) throws QidMissingException {
        if (current == null || current.length < 2 || current[1] == null) {
            return false;
        }
        if (current[1].contains("Intersects")) {
            StringBuffer queryString = new StringBuffer();
            StringBuilder displaySb = new StringBuilder();
            Matcher matcher = this.spatialPattern.matcher(current[1]);
            if (matcher.find()) {
                String spatial = matcher.group();
                SpatialSearchRequestParams subQuery = new SpatialSearchRequestParams();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("region Start : " + matcher.regionStart() + " start :  " + matcher.start() + " spatial length " + spatial.length() + " query length " + current[1].length()));
                }
                subQuery.setQ(current[1].substring(matcher.start() + spatial.length(), current[1].length()));
                this.formatSearchQuery(subQuery, false);
                queryString.setLength(0);
                queryString.append(current[1].substring(0, matcher.start()));
                queryString.append(spatial);
                queryString.append(subQuery.getFormattedQuery());
                if (spatial.contains("circles")) {
                    String[] values = spatial.substring(spatial.indexOf("=") + 1, spatial.indexOf("}")).split(",");
                    if (values.length == 3) {
                        displaySb.setLength(0);
                        displaySb.append(subQuery.getDisplayString());
                        displaySb.append(" - within ").append(values[2]).append(" km of point(").append(values[0]).append(",").append(values[1]).append(")");
                    }
                } else {
                    displaySb.append(subQuery.getDisplayString() + " - within supplied region");
                }
            }
            if (queryString.length() > 0) {
                current[0] = displaySb.toString();
                current[1] = queryString.toString();
            }
            return true;
        }
        return false;
    }

    private void formatGeneral(String[] current, SpatialSearchRequestParams searchParams) {
        if (current == null || current.length < 2 || current[1] == null) {
            return;
        }
        current[1] = this.formatString(current[1], true);
        StringBuffer displaySb = new StringBuffer();
        if (current[0].contains("_uid") || current[0].contains("Uid")) {
            displaySb.setLength(0);
            String normalised = current[0].replaceAll("\"", "");
            Matcher matcher = this.uidPattern.matcher(normalised);
            while (matcher.find()) {
                String newVal = "<span>" + this.searchUtils.getUidDisplayString(matcher.group(1), matcher.group(2)) + "</span>";
                matcher.appendReplacement(displaySb, newVal);
            }
            matcher.appendTail(displaySb);
            current[0] = displaySb.toString();
        }
        if (current[1].equals("*:*")) {
            current[0] = "[all records]";
        }
        if (searchParams != null) {
            if (searchParams.getLat() != null && searchParams.getLon() != null && searchParams.getRadius() != null) {
                current[0] = current[0] + MessageFormat.format(this.circleDisplayString, searchParams.getRadius(), searchParams.getLat(), searchParams.getLon());
            } else if (StringUtils.isNotEmpty((String)searchParams.getWkt())) {
                current[0] = current[0] + this.wktDisplayString;
            }
        }
    }

    private void formatTitleMap(String[] current) {
        String q;
        Map titleMap;
        if (current == null || current.length < 2 || current[1] == null) {
            return;
        }
        String[] parts = current[1].split(":", 2);
        if (this.rangeBasedFacets != null && parts != null && parts.length > 0 && (titleMap = this.rangeBasedFacets.getTitleMap(parts[0])) != null && titleMap.size() > 0 && StringUtils.isNotEmpty((String)(q = (String)titleMap.get(parts[1])))) {
            current[1] = q;
        }
    }

    public String[] formatQueryTerm(String query, SpatialSearchRequestParams searchParams) throws QidMissingException {
        String tQuery = this.fieldMappingUtil.translateQueryFields(query);
        String[] formatted = this.formatQid(tQuery, searchParams);
        this.formatTerms(formatted);
        this.formatTaxa(formatted);
        this.formatSpeciesList(formatted);
        this.formatLsid(formatted);
        this.formatUrn(formatted);
        this.formatHttp(formatted);
        this.formatTitleMap(formatted);
        if (!this.formatSpatial(formatted)) {
            this.formatGeneral(formatted, searchParams);
        }
        formatted[0] = this.formatString(formatted[0], false);
        return formatted;
    }

    public String formatString(String text, boolean isQuery) {
        if (StringUtils.trimToNull((String)text) == null) {
            return text;
        }
        if (isQuery && text.contains(" OR ") || text.contains(" AND ") || text.contains("Intersects(")) {
            return text;
        }
        try {
            String formatted = "";
            Matcher m = this.indexFieldPatternMatcher.matcher(text);
            int currentPos = 0;
            while (m.find(currentPos)) {
                String i18nForValue;
                formatted = formatted + text.substring(currentPos, m.start());
                String matchedIndexTerm = m.group(0);
                if (matchedIndexTerm.startsWith("<span")) {
                    formatted = formatted + matchedIndexTerm;
                    currentPos = m.end();
                    continue;
                }
                MatchResult mr = m.toMatchResult();
                if (matchedIndexTerm.startsWith("-(")) {
                    matchedIndexTerm = matchedIndexTerm.substring(2);
                    formatted = formatted + "-(";
                } else if (matchedIndexTerm.startsWith("-")) {
                    matchedIndexTerm = matchedIndexTerm.substring(1);
                    formatted = formatted + "-";
                }
                String i18n = null;
                if (isQuery) {
                    i18n = matchedIndexTerm;
                } else {
                    Matcher lm = this.layersPattern.matcher(matchedIndexTerm);
                    matchedIndexTerm = matchedIndexTerm.replaceAll(":", "");
                    if (lm.matches()) {
                        i18n = this.layersService.getName(matchedIndexTerm);
                    }
                    if (i18n == null) {
                        i18n = this.messageSource.getMessage("facet." + this.fieldMappingUtil.translateFieldName(matchedIndexTerm), null, matchedIndexTerm, null);
                    }
                    i18n = i18n + ":";
                }
                String extractedValue = text.substring(mr.end());
                int end = 0;
                if (extractedValue.startsWith("(")) {
                    extractedValue = extractedValue.substring(1, extractedValue.indexOf(41) > 1 ? extractedValue.indexOf(41) : extractedValue.length());
                    end += 2;
                }
                if (extractedValue.startsWith("\"")) {
                    Matcher termMatcher;
                    if (extractedValue.contains(" OR ")) {
                        extractedValue = extractedValue.substring(0, extractedValue.indexOf(" OR "));
                    }
                    if ((termMatcher = this.termPattern.matcher(extractedValue)).find()) {
                        extractedValue = extractedValue.substring(0, termMatcher.start());
                    }
                    extractedValue = extractedValue.replace("\\\\", "\\").replace("\\\"", "\"");
                    int pos = extractedValue.length() - 1;
                    while ((pos = extractedValue.lastIndexOf(34, pos)) >= 0 && pos != 0 && extractedValue.charAt(pos - 1) == '\\') {
                        --pos;
                    }
                    extractedValue = pos >= 1 ? extractedValue.substring(1, pos) : extractedValue.substring(1, extractedValue.length());
                    end += 2;
                }
                boolean skipEncoding = false;
                if (extractedValue.startsWith("[")) {
                    skipEncoding = true;
                    extractedValue = extractedValue.substring(1, extractedValue.indexOf(93) > 1 ? extractedValue.indexOf(93) : extractedValue.length());
                    end += 2;
                }
                if (extractedValue.endsWith(")") && end == 0) {
                    extractedValue = extractedValue.substring(0, extractedValue.length() - 1);
                    ++end;
                } else if (extractedValue.contains(" ") && end == 0) {
                    extractedValue = extractedValue.substring(0, extractedValue.indexOf(32) >= 1 ? extractedValue.indexOf(32) : extractedValue.length());
                }
                if (skipEncoding && isQuery) {
                    i18nForValue = extractedValue;
                } else if (isQuery) {
                    i18nForValue = !extractedValue.contains("http\\") && !extractedValue.contains("urn\\") ? this.prepareSolrStringForReplacement(extractedValue, false) : extractedValue;
                } else {
                    String formattedExtractedValue = this.formatValue(matchedIndexTerm, extractedValue);
                    i18nForValue = this.messageSource.getMessage(this.fieldMappingUtil.translateFieldName(matchedIndexTerm) + "." + formattedExtractedValue, null, "", null);
                    if (i18nForValue.length() == 0) {
                        i18nForValue = this.messageSource.getMessage(formattedExtractedValue, null, formattedExtractedValue, null);
                    }
                }
                formatted = formatted + i18n + text.substring(mr.end(), mr.end() + extractedValue.length() + end).replace(extractedValue, i18nForValue);
                currentPos = mr.end() + extractedValue.length() + end;
            }
            formatted = formatted + text.substring(currentPos, text.length());
            return formatted;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            return text;
        }
    }

    private String formatValue(String fn, String fv) {
        fv = SearchUtils.stripEscapedQuotes((String)fv);
        String speciesGuid = "speciesID";
        String genusGuid = "genusID";
        String occurrenceYear = "occurrenceYear";
        String month = "month";
        String tfn = this.fieldMappingUtil.translateFieldName(fn);
        if (StringUtils.equals((String)tfn, (String)speciesGuid) || StringUtils.equals((String)tfn, (String)genusGuid)) {
            fv = this.searchUtils.substituteLsidsForNames(fv.replaceAll("\"", ""));
        } else if (StringUtils.equals((String)tfn, (String)occurrenceYear)) {
            fv = this.searchUtils.substituteYearsForDates(fv);
        } else if (StringUtils.equals((String)tfn, (String)month)) {
            fv = this.searchUtils.substituteMonthNamesForNums(fv);
        } else if (this.searchUtils.getAuthIndexFields().contains(tfn)) {
            if (this.authService.getMapOfAllUserNamesById().containsKey(StringUtils.remove((String)fv, (String)"\""))) {
                fv = (String)this.authService.getMapOfAllUserNamesById().get(StringUtils.remove((String)fv, (String)"\""));
            } else if (this.authService.getMapOfAllUserNamesByNumericId().containsKey(StringUtils.remove((String)fv, (String)"\""))) {
                fv = (String)this.authService.getMapOfAllUserNamesByNumericId().get(StringUtils.remove((String)fv, (String)"\""));
            }
        } else {
            fv = StringUtils.contains((String)fv, (String)"@") ? (this.authService.getMapOfAllUserNamesById().containsKey(StringUtils.remove((String)fv, (String)"\"")) ? (String)this.authService.getMapOfAllUserNamesById().get(StringUtils.remove((String)fv, (String)"\"")) : fv.replaceAll("\\@\\w+", "@..")) : this.searchUtils.getUidDisplayString(tfn, fv, false);
        }
        return fv;
    }

    private String prepareSolrStringForReplacement(String value, boolean forMatcher) {
        if (value.equals("*")) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        if (forMatcher) {
            sb.append(ClientUtils.escapeQueryChars((String)value).replaceAll("\\\\", "\\\\\\\\"));
        } else {
            sb.append(ClientUtils.escapeQueryChars((String)value));
        }
        return sb.toString();
    }

    protected void updateQueryContext(SearchRequestParams searchParams) {
        String qc = searchParams.getQc();
        if (StringUtils.isNotEmpty((String)qc)) {
            this.addFormattedFq(this.getQueryContextAsArray(qc), searchParams);
        }
    }

    public String[] getQueryContextAsArray(String queryContext) {
        String dataHubUid = "dataHubUid";
        if (StringUtils.isNotEmpty((String)queryContext)) {
            String[] values = queryContext.split(",");
            for (int i = 0; i < values.length; ++i) {
                String field = values[i];
                values[i] = field.replace("hub:", dataHubUid + ":");
            }
            return values;
        }
        return new String[0];
    }

    protected void updateQualityProfileContext(SearchRequestParams searchParams) {
        Map enabledFiltersByLabel = this.dataQualityService.getEnabledFiltersByLabel(searchParams);
        String[] enabledFilters = enabledFiltersByLabel.values().toArray(new String[0]);
        this.addFormattedFq(enabledFilters, searchParams);
    }

    String createQueryWithTaxaParam(List taxaQueries, List guidsForTaxa) {
        StringBuilder query = new StringBuilder();
        if (taxaQueries.size() != guidsForTaxa.size()) {
            throw new IllegalArgumentException("Arguments (List) are not the same size: taxaQueries.size() (${taxaQueries.size()}) != guidsForTaxa.size() (${guidsForTaxa.size()})");
        }
        if (taxaQueries.size() > 1) {
            query.append("(");
            for (int i = 0; i < guidsForTaxa.size(); ++i) {
                String guid = (String)guidsForTaxa.get(i);
                if (i > 0) {
                    query.append(" OR ");
                }
                if (guid != null && !guid.isEmpty()) {
                    query.append("lsid:").append(guid);
                    continue;
                }
                query.append("text:").append(taxaQueries.get(i));
            }
            query.append(")");
        } else if (guidsForTaxa.size() > 0) {
            String taxa = (String)taxaQueries.get(0);
            String guid = (String)guidsForTaxa.get(0);
            if (guid != null && !guid.isEmpty()) {
                query.append("lsid:").append(guid);
            } else if (taxa != null && !taxa.isEmpty()) {
                query.append("text:").append(taxa);
            }
        }
        return query.toString();
    }

    public String buildSpatialQueryString(SpatialSearchRequestParams searchParams) {
        if (searchParams != null) {
            StringBuilder sb = new StringBuilder();
            if (searchParams.getLat() != null) {
                String wkt = this.createCircleWkt((double)searchParams.getLon().floatValue(), (double)searchParams.getLat().floatValue(), (double)searchParams.getRadius().floatValue());
                sb.append(this.spatialField).append(":\"Intersects(").append(wkt).append(")\"");
            } else if (!StringUtils.isEmpty((String)searchParams.getWkt())) {
                sb.append(SpatialUtils.getWKTQuery((String)this.spatialField, (String)searchParams.getWkt(), (boolean)false));
            }
            return sb.toString();
        }
        return null;
    }

    private String createCircleWkt(double longitude, double latitude, double radius) {
        radius *= 1000.0;
        boolean belowMinus180 = false;
        int step = 360 / this.solrCircleSegments;
        double[][] points = new double[360 / step][];
        for (int i = 0; i < 360; i += step) {
            points[i / step] = this.computeOffset(latitude, 0.0, radius, i);
            if (!(points[i / step][0] + longitude < -180.0)) continue;
            belowMinus180 = true;
        }
        double dist = (double)(belowMinus180 ? 360 : 0) + longitude;
        StringBuilder s = new StringBuilder();
        s.append("POLYGON((");
        for (int i = 0; i < 360; i += step) {
            s.append(points[i / step][0] + dist).append(" ").append(points[i / step][1]).append(",");
        }
        s.append(points[0][0] + dist).append(" ").append(points[0][1]);
        s.append("))");
        return s.toString();
    }

    private double[] computeOffset(double lat, double lng, double radius, int angle) {
        double b = radius / 6378137.0;
        double c = (double)angle * (Math.PI / 180);
        double e = lat * (Math.PI / 180);
        double d = Math.cos(b);
        b = Math.sin(b);
        double f = Math.sin(e);
        e = Math.cos(e);
        double g = d * f + b * e * Math.cos(c);
        double x = (lng * (Math.PI / 180) + Math.atan2(b * e * Math.sin(c), d - f * g)) / (Math.PI / 180);
        double y = Math.asin(g) / (Math.PI / 180);
        return new double[]{x, y};
    }

    public static void assertNoSensitiveValues(Class c, String property, String input) {
        if (input != null && input.matches(OccurrenceIndex.CONTAINS_SENSITIVE_PATTERN)) {
            InvalidPropertyException e = new InvalidPropertyException(c, property, "Input cannot contain any of: " + org.apache.commons.lang3.StringUtils.join((Object[])OccurrenceIndex.sensitiveSOLRHdr, (String)", "));
            logger.error((Object)"Input matches a sensitive field", (Throwable)e);
            throw e;
        }
    }

    public static void assertNoSensitiveValues(Class c, String property, String[] inputs) {
        if (inputs != null) {
            for (String input : inputs) {
                QueryFormatUtils.assertNoSensitiveValues((Class)c, (String)property, (String)input);
            }
        }
    }
}

