/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="restartDataService")
public class RestartDataService {
    protected static final Logger logger = Logger.getLogger(RestartDataService.class);
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static Map<Object, List<String>> sources = new ConcurrentHashMap();
    private static Map<String, Object> values = new ConcurrentHashMap();
    public static String dir;
    @Value(value="${restart.data.enabled:false}")
    public Boolean enabled = false;
    @Value(value="${restart.data.frequency:60000}")
    public Integer frequency;
    private Thread loop;

    @PostConstruct
    public void init() {
        if (this.enabled.booleanValue()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RestartDataService dir: " + dir));
            }
            new File(dir).mkdirs();
            jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.loop = new /* Unavailable Anonymous Inner Class!! */;
            this.loop.setName("restart-data-service");
            this.loop.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadFromDisk(String key, TypeReference type) {
        String path = dir + File.separator + key;
        try {
            ObjectMapper objectMapper = jsonMapper;
            synchronized (objectMapper) {
                File file = new File(path);
                Object diskValue = null;
                if (file.exists()) {
                    jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    jsonMapper.getTypeFactory().constructType(type);
                    try {
                        diskValue = jsonMapper.readValue(file, type);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (diskValue == null && (file = new File(path + ".backup")).exists()) {
                        diskValue = jsonMapper.readValue(file, type);
                    }
                    return diskValue;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("failed to read: " + path + " into type:" + (type != null ? type.toString() : "null")), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDisk(String key, Object value) {
        if (this.enabled.booleanValue()) {
            String path = dir + File.separator + key;
            try {
                ObjectMapper objectMapper = jsonMapper;
                synchronized (objectMapper) {
                    File file = new File(path);
                    if (file.exists()) {
                        File backup = new File(path + ".backup");
                        if (backup.exists()) {
                            backup.delete();
                        }
                        FileUtils.moveFile((File)file, (File)backup);
                    }
                    jsonMapper.writeValue(file, value);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("writing " + path + " to disk"));
                }
            }
            catch (Exception e) {
                logger.error((Object)("failed to save to disk: " + path), (Throwable)e);
            }
        }
    }

    public static <T> T get(Object parent, String name, TypeReference typeRef, Class<T> defaultValue) {
        Object value = null;
        if (typeRef == null) {
            logger.error((Object)("defaultValue cannot be null: " + parent.toString() + " " + name));
        }
        if (sources.containsKey(parent)) {
            ((List)sources.get(parent)).add(name);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(name);
            sources.put(parent, list);
        }
        String key = parent.getClass().getCanonicalName() + "." + name;
        try {
            value = RestartDataService.loadFromDisk((String)key, (TypeReference)typeRef);
            if (value == null) {
                value = defaultValue.newInstance();
            } else {
                logger.debug((Object)("reading " + parent.getClass().toString() + " " + name + " from disk cache"));
            }
            values.put(key, value);
        }
        catch (Exception e) {
            logger.error((Object)("failed to instantiate: " + defaultValue != null ? defaultValue.toString() : "null"), (Throwable)e);
        }
        return (T)value;
    }

    static /* synthetic */ Map access$000() {
        return sources;
    }

    static /* synthetic */ Map access$100() {
        return values;
    }

    static /* synthetic */ void access$200(RestartDataService x0, String x1, Object x2) {
        x0.saveToDisk(x1, x2);
    }
}

