/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="emailService")
public class EmailService {
    @Value(value="${email.sender:support@ala.org.au}")
    private String sender;
    private static final Logger logger = Logger.getLogger(EmailService.class);
    private Properties properties = new Properties();
    @Value(value="${mail.smtp.host:localhost}")
    private String host;
    @Value(value="${mail.smtp.port:25}")
    private String port;

    @PostConstruct
    protected void init() {
        this.properties.put("mail.smtp.host", this.host);
        this.properties.put("mail.smtp.port", this.port);
    }

    public void sendEmail(String recipient, String copy, String subject, String content, String sender) {
        logger.debug((Object)("Send email to : " + recipient));
        Session session = Session.getDefaultInstance((Properties)this.properties);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(sender));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            if (copy != null) {
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(copy));
            }
            message.setSubject(subject);
            message.setContent((Object)content, "text/html");
            Transport.send((Message)message);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to send email to " + recipient + ".\n" + content), (Throwable)e);
        }
    }

    public void sendEmail(String recipient, String subject, String content) {
        this.sendEmail(recipient, null, subject, content, this.sender);
    }

    public void sendEmail(String recipient, String copy, String subject, String content) {
        this.sendEmail(recipient, copy, subject, content, this.sender);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }
}

