/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.ErrorCode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public class AssertionCodes {
    public static final ErrorCode GEOSPATIAL_ISSUE = new ErrorCode("geospatialIssue", Integer.valueOf(0), Boolean.valueOf(true), "Geospatial issue", ErrorCode.Category.Warning);
    public static final ErrorCode NEGATED_LATITUDE = new ErrorCode("negatedLatitude", Integer.valueOf(1), Boolean.valueOf(false), "Latitude is negated", ErrorCode.Category.Warning);
    public static final ErrorCode NEGATED_LONGITUDE = new ErrorCode("negatedLongitude", Integer.valueOf(2), Boolean.valueOf(false), "Longitude is negated", ErrorCode.Category.Warning);
    public static final ErrorCode INVERTED_COORDINATES = new ErrorCode("invertedCoordinates", Integer.valueOf(3), Boolean.valueOf(false), "Coordinates are transposed", ErrorCode.Category.Warning);
    public static final ErrorCode ZERO_COORDINATES = new ErrorCode("zeroCoordinates", Integer.valueOf(4), Boolean.valueOf(true), "Supplied coordinates are zero", ErrorCode.Category.Warning);
    public static final ErrorCode COORDINATES_OUT_OF_RANGE = new ErrorCode("coordinatesOutOfRange", Integer.valueOf(5), Boolean.valueOf(true), "Coordinates are out of range", ErrorCode.Category.Error);
    public static final ErrorCode UNKNOWN_COUNTRY_NAME = new ErrorCode("unknownCountry", Integer.valueOf(6), Boolean.valueOf(false), "Supplied country not recognised", ErrorCode.Category.Error);
    public static final ErrorCode ALTITUDE_OUT_OF_RANGE = new ErrorCode("altitudeOutOfRange", Integer.valueOf(7), Boolean.valueOf(false), "Altitude out of range", ErrorCode.Category.Error);
    public static final ErrorCode BADLY_FORMED_ALTITUDE = new ErrorCode("erroneousAltitude", Integer.valueOf(8), Boolean.valueOf(false), "Badly formed altitude", ErrorCode.Category.Error);
    public static final ErrorCode MIN_MAX_ALTITUDE_REVERSED = new ErrorCode("minMaxAltitudeReversed", Integer.valueOf(9), Boolean.valueOf(false), "Min and max altitude reversed", ErrorCode.Category.Warning);
    public static final ErrorCode DEPTH_IN_FEET = new ErrorCode("depthInFeet", Integer.valueOf(10), Boolean.valueOf(false), "Depth value supplied in feet", ErrorCode.Category.Warning);
    public static final ErrorCode DEPTH_OUT_OF_RANGE = new ErrorCode("depthOutOfRange", Integer.valueOf(11), Boolean.valueOf(false), "Depth out of range", ErrorCode.Category.Error);
    public static final ErrorCode MIN_MAX_DEPTH_REVERSED = new ErrorCode("minMaxDepthReversed", Integer.valueOf(12), Boolean.valueOf(false), "Min and max depth reversed", ErrorCode.Category.Warning);
    public static final ErrorCode ALTITUDE_IN_FEET = new ErrorCode("altitudeInFeet", Integer.valueOf(13), Boolean.valueOf(false), "Altitude value supplied in feet", ErrorCode.Category.Warning);
    public static final ErrorCode ALTITUDE_NON_NUMERIC = new ErrorCode("altitudeNonNumeric", Integer.valueOf(14), Boolean.valueOf(false), "Altitude value non-numeric", ErrorCode.Category.Error);
    public static final ErrorCode DEPTH_NON_NUMERIC = new ErrorCode("depthNonNumeric", Integer.valueOf(15), Boolean.valueOf(false), "Depth value non-numeric", ErrorCode.Category.Error);
    public static final ErrorCode COUNTRY_COORDINATE_MISMATCH = new ErrorCode("countryCoordinateMismatch", Integer.valueOf(16), Boolean.valueOf(false), "Coordinates dont match supplied country", ErrorCode.Category.Error);
    public static final ErrorCode STATE_COORDINATE_MISMATCH = new ErrorCode("stateCoordinateMismatch", Integer.valueOf(18), Boolean.valueOf(false), "Coordinates dont match supplied state", ErrorCode.Category.Error);
    public static final ErrorCode COORDINATE_HABITAT_MISMATCH = new ErrorCode("habitatMismatch", Integer.valueOf(19), Boolean.valueOf(true), "Habitat incorrect for species", ErrorCode.Category.Error);
    public static final ErrorCode DETECTED_OUTLIER = new ErrorCode("detectedOutlier", Integer.valueOf(20), Boolean.valueOf(true), "Suspected outlier", ErrorCode.Category.Error);
    public static final ErrorCode COUNTRY_INFERRED_FROM_COORDINATES = new ErrorCode("countryInferredByCoordinates", Integer.valueOf(21), Boolean.valueOf(false), "Country inferred from coordinates", ErrorCode.Category.Warning);
    public static final ErrorCode COORDINATES_CENTRE_OF_STATEPROVINCE = new ErrorCode("coordinatesCentreOfStateProvince", Integer.valueOf(22), Boolean.valueOf(true), "Supplied coordinates centre of state", ErrorCode.Category.Warning);
    public static final ErrorCode COORDINATE_PRECISION_MISMATCH = new ErrorCode("coordinatePrecisionMismatch", Integer.valueOf(23), Boolean.valueOf(false), "Coordinate precision not valid", ErrorCode.Category.Error);
    public static final ErrorCode PRECISION_RANGE_MISMATCH = new ErrorCode("precisionRangeMismatch", Integer.valueOf(17), Boolean.valueOf(false), "The precision value should be between 0 and 1.", ErrorCode.Category.Error);
    public static final ErrorCode UNCERTAINTY_RANGE_MISMATCH = new ErrorCode("uncertaintyRangeMismatch", Integer.valueOf(24), Boolean.valueOf(false), "Coordinate accuracy not valid", ErrorCode.Category.Error);
    public static final ErrorCode UNCERTAINTY_IN_PRECISION = new ErrorCode("uncertaintyInPrecision", Integer.valueOf(25), Boolean.valueOf(false), "Coordinate precision and accuracy transposed", ErrorCode.Category.Error);
    public static final ErrorCode SPECIES_OUTSIDE_EXPERT_RANGE = new ErrorCode("speciesOutsideExpertRange", Integer.valueOf(26), Boolean.valueOf(true), "Geographic coordinates are outside the range as defined by 'expert/s' for the taxa", ErrorCode.Category.Error);
    public static final ErrorCode UNCERTAINTY_NOT_SPECIFIED = new ErrorCode("uncertaintyNotSpecified", Integer.valueOf(27), Boolean.valueOf(false), "Coordinate uncertainty was not supplied", ErrorCode.Category.Missing);
    public static final ErrorCode COORDINATES_CENTRE_OF_COUNTRY = new ErrorCode("coordinatesCentreOfCountry", Integer.valueOf(28), Boolean.valueOf(true), "Supplied coordinates centre of country", ErrorCode.Category.Warning);
    public static final ErrorCode MISSING_COORDINATEPRECISION = new ErrorCode("missingCoordinatePrecision", Integer.valueOf(29), Boolean.valueOf(false), "coordinatePrecision not supplied with the record", ErrorCode.Category.Missing);
    public static final ErrorCode MISSING_GEODETICDATUM = new ErrorCode("missingGeodeticDatum", Integer.valueOf(30), Boolean.valueOf(false), "geodeticDatum not supplied for coordinates", ErrorCode.Category.Missing);
    public static final ErrorCode MISSING_GEOREFERNCEDBY = new ErrorCode("missingGeorefencedBy", Integer.valueOf(31), Boolean.valueOf(false), "GeoreferencedBy not supplied with the record", ErrorCode.Category.Missing);
    public static final ErrorCode MISSING_GEOREFERENCEPROTOCOL = new ErrorCode("missingGeoreferenceProtocol", Integer.valueOf(32), Boolean.valueOf(false), "GeoreferenceProtocol not supplied with the record", ErrorCode.Category.Missing);
    public static final ErrorCode MISSING_GEOREFERENCESOURCES = new ErrorCode("missingGeoreferenceSources", Integer.valueOf(33), Boolean.valueOf(false), "GeoreferenceSources not supplied with the record", ErrorCode.Category.Missing);
    public static final ErrorCode MISSING_GEOREFERENCEVERIFICATIONSTATUS = new ErrorCode("missingGeoreferenceVerificationStatus", Integer.valueOf(34), Boolean.valueOf(false), "GeoreferenceVerificationStatus not supplied with the record", ErrorCode.Category.Missing);
    public static final ErrorCode INVALID_GEODETICDATUM = new ErrorCode("invalidGeodeticDatum", Integer.valueOf(35), Boolean.valueOf(false), "The geodetic datum is not valid", ErrorCode.Category.Error);
    public static final ErrorCode MISSING_GEOREFERENCE_DATE = new ErrorCode("missingGeoreferenceDate", Integer.valueOf(42), Boolean.valueOf(false), "GeoreferenceDate not supplied with the record", ErrorCode.Category.Missing);
    public static final ErrorCode LOCATION_NOT_SUPPLIED = new ErrorCode("locationNotSupplied", Integer.valueOf(43), Boolean.valueOf(false), "No location information has been provided with the record", ErrorCode.Category.Missing);
    public static final ErrorCode DECIMAL_COORDINATES_NOT_SUPPLIED = new ErrorCode("decimalCoordinatesNotSupplied", Integer.valueOf(44), Boolean.valueOf(false), "No decimal longitude and latitude provided", ErrorCode.Category.Missing);
    public static final ErrorCode DECIMAL_LAT_LONG_CONVERTED = new ErrorCode("decimalLatLongConverted", Integer.valueOf(45), Boolean.valueOf(false), "Decimal latitude and longitude were converted to WGS84", ErrorCode.Category.Warning);
    public static final ErrorCode DECIMAL_LAT_LONG_CONVERSION_FAILED = new ErrorCode("decimalLatLongConversionFailed", Integer.valueOf(46), Boolean.valueOf(true), "Conversion of decimal latitude and longitude to WGS84 failed", ErrorCode.Category.Error);
    public static final ErrorCode DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM = new ErrorCode("decimalLatLongCalculatedFromVerbatim", Integer.valueOf(47), Boolean.valueOf(false), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS", ErrorCode.Category.Warning);
    public static final ErrorCode DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED = new ErrorCode("decimalLatLongCalculationFromVerbatimFailed", Integer.valueOf(48), Boolean.valueOf(true), "Failed to calculate decimal latitude and longitude from verbatimLatitude, verbatimLongitude and verbatimSRS", ErrorCode.Category.Error);
    public static final ErrorCode DECIMAL_LAT_LONG_CALCULATED_FROM_EASTING_NORTHING = new ErrorCode("decimalLatLongCalculatedFromEastingNorthing", Integer.valueOf(49), Boolean.valueOf(false), "Decimal latitude and longitude were calculated using easting, nothing and zone", ErrorCode.Category.Warning);
    public static final ErrorCode DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED = new ErrorCode("decimalLatLongCalculationFromEastingNorthingFailed", Integer.valueOf(50), Boolean.valueOf(true), "Failed to calculate decimal latitude and longitude using easting, northing and zone", ErrorCode.Category.Error);
    public static final ErrorCode GEODETIC_DATUM_ASSUMED_WGS84 = new ErrorCode("geodeticDatumAssumedWgs84", Integer.valueOf(51), Boolean.valueOf(false), "Geodetic datum assumed to be WGS84 (EPSG:4326)", ErrorCode.Category.Warning);
    public static final ErrorCode UNRECOGNIZED_GEODETIC_DATUM = new ErrorCode("unrecognizedGeodeticDatum", Integer.valueOf(52), Boolean.valueOf(false), "Geodetic datum not recognized", ErrorCode.Category.Error);
    public static final ErrorCode ZERO_LATITUDE_COORDINATES = new ErrorCode("zeroLatitude", Integer.valueOf(53), Boolean.valueOf(true), "Supplied latitude is zero", ErrorCode.Category.Warning);
    public static final ErrorCode ZERO_LONGITUDE_COORDINATES = new ErrorCode("zeroLongitude", Integer.valueOf(54), Boolean.valueOf(true), "Supplied longitude are zero", ErrorCode.Category.Warning);
    public static final ErrorCode DECIMAL_LAT_LONG_CALCULATED_FROM_GRID_REF = new ErrorCode("decimalLatLongCalculatedFromGridReference", Integer.valueOf(55), Boolean.valueOf(false), "Decimal latitude and longitude were calculated using grid reference", ErrorCode.Category.Warning);
    public static final ErrorCode TAXONOMIC_ISSUE = new ErrorCode("taxonomicIssue", Integer.valueOf(10000), Boolean.valueOf(false), "Taxonomic issue", ErrorCode.Category.Error);
    public static final ErrorCode INVALID_SCIENTIFIC_NAME = new ErrorCode("invalidScientificName", Integer.valueOf(10001), Boolean.valueOf(false), "Invalid scientific name", ErrorCode.Category.Error);
    public static final ErrorCode UNKNOWN_KINGDOM = new ErrorCode("unknownKingdom", Integer.valueOf(10002), Boolean.valueOf(false), "Kingdom not recognised", ErrorCode.Category.Error);
    public static final ErrorCode AMBIGUOUS_NAME = new ErrorCode("ambiguousName", Integer.valueOf(10003), Boolean.valueOf(false), "Higher taxonomy missing", ErrorCode.Category.Error);
    public static final ErrorCode NAME_NOTRECOGNISED = new ErrorCode("nameNotRecognised", Integer.valueOf(10004), Boolean.valueOf(false), "Name not recognised", ErrorCode.Category.Error);
    public static final ErrorCode NAME_NOT_IN_NATIONAL_CHECKLISTS = new ErrorCode("nameNotInNationalChecklists", Integer.valueOf(10005), Boolean.valueOf(false), "Name not in national checklists", ErrorCode.Category.Warning);
    public static final ErrorCode HOMONYM_ISSUE = new ErrorCode("homonymIssue", Integer.valueOf(10006), Boolean.valueOf(false), "Homonym issues with supplied name", ErrorCode.Category.Error);
    public static final ErrorCode IDENTIFICATION_INCORRECT = new ErrorCode("identificationIncorrect", Integer.valueOf(10007), Boolean.valueOf(false), "Taxon misidentified", ErrorCode.Category.Error);
    public static final ErrorCode MISSING_TAXONRANK = new ErrorCode("missingTaxonRank", Integer.valueOf(10008), Boolean.valueOf(false), "taxonRank not supplied with the record", ErrorCode.Category.Missing);
    public static final ErrorCode MISSING_IDENTIFICATIONQUALIFIER = new ErrorCode("missingIdentificationQualifier", Integer.valueOf(10009), Boolean.valueOf(false), "identificationQualifier not supplied with the record", ErrorCode.Category.Missing);
    public static final ErrorCode MISSING_IDENTIFIEDBY = new ErrorCode("missingIdentifiedBy", Integer.valueOf(10010), Boolean.valueOf(false), "identifiedBy not supplied with the record", ErrorCode.Category.Missing);
    public static final ErrorCode MISSING_IDENTIFICATIONREFERENCES = new ErrorCode("missingIdentificationReferences", Integer.valueOf(10011), Boolean.valueOf(false), "identificationReferences not supplied with the record", ErrorCode.Category.Missing);
    public static final ErrorCode MISSING_DATEIDENTIFIED = new ErrorCode("missingDateIdentified", Integer.valueOf(10012), Boolean.valueOf(false), "identificationDate not supplied with the record", ErrorCode.Category.Missing);
    public static final ErrorCode NAME_NOT_SUPPLIED = new ErrorCode("nameNotSupplied", Integer.valueOf(10015), Boolean.valueOf(false), "No scientific name or vernacular name was supplied", ErrorCode.Category.Missing);
    public static final ErrorCode MISSING_BASIS_OF_RECORD = new ErrorCode("missingBasisOfRecord", Integer.valueOf(20001), Boolean.valueOf(true), "Basis of record not supplied", ErrorCode.Category.Missing);
    public static final ErrorCode BADLY_FORMED_BASIS_OF_RECORD = new ErrorCode("badlyFormedBasisOfRecord", Integer.valueOf(20002), Boolean.valueOf(true), "Basis of record badly formed", ErrorCode.Category.Error);
    public static final ErrorCode UNRECOGNISED_TYPESTATUS = new ErrorCode("unrecognisedTypeStatus", Integer.valueOf(20004), Boolean.valueOf(false), "Type status not recognised", ErrorCode.Category.Error);
    public static final ErrorCode UNRECOGNISED_COLLECTIONCODE = new ErrorCode("unrecognisedCollectionCode", Integer.valueOf(20005), Boolean.valueOf(false), "Collection code not recognised", ErrorCode.Category.Error);
    public static final ErrorCode UNRECOGNISED_INSTITUTIONCODE = new ErrorCode("unrecognisedInstitutionCode", Integer.valueOf(20006), Boolean.valueOf(false), "Institution code not recognised", ErrorCode.Category.Error);
    public static final ErrorCode INVALID_IMAGE_URL = new ErrorCode("invalidImageUrl", Integer.valueOf(20007), Boolean.valueOf(false), "Image URL invalid", ErrorCode.Category.Error);
    public static final ErrorCode RESOURCE_TAXONOMIC_SCOPE_MISMATCH = new ErrorCode("resourceTaxonomicScopeMismatch", Integer.valueOf(20008), Boolean.valueOf(false), "Taxonomic scope mismatch between record and resource", ErrorCode.Category.Error);
    public static final ErrorCode DATA_ARE_GENERALISED = new ErrorCode("dataAreGeneralised", Integer.valueOf(20009), Boolean.valueOf(false), "The data has been supplied generalised", ErrorCode.Category.Warning);
    public static final ErrorCode OCCURRENCE_IS_CULTIVATED_OR_ESCAPEE = new ErrorCode("occCultivatedEscapee", Integer.valueOf(20010), Boolean.valueOf(false), "The occurrence is cultivated or escaped.", ErrorCode.Category.Warning);
    public static final ErrorCode INFERRED_DUPLICATE_RECORD = new ErrorCode("inferredDuplicateRecord", Integer.valueOf(20014), Boolean.valueOf(false), "The occurrence appears to be a duplicate", ErrorCode.Category.Warning);
    public static final ErrorCode MISSING_CATALOGUENUMBER = new ErrorCode("missingCatalogueNumber", Integer.valueOf(20015), Boolean.valueOf(false), "No catalogue number has been supplied", ErrorCode.Category.Missing);
    public static final ErrorCode RECORDED_BY_UNPARSABLE = new ErrorCode("recordedByUnparsable", Integer.valueOf(20016), Boolean.valueOf(false), "RecordedBy value unparseable", ErrorCode.Category.Warning);
    public static final ErrorCode UNRECOGNISED_OCCURRENCE_STATUS = new ErrorCode("unrecognisedOccurrenceStatus", Integer.valueOf(20017), Boolean.valueOf(false), "Occurrence status not recognised", ErrorCode.Category.Error);
    public static final ErrorCode ASSUMED_PRESENT_OCCURRENCE_STATUS = new ErrorCode("assumedPresentOccurrenceStatus", Integer.valueOf(20018), Boolean.valueOf(false), "Occurrence status assumed to be present", ErrorCode.Category.Warning);
    public static final ErrorCode USER_ASSERTION_OTHER = new ErrorCode("userAssertionOther", Integer.valueOf(20019), Boolean.valueOf(false), "Other error", ErrorCode.Category.Error);
    public static final ErrorCode TEMPORAL_ISSUE = new ErrorCode("temporalIssue", Integer.valueOf(30000), Boolean.valueOf(false), "Temporal issue", ErrorCode.Category.Error);
    public static final ErrorCode ID_PRE_OCCURRENCE = new ErrorCode("idPreOccurrence", Integer.valueOf(30001), Boolean.valueOf(false), "Identification date before occurrence date", ErrorCode.Category.Error);
    public static final ErrorCode GEOREFERENCE_POST_OCCURRENCE = new ErrorCode("georefPostDate", Integer.valueOf(30002), Boolean.valueOf(false), "Georeferenced after occurrence date", ErrorCode.Category.Error);
    public static final ErrorCode FIRST_OF_MONTH = new ErrorCode("firstOfMonth", Integer.valueOf(30003), Boolean.valueOf(false), "First of the month", ErrorCode.Category.Warning);
    public static final ErrorCode FIRST_OF_YEAR = new ErrorCode("firstOfYear", Integer.valueOf(30004), Boolean.valueOf(false), "First of the year", ErrorCode.Category.Warning);
    public static final ErrorCode FIRST_OF_CENTURY = new ErrorCode("firstOfCentury", Integer.valueOf(30005), Boolean.valueOf(false), "First of the century", ErrorCode.Category.Warning);
    public static final ErrorCode DATE_PRECISION_MISMATCH = new ErrorCode("datePrecisionMismatch", Integer.valueOf(30006), Boolean.valueOf(false), "Date precision invalid", ErrorCode.Category.Error);
    public static final ErrorCode INVALID_COLLECTION_DATE = new ErrorCode("invalidCollectionDate", Integer.valueOf(30007), Boolean.valueOf(false), "Invalid collection date", ErrorCode.Category.Error);
    public static final ErrorCode MISSING_COLLECTION_DATE = new ErrorCode("missingCollectionDate", Integer.valueOf(30008), Boolean.valueOf(false), "Missing collection date", ErrorCode.Category.Missing);
    public static final ErrorCode DAY_MONTH_TRANSPOSED = new ErrorCode("dayMonthTransposed", Integer.valueOf(30009), Boolean.valueOf(false), "Day and month transposed", ErrorCode.Category.Warning);
    public static final ErrorCode INCOMPLETE_COLLECTION_DATE = new ErrorCode("incompleteCollectionDate", Integer.valueOf(30010), Boolean.valueOf(false), "The date supplied was incomplete, missing the day and/or month component", ErrorCode.Category.Warning);
    public static final ErrorCode VERIFIED = new ErrorCode("userVerified", Integer.valueOf(50000), Boolean.valueOf(true), "Record Verified by collection manager", ErrorCode.Category.Verified);
    public static final ErrorCode PROCESSING_ERROR = new ErrorCode("processingError", Integer.valueOf(60000), Boolean.valueOf(true), "The system has incorrectly processed a record", ErrorCode.Category.Error);
    public static final ErrorCode MEDIA_REPRESENTATIVE = new ErrorCode("mediaRepresentative", Integer.valueOf(70000), Boolean.valueOf(false), "Media representative of taxon", ErrorCode.Category.Comment);
    public static final ErrorCode MEDIA_UNREPRESENTATIVE = new ErrorCode("mediaUnrepresentative", Integer.valueOf(70001), Boolean.valueOf(false), "Media not representative of taxon", ErrorCode.Category.Comment);
    public static final ErrorCode[] userAssertionCodes = new ErrorCode[]{GEOSPATIAL_ISSUE, COORDINATE_HABITAT_MISMATCH, DETECTED_OUTLIER, TAXONOMIC_ISSUE, IDENTIFICATION_INCORRECT, TEMPORAL_ISSUE, USER_ASSERTION_OTHER};
    private static final int[] GEOSPATIAL_BOUNDS = new int[]{0, 10000};
    private static final int[] TAXONOMIC_BOUNDS = new int[]{10000, 20000};
    private static final int[] MISCELLANEOUS_BOUNDS = new int[]{20000, 30000};
    private static final int[] TEMPORAL_BOUNDS = new int[]{30000, 40000};

    public static ErrorCode[] getAll() {
        return AssertionCodes.getAllCodesInRange(null);
    }

    private static ErrorCode[] getAllCodesInRange(int[] range) {
        ArrayList<ErrorCode> list = new ArrayList<ErrorCode>();
        for (Field field : AssertionCodes.class.getFields()) {
            if (field.getType() != ErrorCode.class) continue;
            try {
                ErrorCode errorCode = (ErrorCode)field.get(null);
                if (range != null && (errorCode.code < range[0] || errorCode.code >= range[1])) continue;
                list.add(errorCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list.toArray(new ErrorCode[0]);
    }

    public static ErrorCode[] getGeospatialCodes() {
        return AssertionCodes.getAllCodesInRange((int[])GEOSPATIAL_BOUNDS);
    }

    public static ErrorCode[] getTaxonomicCodes() {
        return AssertionCodes.getAllCodesInRange((int[])TAXONOMIC_BOUNDS);
    }

    public static ErrorCode[] getMiscellaneousCodes() {
        return AssertionCodes.getAllCodesInRange((int[])MISCELLANEOUS_BOUNDS);
    }

    public static ErrorCode[] getTemporalCodes() {
        return AssertionCodes.getAllCodesInRange((int[])TEMPORAL_BOUNDS);
    }

    public static ErrorCode getByCode(int code) {
        return Arrays.stream(AssertionCodes.getAll()).filter(errorCode -> errorCode.code == code).findFirst().orElse(null);
    }

    public static ErrorCode getByName(String name) {
        for (Field field : AssertionCodes.class.getFields()) {
            if (field.getType() != ErrorCode.class) continue;
            try {
                ErrorCode ec = (ErrorCode)field.get(null);
                if (!ec.name.equals(name) && !field.getName().equals(name)) continue;
                return ec;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

