/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.dao.IndexDAO;
import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.AssertionCodes;
import au.org.ala.biocache.dto.BreakdownRequestParams;
import au.org.ala.biocache.dto.DataProviderCountDTO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.ErrorCode;
import au.org.ala.biocache.dto.FacetDTO;
import au.org.ala.biocache.dto.FacetPivotResultDTO;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FacetThemes;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.FieldStatsItem;
import au.org.ala.biocache.dto.HeatmapDTO;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.Kvp;
import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.dto.OccurrencePoint;
import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.dto.SearchRequestParams;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SensitiveOccurrenceIndex;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.TaxaCountDTO;
import au.org.ala.biocache.dto.TaxaRankCountDTO;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.ListsService;
import au.org.ala.biocache.service.SpeciesCountsService;
import au.org.ala.biocache.service.SpeciesImageService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.stream.OptionalZipOutputStream;
import au.org.ala.biocache.util.CollectionsCache;
import au.org.ala.biocache.util.ColorUtil;
import au.org.ala.biocache.util.DownloadFields;
import au.org.ala.biocache.util.LegendItem;
import au.org.ala.biocache.util.OccurrenceUtils;
import au.org.ala.biocache.util.QueryFormatUtils;
import au.org.ala.biocache.util.RangeBasedFacets;
import au.org.ala.biocache.util.RecordWriter;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.biocache.util.SpatialUtils;
import au.org.ala.biocache.util.solr.FieldMappingUtil;
import au.org.ala.biocache.util.thread.EndemicCallable;
import au.org.ala.biocache.writer.CSVRecordWriter;
import au.org.ala.biocache.writer.RecordWriterError;
import au.org.ala.biocache.writer.RecordWriterException;
import au.org.ala.biocache.writer.ShapeFileRecordWriter;
import au.org.ala.biocache.writer.TSVRecordWriter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.googlecode.ehcache.annotations.Cacheable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.PivotField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="searchDao")
public class SearchDAOImpl
implements SearchDAO {
    private static final Logger logger = Logger.getLogger(SearchDAOImpl.class);
    public static final String DECADE_FACET_START_DATE = "1850-01-01T00:00:00Z";
    public static final String DECADE_PRE_1850_LABEL = "before";
    public static final String SOLR_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss'Z'";
    @Inject
    protected IndexDAO indexDao;
    @Inject
    protected OccurrenceUtils occurrenceUtils;
    @Value(value="${download.max:500000}")
    public Integer MAX_DOWNLOAD_SIZE = 500000;
    @Value(value="${solr.export.handler.threshold:10000}")
    public Integer EXPORT_THRESHOLD = 10000;
    @Value(value="${download.throttle.ms:50}")
    protected Integer throttle = 50;
    @Value(value="${download.batch.size:500}")
    protected Integer downloadBatchSize = 500;
    @Value(value="${download.internal.queue.size:100}")
    protected Integer resultsQueueLength;
    @Value(value="${download.max.execute.time:604800000}")
    protected Long downloadMaxTime = 604800000L;
    @Value(value="${download.max.completion.time:300000}")
    protected Long downloadMaxCompletionTime = 300000L;
    protected static final Integer FACET_PAGE_SIZE = 1000;
    protected Pattern clpField = Pattern.compile("(,|^)cl.p(,|$)");
    protected Pattern elpField = Pattern.compile("(,|^)el.p(,|$)");
    protected Pattern allDwcField = Pattern.compile("(,|^)allDwc(,|$)");
    @Value(value="${shapefile.tmp.dir:/data/biocache-download/tmp}")
    protected String tmpShapefileDir;
    @Value(value="${download.unzipped.limit:10000}")
    public Integer unzippedLimit;
    protected DownloadFields downloadFields;
    @Inject
    protected SearchUtils searchUtils;
    @Inject
    protected QueryFormatUtils queryFormatUtils;
    @Inject
    protected FieldMappingUtil fieldMappingUtil;
    @Inject
    protected CollectionsCache collectionCache;
    @Inject
    protected AbstractMessageSource messageSource;
    @Inject
    protected SpeciesLookupService speciesLookupService;
    @Inject
    protected AuthService authService;
    @Inject
    protected LayersService layersService;
    @Inject
    protected QidCacheDAO qidCacheDao;
    @Inject
    protected RangeBasedFacets rangeBasedFacets;
    @Inject
    protected SpeciesCountsService speciesCountsService;
    @Inject
    protected SpeciesImageService speciesImageService;
    @Inject
    protected ListsService listsService;
    @Inject
    protected DownloadService downloadService;
    @Value(value="${media.store.local:true}")
    protected Boolean usingLocalMediaRepo = true;
    @Value(value="${endemic.query.maxthreads:30}")
    protected Integer maxEndemicQueryThreads = 30;
    @Value(value="${solr.downloadquery.maxthreads:30}")
    protected Integer maxSolrDownloadThreads = 30;
    @Value(value="${solr.downloadquery.writertimeout:60000}")
    protected Long writerTimeoutWaitMillis = 60000L;
    @Value(value="${solr.downloadquery.busywaitsleep:100}")
    protected Long downloadCheckBusyWaitSleep = 100L;
    @Value(value="${wms.legendMaxItems:30}")
    private int wmslegendMaxItems;
    private volatile ExecutorService endemicExecutor = null;
    private volatile ExecutorService solrOnlineExecutor = null;
    @Value(value="${check.download.limits:false}")
    protected boolean checkDownloadLimits = false;
    @Value(value="${term.query.limit:1000}")
    protected Integer termQueryLimit = 1000;
    @Value(value="${media.url:https://biocache.ala.org.au/biocache-media/}")
    public String biocacheMediaUrl = "https://biocache.ala.org.au/biocache-media/";
    @Value(value="${index.fields.tohide:collector_text,location_determined,row_key,matched_name,decimal_latitudelatitude,collectors,default_values_used,generalisation_to_apply_in_metres,geohash,ibra_subregion,identifier_by,occurrence_details,text,photo_page_url,photographer,places,portal_id,quad,rem_text,occurrence_status_s,identification_qualifier_s}")
    protected String indexFieldsToHide;
    @Value(value="${default.download.fields:id,dataResourceUid,dataResourceName,license,catalogNumber,taxonConceptID,raw_scientificName,raw_vernacularName,scientificName,taxonRank,vernacularName,kingdom,phylum,class,order,family,genus,species,subspecies,institutionCode,collectionCode,raw_locality,raw_decimalLatitude,raw_decimalLongitude,raw_geodeticDatum,decimalLatitude,decimalLongitude,coordinatePrecision,coordinateUncertaintyInMeters,country,stateProvince,cl959,minimumElevationInMeters,maximumElevationInMeters,minimumDepthInMeters,maximumDepthInMeters,individualCount,recordedBy,year,month,day,verbatimEventDate,basisOfRecord,raw_basisOfRecord,sex,preparations,informationWithheld,dataGeneralizations,outlierLayer}")
    protected String defaultDownloadFields;
    @Value(value="${wms.colour:0x00000000}")
    protected int DEFAULT_COLOUR;
    @Value(value="${dwc.url:http://rs.tdwg.org/dwc/terms/}")
    protected String dwcUrl = "http://rs.tdwg.org/dwc/terms/";
    @Value(value="${max.boolean.clauses:1024}")
    private int maxBooleanClauses;
    @Value(value="${layers.service.url:https://spatial.ala.org.au/ws}")
    protected String layersServiceUrl;
    @Value(value="${solr.collection:biocache1}")
    protected String solrCollection;

    @PostConstruct
    public void init() throws Exception {
        logger.debug((Object)"Initialising SearchDAOImpl");
        Set indexedFields = this.indexDao.getIndexedFields(true);
        this.indexDao.getSchemaFields(true);
        if (this.downloadFields == null) {
            this.downloadFields = new DownloadFields(this.fieldMappingUtil, indexedFields, this.messageSource, this.layersService, this.listsService);
        } else {
            this.downloadFields.update(indexedFields);
        }
        this.getMaxBooleanClauses();
    }

    public void refreshCaches() {
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.collectionCache.updateCache();
        try {
            this.downloadFields.update(this.indexDao.getIndexedFields(true));
        }
        catch (Exception e) {
            logger.error((Object)"Unable to refresh cache.", (Throwable)e);
        }
        this.speciesImageService.resetCache();
        this.speciesCountsService.resetCache();
        this.listsService.refreshCache();
        this.layersService.refreshCache();
    }

    /*
     * WARNING - void declaration
     */
    @Cacheable(cacheName="endemicCache")
    public List<FieldResultDTO> getEndemicSpecies(SpatialSearchRequestParams requestParams) throws Exception {
        ExecutorService nextExecutor = this.getEndemicThreadPoolExecutor();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting to get Endemic Species...");
        }
        List list1 = this.getValuesForFacet(requestParams);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved species within area...(" + list1.size() + ")"));
        }
        String reverseQuery = SpatialUtils.getWKTQuery((String)"geohash", (String)requestParams.getWkt(), (boolean)true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The reverse query:" + reverseQuery));
        }
        requestParams.setWkt(null);
        int i = 0;
        int localterms = 0;
        String facet = requestParams.getFacets()[0];
        Object[] originalFqs = requestParams.getFq();
        originalFqs = (String[])ArrayUtils.add((Object[])originalFqs, (Object)reverseQuery);
        ArrayList threads = new ArrayList();
        while (i < list1.size()) {
            void var11_11;
            StringBuffer sb = new StringBuffer();
            while ((localterms == 0 || localterms % this.termQueryLimit != 0) && i < list1.size()) {
                if (localterms > 0) {
                    sb.append(" OR ");
                }
                sb.append(facet).append(":").append(ClientUtils.escapeQueryChars((String)((FieldResultDTO)list1.get(i)).getFieldValue()));
                ++i;
                ++localterms;
            }
            String string = sb.toString();
            if (localterms == 1) {
                String string2 = string + " OR " + string;
            }
            localterms = 0;
            SpatialSearchRequestParams srp = new SpatialSearchRequestParams();
            BeanUtils.copyProperties((Object)requestParams, (Object)srp);
            srp.setFq((String[])ArrayUtils.add((Object[])originalFqs, (Object)var11_11));
            int batch = i / this.termQueryLimit;
            EndemicCallable callable = new EndemicCallable(srp, batch, (SearchDAO)this);
            threads.add(nextExecutor.submit(callable));
        }
        for (Future future : threads) {
            List list = (List)future.get();
            if (list == null) continue;
            list1.removeAll(list);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Determined final endemic list (" + list1.size() + ")..."));
        }
        return list1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getEndemicThreadPoolExecutor() {
        ExecutorService nextExecutor = this.endemicExecutor;
        if (nextExecutor == null) {
            SearchDAOImpl searchDAOImpl = this;
            synchronized (searchDAOImpl) {
                nextExecutor = this.endemicExecutor;
                if (nextExecutor == null) {
                    nextExecutor = this.endemicExecutor = Executors.newFixedThreadPool(this.getMaxEndemicQueryThreads(), new ThreadFactoryBuilder().setNameFormat("biocache-endemic-%d").setPriority(1).build());
                }
            }
        }
        return nextExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getSolrOnlineThreadPoolExecutor() {
        ExecutorService nextExecutor = this.solrOnlineExecutor;
        if (nextExecutor == null) {
            SearchDAOImpl searchDAOImpl = this;
            synchronized (searchDAOImpl) {
                nextExecutor = this.solrOnlineExecutor;
                if (nextExecutor == null) {
                    nextExecutor = this.solrOnlineExecutor = Executors.newFixedThreadPool(this.getMaxSolrOnlineDownloadThreads(), new ThreadFactoryBuilder().setNameFormat("biocache-solr-online-%d").setPriority(1).build());
                }
            }
        }
        return nextExecutor;
    }

    /*
     * WARNING - void declaration
     */
    public List<FieldResultDTO> getSubquerySpeciesOnly(SpatialSearchRequestParams subQuery, SpatialSearchRequestParams parentQuery) throws Exception {
        ExecutorService nextExecutor = this.getEndemicThreadPoolExecutor();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting to get Endemic Species...");
        }
        subQuery.setFacet(Boolean.valueOf(true));
        subQuery.setFacets(parentQuery.getFacets());
        List list1 = this.getValuesForFacet(subQuery);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved species within area...(" + list1.size() + ")"));
        }
        int i = 0;
        int localterms = 0;
        String facet = parentQuery.getFacets()[0];
        Object[] originalFqs = parentQuery.getFq();
        ArrayList futures = new ArrayList();
        while (i < list1.size()) {
            void var11_11;
            StringBuffer sb = new StringBuffer();
            while ((localterms == 0 || localterms % this.termQueryLimit != 0) && i < list1.size()) {
                void var11_18;
                if (localterms > 0) {
                    sb.append(" OR ");
                }
                String string = ((FieldResultDTO)list1.get(i)).getFieldValue();
                if (facet.equals("names_and_lsid")) {
                    void var11_15;
                    if (string.startsWith("\"") && string.endsWith("\"")) {
                        String string2 = string.substring(1, string.length() - 1);
                    }
                    String string3 = "\"" + ClientUtils.escapeQueryChars((String)var11_15) + "\"";
                } else {
                    String string4 = ClientUtils.escapeQueryChars((String)string);
                }
                sb.append(facet).append(":").append((String)var11_18);
                ++i;
                ++localterms;
            }
            String string = sb.toString();
            if (localterms == 1) {
                String string5 = string + " OR " + string;
            }
            localterms = 0;
            SpatialSearchRequestParams srp = new SpatialSearchRequestParams();
            BeanUtils.copyProperties((Object)parentQuery, (Object)srp);
            srp.setFq((String[])ArrayUtils.add((Object[])originalFqs, (Object)var11_11));
            int batch = i / this.termQueryLimit;
            EndemicCallable callable = new EndemicCallable(srp, batch, (SearchDAO)this);
            futures.add(nextExecutor.submit(callable));
        }
        Collections.sort(list1);
        for (Future future : futures) {
            List list = (List)future.get();
            if (list == null) continue;
            for (FieldResultDTO find : list) {
                int idx = Collections.binarySearch(list1, find);
                if (idx < 0 || ((FieldResultDTO)list1.get(idx)).getCount() >= find.getCount()) continue;
                list1.remove(idx);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Determined final endemic list (" + list1.size() + ")..."));
        }
        return list1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEndemicFacetToStream(SpatialSearchRequestParams subQuery, SpatialSearchRequestParams parentQuery, boolean includeCount, boolean lookupName, boolean includeSynonyms, boolean includeLists, OutputStream out) throws Exception {
        List list = this.getSubquerySpeciesOnly(subQuery, parentQuery);
        String facet = parentQuery.getFacets()[0];
        boolean shouldLookup = lookupName && (facet.contains("_guid") || facet.contains("_lsid") || facet.endsWith("ID"));
        Object[] header = new String[]{facet};
        if (shouldLookup) {
            header = this.speciesLookupService.getHeaderDetails(this.fieldMappingUtil.translateFieldName(facet), includeCount, includeSynonyms);
        } else if (includeCount) {
            header = (String[])ArrayUtils.add((Object[])header, (Object)"count");
        }
        if (includeLists) {
            header = (String[])ArrayUtils.addAll((Object[])header, (Object[])this.listsService.getTypes().toArray(new String[0]));
        }
        CSVRecordWriter writer = new CSVRecordWriter(out, (String[])header);
        try {
            writer.initialise();
            boolean addedNullFacet = false;
            ArrayList<String> guids = new ArrayList<String>();
            ArrayList<Long> counts = new ArrayList<Long>();
            for (FieldResultDTO ff : list) {
                String[] stringArray;
                String name;
                if (ff.getLabel() == null) {
                    addedNullFacet = true;
                }
                if (ff.getCount() == 0L || ff.getLabel() == null && addedNullFacet) continue;
                if (shouldLookup) {
                    guids.add(ff.getLabel());
                    if (includeCount) {
                        counts.add(ff.getCount());
                    }
                    if (guids.size() != 30) continue;
                    this.writeTaxonDetailsToStream(guids, counts, includeCount, includeSynonyms, includeLists, writer);
                    guids.clear();
                    counts.clear();
                    continue;
                }
                String string = name = ff.getLabel() != null ? ff.getLabel() : "";
                if (includeCount) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = name;
                    stringArray = stringArray2;
                    stringArray2[1] = Long.toString(ff.getCount());
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = name;
                }
                String[] row = stringArray;
                writer.write(row);
            }
            if (shouldLookup) {
                this.writeTaxonDetailsToStream(guids, counts, includeCount, includeSynonyms, includeLists, writer);
            }
        }
        finally {
            writer.finalise();
        }
    }

    public List<FieldResultDTO> getValuesForFacet(SpatialSearchRequestParams requestParams) throws Exception {
        String[] line;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.writeFacetToStream(requestParams, true, false, false, false, (OutputStream)outputStream, null);
        outputStream.flush();
        outputStream.close();
        CSVReader csvReader = new CSVReader((Reader)new StringReader(outputStream.toString(StandardCharsets.UTF_8)));
        ArrayList<FieldResultDTO> list = new ArrayList<FieldResultDTO>();
        boolean first = true;
        while ((line = csvReader.readNext()) != null) {
            if (first) {
                first = false;
                continue;
            }
            if (line.length != 2) continue;
            String name = line[0];
            list.add(new FieldResultDTO(name, name, Long.parseLong(line[1])));
        }
        return list;
    }

    public SearchResultDTO findByFulltextSpatialQuery(SpatialSearchRequestParams searchParams, Map<String, String[]> extraParams) {
        return this.findByFulltextSpatialQuery(searchParams, false, extraParams);
    }

    public SearchResultDTO findByFulltextSpatialQuery(SpatialSearchRequestParams searchParams, boolean includeSensitive, Map<String, String[]> extraParams) {
        SearchResultDTO searchResults = new SearchResultDTO();
        SpatialSearchRequestParams original = new SpatialSearchRequestParams();
        BeanUtils.copyProperties((Object)searchParams, (Object)original);
        try {
            Map[] fqMaps = this.queryFormatUtils.formatSearchQuery(searchParams, true);
            String queryString = searchParams.getFormattedQuery();
            SolrQuery solrQuery = this.initSolrQuery((SearchRequestParams)searchParams, true, extraParams);
            solrQuery.setQuery(queryString);
            QueryResponse qr = this.indexDao.runSolrQuery(solrQuery, (SearchRequestParams)searchParams);
            Class resultClass = includeSensitive ? SensitiveOccurrenceIndex.class : OccurrenceIndex.class;
            searchResults = this.processSolrResponse((SearchRequestParams)original, qr, solrQuery, resultClass);
            searchResults.setQueryTitle(searchParams.getDisplayString());
            searchResults.setUrlParameters(original.getUrlParams());
            searchResults.setActiveFacetMap(fqMaps[0]);
            searchResults.setActiveFacetObj(fqMaps[1]);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("spatial search query: " + queryString));
            }
        }
        catch (Exception ex) {
            this.logError("Error executing query with requestParams: " + searchParams.toString(), ex.getMessage());
            searchResults.setStatus("ERROR");
            searchResults.setErrorMessage(ex.getMessage());
        }
        return searchResults;
    }

    public int writeSpeciesCountByCircleToStream(SpatialSearchRequestParams searchParams, String speciesGroup, ServletOutputStream out) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Writing CSV file for species count by circle");
        }
        searchParams.setPageSize(Integer.valueOf(-1));
        List species = this.findAllSpeciesByCircleAreaAndHigherTaxa(searchParams, speciesGroup);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("There are " + species.size() + "records being downloaded"));
        }
        try (CSVWriter csvWriter = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new CloseShieldOutputStream((OutputStream)out), StandardCharsets.UTF_8), '\t', '\"');){
            csvWriter.writeNext(new String[]{"Taxon ID", "Kingdom", "Family", "Scientific name", "Common name", "Record count"});
            int count = 0;
            for (TaxaCountDTO item : species) {
                String[] record = new String[]{item.getGuid(), item.getKingdom(), item.getFamily(), item.getName(), item.getCommonName(), item.getCount().toString()};
                csvWriter.writeNext(record);
                ++count;
            }
            csvWriter.flush();
            int n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFacetToStream(SpatialSearchRequestParams searchParams, boolean includeCount, boolean lookupName, boolean includeSynonyms, boolean includeLists, OutputStream out, DownloadDetailsDTO dd) throws Exception {
        FacetField ff;
        boolean shouldLookupAttribution;
        searchParams.setFlimit(Integer.valueOf(-1));
        this.queryFormatUtils.formatSearchQuery(searchParams);
        String queryString = searchParams.getFormattedQuery();
        SolrQuery solrQuery = this.initSolrQuery((SearchRequestParams)searchParams, false, null);
        solrQuery.setQuery(queryString);
        solrQuery.setRows(Integer.valueOf(0));
        searchParams.setPageSize(Integer.valueOf(0));
        solrQuery.setFacetLimit(FACET_PAGE_SIZE.intValue());
        int offset = 0;
        boolean isGuid = searchParams.getFacets()[0].contains("_guid") || searchParams.getFacets()[0].endsWith("ID");
        boolean isLsid = searchParams.getFacets()[0].contains("_lsid") || searchParams.getFacets()[0].contains("taxonConceptID");
        boolean shouldLookupTaxon = lookupName && (isLsid || isGuid);
        boolean isUid = searchParams.getFacets()[0].contains("_uid") || searchParams.getFacets()[0].endsWith("Uid");
        boolean bl = shouldLookupAttribution = lookupName && isUid;
        if (dd != null) {
            dd.resetCounts();
        }
        QueryResponse qr = this.indexDao.runSolrQuery(solrQuery, (SearchRequestParams)searchParams);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Retrieved facet results from server...");
        }
        if (qr.getResults().getNumFound() > 0L && (ff = qr.getFacetField(searchParams.getFacets()[0])) != null) {
            Object[] header = new String[]{ff.getName()};
            if (shouldLookupTaxon) {
                header = this.speciesLookupService.getHeaderDetails(this.fieldMappingUtil.translateFieldName(ff.getName()), includeCount, includeSynonyms);
            } else if (shouldLookupAttribution) {
                header = (String[])ArrayUtils.addAll((Object[])header, (Object[])new String[]{"name", "count"});
            } else if (includeCount) {
                header = (String[])ArrayUtils.add((Object[])header, (Object)"count");
            }
            if (includeLists) {
                header = (String[])ArrayUtils.addAll((Object[])header, (Object[])this.listsService.getTypes().toArray(new String[0]));
            }
            CSVRecordWriter writer = new CSVRecordWriter((OutputStream)new CloseShieldOutputStream(out), (String[])header);
            try {
                writer.initialise();
                boolean addedNullFacet = false;
                while (ff.getValueCount() > 1 || !addedNullFacet || ff.getValueCount() == 1 && ((FacetField.Count)ff.getValues().get(0)).getName() != null) {
                    if (shouldLookupTaxon) {
                        ArrayList<String> guids = new ArrayList<String>();
                        ArrayList<Long> counts = new ArrayList<Long>();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Downloading " + ff.getValueCount() + " species guids"));
                        }
                        for (FacetField.Count value : ff.getValues()) {
                            if (value.getName() == null) {
                                addedNullFacet = true;
                            }
                            if (value.getCount() == 0L || value.getName() == null && addedNullFacet) continue;
                            guids.add(value.getName());
                            if (includeCount) {
                                counts.add(value.getCount());
                            }
                            if (guids.size() != 30) continue;
                            this.writeTaxonDetailsToStream(guids, counts, includeCount, includeSynonyms, includeLists, writer);
                            guids.clear();
                            counts.clear();
                        }
                        this.writeTaxonDetailsToStream(guids, counts, includeCount, includeSynonyms, includeLists, writer);
                    } else {
                        for (FacetField.Count value : ff.getValues()) {
                            String[] stringArray;
                            String name;
                            if (value.getName() == null) {
                                addedNullFacet = true;
                            }
                            if (value.getCount() == 0L || value.getName() == null && addedNullFacet) continue;
                            String string = name = value.getName() != null ? value.getName() : "";
                            if (shouldLookupAttribution) {
                                String[] stringArray2;
                                if (includeCount) {
                                    String[] stringArray3 = new String[3];
                                    stringArray3[0] = name;
                                    stringArray3[1] = this.collectionCache.getNameForCode(name);
                                    stringArray2 = stringArray3;
                                    stringArray3[2] = Long.toString(value.getCount());
                                } else {
                                    String[] stringArray4 = new String[1];
                                    stringArray2 = stringArray4;
                                    stringArray4[0] = name;
                                }
                                writer.write(stringArray2);
                                continue;
                            }
                            if (includeCount) {
                                String[] stringArray5 = new String[2];
                                stringArray5[0] = name;
                                stringArray = stringArray5;
                                stringArray5[1] = Long.toString(value.getCount());
                            } else {
                                String[] stringArray6 = new String[1];
                                stringArray = stringArray6;
                                stringArray6[0] = name;
                            }
                            writer.write(stringArray);
                        }
                    }
                    offset += FACET_PAGE_SIZE.intValue();
                    if (dd != null) {
                        dd.updateCounts(FACET_PAGE_SIZE.intValue());
                    }
                    solrQuery.remove("facet.offset");
                    solrQuery.add("facet.offset", new String[]{Integer.toString(offset)});
                    qr = this.indexDao.runSolrQuery(solrQuery, (SearchRequestParams)searchParams);
                    ff = qr.getFacetField(searchParams.getFacets()[0]);
                }
            }
            finally {
                writer.finalise();
            }
        }
    }

    private void writeTaxonDetailsToStream(List<String> guids, List<Long> counts, boolean includeCounts, boolean includeSynonyms, boolean includeLists, CSVRecordWriter writer) throws Exception {
        List values = this.speciesLookupService.getSpeciesDetails(guids, counts, includeCounts, includeSynonyms, includeLists);
        for (String[] value : values) {
            writer.write(value);
        }
    }

    public void writeCoordinatesToStream(SearchRequestParams searchParams, OutputStream out) throws Exception {
        FacetField ff;
        SearchRequestParams srp = new SearchRequestParams();
        SearchUtils.setDefaultParams((SearchRequestParams)srp);
        srp.setFacets(searchParams.getFacets());
        SolrQuery solrQuery = this.initSolrQuery(srp, false, null);
        solrQuery.setFacetLimit(-1);
        solrQuery.setFacetSort("count");
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery(searchParams.getQ());
        QueryResponse qr = this.indexDao.runSolrQuery(solrQuery, srp);
        if (qr.getResults().size() > 0 && (ff = qr.getFacetField(searchParams.getFacets()[0])) != null && ff.getValueCount() > 0) {
            out.write("latitude,longitude\n".getBytes(StandardCharsets.UTF_8));
            for (FacetField.Count value : ff.getValues()) {
                if (value.getName() == null || value.getCount() <= 0L) continue;
                out.write(value.getName().getBytes(StandardCharsets.UTF_8));
                out.write("\n".getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public ConcurrentMap<String, AtomicInteger> writeResultsFromIndexToStream(DownloadRequestParams downloadParams, OutputStream out, boolean includeSensitive, DownloadDetailsDTO dd, boolean checkLimit) throws Exception {
        ExecutorService nextExecutor = this.getSolrOnlineThreadPoolExecutor();
        return this.writeResultsFromIndexToStream(downloadParams, out, includeSensitive, dd, checkLimit, nextExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ConcurrentMap<String, AtomicInteger> writeResultsFromIndexToStream(DownloadRequestParams downloadParams, OutputStream out, boolean includeSensitive, DownloadDetailsDTO dd, boolean checkLimit, ExecutorService nextExecutor) throws Exception {
        ConcurrentHashMap<String, AtomicInteger> uidStats;
        block319: {
            this.expandRequestedFields(downloadParams, true);
            if (dd != null) {
                dd.resetCounts();
            }
            long start = System.currentTimeMillis();
            uidStats = new ConcurrentHashMap<String, AtomicInteger>();
            try {
                void var36_47;
                Object[] notSensitiveFields;
                String[] sensitiveFields;
                SolrQuery monthAssertionsQuery;
                List[] indexedFields;
                int i;
                SolrQuery solrQuery = new SolrQuery();
                this.queryFormatUtils.formatSearchQuery((SpatialSearchRequestParams)downloadParams);
                String requestedFieldsParam = this.getDownloadFields(downloadParams);
                if (includeSensitive) {
                    if (requestedFieldsParam.contains(",decimalLatitude")) {
                        requestedFieldsParam = requestedFieldsParam.replaceFirst(",decimalLatitude", ",sensitive_decimalLatitude,sensitive_decimalLongitude,decimalLatitude");
                    } else if (requestedFieldsParam.contains("raw_decimalLatitude")) {
                        requestedFieldsParam = requestedFieldsParam.replaceFirst("raw_decimalLatitude", "sensitive_decimalLatitude,sensitive_decimalLongitude,raw_decimalLatitude");
                    }
                    if (requestedFieldsParam.contains(",raw_locality,")) {
                        requestedFieldsParam = requestedFieldsParam.replaceFirst(",raw_locality,", ",raw_locality,sensitive_locality,");
                    }
                    if (requestedFieldsParam.contains(",locality,")) {
                        requestedFieldsParam = requestedFieldsParam.replaceFirst(",locality,", ",locality,sensitive_locality,");
                    }
                }
                StringBuilder dbFieldsBuilder = new StringBuilder(requestedFieldsParam);
                if (!downloadParams.getExtra().isEmpty()) {
                    dbFieldsBuilder.append(",").append(downloadParams.getExtra());
                }
                List<String> requestedFields = Arrays.stream(dbFieldsBuilder.toString().split(",")).map(field -> this.fieldMappingUtil.translateFieldName(field)).collect(Collectors.toList());
                if (this.downloadFields == null) {
                    LinkedList mappedNames = new LinkedList();
                    for (i = 0; i < requestedFields.size(); ++i) {
                        mappedNames.add(requestedFields.get(i));
                    }
                    indexedFields = new List[]{mappedNames, new LinkedList(), mappedNames, mappedNames, new ArrayList(), new ArrayList()};
                } else {
                    indexedFields = this.downloadFields.getIndexFields(requestedFields.toArray(new String[0]), downloadParams.getDwcHeaders().booleanValue(), downloadParams.getLayersServiceUrl());
                }
                String[] customHeader = dd.getRequestParams().getCustomHeader().split(",");
                i = 0;
                while (i + 1 < customHeader.length) {
                    int j;
                    for (j = 0; j < indexedFields[0].size(); ++j) {
                        if (!customHeader[i].equals(indexedFields[0].get(j))) continue;
                        indexedFields[2].set(j, customHeader[i + 1]);
                    }
                    for (j = 0; j < indexedFields[4].size(); ++j) {
                        if (!customHeader[i].equals(indexedFields[5].get(j))) continue;
                        indexedFields[4].set(j, customHeader[i + 1]);
                    }
                    i += 2;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Fields included in download: " + indexedFields[0]));
                    logger.debug((Object)("Fields excluded from download: " + indexedFields[1]));
                    logger.debug((Object)("The headers in downloads: " + indexedFields[2]));
                    logger.debug((Object)("Analysis headers: " + indexedFields[4]));
                    logger.debug((Object)("Analysis fields: " + indexedFields[5]));
                    logger.debug((Object)("Species List headers: " + indexedFields[6]));
                    logger.debug((Object)("Species List fields: " + indexedFields[7]));
                }
                Object[] fields = indexedFields[0].toArray(new String[0]);
                solrQuery.setFields((String[])fields);
                StringBuilder qasb = new StringBuilder();
                if (!"none".equals(downloadParams.getQa())) {
                    solrQuery.addField("assertions");
                    if (!"all".equals(downloadParams.getQa()) && !"includeall".equals(downloadParams.getQa())) {
                        qasb.append(downloadParams.getQa());
                    }
                }
                solrQuery.addField("institutionUid").addField("collectionUid").addField("dataResourceUid").addField("dataProviderUid");
                if (indexedFields[7].size() > 0) {
                    String lft = "lft";
                    String rgt = "rgt";
                    if (!solrQuery.getFields().matches("($" + lft + ",|," + lft + ",|," + lft + "^)")) {
                        solrQuery.addField(lft);
                    }
                    if (!solrQuery.getFields().matches("($" + rgt + ",|," + rgt + ",|," + rgt + "^)")) {
                        solrQuery.addField(rgt);
                    }
                }
                solrQuery.setQuery(downloadParams.getFormattedQuery());
                solrQuery.setFacetMinCount(1);
                solrQuery.setFacetLimit(-1);
                boolean getAssertionsFromFacets = "all".equals(downloadParams.getQa()) || "includeall".equals(downloadParams.getQa());
                SolrQuery solrQuery2 = monthAssertionsQuery = getAssertionsFromFacets ? solrQuery.getCopy().addFacetField(new String[]{"month", "assertions"}) : solrQuery.getCopy().addFacetField(new String[]{"month"});
                if (getAssertionsFromFacets) {
                    monthAssertionsQuery.add("f.assertions.facet.sort", new String[]{"index"});
                }
                QueryResponse facetQuery = this.runSolrQuery(monthAssertionsQuery, downloadParams.getFormattedFq(), Integer.valueOf(0), Integer.valueOf(0), "score", "asc");
                dd.setTotalRecords(facetQuery.getResults().getNumFound());
                long maxDownloadSize = this.MAX_DOWNLOAD_SIZE > this.unzippedLimit && out instanceof OptionalZipOutputStream && ((OptionalZipOutputStream)out).getType() == OptionalZipOutputStream.Type.unzipped ? (long)this.unzippedLimit.intValue() : (long)this.MAX_DOWNLOAD_SIZE.intValue();
                if (checkLimit && dd.getTotalRecords() < maxDownloadSize) {
                    checkLimit = false;
                }
                if (dd.getRequestParams() != null && dd.getRequestParams().getIncludeMisc().booleanValue()) {
                    for (IndexFieldDTO f : this.indexDao.getIndexFieldDetails(new String[0])) {
                        if (!f.isStored() || f.getName() == null || !f.getName().startsWith("_")) continue;
                        solrQuery.addField(f.getName());
                    }
                    if (!solrQuery.getFields().contains(",sensitive,")) {
                        solrQuery.addField("sensitive");
                    }
                }
                List splitByFacet = null;
                for (FacetField facet : facetQuery.getFacetFields()) {
                    if (facet.getName().equals("assertions") && facet.getValueCount() > 0) {
                        qasb.append(this.getQAFromFacet(facet));
                    }
                    if (!facet.getName().equals("month") || facet.getValueCount() <= 0) continue;
                    splitByFacet = facet.getValues();
                }
                if ("includeall".equals(downloadParams.getQa())) {
                    qasb = this.getAllQAFields();
                }
                String qas = qasb.toString();
                if (dd.getSensitiveFq() != null) {
                    List[] sensitiveHdr = this.downloadFields.getIndexFields(OccurrenceIndex.sensitiveSOLRHdr, downloadParams.getDwcHeaders().booleanValue(), downloadParams.getLayersServiceUrl());
                    indexedFields[2].addAll(sensitiveHdr[2]);
                    sensitiveFields = (String[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])indexedFields[0].toArray(new String[0]), (Object[])sensitiveHdr[0].toArray(new String[0]));
                    notSensitiveFields = (String[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])indexedFields[0].toArray(new String[0]), (Object[])OccurrenceIndex.notSensitiveSOLRHdr);
                } else {
                    sensitiveFields = new String[]{};
                    notSensitiveFields = fields;
                }
                indexedFields[2].addAll(indexedFields[4]);
                String[] analysisFields = indexedFields[5].toArray(new String[0]);
                indexedFields[2].addAll(indexedFields[6]);
                String[] speciesListFields = indexedFields[7].toArray(new String[0]);
                Object[] qaFields = qas.equals("") ? new String[]{} : qas.split(",");
                Object[] qaTitles = this.downloadFields.getHeader((String[])qaFields, false, false);
                String[] header = (String[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])indexedFields[2].toArray(new String[0]), (Object[])qaTitles);
                StringBuilder infoFields = new StringBuilder("infoFields");
                for (String h : indexedFields[3]) {
                    infoFields.append(",").append(h);
                }
                for (String string : analysisFields) {
                    infoFields.append(",").append(string);
                }
                for (String string : speciesListFields) {
                    infoFields.append(",").append(string);
                }
                for (String string : qaFields) {
                    infoFields.append(",").append(string);
                }
                StringBuilder infoHeader = new StringBuilder("infoHeaders");
                String[] h = header;
                int n = h.length;
                boolean bl = false;
                while (var36_47 < n) {
                    String h2 = h[var36_47];
                    infoHeader.append(",").append(h2);
                    ++var36_47;
                }
                String info = infoFields.toString();
                while (info.contains(",,")) {
                    info = info.replace(",,", ",");
                }
                uidStats.put(info, new AtomicInteger(-1));
                String hdr = infoHeader.toString();
                while (hdr.contains(",,")) {
                    hdr = hdr.replace(",,", ",");
                }
                uidStats.put(hdr, new AtomicInteger(-2));
                CSVRecordWriter cSVRecordWriter = downloadParams.getFileType().equals("csv") ? new CSVRecordWriter(out, header, downloadParams.getSep().charValue(), downloadParams.getEsc().charValue()) : (downloadParams.getFileType().equals("tsv") ? new TSVRecordWriter(out, header) : new ShapeFileRecordWriter(this.tmpShapefileDir, downloadParams.getFile(), out, (String[])ArrayUtils.addAll((Object[])fields, (Object[])qaFields)));
                AtomicBoolean interruptFound = dd != null ? dd.getInterrupt() : new AtomicBoolean(false);
                ArrayBlockingQueue<String[]> queue = new ArrayBlockingQueue<String[]>(this.resultsQueueLength);
                String[] sentinel = new String[]{};
                1 concurrentWrapper = new /* Unavailable Anonymous Inner Class!! */;
                2 writerRunnable = new /* Unavailable Anonymous Inner Class!! */;
                Thread writerThread = new Thread((Runnable)writerRunnable);
                try {
                    boolean bl2;
                    cSVRecordWriter.initialise();
                    writerThread.start();
                    if (cSVRecordWriter instanceof ShapeFileRecordWriter) {
                        dd.setHeaderMap(((ShapeFileRecordWriter)cSVRecordWriter).getHeaderMappings());
                    }
                    ArrayList<SolrQuery> queries = new ArrayList<SolrQuery>();
                    if (splitByFacet != null) {
                        for (FacetField.Count facet : splitByFacet) {
                            if (facet.getCount() <= 0L || facet.getName() == null) continue;
                            SolrQuery splitByFacetQuery = solrQuery.getCopy().addFilterQuery(new String[]{facet.getFacetField().getName() + ":" + facet.getName()});
                            splitByFacetQuery.setFacet(false);
                            queries.add(splitByFacetQuery);
                        }
                        if (splitByFacet.size() > 0) {
                            SolrQuery remainderQuery = solrQuery.getCopy().addFilterQuery(new String[]{"-" + ((FacetField.Count)splitByFacet.get(0)).getFacetField().getName() + ":[* TO *]"});
                            queries.add(0, remainderQuery);
                        }
                    } else {
                        queries.add(0, solrQuery);
                    }
                    String[] notSensitiveSOLRHdr = OccurrenceIndex.notSensitiveSOLRHdr;
                    ArrayList sensitiveQ = new ArrayList();
                    if (!includeSensitive && dd.getSensitiveFq() != null) {
                        sensitiveQ.addAll(this.splitQueries(queries, dd.getSensitiveFq(), OccurrenceIndex.sensitiveSOLRHdr, notSensitiveSOLRHdr));
                    }
                    AtomicInteger resultsCount = new AtomicInteger(0);
                    boolean threadCheckLimit = checkLimit;
                    ArrayList miscFields = new ArrayList(0);
                    ArrayList<3> solrCallables = new ArrayList<3>(queries.size());
                    for (SolrQuery solrQuery3 : queries) {
                        3 var52_68 = new /* Unavailable Anonymous Inner Class!! */;
                        solrCallables.add(var52_68);
                    }
                    ArrayList futures = new ArrayList(solrCallables.size());
                    for (Callable callable : solrCallables) {
                        futures.add(nextExecutor.submit(callable));
                    }
                    boolean bl3 = false;
                    do {
                        bl2 = false;
                        for (Future future : futures) {
                            if (future.isDone()) continue;
                            bl2 = true;
                            if (!interruptFound.get()) continue;
                            future.cancel(true);
                        }
                        if (bl2 && System.currentTimeMillis() - start > this.downloadMaxTime) {
                            logger.error((Object)("Download max time was exceeded: downloadMaxTime=" + this.downloadMaxTime + " duration=" + (System.currentTimeMillis() - start)));
                            interruptFound.set(true);
                            break;
                        }
                        if (!bl2) continue;
                        Thread.sleep(this.downloadCheckBusyWaitSleep);
                    } while (bl2);
                    AtomicInteger atomicInteger = new AtomicInteger(0);
                    for (Future future : futures) {
                        if (future.isDone()) {
                            atomicInteger.addAndGet((Integer)future.get());
                            continue;
                        }
                        future.cancel(true);
                    }
                    long l = System.currentTimeMillis();
                    long timeTakenInSecs = (l - start) / 1000L;
                    if (timeTakenInSecs <= 0L) {
                        timeTakenInSecs = 1L;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Download of " + resultsCount + " records in " + timeTakenInSecs + " seconds. Record/sec: " + (long)resultsCount.intValue() / timeTakenInSecs));
                    }
                    if (dd != null && miscFields.size() > 0) {
                        String[] newMiscFields = new String[miscFields.size()];
                        miscFields.toArray(newMiscFields);
                        dd.setMiscFields(newMiscFields);
                    }
                }
                finally {
                    try {
                        concurrentWrapper.finalise();
                    }
                    finally {
                        try {
                            long completionStartTime = System.currentTimeMillis();
                            while (!(!writerThread.isAlive() || writerThread.isInterrupted() || interruptFound.get() || Thread.currentThread().isInterrupted() || cSVRecordWriter.finalised() || System.currentTimeMillis() - completionStartTime > this.downloadMaxCompletionTime)) {
                                Thread.sleep(this.downloadCheckBusyWaitSleep);
                            }
                        }
                        finally {
                            try {
                                interruptFound.set(true);
                            }
                            finally {
                                try {
                                    while (!queue.offer(sentinel)) {
                                        queue.clear();
                                    }
                                }
                                finally {
                                    try {
                                        writerThread.interrupt();
                                    }
                                    finally {
                                        try {
                                            cSVRecordWriter.finalise();
                                        }
                                        finally {
                                            if (cSVRecordWriter != null && cSVRecordWriter.hasError()) {
                                                throw RecordWriterException.newRecordWriterException((DownloadDetailsDTO)dd, (DownloadRequestParams)downloadParams, (boolean)true, (RecordWriterError)cSVRecordWriter);
                                            }
                                            out.flush();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (SolrServerException ex) {
                this.logError("Problem communicating with SOLR server while processing download. ", ex.getMessage());
                if (!logger.isDebugEnabled()) break block319;
                logger.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return uidStats;
    }

    private List<String[]> intersectResults(String layersServiceUrl, String[] analysisLayers, SolrDocumentList results) {
        List<Object> intersection = new ArrayList<String[]>();
        if (analysisLayers.length > 0 && StringUtils.isNotEmpty((String)layersServiceUrl)) {
            try {
                double[][] points = new double[results.size()][2];
                int invalid = 0;
                int i = 0;
                for (SolrDocument sd : results) {
                    if (sd.containsKey((Object)"sensitive_longitude") && sd.containsKey((Object)"sensitive_latitude")) {
                        points[i][0] = (Double)sd.getFirstValue("sensitive_longitude");
                        points[i][1] = (Double)sd.getFirstValue("sensitive_latitude");
                    } else if (sd.containsKey((Object)"decimalLatitude") && sd.containsKey((Object)"decimalLongitude")) {
                        points[i][0] = (Double)sd.getFirstValue("decimalLongitude");
                        points[i][1] = (Double)sd.getFirstValue("decimalLatitude");
                    } else {
                        points[i][0] = 0.0;
                        points[i][1] = 0.0;
                        ++invalid;
                    }
                    ++i;
                }
                if (invalid < results.size()) {
                    Reader reader = this.layersService.sample(analysisLayers, points, null);
                    CSVReader csv = new CSVReader(reader);
                    intersection = csv.readAll();
                    csv.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"Failed to intersect analysis layers", (Throwable)e);
            }
        }
        return intersection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processQueryResults(ConcurrentMap<String, AtomicInteger> uidStats, String[] fields, String[] qaFields, RecordWriter rw, QueryResponse qr, DownloadDetailsDTO dd, boolean checkLimit, AtomicInteger resultsCount, long maxDownloadSize, String[] analysisLayers, String[] speciesListFields, List<String> miscFields, Boolean sensitiveDataAllowed) {
        List intersection = this.intersectResults(dd.getRequestParams().getLayersServiceUrl(), analysisLayers, qr.getResults());
        String institutionUid = "institutionUid";
        String collectionUid = "collectionUid";
        String dataProviderUid = "dataProviderUid";
        String dataResourceUid = "dataResourceUid";
        int count = 0;
        int record = 0;
        for (SolrDocument sd : qr.getResults()) {
            if (sd.getFieldValue(dataResourceUid) != null && (!checkLimit || checkLimit && (long)resultsCount.intValue() < maxDownloadSize)) {
                Collection assertions;
                String[] sampling;
                ++count;
                resultsCount.incrementAndGet();
                String[] values = new String[fields.length + analysisLayers.length + speciesListFields.length + qaFields.length];
                block4: for (int j = 0; j < fields.length; ++j) {
                    Collection allValues = sd.getFieldValues(fields[j]);
                    if (allValues == null) {
                        values[j] = "";
                        continue;
                    }
                    for (Object value : allValues) {
                        if (values[j] != null && values[j].length() > 0) {
                            int n = j;
                            values[n] = values[n] + "|";
                        }
                        values[j] = this.formatValue(value);
                        if (dd != null && dd.getRequestParams() != null && dd.getRequestParams().getIncludeMultivalues() != null && dd.getRequestParams().getIncludeMultivalues().booleanValue()) continue;
                        continue block4;
                    }
                }
                if (analysisLayers.length > 0 && intersection.size() > record && (sampling = (String[])intersection.get(record + 1)) != null && sampling.length == analysisLayers.length + 2) {
                    System.arraycopy(sampling, 2, values, fields.length, sampling.length - 2);
                }
                if (speciesListFields.length > 0) {
                    String lftString = String.valueOf(sd.getFieldValue("lft"));
                    String rgtString = String.valueOf(sd.getFieldValue("rgt"));
                    if (StringUtils.isNumeric((String)lftString)) {
                        long lft = Long.parseLong(lftString);
                        long rgt = Long.parseLong(rgtString);
                        Kvp lftrgt = new Kvp(lft, rgt);
                        String drDot = ".";
                        String dr = "";
                        int fieldIdx = 0;
                        for (int i = 0; i < speciesListFields.length; ++i) {
                            if (speciesListFields[i].startsWith(drDot)) {
                                ++fieldIdx;
                            } else {
                                dr = speciesListFields[i].split("\\.", 2)[0];
                                drDot = dr + ".";
                                fieldIdx = 0;
                            }
                            values[analysisLayers.length + fields.length + i] = this.listsService.getKvpValue(fieldIdx, this.listsService.getKvp(dr), lftrgt);
                        }
                    }
                }
                if ((assertions = sd.getFieldValues("assertions")) == null) {
                    assertions = Collections.EMPTY_LIST;
                }
                for (int k = 0; k < qaFields.length; ++k) {
                    values[fields.length + analysisLayers.length + speciesListFields.length + k] = Boolean.toString(assertions.contains(qaFields[k]));
                }
                if (dd != null && dd.getRequestParams() != null && dd.getRequestParams().getIncludeMisc().booleanValue() && (sensitiveDataAllowed.booleanValue() || "Not sensitive".equals(this.formatValue(sd.getFieldValue("sensitive"))) || "".equals(this.formatValue(sd.getFieldValue("sensitive"))))) {
                    ArrayList<String> miscValues = new ArrayList<String>(miscFields.size());
                    List<String> lft = miscFields;
                    synchronized (lft) {
                        Object value;
                        for (String f : miscFields) {
                            miscValues.add(this.formatValue(sd.getFieldValue(f)));
                            sd.setField(f, null);
                        }
                        value = sd.getFieldNames().iterator();
                        while (value.hasNext()) {
                            String value2;
                            String key = (String)value.next();
                            if (key == null || !key.startsWith("_") || !StringUtils.isNotEmpty((String)(value2 = this.formatValue(sd.getFieldValue(key))))) continue;
                            miscValues.add(value2);
                            miscFields.add(key);
                        }
                    }
                    if (miscValues.size() > 0) {
                        String[] newValues = new String[miscValues.size() + values.length];
                        System.arraycopy(values, 0, newValues, 0, values.length);
                        for (int i = 0; i < miscValues.size(); ++i) {
                            newValues[values.length + i] = (String)miscValues.get(i);
                        }
                        values = newValues;
                    }
                }
                rw.write(values);
                SearchDAOImpl.incrementCount(uidStats, (Object)sd.getFieldValue(institutionUid));
                SearchDAOImpl.incrementCount(uidStats, (Object)sd.getFieldValue(collectionUid));
                SearchDAOImpl.incrementCount(uidStats, (Object)sd.getFieldValue(dataProviderUid));
                SearchDAOImpl.incrementCount(uidStats, (Object)sd.getFieldValue(dataResourceUid));
            }
            ++record;
        }
        dd.updateCounts(count);
        return count;
    }

    private String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            return DateFormatUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
        }
        return value.toString();
    }

    private void expandRequestedFields(DownloadRequestParams downloadParams, boolean isSolr) {
        String fields = this.getDownloadFields(downloadParams);
        try {
            StringBuilder sb;
            Matcher matcher = this.clpField.matcher(fields);
            if (matcher.find()) {
                sb = new StringBuilder();
                for (IndexFieldDTO field : this.indexDao.getIndexedFields()) {
                    if (!field.getName().matches("cl[0-9]*")) continue;
                    if (sb.length() > 0 || matcher.start() > 0) {
                        sb.append(",");
                    }
                    sb.append(field.getName());
                }
                if (sb.length() > 0 && matcher.end() < fields.length()) {
                    sb.append(",");
                }
                fields = matcher.replaceFirst(sb.toString());
            }
            if ((matcher = this.elpField.matcher(fields)).find()) {
                sb = new StringBuilder();
                for (IndexFieldDTO field : this.indexDao.getIndexedFields()) {
                    if (!field.getName().matches("el[0-9]*")) continue;
                    if (sb.length() > 0 || matcher.start() > 0) {
                        sb.append(",");
                    }
                    sb.append(field.getName());
                }
                if (sb.length() > 0 && matcher.end() < fields.length()) {
                    sb.append(",");
                }
                fields = matcher.replaceFirst(sb.toString());
            }
            if ((matcher = this.allDwcField.matcher(fields)).find()) {
                sb = new StringBuilder();
                for (IndexFieldDTO field : this.indexDao.getIndexedFields()) {
                    if (!StringUtils.isNotEmpty((String)field.getDwcTerm()) || isSolr && !field.isStored()) continue;
                    if (sb.length() > 0 || matcher.start() > 0) {
                        sb.append(",");
                    }
                    if (isSolr) {
                        sb.append(field.getName());
                        continue;
                    }
                    sb.append(field.getDownloadName());
                }
                if (sb.length() > 0 && matcher.end() < fields.length()) {
                    sb.append(",");
                }
                fields = matcher.replaceFirst(sb.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to substitute fields", (Throwable)e);
        }
        downloadParams.setFields(fields);
    }

    private String getQAFromFacet(FacetField facet) {
        StringBuilder qasb = new StringBuilder();
        for (FacetField.Count facetEntry : facet.getValues()) {
            if (facetEntry.getCount() <= 0L) continue;
            if (qasb.length() > 0) {
                qasb.append(",");
            }
            if (facetEntry.getName() == null) continue;
            qasb.append(facetEntry.getName());
        }
        return qasb.toString();
    }

    private String getDownloadFields(DownloadRequestParams downloadParams) {
        String dFields = downloadParams.getFields();
        if (StringUtils.isEmpty((String)dFields)) {
            dFields = this.defaultDownloadFields;
        }
        return dFields;
    }

    private List<SolrQuery> splitQueries(List<SolrQuery> queries, String fq, String[] fqFields, String[] notFqFields) {
        ArrayList<SolrQuery> notFQ = new ArrayList<SolrQuery>();
        ArrayList<SolrQuery> fQ = new ArrayList<SolrQuery>();
        for (SolrQuery query : queries) {
            SolrQuery nsq = query.getCopy().addFilterQuery(new String[]{"-(" + fq + ")"});
            if (notFqFields != null) {
                Arrays.stream(notFqFields).forEach(arg_0 -> ((SolrQuery)nsq).addField(arg_0));
            }
            notFQ.add(nsq);
            SolrQuery sq = query.getCopy().addFilterQuery(new String[]{fq});
            if (fqFields != null) {
                Arrays.stream(fqFields).forEach(arg_0 -> ((SolrQuery)sq).addField(arg_0));
            }
            fQ.add(sq);
        }
        queries.clear();
        queries.addAll(notFQ);
        queries.addAll(fQ);
        return fQ;
    }

    private static void incrementCount(ConcurrentMap<String, AtomicInteger> values, Object uid) {
        if (uid != null) {
            String nextKey = uid.toString();
            if (values.containsKey(nextKey)) {
                ((AtomicInteger)values.get(nextKey)).incrementAndGet();
            } else {
                AtomicInteger putIfAbsent = values.putIfAbsent(nextKey, new AtomicInteger(1));
                if (putIfAbsent != null) {
                    putIfAbsent.incrementAndGet();
                }
            }
        }
    }

    public List<OccurrencePoint> getFacetPoints(SpatialSearchRequestParams searchParams, PointType pointType) throws Exception {
        return this.getPoints(searchParams, pointType, -1);
    }

    private List<OccurrencePoint> getPoints(SpatialSearchRequestParams searchParams, PointType pointType, int max) throws Exception {
        ArrayList<OccurrencePoint> points = new ArrayList<OccurrencePoint>();
        this.queryFormatUtils.formatSearchQuery(searchParams);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("search query: " + searchParams.getFormattedQuery()));
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        solrQuery.setQuery(searchParams.getFormattedQuery());
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{pointType.getLabel()});
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(max);
        QueryResponse qr = this.runSolrQuery(solrQuery, searchParams.getFormattedFq(), Integer.valueOf(1), Integer.valueOf(0), "score", "asc");
        List facets = qr.getFacetFields();
        if (facets != null) {
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                if (!facet.getName().contains(pointType.getLabel()) || facetEntries == null || facetEntries.size() <= 0) continue;
                for (FacetField.Count fcount : facetEntries) {
                    if (!StringUtils.isNotEmpty((String)fcount.getName()) || fcount.getCount() <= 0L) continue;
                    OccurrencePoint point = new OccurrencePoint(pointType);
                    point.setCount(Long.valueOf(fcount.getCount()));
                    String[] pointsDelimited = StringUtils.split((String)fcount.getName(), (char)',');
                    ArrayList<Float> coords = new ArrayList<Float>();
                    for (String coord : pointsDelimited) {
                        try {
                            Float decimalCoord = Float.valueOf(Float.parseFloat(coord));
                            coords.add(decimalCoord);
                        }
                        catch (NumberFormatException numberFormatException) {
                            logger.warn((Object)("Error parsing Float for Lat/Long: " + numberFormatException.getMessage()), (Throwable)numberFormatException);
                        }
                    }
                    if (coords.isEmpty()) continue;
                    Collections.reverse(coords);
                    point.setCoordinates(coords);
                    points.add(point);
                }
            }
        }
        return points;
    }

    public FacetField getFacetPointsShort(SpatialSearchRequestParams searchParams, String pointType) throws Exception {
        this.queryFormatUtils.formatSearchQuery(searchParams);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("FacetPointsShort : " + searchParams.getFormattedQuery()));
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        solrQuery.setQuery(searchParams.getFormattedQuery());
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{pointType});
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(searchParams.getFlimit().intValue());
        QueryResponse qr = this.runSolrQuery(solrQuery, searchParams.getFormattedFq(), Integer.valueOf(0), Integer.valueOf(0), "", "");
        List facets = qr.getFacetFields();
        if (facets != null && facets.size() > 0) {
            return (FacetField)facets.get(0);
        }
        return null;
    }

    public List<OccurrencePoint> getOccurrences(SpatialSearchRequestParams searchParams, PointType pointType, String colourBy) throws Exception {
        ArrayList<OccurrencePoint> points = new ArrayList<OccurrencePoint>();
        searchParams.setPageSize(Integer.valueOf(100));
        String queryString = "";
        this.queryFormatUtils.formatSearchQuery(searchParams);
        queryString = searchParams.getFormattedQuery();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getOccurrences - search query: " + queryString));
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        solrQuery.setQuery(queryString);
        QueryResponse qr = this.indexDao.runSolrQuery(solrQuery, (SearchRequestParams)searchParams);
        SearchResultDTO searchResults = this.processSolrResponse((SearchRequestParams)searchParams, qr, solrQuery, OccurrenceIndex.class);
        List ocs = searchResults.getOccurrences();
        if (!ocs.isEmpty() && ocs.size() > 0) {
            for (OccurrenceIndex oc : ocs) {
                ArrayList<Float> coords = new ArrayList<Float>();
                coords.add(Float.valueOf(oc.getDecimalLongitude().floatValue()));
                coords.add(Float.valueOf(oc.getDecimalLatitude().floatValue()));
                OccurrencePoint point = new OccurrencePoint();
                point.setCoordinates(coords);
                point.setOccurrenceUid(oc.getUuid());
                points.add(point);
            }
        }
        return points;
    }

    @Deprecated
    public List<DataProviderCountDTO> getDataProviderCounts() throws Exception {
        ArrayList<DataProviderCountDTO> dpDTOs = new ArrayList<DataProviderCountDTO>();
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        solrQuery.setQuery("*:*");
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{"dataProviderUid"});
        solrQuery.addFacetField(new String[]{"dataProviderName"});
        solrQuery.setFacetMinCount(1);
        QueryResponse qr = this.runSolrQuery(solrQuery, null, Integer.valueOf(1), Integer.valueOf(0), "dataProviderName", "asc");
        List facets = qr.getFacetFields();
        if (facets != null && facets.size() == 2) {
            FacetField dataProviderIdFacet = (FacetField)facets.get(0);
            FacetField dataProviderNameFacet = (FacetField)facets.get(1);
            List dpIdEntries = dataProviderIdFacet.getValues();
            List dpNameEntries = dataProviderNameFacet.getValues();
            if (dpIdEntries != null) {
                for (int i = 0; i < dpIdEntries.size(); ++i) {
                    FacetField.Count dpIdEntry = (FacetField.Count)dpIdEntries.get(i);
                    FacetField.Count dpNameEntry = (FacetField.Count)dpNameEntries.get(i);
                    String dataProviderId = dpIdEntry.getName();
                    String dataProviderName = dpNameEntry.getName();
                    long count = dpIdEntry.getCount();
                    if (count <= 0L) continue;
                    DataProviderCountDTO dto = new DataProviderCountDTO(dataProviderId, dataProviderName, count);
                    dpDTOs.add(dto);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Find data providers = " + dpDTOs.size()));
        }
        return dpDTOs;
    }

    public List<OccurrencePoint> findRecordsForLocation(SpatialSearchRequestParams requestParams, PointType pointType) throws Exception {
        return this.getPoints(requestParams, pointType, this.MAX_DOWNLOAD_SIZE.intValue());
    }

    public List<TaxaCountDTO> findAllSpeciesByCircleAreaAndHigherTaxa(SpatialSearchRequestParams requestParams, String speciesGroup) throws Exception {
        this.queryFormatUtils.formatSearchQuery(requestParams);
        String queryString = requestParams.getFormattedQuery();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The species count query " + queryString));
        }
        ArrayList fqList = new ArrayList();
        if (requestParams.getFormattedFq().length > 0) {
            org.apache.commons.collections.CollectionUtils.addAll(fqList, (Object[])requestParams.getFormattedFq());
        }
        List speciesWithCounts = this.getSpeciesCounts(queryString, fqList, CollectionUtils.arrayToList((Object)requestParams.getFacets()), requestParams.getPageSize(), requestParams.getStart(), requestParams.getSort(), requestParams.getDir());
        return speciesWithCounts;
    }

    @Deprecated
    public List<FieldResultDTO> findRecordByStateFor(String query) throws Exception {
        String dataProviderName = "dataProviderName";
        ArrayList<FieldResultDTO> fDTOs = new ArrayList<FieldResultDTO>();
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        solrQuery.setQuery(query);
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{"stateProvince"});
        solrQuery.setFacetMinCount(1);
        QueryResponse qr = this.runSolrQuery(solrQuery, null, Integer.valueOf(1), Integer.valueOf(0), dataProviderName, "asc");
        FacetField ff = qr.getFacetField("stateProvince");
        if (ff != null) {
            for (FacetField.Count count : ff.getValues()) {
                if (count.getCount() <= 0L) continue;
                FieldResultDTO f = new FieldResultDTO(count.getName(), "stateProvince." + count.getName(), count.getCount());
                fDTOs.add(f);
            }
        }
        return fDTOs;
    }

    public TaxaRankCountDTO calculateBreakdown(BreakdownRequestParams queryParams) throws Exception {
        TaxaRankCountDTO trDTO;
        block10: {
            List ffs;
            QueryResponse qr;
            block11: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Attempting to find the counts for " + queryParams));
                }
                trDTO = null;
                SolrQuery solrQuery = new SolrQuery();
                solrQuery.setRequestHandler("standard");
                this.queryFormatUtils.formatSearchQuery((SpatialSearchRequestParams)queryParams);
                solrQuery.setQuery(queryParams.getFormattedQuery());
                queryParams.setPageSize(Integer.valueOf(0));
                solrQuery.setFacet(true);
                solrQuery.setFacetMinCount(1);
                solrQuery.setFacetSort("count");
                solrQuery.setFacetLimit(-1);
                if (StringUtils.isNotEmpty((String)queryParams.getName()) && StringUtils.isNotEmpty((String)queryParams.getRank())) {
                    queryParams.setFormattedFq((String[])ArrayUtils.addAll((Object[])queryParams.getFormattedFq(), (Object[])new String[]{queryParams.getRank() + ":" + queryParams.getName()}));
                }
                if (queryParams.getLevel() == null) {
                    List ranks = queryParams.getRank() != null ? this.searchUtils.getNextRanks(queryParams.getRank(), queryParams.getName() == null) : this.searchUtils.getRanks();
                    for (String r : ranks) {
                        solrQuery.addFacetField(new String[]{r});
                    }
                } else {
                    solrQuery.addFacetField(new String[]{queryParams.getLevel()});
                }
                qr = this.indexDao.runSolrQuery(solrQuery, (SearchRequestParams)queryParams);
                if (queryParams.getMax() == null || queryParams.getMax() <= 0) break block11;
                if (qr.getResults().getNumFound() <= 0L) break block10;
                ffs = qr.getFacetFields();
                Collections.reverse(ffs);
                for (FacetField ff : ffs) {
                    trDTO = new TaxaRankCountDTO(ff.getName());
                    if (ff.getValues() == null || ff.getValues().size() > queryParams.getMax()) continue;
                    ArrayList<FieldResultDTO> fDTOs = new ArrayList<FieldResultDTO>();
                    for (FacetField.Count count : ff.getValues()) {
                        if (count.getCount() <= 0L) continue;
                        FieldResultDTO f = new FieldResultDTO(count.getName(), count.getFacetField().getName() + "." + count.getName(), count.getCount());
                        fDTOs.add(f);
                    }
                    trDTO.setTaxa(fDTOs);
                    break block10;
                }
                break block10;
            }
            if ((queryParams.getRank() != null || queryParams.getLevel() != null) && qr.getResults().getNumFound() > 0L) {
                ffs = qr.getFacetFields();
                for (FacetField ff : ffs) {
                    List counts;
                    trDTO = new TaxaRankCountDTO(ff.getName());
                    if (ff == null || ff.getValues() == null || (counts = ff.getValues()).size() <= 0) continue;
                    ArrayList<FieldResultDTO> fDTOs = new ArrayList<FieldResultDTO>();
                    for (FacetField.Count count : counts) {
                        if (count.getCount() <= 0L) continue;
                        FieldResultDTO f = new FieldResultDTO(count.getName(), count.getFacetField().getName() + "." + count.getName(), count.getCount());
                        fDTOs.add(f);
                    }
                    trDTO.setTaxa(fDTOs);
                    break;
                }
            }
        }
        return trDTO;
    }

    @Deprecated
    public TaxaRankCountDTO findTaxonCountForUid(BreakdownRequestParams breakdownParams, String query) throws Exception {
        ArrayList<String> ranks;
        TaxaRankCountDTO trDTO = null;
        List<String> list = breakdownParams.getLevel() == null ? this.searchUtils.getNextRanks(breakdownParams.getRank(), breakdownParams.getName() == null) : (ranks = new ArrayList<String>());
        if (breakdownParams.getLevel() != null) {
            ranks.add(breakdownParams.getLevel());
        }
        if (ranks != null && ranks.size() > 0) {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setRequestHandler("standard");
            solrQuery.setQuery(query);
            solrQuery.setRows(Integer.valueOf(0));
            solrQuery.setFacet(true);
            solrQuery.setFacetMinCount(1);
            solrQuery.setFacetSort("count");
            solrQuery.setFacetLimit(-1);
            for (String r : ranks) {
                solrQuery.addFacetField(new String[]{r});
            }
            QueryResponse qr = this.runSolrQuery(solrQuery, this.queryFormatUtils.getQueryContextAsArray(breakdownParams.getQc()), Integer.valueOf(1), Integer.valueOf(0), breakdownParams.getRank(), "asc");
            if (qr.getResults().size() > 0) {
                for (String r : ranks) {
                    List counts;
                    trDTO = new TaxaRankCountDTO(r);
                    FacetField ff = qr.getFacetField(r);
                    if (ff == null || ff.getValues() == null || (counts = ff.getValues()).size() <= 0) continue;
                    ArrayList<FieldResultDTO> fDTOs = new ArrayList<FieldResultDTO>();
                    for (FacetField.Count count : counts) {
                        FieldResultDTO f = new FieldResultDTO(count.getName(), count.getFacetField().getName() + "." + count.getName(), count.getCount());
                        fDTOs.add(f);
                    }
                    trDTO.setTaxa(fDTOs);
                    break;
                }
            }
        }
        return trDTO;
    }

    private QueryResponse runSolrQuery(SolrQuery solrQuery, String[] filterQuery, Integer pageSize, Integer startIndex, String sortField, String sortDirection) throws Exception {
        SearchRequestParams requestParams = new SearchRequestParams();
        requestParams.setFq(filterQuery);
        requestParams.setFormattedFq(filterQuery);
        requestParams.setPageSize(pageSize);
        requestParams.setStart(startIndex);
        requestParams.setSort(sortField);
        requestParams.setDir(sortDirection);
        return this.indexDao.runSolrQuery(solrQuery, requestParams);
    }

    private QueryResponse runSolrQueryWithCursorMark(SolrQuery solrQuery, int pageSize, String cursorMark) throws Exception {
        solrQuery.setFacetMissing(Boolean.valueOf(true));
        solrQuery.setRows(Integer.valueOf(pageSize));
        if (cursorMark == null) {
            cursorMark = "*";
        }
        solrQuery.set("cursorMark", new String[]{cursorMark});
        solrQuery.setSort("id", SolrQuery.ORDER.desc);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SOLR query (cursor mark): " + solrQuery.toString()));
        }
        QueryResponse qr = this.query((SolrParams)solrQuery);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SOLR query (cursor mark): " + solrQuery.toString() + " qtime:" + qr.getQTime()));
            if (qr.getResults() == null) {
                logger.debug((Object)"no results");
            } else {
                logger.debug((Object)("matched records: " + qr.getResults().getNumFound()));
            }
        }
        return qr;
    }

    private SearchResultDTO processSolrResponse(SearchRequestParams params, QueryResponse qr, SolrQuery solrQuery, Class resultClass) {
        SearchResultDTO searchResult = new SearchResultDTO();
        SolrDocumentList sdl = qr.getResults();
        List facets = qr.getFacetFields();
        List facetDates = qr.getFacetDates();
        Map facetQueries = qr.getFacetQuery();
        if (facetDates != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Facet dates size: " + facetDates.size()));
            }
            facets.addAll(facetDates);
        }
        List results = qr.getBeans(resultClass);
        searchResult.setTotalRecords(sdl.getNumFound());
        searchResult.setStartIndex(sdl.getStart());
        searchResult.setPageSize((long)solrQuery.getRows().intValue());
        searchResult.setStatus("OK");
        Object[] solrSort = StringUtils.split((String)solrQuery.getSortField(), (String)" ");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sortField post-split: " + StringUtils.join((Object[])solrSort, (String)"|")));
        }
        if (solrSort != null && solrSort.length == 2) {
            searchResult.setSort((String)solrSort[0]);
            searchResult.setDir((String)solrSort[1]);
        }
        searchResult.setQuery(params.getUrlParams());
        searchResult.setOccurrences(results);
        List facetResults = this.buildFacetResults(facets);
        if (facetQueries != null && !facetQueries.isEmpty()) {
            Map rangeMap = this.rangeBasedFacets.getRangeMap("coordinateUncertaintyInMeters");
            ArrayList<FieldResultDTO> fqr = new ArrayList<FieldResultDTO>();
            for (String value : facetQueries.keySet()) {
                if ((Integer)facetQueries.get(value) <= 0) continue;
                fqr.add(new FieldResultDTO((String)rangeMap.get(value), (String)rangeMap.get(value), (long)((Integer)facetQueries.get(value)).intValue(), value));
            }
            facetResults.add(new FacetResultDTO("coordinateUncertaintyInMeters", fqr));
        }
        if (qr.getFacetRanges() != null) {
            for (RangeFacet rfacet : qr.getFacetRanges()) {
                ArrayList<FieldResultDTO> fqr = new ArrayList<FieldResultDTO>();
                if (rfacet instanceof RangeFacet.Numeric) {
                    RangeFacet.Numeric nrfacet = (RangeFacet.Numeric)rfacet;
                    List counts = nrfacet.getCounts();
                    if (nrfacet.getBefore().intValue() > 0) {
                        String name = "[* TO " + this.getUpperRange(((Number)nrfacet.getStart()).toString(), (Number)nrfacet.getGap(), false) + "]";
                        fqr.add(new FieldResultDTO(name, name, (long)nrfacet.getBefore().intValue()));
                    }
                    for (RangeFacet.Count count : counts) {
                        String title = this.getRangeValue(count.getValue(), (Number)nrfacet.getGap());
                        fqr.add(new FieldResultDTO(title, title, (long)count.getCount()));
                    }
                    if (nrfacet.getAfter().intValue() > 0) {
                        fqr.add(new FieldResultDTO("[" + ((Number)nrfacet.getEnd()).toString() + " TO *]", "[" + ((Number)nrfacet.getEnd()).toString() + " TO *]", (long)nrfacet.getAfter().intValue()));
                    }
                    facetResults.add(new FacetResultDTO(nrfacet.getName(), fqr));
                    continue;
                }
                List facetEntries = rfacet.getCounts();
                String facetName = rfacet.getName();
                this.addFacetResultsFromSolrFacets(facetResults, facetEntries, facetName);
            }
        }
        for (OccurrenceIndex oi : results) {
            this.updateImageUrls(oi);
        }
        searchResult.setFacetResults(facetResults);
        searchResult.setQr(qr);
        return searchResult;
    }

    private List<FacetResultDTO> buildFacetResults(List<FacetField> facets) {
        ArrayList<FacetResultDTO> facetResults = new ArrayList<FacetResultDTO>();
        if (facets != null) {
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                String facetName = facet.getName();
                this.addFacetResultsFromSolrFacets(facetResults, facetEntries, facetName);
            }
        }
        return facetResults;
    }

    private void addFacetResultsFromSolrFacets(List<FacetResultDTO> facetResults, List<?> facetEntries, String facetName) {
        if (facetEntries != null && facetEntries.size() > 0) {
            ArrayList<FieldResultDTO> r = new ArrayList<FieldResultDTO>();
            for (Object facetCountEntryObject : facetEntries) {
                String countEntryName;
                long entryCount;
                if (facetCountEntryObject instanceof FacetField.Count) {
                    FacetField.Count facetCountEntry = (FacetField.Count)facetCountEntryObject;
                    entryCount = facetCountEntry.getCount();
                    countEntryName = facetCountEntry.getName();
                } else if (facetCountEntryObject instanceof RangeFacet.Count) {
                    RangeFacet.Count raengeFacetCountEntry = (RangeFacet.Count)facetCountEntryObject;
                    entryCount = raengeFacetCountEntry.getCount();
                    countEntryName = raengeFacetCountEntry.getValue();
                } else {
                    throw new IllegalArgumentException("facetCountEntry is not an instance of FacetField.Count nor RangeFacet.Count: " + facetCountEntryObject.getClass());
                }
                if (entryCount == 0L) continue;
                if (countEntryName == null) {
                    String label = "";
                    if (this.messageSource != null) {
                        label = this.messageSource.getMessage(this.fieldMappingUtil.translateFieldName(facetName) + ".novalue", null, "Not supplied", null);
                    }
                    r.add(new FieldResultDTO(label, facetName + ".novalue", entryCount, "-" + facetName + ":*"));
                    continue;
                }
                if (countEntryName.equals("before")) {
                    r.add(0, new FieldResultDTO(this.getFacetValueDisplayName(this.fieldMappingUtil.translateFieldName(facetName), countEntryName), facetName + "." + countEntryName, entryCount, this.getFormattedFqQuery(facetName, countEntryName)));
                    continue;
                }
                r.add(new FieldResultDTO(this.getFacetValueDisplayName(this.fieldMappingUtil.translateFieldName(facetName), countEntryName), facetName + "." + countEntryName, entryCount, this.getFormattedFqQuery(facetName, countEntryName)));
            }
            if (r.size() > 0) {
                FacetResultDTO fr = new FacetResultDTO(facetName, r);
                facetResults.add(fr);
            }
        }
    }

    private void updateImageUrls(OccurrenceIndex oi) {
        if (!StringUtils.isNotBlank((String)oi.getImage())) {
            return;
        }
        try {
            Map formats = this.occurrenceUtils.getImageFormats(oi.getImage());
            oi.setImageUrl((String)formats.get("raw"));
            oi.setThumbnailUrl((String)formats.get("thumb"));
            oi.setSmallImageUrl((String)formats.get("small"));
            oi.setLargeImageUrl((String)formats.get("large"));
            String[] images = oi.getImages();
            if (images != null && images.length > 0) {
                String[] imageUrls = new String[images.length];
                for (int i = 0; i < images.length; ++i) {
                    try {
                        Map availableFormats = this.occurrenceUtils.getImageFormats(images[i]);
                        imageUrls[i] = (String)availableFormats.get("large");
                        continue;
                    }
                    catch (Exception ex) {
                        logger.warn((Object)("Unable to update image URL for " + images[i] + ": " + ex.getMessage()));
                    }
                }
                oi.setImageUrls(imageUrls);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("Unable to update image URL for " + oi.getImage() + ": " + ex.getMessage()));
        }
    }

    private String getRangeValue(String lower, Number gap) {
        StringBuilder value = new StringBuilder("[");
        value.append(lower).append(" TO ").append(this.getUpperRange(lower, gap, true));
        return value.append("]").toString();
    }

    private String getUpperRange(String lower, Number gap, boolean addGap) {
        if (gap instanceof Integer) {
            Integer upper = Integer.parseInt(lower) - 1;
            if (addGap) {
                upper = upper + (Integer)gap;
            }
            return upper.toString();
        }
        if (gap instanceof Double) {
            BigDecimal upper = new BigDecimal(lower).add(new BigDecimal(-0.001));
            if (addGap) {
                upper = upper.add(new BigDecimal(gap.doubleValue()));
            }
            return upper.setScale(3, RoundingMode.HALF_UP).toString();
        }
        return lower;
    }

    protected void initDecadeBasedFacet(SolrQuery solrQuery, String field) {
        solrQuery.add("facet.range", new String[]{field});
        solrQuery.add("facet.range.start", new String[]{"1850-01-01T00:00:00Z"});
        solrQuery.add("facet.range.end", new String[]{"NOW/DAY"});
        solrQuery.add("facet.range.gap", new String[]{"+10YEAR"});
        solrQuery.add("facet.range.other", new String[]{"before"});
        solrQuery.add("facet.range.include", new String[]{"lower"});
    }

    protected SolrQuery initSolrQuery(SearchRequestParams searchParams, boolean substituteDefaultFacetOrder, Map<String, String[]> extraSolrParams) {
        String occurrenceDate = "eventDate";
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        boolean rangeAdded = false;
        solrQuery.setFacet(searchParams.getFacet().booleanValue());
        if (searchParams.getFacet().booleanValue()) {
            for (String facet : searchParams.getFacets()) {
                if (facet.equals("decade") || facet.equals("date")) {
                    String fname = facet.equals("decade") ? "occurrenceYear" : occurrenceDate;
                    this.initDecadeBasedFacet(solrQuery, fname);
                    rangeAdded = true;
                    continue;
                }
                if (facet.equals("uncertainty")) {
                    Map rangeMap = this.rangeBasedFacets.getRangeMap("uncertainty");
                    for (String range : rangeMap.keySet()) {
                        solrQuery.add("facet.query", new String[]{range});
                    }
                    continue;
                }
                solrQuery.addFacetField(new String[]{facet});
                if (!"".equals(searchParams.getFsort()) || !substituteDefaultFacetOrder || !FacetThemes.getFacetsMap().containsKey(facet)) continue;
                String thisSort = ((FacetDTO)FacetThemes.getFacetsMap().get(facet)).getSort();
                if (searchParams.getFsort().equalsIgnoreCase(thisSort)) continue;
                solrQuery.add("f." + facet + ".facet.sort", new String[]{thisSort});
            }
            solrQuery.setFacetMinCount(1);
            solrQuery.setFacetLimit(searchParams.getFlimit().intValue());
            String fsort = "".equals(searchParams.getFsort()) ? "count" : searchParams.getFsort();
            solrQuery.setFacetSort(fsort);
            if (searchParams.getFoffset() > 0) {
                solrQuery.add("facet.offset", new String[]{Integer.toString(searchParams.getFoffset())});
            }
            if (StringUtils.isNotEmpty((String)searchParams.getFprefix())) {
                solrQuery.add("facet.prefix", new String[]{searchParams.getFprefix()});
            }
        }
        solrQuery.setRows(Integer.valueOf(10));
        solrQuery.setStart(Integer.valueOf(0));
        if (searchParams.getFl().length() > 0) {
            solrQuery.setFields(new String[]{searchParams.getFl()});
        }
        if (extraSolrParams != null) {
            if (!rangeAdded) {
                solrQuery.add("facet.range.other", new String[]{"before"});
                solrQuery.add("facet.range.other", new String[]{"after"});
            }
            for (String key : extraSolrParams.keySet()) {
                String[] values = extraSolrParams.get(key);
                solrQuery.add(key, values);
            }
        }
        return solrQuery;
    }

    protected List<TaxaCountDTO> getSpeciesCounts(String queryString, List<String> filterQueries, List<String> facetFields, Integer pageSize, Integer startIndex, String sortField, String sortDirection) throws Exception {
        ArrayList<TaxaCountDTO> speciesCounts = new ArrayList<TaxaCountDTO>();
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        solrQuery.setQuery(queryString);
        if (filterQueries != null && filterQueries.size() > 0) {
            for (String fq : filterQueries) {
                solrQuery.addFilterQuery(new String[]{fq});
            }
        }
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.setFacetSort(sortField);
        for (String facet : facetFields) {
            solrQuery.addFacetField(new String[]{facet});
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("adding facetField: " + facet));
        }
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(pageSize.intValue());
        solrQuery.add("facet.offset", new String[]{Integer.toString(startIndex)});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getSpeciesCount query :" + solrQuery.getQuery()));
        }
        QueryResponse qr = this.runSolrQuery(solrQuery, null, Integer.valueOf(1), Integer.valueOf(0), "score", sortDirection);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SOLR query: " + solrQuery.getQuery() + "; total hits: " + qr.getResults().getNumFound()));
        }
        List facets = qr.getFacetFields();
        Pattern p = Pattern.compile("\\|");
        if (facets != null && facets.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Facets: " + facets.size() + "; facet #1: " + ((FacetField)facets.get(0)).getName()));
            }
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                if (facetEntries == null || facetEntries.size() <= 0) continue;
                for (FacetField.Count fcount : facetEntries) {
                    String[] values;
                    String name;
                    TaxaCountDTO tcDTO = null;
                    String string = name = fcount.getName() != null ? fcount.getName() : "";
                    if (fcount.getFacetField().getName().equals("names_and_lsid")) {
                        values = p.split(name, 5);
                        if (values.length >= 5) {
                            if (!"||||".equals(name)) {
                                tcDTO = new TaxaCountDTO(values[0], Long.valueOf(fcount.getCount()));
                                tcDTO.setGuid(StringUtils.trimToNull((String)values[1]));
                                tcDTO.setCommonName("null".equals(values[2]) ? "" : values[2]);
                                tcDTO.setKingdom(values[3]);
                                tcDTO.setFamily(values[4]);
                                if (StringUtils.isNotEmpty((String)tcDTO.getGuid())) {
                                    tcDTO.setRank(this.searchUtils.getTaxonSearch(tcDTO.getGuid())[1].split(":")[0]);
                                }
                            }
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("The values length: " + values.length + " :" + name));
                            }
                            tcDTO = new TaxaCountDTO(name, Long.valueOf(fcount.getCount()));
                        }
                        if (tcDTO == null || tcDTO.getCount() <= 0L) continue;
                        speciesCounts.add(tcDTO);
                        continue;
                    }
                    if (!fcount.getFacetField().getName().equals("common_name_and_lsid")) continue;
                    values = p.split(name, 6);
                    if (values.length >= 5) {
                        if (!"|||||".equals(name)) {
                            tcDTO = new TaxaCountDTO(values[1], Long.valueOf(fcount.getCount()));
                            tcDTO.setGuid(StringUtils.trimToNull((String)values[2]));
                            tcDTO.setCommonName("null".equals(values[0]) ? "" : values[0]);
                            tcDTO.setKingdom(values[values.length - 2]);
                            tcDTO.setFamily(values[values.length - 1]);
                            if (StringUtils.isNotEmpty((String)tcDTO.getGuid())) {
                                tcDTO.setRank(this.searchUtils.getTaxonSearch(tcDTO.getGuid())[1].split(":")[0]);
                            }
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("The values length: " + values.length + " :" + name));
                        }
                        tcDTO = new TaxaCountDTO(name, Long.valueOf(fcount.getCount()));
                    }
                    if (tcDTO == null || tcDTO.getCount() <= 0L) continue;
                    speciesCounts.add(tcDTO);
                }
            }
        }
        return speciesCounts;
    }

    public Map<String, Integer> getSourcesForQuery(SpatialSearchRequestParams searchParams) throws Exception {
        HashMap<String, Integer> uidStats = new HashMap<String, Integer>();
        SolrQuery solrQuery = new SolrQuery();
        this.queryFormatUtils.formatSearchQuery(searchParams);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The query : " + searchParams.getFormattedQuery()));
        }
        solrQuery.setQuery(searchParams.getFormattedQuery());
        solrQuery.setRequestHandler("standard");
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.addField("institutionUid").addField("collectionUid").addField("dataResourceUid").addField("dataProviderUid");
        QueryResponse qr = this.runSolrQuery(solrQuery, searchParams.getFormattedFq(), Integer.valueOf(1), Integer.valueOf(0), "score", "asc");
        List facets = qr.getFacetFields();
        for (FacetField facet : facets) {
            if (facet.getValues() == null) continue;
            for (FacetField.Count ffc : facet.getValues()) {
                if (ffc.getCount() <= 0L) continue;
                uidStats.put(ffc.getName() != null ? ffc.getName() : "", new Integer((int)ffc.getCount()));
            }
        }
        return uidStats;
    }

    public List<FacetResultDTO> getFacetCounts(SpatialSearchRequestParams searchParams) throws Exception {
        this.queryFormatUtils.formatSearchQuery(searchParams, true);
        String queryString = searchParams.getFormattedQuery();
        searchParams.setFacet(Boolean.valueOf(true));
        searchParams.setPageSize(Integer.valueOf(0));
        SolrQuery facetQuery = this.initSolrQuery((SearchRequestParams)searchParams, false, null);
        facetQuery.setQuery(queryString);
        facetQuery.setFields(null);
        facetQuery.setRows(Integer.valueOf(0));
        facetQuery.setFacetLimit(-1);
        ArrayList fqList = new ArrayList();
        if (searchParams != null && searchParams.getFormattedFq() != null && searchParams.getFormattedFq().length > 0) {
            org.apache.commons.collections.CollectionUtils.addAll(fqList, (Object[])searchParams.getFormattedFq());
        }
        facetQuery.setFilterQueries((String[])fqList.stream().toArray(String[]::new));
        QueryResponse qr = this.query((SolrParams)facetQuery);
        SearchResultDTO searchResults = this.processSolrResponse((SearchRequestParams)searchParams, qr, facetQuery, OccurrenceIndex.class);
        List facetResults = searchResults.getFacetResults();
        if (facetResults != null) {
            for (FacetResultDTO fr : facetResults) {
                FacetResultDTO frDTO = new FacetResultDTO();
                frDTO.setCount(fr.getCount());
                frDTO.setFieldName(fr.getFieldName());
                if (fr.getCount() == null) {
                    fr.setCount(Integer.valueOf(fr.getFieldResult().size()));
                }
                if (searchParams.getFlimit() == null || searchParams.getFlimit() >= fr.getFieldResult().size() || searchParams.getFlimit() < 0) continue;
                fr.setFieldResult(fr.getFieldResult().subList(0, searchParams.getFlimit()));
            }
        }
        return facetResults;
    }

    public SolrDocumentList findByFulltext(SpatialSearchRequestParams searchParams) throws Exception {
        SolrDocumentList sdl = null;
        try {
            this.queryFormatUtils.formatSearchQuery(searchParams);
            String queryString = searchParams.getFormattedQuery();
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(queryString);
            solrQuery.setFields(searchParams.getFl().split(","));
            solrQuery.setFacet(false);
            solrQuery.setRows(searchParams.getPageSize());
            sdl = this.indexDao.runSolrQuery(solrQuery, (SearchRequestParams)searchParams).getResults();
        }
        catch (SolrServerException ex) {
            this.logError("Problem communicating with SOLR server. ", ex.getMessage());
        }
        return sdl;
    }

    private void logError(String description, String message) {
        String requestID = MDC.get((String)"X-Request-ID");
        if (requestID != null) {
            logger.error((Object)(description + ", RequestID:" + requestID + " Error : " + message));
        } else {
            logger.error((Object)(description + " : " + message));
        }
    }

    public List<LegendItem> getLegend(SpatialSearchRequestParams searchParams, String facetField, String[] cutpoints) throws Exception {
        return this.getLegend(searchParams, facetField, cutpoints, false);
    }

    @Cacheable(cacheName="legendCache")
    public List<LegendItem> getLegend(SpatialSearchRequestParams searchParams, String facetField, String[] cutpoints, boolean skipI18n) throws Exception {
        List facetDates;
        ArrayList<LegendItem> legend = new ArrayList<LegendItem>();
        this.queryFormatUtils.formatSearchQuery(searchParams);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("getLegend -search query: " + searchParams.getFormattedQuery()));
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        solrQuery.setQuery(searchParams.getFormattedQuery());
        solrQuery.addFilterQuery(searchParams.getFormattedFq());
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        if (cutpoints == null) {
            solrQuery.addFacetField(new String[]{facetField});
        } else {
            solrQuery.addFacetQuery("-" + facetField + ":*");
            for (int i = 0; i < cutpoints.length; i += 2) {
                solrQuery.addFacetQuery(facetField + ":[" + cutpoints[i] + " TO " + cutpoints[i + 1] + "]");
            }
        }
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(-1);
        FacetDTO facetDTO = (FacetDTO)FacetThemes.getFacetsMap().get(this.fieldMappingUtil.translateFieldName(facetField));
        if (facetDTO != null) {
            String thisSort = facetDTO.getSort();
            if (thisSort != null) {
                solrQuery.setFacetSort(thisSort);
            }
        } else {
            solrQuery.setFacetSort("count");
        }
        solrQuery.setFacetLimit(this.wmslegendMaxItems + 1);
        solrQuery.setFacetMissing(Boolean.valueOf(true));
        QueryResponse qr = this.runSolrQuery(solrQuery, searchParams.getFormattedFq(), Integer.valueOf(1), Integer.valueOf(0), "score", "asc");
        long remainderCount = qr.getResults().getNumFound();
        List facets = qr.getFacetFields();
        if (facets != null) {
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                if (!facet.getName().contains(facetField) || facetEntries == null || facetEntries.isEmpty()) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < facetEntries.size() && i < this.wmslegendMaxItems; ++i) {
                    FacetField.Count fcount = (FacetField.Count)facetEntries.get(i);
                    if (fcount.getCount() <= 0L) continue;
                    remainderCount -= fcount.getCount();
                    String fq = facetField + ":\"" + fcount.getName() + "\"";
                    if (fcount.getName() == null) {
                        fq = "-" + facetField + ":*";
                        arrayList.add(facetField + ":*");
                    } else {
                        arrayList.add("-" + fq);
                    }
                    if (skipI18n) {
                        legend.add(new LegendItem(fcount.getName(), null, fcount.getName(), fcount.getCount(), fq));
                        continue;
                    }
                    String i18nCode = null;
                    i18nCode = StringUtils.isNotBlank((String)fcount.getName()) ? this.fieldMappingUtil.translateFieldName(facetField) + "." + fcount.getName() : this.fieldMappingUtil.translateFieldName(facetField) + ".novalue";
                    legend.add(new LegendItem(this.getFacetValueDisplayName(this.fieldMappingUtil.translateFieldName(facetField), fcount.getName()), i18nCode, fcount.getName(), fcount.getCount(), fq));
                }
                if (facetEntries.size() <= this.wmslegendMaxItems) break;
                String theFq = "-(" + StringUtils.join(arrayList, (String)" AND ") + ")";
                legend.add(legend.size(), new LegendItem("Other " + facetField, facetField + ".other", "", remainderCount, theFq, true));
                break;
            }
        }
        String tFacetField = this.fieldMappingUtil.translateFieldName(facetField);
        Map facetq = qr.getFacetQuery();
        if (facetq != null && facetq.size() > 0) {
            for (Map.Entry entry : facetq.entrySet()) {
                legend.add(new LegendItem(this.getFacetValueDisplayName(tFacetField, (String)entry.getKey()), tFacetField + "." + (String)entry.getKey(), (String)entry.getKey(), (long)((Integer)entry.getValue()).intValue(), (String)entry.getKey()));
            }
        }
        if ((facetDates = qr.getFacetDates()) != null && !facetDates.isEmpty()) {
            FacetField facetField2 = (FacetField)facetDates.get(0);
            String firstDate = null;
            for (FacetField.Count facetEntry : facetField2.getValues()) {
                String finishDate;
                String startDate = facetEntry.getName();
                if (firstDate == null) {
                    firstDate = startDate;
                }
                if ("before".equals(startDate)) {
                    startDate = "*";
                    finishDate = firstDate;
                } else {
                    int startYear = Integer.parseInt(startDate.substring(0, 4));
                    finishDate = startYear - 1 + "-12-31T23:59:59Z";
                }
                legend.add(new LegendItem(this.getFacetValueDisplayName(facetEntry.getFacetField().getName(), facetEntry.getName()), facetEntry.getFacetField().getName() + "." + facetEntry.getName(), facetEntry.getFacetField().getName(), facetEntry.getCount(), "occurrenceYear:[" + startDate + " TO " + finishDate + "]"));
            }
        }
        return legend;
    }

    public FacetField getFacet(SpatialSearchRequestParams searchParams, String facet) throws Exception {
        this.queryFormatUtils.formatSearchQuery(searchParams);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getFacet - search query: " + searchParams.getFormattedQuery()));
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        solrQuery.setQuery(searchParams.getFormattedQuery());
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{facet});
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(-1);
        QueryResponse qr = this.runSolrQuery(solrQuery, searchParams.getFormattedFq(), Integer.valueOf(1), Integer.valueOf(0), null, null);
        return (FacetField)qr.getFacetFields().get(0);
    }

    public List<DataProviderCountDTO> getDataProviderList(SpatialSearchRequestParams requestParams) throws Exception {
        List facetEntries;
        ArrayList<DataProviderCountDTO> dataProviderList = new ArrayList<DataProviderCountDTO>();
        String dataProviderUid = "dataProviderUid";
        FacetField facet = this.getFacet(requestParams, dataProviderUid);
        String[] oldFq = requestParams.getFacets();
        if (facet != null && (facetEntries = facet.getValues()) != null && facetEntries.size() > 0) {
            for (int i = 0; i < facetEntries.size(); ++i) {
                FacetField.Count fcount = (FacetField.Count)facetEntries.get(i);
                String dataProviderName = this.collectionCache.getNameForCode(fcount.getName());
                if (!StringUtils.isNotEmpty((String)dataProviderName)) continue;
                dataProviderList.add(new DataProviderCountDTO(fcount.getName(), dataProviderName, fcount.getCount()));
            }
        }
        requestParams.setFacets(oldFq);
        return dataProviderList;
    }

    public List<TaxaCountDTO> findAllSpecies(SpatialSearchRequestParams requestParams) throws Exception {
        this.queryFormatUtils.formatSearchQuery(requestParams);
        ArrayList<String> facetFields = new ArrayList<String>();
        facetFields.add("names_and_lsid");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The species count query " + requestParams.getFormattedQuery()));
        }
        ArrayList fqList = new ArrayList();
        if (requestParams.getFormattedFq() != null && requestParams.getFormattedFq().length > 0) {
            org.apache.commons.collections.CollectionUtils.addAll(fqList, (Object[])requestParams.getFormattedFq());
        }
        String query = requestParams.getFormattedQuery();
        List speciesWithCounts = this.getSpeciesCounts(query, fqList, facetFields, requestParams.getPageSize(), requestParams.getStart(), requestParams.getSort(), requestParams.getDir());
        return speciesWithCounts;
    }

    public Map<String, Integer> getOccurrenceCountsForTaxa(List<String> taxa, String[] filterQueries) throws Exception {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.setFacetLimit(taxa.size());
        if (filterQueries != null && filterQueries.length > 0) {
            solrQuery.setFilterQueries(filterQueries);
        }
        StringBuilder sb = new StringBuilder();
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        HashMap<String, String> lftToGuid = new HashMap<String, String>();
        for (String lsid : taxa) {
            String[] values = this.searchUtils.getTaxonSearch(lsid);
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(values[0]);
            lftToGuid.put(values[0], lsid);
            solrQuery.add("facet.query", new String[]{values[0]});
        }
        solrQuery.setQuery(sb.toString());
        QueryResponse qr = this.runSolrQuery(solrQuery, null, Integer.valueOf(1), Integer.valueOf(0), "score", "asc");
        Map facetQueries = qr.getFacetQuery();
        for (String facet : facetQueries.keySet()) {
            String lsid = (String)lftToGuid.get(facet);
            Integer count = (Integer)facetQueries.get(facet);
            if (lsid == null || count == null) continue;
            counts.put(lsid, count);
        }
        logger.debug((Object)facetQueries);
        return counts;
    }

    public Integer getMaxEndemicQueryThreads() {
        return this.maxEndemicQueryThreads;
    }

    public void setMaxEndemicQueryThreads(Integer maxEndemicQueryThreads) {
        this.maxEndemicQueryThreads = Objects.requireNonNull(maxEndemicQueryThreads, "Max endemic multipart threads cannot be null");
    }

    public Integer getMaxSolrOnlineDownloadThreads() {
        return this.maxSolrDownloadThreads;
    }

    public void setMaxSolrDownloadThreads(Integer maxSolrDownloadThreads) {
        this.maxSolrDownloadThreads = Objects.requireNonNull(maxSolrDownloadThreads, "Max solr download threads cannot be null");
    }

    public Integer getThrottle() {
        return this.throttle;
    }

    public void setThrottle(Integer throttle) {
        this.throttle = Objects.requireNonNull(throttle, "Throttle cannot be null");
    }

    private QueryResponse query(SolrParams query) throws Exception {
        return this.indexDao.query(query);
    }

    public int getMaxBooleanClauses() {
        if (this.maxBooleanClauses == 0) {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setFacet(false);
            solrQuery.setRows(Integer.valueOf(0));
            int value = 1024;
            boolean ok = false;
            int step = -1;
            while (step != 0 || !ok) {
                String q = 1 + StringUtils.repeat((String)" AND 1", (int)(value - 1));
                solrQuery.setQuery(q);
                try {
                    this.query((SolrParams)solrQuery);
                    if (step == -1) {
                        value *= 2;
                    } else {
                        step /= 2;
                    }
                    ok = true;
                }
                catch (Exception e) {
                    if (step == -1) {
                        step = value / 2;
                    } else if (!ok && step > 1) {
                        step /= 2;
                    }
                    ok = false;
                }
                if (step == -1) continue;
                if (ok) {
                    value += step;
                    continue;
                }
                value -= step;
            }
            this.maxBooleanClauses = value;
        }
        this.queryFormatUtils.setMaxBooleanClauses(this.maxBooleanClauses);
        return this.maxBooleanClauses;
    }

    public QueryResponse searchGroupedFacets(SpatialSearchRequestParams searchParams) throws Exception {
        this.queryFormatUtils.formatSearchQuery(searchParams);
        String queryString = searchParams.getFormattedQuery();
        SolrQuery solrQuery = this.initSolrQuery((SearchRequestParams)searchParams, false, null);
        solrQuery.setQuery(queryString);
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(false);
        StringBuilder sb = new StringBuilder("{");
        int facets = 0;
        for (String facet : searchParams.getFacets()) {
            if (!StringUtils.isNotEmpty((String)searchParams.getFl())) continue;
            if (facets > 0) {
                sb.append(",");
            }
            ++facets;
            sb.append(facet).append(":{type:terms,limit:-1,sort:index,field:").append(facet).append(",facet:{");
            int fls = 0;
            for (String fl : searchParams.getFl().split(",")) {
                if (fls > 0) {
                    sb.append(",");
                }
                ++fls;
                sb.append(fl).append(":{type:terms,limit:1,sort:index,field:").append(fl).append("}");
            }
            sb.append("}}}");
        }
        solrQuery.add("json.facet", new String[]{sb.toString()});
        return this.query((SolrParams)solrQuery);
    }

    String getFormattedFqQuery(String facet, String value) {
        if (facet.equals("occurrenceYear")) {
            if (value.equals("before")) {
                return facet + ":[* TO " + "1850-01-01T00:00:00Z" + "]";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");
            try {
                Date date = sdf.parse(value);
                Date endDate = DateUtils.addYears((Date)date, (int)10);
                endDate = DateUtils.addMilliseconds((Date)endDate, (int)-1);
                return facet + ":[" + value + " TO " + sdf.format(endDate) + "]";
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return facet + ":\"" + value.replace("\"", "\\\"") + "\"";
    }

    String getFacetValueDisplayName(String facet, String value) {
        String tFacet = this.fieldMappingUtil.translateFieldName(facet);
        String tValue = this.fieldMappingUtil.translateFieldValue(tFacet, value);
        if (facet.endsWith("_uid") || facet.endsWith("Uid")) {
            return this.searchUtils.getUidDisplayString(tFacet, tValue, false);
        }
        if ("occurrenceYear".equals(facet) && value != null) {
            try {
                if ("before".equals(value)) {
                    return this.messageSource.getMessage("decade.pre.start", null, "pre 1850", null);
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");
                Date date = sdf.parse(value);
                SimpleDateFormat df = new SimpleDateFormat("yyyy");
                String year = df.format(date);
                return year + "-" + (Integer.parseInt(year) + 9);
            }
            catch (ParseException pe) {
                return facet;
            }
        }
        if (this.searchUtils.getAuthIndexFields().contains(facet)) {
            return this.authService.getDisplayNameFor(value);
        }
        if (this.messageSource != null) {
            if (StringUtils.isNotBlank((String)value)) {
                return this.messageSource.getMessage(tFacet + "." + tValue, null, value, (Locale)null);
            }
            return this.messageSource.getMessage(this.fieldMappingUtil.translateFieldName(facet) + ".novalue", null, "Not supplied", (Locale)null);
        }
        return value;
    }

    public List<FacetPivotResultDTO> searchPivot(SpatialSearchRequestParams searchParams) throws Exception {
        ArrayList<FacetPivotResultDTO> output;
        block0: {
            Map.Entry pfl;
            List list;
            String pivot = StringUtils.join((Object[])searchParams.getFacets(), (String)",");
            searchParams.setFacets(new String[0]);
            this.queryFormatUtils.formatSearchQuery(searchParams);
            String queryString = searchParams.getFormattedQuery();
            searchParams.setFacet(Boolean.valueOf(true));
            SolrQuery query = this.initSolrQuery((SearchRequestParams)searchParams, false, null);
            query.setQuery(queryString);
            query.setFields(null);
            query.add("facet.pivot", new String[]{pivot});
            query.add("facet.pivot.mincount", new String[]{"1"});
            query.add("facet.missing", new String[]{"true"});
            query.setRows(Integer.valueOf(0));
            searchParams.setPageSize(Integer.valueOf(0));
            QueryResponse response = this.indexDao.runSolrQuery(query, (SearchRequestParams)searchParams);
            NamedList result = response.getFacetPivot();
            output = new ArrayList<FacetPivotResultDTO>();
            Iterator iterator = result.iterator();
            if (!iterator.hasNext() || (list = (List)(pfl = (Map.Entry)iterator.next()).getValue()) == null || list.size() <= 0) break block0;
            output.add(new FacetPivotResultDTO(((PivotField)list.get(0)).getField(), this.getFacetPivotResults(list), null, Integer.valueOf((int)response.getResults().getNumFound())));
        }
        return output;
    }

    private List<FacetPivotResultDTO> getFacetPivotResults(List<PivotField> pfl) {
        if (pfl == null || pfl.size() == 0) {
            return null;
        }
        ArrayList<FacetPivotResultDTO> list = new ArrayList<FacetPivotResultDTO>();
        for (PivotField pf : pfl) {
            String value;
            String string = value = pf.getValue() != null ? pf.getValue().toString() : null;
            if (pf.getPivot() != null && pf.getPivot().size() != 0) continue;
            list.add(new FacetPivotResultDTO(null, null, value, Integer.valueOf(pf.getCount())));
        }
        return list;
    }

    public StringBuilder getAllQAFields() {
        StringBuilder qasb = new StringBuilder();
        ErrorCode[] errorCodes = AssertionCodes.getAll();
        Arrays.sort(errorCodes, new /* Unavailable Anonymous Inner Class!! */);
        for (ErrorCode assertionCode : errorCodes) {
            if (qasb.length() > 0) {
                qasb.append(",");
            }
            qasb.append(assertionCode.getName());
        }
        return qasb;
    }

    public List<FieldStatsItem> searchStat(SpatialSearchRequestParams searchParams, String field, String facet, Collection<String> statType) throws Exception {
        searchParams.setFacets(new String[0]);
        this.queryFormatUtils.formatSearchQuery(searchParams);
        String queryString = searchParams.getFormattedQuery();
        if (facet != null) {
            searchParams.setFacet(Boolean.valueOf(true));
        }
        SolrQuery query = this.initSolrQuery((SearchRequestParams)searchParams, false, null);
        query.setQuery(queryString);
        query.setFields(null);
        query.add("stats", new String[]{"true"});
        if (facet != null) {
            query.add("stats.facet", new String[]{facet});
        }
        query.add("stats.field", new String[]{"{!" + StringUtils.join(statType, (String)"=true ") + "=true}" + field});
        query.setRows(Integer.valueOf(0));
        searchParams.setPageSize(Integer.valueOf(0));
        QueryResponse response = this.indexDao.runSolrQuery(query, (SearchRequestParams)searchParams);
        ArrayList<FieldStatsItem> output = new ArrayList<FieldStatsItem>();
        if (facet != null && response.getFieldStatsInfo().size() > 0) {
            for (FieldStatsInfo f : (List)((FieldStatsInfo)response.getFieldStatsInfo().values().iterator().next()).getFacets().values().iterator().next()) {
                FieldStatsItem item = new FieldStatsItem(f);
                if (f.getName() == null) {
                    item.setFq("-" + facet + ":*");
                } else {
                    item.setFq(facet + ":\"" + f.getName() + "\"");
                }
                item.setLabel(f.getName());
                output.add(item);
            }
        } else if (response.getFieldStatsInfo().size() > 0) {
            output.add(new FieldStatsItem((FieldStatsInfo)response.getFieldStatsInfo().values().iterator().next()));
        }
        return output;
    }

    @Cacheable(cacheName="getColours")
    public List<LegendItem> getColours(SpatialSearchRequestParams request, String colourMode) throws Exception {
        ArrayList<LegendItem> colours = new ArrayList<LegendItem>();
        if (colourMode.equals("grid")) {
            for (int i = 0; i <= 500; i += 100) {
                LegendItem li = i == 0 ? new LegendItem(">0", "", "", 0L, null) : new LegendItem(String.valueOf(i), "", "", 0L, null);
                li.setColour((500 - i) / 2 << 8 | 0xFF0000);
                colours.add(li);
            }
        } else {
            SpatialSearchRequestParams requestParams = new SpatialSearchRequestParams();
            requestParams.setFormattedQuery(request.getFormattedQuery());
            requestParams.setWkt(request.getWkt());
            requestParams.setRadius(request.getRadius());
            requestParams.setLat(request.getLat());
            requestParams.setLon(request.getLon());
            requestParams.setQ(request.getQ());
            requestParams.setQc(request.getQc());
            requestParams.setFq(this.qidCacheDao.getFq(request));
            requestParams.setFoffset(Integer.valueOf(-1));
            String[] s = colourMode.split(",");
            String[] cutpoints = null;
            if (s.length > 1) {
                cutpoints = new String[s.length - 1];
                System.arraycopy(s, 1, cutpoints, 0, cutpoints.length);
            }
            if (s[0].equals("-1") || s[0].equals("grid")) {
                return null;
            }
            List legend = this.getLegend(requestParams, s[0], cutpoints, true);
            if (cutpoints == null) {
                Collections.sort(legend);
            }
            int offset = 0;
            for (int i = 0; i < legend.size(); ++i) {
                LegendItem li = (LegendItem)legend.get(i);
                colours.add(new LegendItem(li.getName(), li.getName(), li.getFacetValue(), li.getCount(), li.getFq(), li.isRemainder()));
                int colour = this.DEFAULT_COLOUR;
                if (cutpoints == null) {
                    colour = ColorUtil.colourList[i];
                } else if (cutpoints != null && i - offset < cutpoints.length) {
                    if (li.isRemainder()) {
                        colour = ColorUtil.getRangedColour((int)(i - offset), (int)(cutpoints.length / 2));
                    } else if (StringUtils.isEmpty((String)((LegendItem)legend.get(i)).getName()) || ((LegendItem)legend.get(i)).getName().equals("Unknown") || ((LegendItem)legend.get(i)).getName().startsWith("-")) {
                        ++offset;
                    } else {
                        colour = ColorUtil.getRangedColour((int)(i - offset), (int)(cutpoints.length / 2));
                    }
                }
                ((LegendItem)colours.get(colours.size() - 1)).setColour(colour);
            }
        }
        return colours;
    }

    public double[] getBBox(SpatialSearchRequestParams requestParams) throws Exception {
        String latitude = "decimalLatitude";
        String longitude = "decimalLongitude";
        double[] bbox = new double[4];
        String[] sort = new String[]{longitude, latitude, longitude, latitude};
        String[] dir = new String[]{"asc", "asc", "desc", "desc"};
        String[] bounds = new String[]{longitude + ":[-180 TO 180]", latitude + ":[-90 TO 90]"};
        this.queryFormatUtils.addFqs(bounds, requestParams);
        requestParams.setFq(requestParams.getFq());
        requestParams.setPageSize(Integer.valueOf(10));
        for (int i = 0; i < sort.length; ++i) {
            requestParams.setSort(sort[i]);
            requestParams.setDir(dir[i]);
            requestParams.setFl(sort[i]);
            SolrDocumentList sdl = this.findByFulltext(requestParams);
            if (sdl == null || sdl.size() <= 0) continue;
            if (sdl.get(0) != null) {
                bbox[i] = (Double)((SolrDocument)sdl.get(0)).getFieldValue(sort[i]);
                continue;
            }
            logger.error((Object)"searchDAO.findByFulltext returning SolrDocumentList with null records");
        }
        return bbox;
    }

    public List<String> listFacets(SpatialSearchRequestParams searchParams) throws Exception {
        this.queryFormatUtils.formatSearchQuery(searchParams);
        searchParams.setFacet(Boolean.valueOf(true));
        searchParams.setFacets(new String[0]);
        String queryString = searchParams.getFormattedQuery();
        SolrQuery solrQuery = this.initSolrQuery((SearchRequestParams)searchParams, false, null);
        solrQuery.setQuery(queryString);
        solrQuery.setFacetLimit(-1);
        solrQuery.setRows(Integer.valueOf(0));
        if (searchParams.getFormattedFq() != null) {
            for (String fq : searchParams.getFormattedFq()) {
                if (!StringUtils.isNotEmpty((String)fq)) continue;
                solrQuery.addFilterQuery(new String[]{fq});
            }
        }
        ArrayList<String> found = new ArrayList<String>();
        for (IndexFieldDTO s : this.indexDao.getIndexedFields()) {
            if (s.getDataType().startsWith("t")) continue;
            solrQuery.set("facet.field", new String[]{"{!facet.method=enum facet.exists=true}" + s.getName()});
            QueryResponse qr = this.query((SolrParams)solrQuery);
            for (FacetField f : qr.getFacetFields()) {
                if (f.getValues().isEmpty()) continue;
                found.add(f.getName());
            }
        }
        return found;
    }

    public HeatmapDTO getHeatMap(String query, String[] filterQueries, Double minx, Double miny, Double maxx, Double maxy, List<LegendItem> legend, int gridSizeInPixels) throws Exception {
        ArrayList<List> layers = new ArrayList<List>();
        if (miny < -90.0) {
            miny = -90.0;
        }
        if (maxy > 90.0) {
            maxy = 90.0;
        }
        while (maxx > 180.0) {
            maxx = maxx - 360.0;
            minx = minx - 360.0;
        }
        while (minx < -180.0) {
            maxx = maxx + 360.0;
            minx = minx + 360.0;
        }
        if (gridSizeInPixels > 1 || legend == null || legend.isEmpty()) {
            QueryResponse qr = null;
            SolrQuery solrQuery = this.createHeatmapQuery(query, filterQueries, minx, miny, maxx, maxy);
            qr = this.query((SolrParams)solrQuery);
            SimpleOrderedMap facetHeatMaps = (SimpleOrderedMap)((SimpleOrderedMap)qr.getResponse().get("facet_counts")).get("facet_heatmaps");
            Integer gridLevel = -1;
            if (facetHeatMaps != null) {
                SimpleOrderedMap heatmap = (SimpleOrderedMap)facetHeatMaps.get("quad");
                gridLevel = (Integer)heatmap.get("gridLevel");
                Integer rows = (Integer)heatmap.get("rows");
                Integer columns = (Integer)heatmap.get("columns");
                List layer = (List)heatmap.get("counts_ints2D");
                Double hminx = (Double)heatmap.get("minX");
                Double hminy = (Double)heatmap.get("minY");
                Double hmaxx = (Double)heatmap.get("maxX");
                Double hmaxy = (Double)heatmap.get("maxY");
                layers.add(layer);
                return new HeatmapDTO(gridLevel, layers, legend, gridSizeInPixels, rows, columns, hminx, hminy, hmaxx, hmaxy);
            }
        } else {
            Integer gridLevel = -1;
            Integer rows = 0;
            Integer columns = 0;
            Double hminx = minx;
            Double hminy = miny;
            Double hmaxx = maxx;
            Double hmaxy = maxy;
            boolean zoomOffset = false;
            for (int legendIdx = 0; legendIdx < legend.size(); ++legendIdx) {
                LegendItem legendItem = legend.get(legendIdx);
                QueryResponse qr = null;
                SolrQuery solrQuery = this.createHeatmapQuery(query, filterQueries, minx, miny, maxx, maxy);
                String[] fqs = Arrays.copyOf(solrQuery.getFilterQueries(), solrQuery.getFilterQueries().length + 1);
                fqs[fqs.length - 1] = legendItem.getFq();
                solrQuery.setFilterQueries(fqs);
                qr = this.query((SolrParams)solrQuery);
                if (qr != null) {
                    SimpleOrderedMap facetHeatMaps = (SimpleOrderedMap)((SimpleOrderedMap)qr.getResponse().get("facet_counts")).get("facet_heatmaps");
                    if (facetHeatMaps != null) {
                        SimpleOrderedMap heatmap = (SimpleOrderedMap)facetHeatMaps.get("quad");
                        gridLevel = (Integer)heatmap.get("gridLevel");
                        List layer = (List)heatmap.get("counts_ints2D");
                        rows = (Integer)heatmap.get("rows");
                        columns = (Integer)heatmap.get("columns");
                        hminx = (Double)heatmap.get("minX");
                        hminy = (Double)heatmap.get("minY");
                        hmaxx = (Double)heatmap.get("maxX");
                        hmaxy = (Double)heatmap.get("maxY");
                        layers.add(layer);
                        continue;
                    }
                    layers.add(null);
                    continue;
                }
                layers.add(null);
            }
            return new HeatmapDTO(gridLevel, layers, legend, gridSizeInPixels, rows, columns, hminx, hminy, hmaxx, hmaxy);
        }
        return null;
    }

    private SolrQuery createHeatmapQuery(String query, String[] filterQueries, Double minx, Double miny, Double maxx, Double maxy) {
        int zoomLevelByWidth;
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRequestHandler("standard");
        solrQuery.set("facet.heatmap", new String[]{"quad"});
        if (minx < -180.0) {
            minx = minx + 360.0;
        }
        if (maxx > 180.0) {
            maxx = maxx - 360.0;
        }
        String geom = "[\"" + minx + " " + miny + "\" TO \"" + maxx + " " + maxy + "\"]";
        solrQuery.set("facet.heatmap.geom", new String[]{geom});
        double[] solrGridLevelMap = new double[]{360.0, 180.0, 90.0, 45.0, 22.5, 11.25, 5.625, 2.8125, 1.40625, 0.703125, 0.3515625, 0.17578125, 0.087890625, 0.0439453125, 0.02197265625, 0.010986328125, 0.0054931640625, 0.00274658203125, 0.001373291015625, 6.866455078125E-4};
        for (zoomLevelByWidth = 0; zoomLevelByWidth < solrGridLevelMap.length && maxx - minx < solrGridLevelMap[zoomLevelByWidth]; ++zoomLevelByWidth) {
        }
        int zoomLevelByHeight = 0;
        while (zoomLevelByHeight + 1 < solrGridLevelMap.length && maxy - miny < solrGridLevelMap[zoomLevelByHeight + 1]) {
            ++zoomLevelByHeight;
        }
        int gridLevel = Math.min(zoomLevelByWidth, zoomLevelByHeight) + 7;
        solrQuery.set("facet.heatmap.gridLevel", new String[]{String.valueOf(gridLevel)});
        solrQuery.setFacetLimit(-1);
        solrQuery.setFacet(true);
        solrQuery.setFilterQueries(filterQueries);
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery(query);
        return solrQuery;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ QueryResponse access$100(SearchDAOImpl x0, SolrQuery x1, int x2, String x3) throws Exception {
        return x0.runSolrQueryWithCursorMark(x1, x2, x3);
    }

    static /* synthetic */ int access$200(SearchDAOImpl x0, ConcurrentMap x1, String[] x2, String[] x3, RecordWriter x4, QueryResponse x5, DownloadDetailsDTO x6, boolean x7, AtomicInteger x8, long x9, String[] x10, String[] x11, List x12, Boolean x13) {
        return x0.processQueryResults(x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13);
    }
}

