/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.dao.IndexDAO;
import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.AssertionCodes;
import au.org.ala.biocache.dto.Comparison;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.ErrorCode;
import au.org.ala.biocache.dto.FacetPivotResultDTO;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FacetThemes;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.MediaDTO;
import au.org.ala.biocache.dto.NativeDTO;
import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.dto.OccurrenceSourceDTO;
import au.org.ala.biocache.dto.SearchRequestParams;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.UserAssertions;
import au.org.ala.biocache.service.AssertionService;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.service.ImageMetadataService;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.LoggerService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.util.OccurrenceUtils;
import au.org.ala.biocache.util.QidSizeException;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.biocache.web.AbstractSecureController;
import au.org.ala.biocache.web.OccurrenceController;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.constant.Constable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.sf.ehcache.CacheManager;
import net.sf.json.JSONArray;
import org.ala.client.model.LogEventType;
import org.ala.client.model.LogEventVO;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.utils.file.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class OccurrenceController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(OccurrenceController.class);
    public static final String LEGACY_REPRESENTATIVE_RECORD_VALUE = "R";
    public static final String LEGACY_DUPLICATE_RECORD_VALUE = "D";
    public static final String RAW_FIELD_PREFIX = "raw_";
    public static final String DYNAMIC_PROPERTIES_PREFIX = "dynamicProperties_";
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected IndexDAO indexDao;
    @Inject
    protected SearchUtils searchUtils;
    @Inject
    protected SpeciesLookupService speciesLookupService;
    @Inject
    protected AuthService authService;
    @Inject
    protected OccurrenceUtils occurrenceUtils;
    @Inject
    protected DownloadService downloadService;
    @Inject
    protected LoggerService loggerService;
    @Inject
    private AbstractMessageSource messageSource;
    @Inject
    private ImageMetadataService imageMetadataService;
    @Inject
    protected Validator validator;
    @Inject
    protected QidCacheDAO qidCacheDao;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private LayersService layersService;
    @Inject
    private AssertionService assertionService;
    private final String HOME = "homePage";
    private final String VALIDATION_ERROR = "error/validationError";
    @Value(value="${webservices.root:http://localhost:8080/biocache-service}")
    protected String webservicesRoot;
    @Value(value="${media.store.url:}")
    private String remoteMediaStoreUrl;
    @Value(value="${taxon.id.pattern:urn:lsid:biodiversity.org.au[a-zA-Z0-9\\.:-]*|http://id.biodiversity.org.au/[a-zA-Z0-9/]*}")
    protected String taxonIDPatternString;
    @Value(value="${native.country:Australia}")
    protected String nativeCountry;
    protected Pattern taxonIDPattern;
    @Value(value="${media.url:https://biocache.ala.org.au/biocache-media/}")
    protected String biocacheMediaUrl;
    @Value(value="${facet.config:/data/biocache/config/facets.json}")
    protected String facetConfig;
    @Value(value="${facets.max:4}")
    public Integer facetsMax;
    @Value(value="${facets.defaultmax:0}")
    public Integer facetsDefaultMax;
    @Value(value="${facet.default:true}")
    public Boolean facetDefault;
    @Value(value="${online.downloadquery.maxthreads:30}")
    protected Integer maxOnlineDownloadThreads = 30;
    @Value(value="${occurrence.cache.cachecontrol.publicorprivate:public}")
    private String occurrenceCacheControlHeaderPublicOrPrivate;
    @Value(value="${occurrence.cache.cachecontrol.maxage:86400}")
    private String occurrenceCacheControlHeaderMaxAge;
    @Value(value="${occurrence.log.enabled:true}")
    private boolean occurrenceLogEnabled = true;
    private final AtomicReference<String> occurrenceETag = new AtomicReference<String>(UUID.randomUUID().toString());
    private ExecutorService executor;

    @PostConstruct
    public void init() throws Exception {
        logger.debug((Object)"Initialising OccurrenceController");
        String nameFormat = "occurrencecontroller-pool-%d";
        this.executor = Executors.newFixedThreadPool(this.maxOnlineDownloadThreads, new ThreadFactoryBuilder().setNameFormat(nameFormat).setPriority(1).build());
        Set indexedFields = this.indexDao.getIndexedFields();
        if (indexedFields != null) {
            new FacetThemes(this.facetConfig, indexedFields, this.facetsMax.intValue(), this.facetsDefaultMax.intValue(), this.facetDefault.booleanValue());
        }
    }

    public Pattern getTaxonIDPattern() {
        if (this.taxonIDPattern == null) {
            this.taxonIDPattern = Pattern.compile(this.taxonIDPatternString);
        }
        return this.taxonIDPattern;
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator(this.validator);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String homePageHandler(Model model) {
        model.addAttribute("webservicesRoot", (Object)this.webservicesRoot);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream input = classLoader.getResourceAsStream("/git.properties");
        if (input != null) {
            try {
                Properties versionProperties = new Properties();
                versionProperties.load(input);
                model.addAttribute("versionInfo", (Object)versionProperties);
                StringBuffer sb = new StringBuffer();
                for (String name : versionProperties.stringPropertyNames()) {
                    sb.append(name + " : " + versionProperties.getProperty(name) + "\n");
                }
                model.addAttribute("versionInfoString", (Object)sb.toString());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return "homePage";
    }

    @RequestMapping(value={"/oldapi"}, method={RequestMethod.GET})
    public String oldApiHandler(Model model) {
        model.addAttribute("webservicesRoot", (Object)this.webservicesRoot);
        return "oldapi";
    }

    @RequestMapping(value={"/upload/dynamicFacets"}, method={RequestMethod.GET})
    @ResponseBody
    public Map emptyJson() {
        HashMap map = new HashMap();
        return map;
    }

    @RequestMapping(value={"/active/download/stats"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DownloadDetailsDTO> getCurrentDownloads() {
        return this.downloadService.getCurrentDownloads();
    }

    @RequestMapping(value={"/search/facets"}, method={RequestMethod.GET})
    @ResponseBody
    public String[] listAllFacets() {
        return new SearchRequestParams().getFacets();
    }

    @RequestMapping(value={"/search/grouped/facets"}, method={RequestMethod.GET})
    @ResponseBody
    public List groupFacets() throws IOException {
        return FacetThemes.getAllThemes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/facets/i18n{qualifier:.*}*"}, method={RequestMethod.GET})
    public void writei18nPropertiesFile(@PathVariable(value="qualifier") String qualifier, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setHeader("Content-Type", "text/plain; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", this.occurrenceCacheControlHeaderPublicOrPrivate + ", max-age=" + this.occurrenceCacheControlHeaderMaxAge);
        response.setHeader("ETag", (String)this.occurrenceETag.get());
        qualifier = StringUtils.isNotEmpty((String)qualifier) ? qualifier : ".properties";
        logger.debug((Object)("qualifier = " + qualifier));
        File f = new File("/data/biocache/config/messages" + qualifier);
        try (InputStream is = f.exists() && f.isFile() && f.canRead() ? FileUtils.getInputStream((File)f) : request.getSession().getServletContext().getResourceAsStream("/WEB-INF/messages" + qualifier);
             ServletOutputStream os = response.getOutputStream();){
            if (is != null) {
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            }
            if (StringUtils.isNotEmpty((String)this.layersService.getLayersServiceUrl())) {
                try {
                    Map fields = this.layersService.getLayerNameMap();
                    for (Map.Entry field : fields.entrySet()) {
                        os.write(("\nfield." + (String)field.getKey() + "=" + (String)field.getValue()).getBytes(StandardCharsets.UTF_8));
                        os.write(("\nfacet." + (String)field.getKey() + "=" + (String)field.getValue()).getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("failed to add layer names from url: " + this.layersService.getLayersServiceUrl()), (Throwable)e);
                }
            }
            os.flush();
        }
    }

    @RequestMapping(value={"index/fields"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<IndexFieldDTO> getIndexedFields(@RequestParam(value="fl", required=false) String fields, @RequestParam(value="indexed", required=false) Boolean indexed, @RequestParam(value="stored", required=false) Boolean stored, @RequestParam(value="multivalue", required=false) Boolean multivalue, @RequestParam(value="dataType", required=false) String dataType, @RequestParam(value="classs", required=false) String classs, @RequestParam(value="isMisc", required=false, defaultValue="false") Boolean isMisc, @RequestParam(value="deprecated", required=false, defaultValue="false") Boolean isDeprecated, @RequestParam(value="isDwc", required=false) Boolean isDwc) throws Exception {
        Set<Object> result = fields == null ? this.indexDao.getIndexedFields() : this.indexDao.getIndexFieldDetails(fields.split(","));
        if (indexed != null || stored != null || multivalue != null || dataType != null || classs != null || !isMisc.booleanValue()) {
            HashSet<IndexFieldDTO> filtered = new HashSet<IndexFieldDTO>();
            HashSet<String> dataTypes = dataType == null ? null : new HashSet<String>(Arrays.asList(dataType.split(",")));
            HashSet<String> classss = classs == null ? null : new HashSet<String>(Arrays.asList(classs.split(",")));
            for (IndexFieldDTO i : result) {
                if (indexed != null && i.isIndexed() != indexed.booleanValue() || stored != null && i.isStored() != stored.booleanValue() || multivalue != null && i.isMultivalue() != multivalue.booleanValue() || dataType != null && !dataTypes.contains(i.getDataType()) || classs != null && !classss.contains(i.getClasss()) || !isMisc.booleanValue() && i.getName().startsWith(DYNAMIC_PROPERTIES_PREFIX) || !isDeprecated.booleanValue() && i.isDeprecated() || isDwc != null && isDwc != StringUtils.isNotEmpty((String)i.getDwcTerm())) continue;
                filtered.add(i);
            }
            result = filtered;
        }
        ArrayList<IndexFieldDTO> myList = new ArrayList<IndexFieldDTO>(result);
        Collections.sort(myList, new /* Unavailable Anonymous Inner Class!! */);
        return myList;
    }

    @RequestMapping(value={"index/fields.csv"}, method={RequestMethod.GET})
    public void getIndexedFields(@RequestParam(value="fl", required=false) String fields, @RequestParam(value="indexed", required=false) Boolean indexed, @RequestParam(value="stored", required=false) Boolean stored, @RequestParam(value="multivalue", required=false) Boolean multivalue, @RequestParam(value="dataType", required=false) String dataType, @RequestParam(value="classs", required=false) String classs, @RequestParam(value="isMisc", required=false, defaultValue="false") Boolean isMisc, @RequestParam(value="deprecated", required=false, defaultValue="false") Boolean isDeprecated, @RequestParam(value="isDwc", required=false) Boolean isDwc, HttpServletResponse response) throws Exception {
        Collection indexedFields = this.getIndexedFields(fields, indexed, stored, multivalue, dataType, classs, isMisc, isDeprecated, isDwc);
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "must-revalidate");
        response.setHeader("Content-Disposition", "attachment;filename=index-fields.csv");
        response.setContentType("text/csv");
        CSVWriter csvWriter = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));
        csvWriter.writeNext(new String[]{"name", "dwc term", "dwc category", "info", "dataType", "description", "download name", "download description", "json name", "stored", "indexed", "multivalue", "deprecated", "newFieldName"});
        for (IndexFieldDTO indexField : indexedFields) {
            csvWriter.writeNext(new String[]{indexField.getName(), indexField.getDwcTerm(), indexField.getClasss(), indexField.getInfo(), indexField.getDataType(), indexField.getDescription(), indexField.getDownloadName(), indexField.getDownloadDescription(), indexField.getJsonName(), Boolean.toString(indexField.isStored()), Boolean.toString(indexField.isIndexed()), Boolean.toString(indexField.isMultivalue()), Boolean.toString(indexField.isDeprecated()), indexField.getNewFieldName()});
        }
        csvWriter.flush();
        csvWriter.close();
    }

    @RequestMapping(value={"index/version"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getIndexedFields(@RequestParam(value="apiKey", required=false) String apiKey, @RequestParam(value="force", required=false, defaultValue="false") Boolean force, HttpServletResponse response) throws Exception {
        Long version = force != false && this.shouldPerformOperation(apiKey, response) ? this.indexDao.getIndexVersion(force) : this.indexDao.getIndexVersion(Boolean.valueOf(false));
        return Collections.singletonMap("version", version);
    }

    @RequestMapping(value={"index/maxBooleanClauses"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getIndexedFields() throws Exception {
        int m = this.searchDAO.getMaxBooleanClauses();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("maxBooleanClauses", m);
        return map;
    }

    @RequestMapping(value={"config"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getConfig() {
        HashMap<String, Constable> map = new HashMap<String, Constable>();
        map.put("maxBooleanClauses", Integer.valueOf(this.searchDAO.getMaxBooleanClauses()));
        map.put("facet.default", this.facetDefault);
        map.put("facets.defaultmax", this.facetsDefaultMax);
        map.put("facets.max", this.facetsMax);
        if (this.searchDAO instanceof SearchDAOImpl) {
            SearchDAOImpl dao = (SearchDAOImpl)this.searchDAO;
            map.put("download.max", dao.MAX_DOWNLOAD_SIZE);
            map.put("download.unzipped.limit", dao.unzippedLimit);
        }
        map.put("citations.enabled", this.downloadService.citationsEnabled);
        map.put("headings.enabled", this.downloadService.headingsEnabled);
        map.put("zip.file.size.mb.max", this.downloadService.maxMB);
        map.put("download.offline.max.size", this.downloadService.dowloadOfflineMaxSize);
        return map;
    }

    @RequestMapping(value={"occurrence/facets"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FacetResultDTO> getOccurrenceFacetDetails(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        return this.searchDAO.getFacetCounts(requestParams);
    }

    @RequestMapping(value={"/images/taxon/**"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getImages(HttpServletRequest request) throws Exception {
        String guid = this.searchUtils.getGuidFromPath(request);
        SpatialSearchRequestParams srp = new SpatialSearchRequestParams();
        srp.setQ("lsid:" + guid);
        srp.setPageSize(Integer.valueOf(0));
        srp.setFacets(new String[]{"imageID"});
        SearchResultDTO results = this.searchDAO.findByFulltextSpatialQuery(srp, false, null);
        if (results.getFacetResults().size() > 0) {
            List fieldResults = ((FacetResultDTO)results.getFacetResults().iterator().next()).getFieldResult();
            ArrayList<String> images = new ArrayList<String>(fieldResults.size());
            for (FieldResultDTO fr : fieldResults) {
                images.add(fr.getLabel());
            }
            return images;
        }
        return Collections.EMPTY_LIST;
    }

    @RequestMapping(value={"/australian/taxon/**", "/native/taxon/**"}, method={RequestMethod.GET})
    @ResponseBody
    public NativeDTO isAustralian(HttpServletRequest request) throws Exception {
        String guid = this.searchUtils.getGuidFromPath(request);
        NativeDTO adto = new NativeDTO();
        if (guid != null) {
            adto = this.getIsAustraliaForGuid(guid);
        }
        return adto;
    }

    @RequestMapping(value={"/australian/taxa.json*", "/australian/taxa*", "/native/taxa.json*", "/native/taxa*"}, method={RequestMethod.GET})
    @ResponseBody
    public List<NativeDTO> isAustralianForList(@RequestParam(value="guids", required=true) String guids) throws Exception {
        ArrayList<NativeDTO> nativeDTOs = new ArrayList<NativeDTO>();
        String[] guidArray = StringUtils.split((String)guids, (char)',');
        if (guidArray != null) {
            for (String guid : guidArray) {
                nativeDTOs.add(this.getIsAustraliaForGuid(guid));
                logger.debug((Object)("guid = " + guid));
            }
        }
        return nativeDTOs;
    }

    private NativeDTO getIsAustraliaForGuid(String guid) {
        SpatialSearchRequestParams requestParams = new SpatialSearchRequestParams();
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacets(new String[0]);
        String query = "lsid:" + guid + " AND (" + "country" + ":\"" + this.nativeCountry + "\" OR " + "stateProvince" + ":[* TO *])";
        requestParams.setQ(query);
        NativeDTO adto = new NativeDTO();
        adto.setTaxonGuid(guid);
        SearchResultDTO results = this.searchDAO.findByFulltextSpatialQuery(requestParams, false, null);
        adto.setHasOccurrenceRecords(results.getTotalRecords() > 0L);
        adto.setIsNSL(this.getTaxonIDPattern().matcher(guid).matches());
        if (adto.isHasOccurrences()) {
            requestParams.setQ("lsid:" + guid + " AND (" + "provenance" + ":\"Published dataset\")");
            results = this.searchDAO.findByFulltextSpatialQuery(requestParams, false, null);
            adto.setHasCSOnly(results.getTotalRecords() == 0L);
        }
        return adto;
    }

    @RequestMapping(value={"/occurrences", "/occurrences/collections", "/occurrences/institutions", "/occurrences/dataResources", "/occurrences/dataProviders", "/occurrences/taxa", "/occurrences/dataHubs"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResultDTO listOccurrences(Model model) throws Exception {
        SpatialSearchRequestParams srp = new SpatialSearchRequestParams();
        srp.setQ("*:*");
        return this.occurrenceSearch(srp);
    }

    @RequestMapping(value={"/occurrences/taxon/**", "/occurrences/taxon/**", "/occurrences/taxa/**"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResultDTO occurrenceSearchByTaxon(SpatialSearchRequestParams requestParams, HttpServletRequest request) throws Exception {
        String guid = this.searchUtils.getGuidFromPath(request);
        requestParams.setQ("lsid:" + guid);
        SearchUtils.setDefaultParams((SearchRequestParams)requestParams);
        return this.occurrenceSearch(requestParams);
    }

    @RequestMapping(value={"/occurrences/taxon/source/**"}, method={RequestMethod.GET})
    @ResponseBody
    public List<OccurrenceSourceDTO> sourceByTaxon(SpatialSearchRequestParams requestParams, HttpServletRequest request) throws Exception {
        String guid = this.searchUtils.getGuidFromPath(request);
        requestParams.setQ("lsid:" + guid);
        Map sources = this.searchDAO.getSourcesForQuery(requestParams);
        return this.searchUtils.getSourceInformation(sources);
    }

    @RequestMapping(value={"/occurrences/collections/{uid}", "/occurrences/institutions/{uid}", "/occurrences/dataResources/{uid}", "/occurrences/dataProviders/{uid}", "/occurrences/dataHubs/{uid}"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResultDTO occurrenceSearchForUID(SpatialSearchRequestParams requestParams, @PathVariable(value="uid") String uid) throws Exception {
        SearchResultDTO searchResult = new SearchResultDTO();
        if (StringUtils.isEmpty((String)uid)) {
            return searchResult;
        }
        SearchUtils.setDefaultParams((SearchRequestParams)requestParams);
        this.searchUtils.updateCollectionSearchString((SearchRequestParams)requestParams, uid);
        logger.debug((Object)("solr query: " + requestParams));
        return this.occurrenceSearch(requestParams);
    }

    @RequestMapping(value={"/occurrences/searchByArea*"}, method={RequestMethod.GET})
    @Deprecated
    @ResponseBody
    public SearchResultDTO occurrenceSearchByArea(SpatialSearchRequestParams requestParams, Model model) {
        SearchResultDTO searchResult = new SearchResultDTO();
        if (StringUtils.isEmpty((String)requestParams.getQ())) {
            return searchResult;
        }
        searchResult = this.searchDAO.findByFulltextSpatialQuery(requestParams, false, null);
        model.addAttribute("searchResult", (Object)searchResult);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning results set with: " + searchResult.getTotalRecords()));
        }
        return searchResult;
    }

    private SearchResultDTO occurrenceSearch(SpatialSearchRequestParams requestParams) throws Exception {
        return this.occurrenceSearch(requestParams, null, Boolean.valueOf(false), null, null);
    }

    @RequestMapping(value={"/occurrences/search.json*", "/occurrences/search*", "/occurrence/search*"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResultDTO occurrenceSearch(SpatialSearchRequestParams requestParams, @RequestParam(value="apiKey", required=false) String apiKey, @RequestParam(value="im", required=false, defaultValue="false") Boolean lookupImageMetadata, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map map;
        SearchUtils.setDefaultParams((SearchRequestParams)requestParams);
        Map map2 = map = request != null ? SearchUtils.getExtraParams((Map)request.getParameterMap()) : null;
        if (map != null) {
            map.remove("apiKey");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("occurrence search params = " + requestParams + " extra params = " + map));
        }
        SearchResultDTO srtdto = null;
        srtdto = apiKey == null ? this.searchDAO.findByFulltextSpatialQuery(requestParams, false, map) : this.occurrenceSearchSensitive(requestParams, apiKey, request, response);
        if (srtdto.getTotalRecords() > 0L && lookupImageMetadata.booleanValue()) {
            ArrayList<String> occurrenceIDs = new ArrayList<String>();
            for (OccurrenceIndex oi : srtdto.getOccurrences()) {
                occurrenceIDs.add(oi.getUuid());
            }
            Map imageMap = this.imageMetadataService.getImageMetadataForOccurrences(occurrenceIDs);
            for (OccurrenceIndex oi : srtdto.getOccurrences()) {
                List imageMetadata = (List)imageMap.get(oi.getUuid());
                oi.setImageMetadata(imageMetadata);
            }
        }
        return srtdto;
    }

    @ResponseBody
    public SearchResultDTO occurrenceSearchSensitive(SpatialSearchRequestParams requestParams, @RequestParam(value="apiKey", required=true) String apiKey, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.shouldPerformOperation(apiKey, response, false)) {
            SearchUtils.setDefaultParams((SearchRequestParams)requestParams);
            Map map = SearchUtils.getExtraParams((Map)request.getParameterMap());
            if (map != null) {
                map.remove("apiKey");
            }
            logger.debug((Object)("occurrence search params = " + requestParams));
            SearchResultDTO searchResult = this.searchDAO.findByFulltextSpatialQuery(requestParams, true, map);
            return searchResult;
        }
        return null;
    }

    @RequestMapping(value={"/cache/refresh"}, method={RequestMethod.GET})
    @ResponseBody
    public String refreshCache() throws Exception {
        this.searchDAO.refreshCaches();
        new FacetThemes(this.facetConfig, this.indexDao.getIndexedFields(), this.facetsMax.intValue(), this.facetsDefaultMax.intValue(), this.facetDefault.booleanValue());
        this.cacheManager.clearAll();
        this.regenerateETag();
        return null;
    }

    private void regenerateETag() {
        this.occurrenceETag.set(UUID.randomUUID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/occurrences/facets/download*"}, method={RequestMethod.GET})
    public void downloadFacet(DownloadRequestParams requestParams, @RequestParam(value="count", required=false, defaultValue="false") boolean includeCount, @RequestParam(value="lookup", required=false, defaultValue="false") boolean lookupName, @RequestParam(value="synonym", required=false, defaultValue="false") boolean includeSynonyms, @RequestParam(value="lists", required=false, defaultValue="false") boolean includeLists, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (requestParams.getFacets().length > 0) {
            DownloadDetailsDTO dd = this.downloadService.registerDownload(requestParams, this.getIPAddress(request), this.getUserAgent(request), DownloadDetailsDTO.DownloadType.FACET);
            try {
                String filename = requestParams.getFile() != null ? requestParams.getFile() : requestParams.getFacets()[0];
                response.setHeader("Cache-Control", "must-revalidate");
                response.setHeader("Pragma", "must-revalidate");
                response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".csv");
                response.setContentType("text/csv");
                this.searchDAO.writeFacetToStream((SpatialSearchRequestParams)requestParams, includeCount, lookupName, includeSynonyms, includeLists, (OutputStream)response.getOutputStream(), dd);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.downloadService.unregisterDownload(dd);
            }
        }
    }

    @RequestMapping(value={"/occurrences/batchSearch"}, method={RequestMethod.POST}, params={"action=Download"})
    public void batchDownload(HttpServletResponse response, HttpServletRequest request, DownloadRequestParams downloadRequestParams, @RequestParam(value="queries", required=true, defaultValue="") String queries, @RequestParam(value="field", required=true, defaultValue="") String field, @RequestParam(value="separator", defaultValue="\n") String separator, @RequestParam(value="title", required=false) String title) throws Exception {
        logger.info((Object)"/occurrences/batchSearch with action=Download Records");
        Long qid = this.getQidForBatchSearch(queries, field, separator, title);
        if (qid != null) {
            if ("*:*".equals(downloadRequestParams.getQ())) {
                downloadRequestParams.setQ("qid:" + qid);
            } else {
                downloadRequestParams.setQ("(" + downloadRequestParams.getQ() + ") AND qid:" + qid);
            }
            String webservicesRoot = request.getSession().getServletContext().getInitParameter("webservicesRoot");
            response.sendRedirect(webservicesRoot + "/occurrences/download?" + downloadRequestParams.getEncodedParams());
        } else {
            response.sendError(400);
        }
    }

    @RequestMapping(value={"/occurrences/download/batchFile"}, method={RequestMethod.GET})
    public String batchDownload(HttpServletRequest request, @Valid DownloadRequestParams params, BindingResult result, @RequestParam(value="file", required=true) String filepath, @RequestParam(value="directory", required=true, defaultValue="/data/biocache-exports") String directory, Model model) {
        if (result.hasErrors()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("validation failed  " + result.getErrorCount() + " checks"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)result.toString());
                }
            }
            model.addAttribute("errorMessage", (Object)this.getValidationErrorMessage(result));
            return "error/validationError";
        }
        File file = new File(filepath);
        SpeciesLookupService mySpeciesLookupService = this.speciesLookupService;
        DownloadDetailsDTO dd = this.downloadService.registerDownload(params, this.getIPAddress(request), this.getUserAgent(request), DownloadDetailsDTO.DownloadType.RECORDS_INDEX);
        if (file.exists()) {
            2 t = new /* Unavailable Anonymous Inner Class!! */;
            this.executor.submit((Runnable)t);
        }
        return null;
    }

    @RequestMapping(value={"/occurrences/batchSearch"}, method={RequestMethod.POST}, params={"action=Search"})
    public void batchSearch(HttpServletResponse response, @RequestParam(value="redirectBase", required=true, defaultValue="") String redirectBase, @RequestParam(value="queries", required=true, defaultValue="") String queries, @RequestParam(value="field", required=true, defaultValue="") String field, @RequestParam(value="separator", defaultValue="\n") String separator, @RequestParam(value="title", required=false) String title) throws Exception {
        logger.info((Object)"/occurrences/batchSearch with action=Search");
        Long qid = this.getQidForBatchSearch(queries, field, separator, title);
        if (qid != null && StringUtils.isNotBlank((String)redirectBase)) {
            response.sendRedirect(redirectBase + "?q=qid:" + qid);
        } else {
            response.sendError(400, "");
        }
    }

    private Long getQidForBatchSearch(String listOfNames, String field, String separator, String title) throws IOException, QidSizeException {
        String[] rawParts = listOfNames.split(separator);
        StringBuilder sb = new StringBuilder();
        int terms = 0;
        for (String part : rawParts) {
            String normalised = StringUtils.trimToNull((String)part);
            if (normalised == null) continue;
            if (terms == 0) {
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("(");
            } else {
                sb.append(" OR ");
            }
            sb.append(field + ":\"" + normalised + "\"");
            if (++terms < this.searchDAO.getMaxBooleanClauses()) continue;
            sb.append(")");
            terms = 0;
        }
        if (terms > 0) {
            sb.append(")");
        }
        String q = sb.toString();
        title = title == null ? q : title;
        String qid = this.qidCacheDao.put(q, title, null, null, null, -1L, null);
        logger.info((Object)("batchSearch: qid = " + qid));
        return Long.parseLong(qid);
    }

    @RequestMapping(value={"/occurrences/taxaCount"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public Map<String, Integer> occurrenceSpeciesCounts(HttpServletResponse response, HttpServletRequest request, @RequestParam(defaultValue="\n") String separator) throws Exception {
        String listOfGuids = request.getParameter("guids");
        String[] filterQueries = request.getParameterValues("fq");
        if (StringUtils.isBlank((String)listOfGuids)) {
            response.sendError(400, "Provide a non-empty guids parameter");
            return null;
        }
        String[] rawGuids = listOfGuids.split(separator);
        ArrayList<String> guids = new ArrayList<String>();
        for (String guid : rawGuids) {
            String normalised = StringUtils.trimToNull((String)guid);
            if (normalised == null) continue;
            guids.add(normalised);
        }
        response.setHeader("Cache-Control", this.occurrenceCacheControlHeaderPublicOrPrivate + ", max-age=" + this.occurrenceCacheControlHeaderMaxAge);
        response.setHeader("ETag", (String)this.occurrenceETag.get());
        return this.searchDAO.getOccurrenceCountsForTaxa(guids, filterQueries);
    }

    @RequestMapping(value={"/occurrences/index/download*", "/occurrences/download*"}, method={RequestMethod.GET})
    public String occurrenceIndexDownload(@Valid DownloadRequestParams requestParams, BindingResult result, @RequestParam(value="email", required=false) String email, @RequestParam(value="apiKey", required=false) String apiKey, @RequestParam(value="zip", required=false, defaultValue="true") Boolean zip, Model model, HttpServletResponse response, HttpServletRequest request) throws Exception {
        if (result.hasErrors()) {
            logger.info((Object)("validation failed  " + result.getErrorCount() + " checks"));
            logger.debug((Object)result.toString());
            model.addAttribute("errorMessage", (Object)this.getValidationErrorMessage(result));
            return "error/validationError";
        }
        boolean validEmail = false;
        if (email != null) {
            try {
                new InternetAddress(email).validate();
                validEmail = true;
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
        if (apiKey == null && !validEmail && this.rateLimitRequest(request, response)) {
            response.sendError(403, "API Key or email required, please contact 'support@ala.org.au'");
            return null;
        }
        if (requestParams.getQ().isEmpty() && requestParams.getFormattedQuery().isEmpty()) {
            return null;
        }
        if (apiKey != null) {
            this.occurrenceSensitiveDownload(requestParams, apiKey, zip.booleanValue(), response, request);
            return null;
        }
        try {
            ServletOutputStream out = response.getOutputStream();
            this.downloadService.writeQueryToStream(requestParams, response, this.getIPAddress(request), this.getUserAgent(request), (OutputStream)new CloseShieldOutputStream((OutputStream)out), true, zip.booleanValue(), this.executor);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String occurrenceSensitiveDownload(DownloadRequestParams requestParams, String apiKey, boolean zip, HttpServletResponse response, HttpServletRequest request) throws Exception {
        if (this.shouldPerformOperation(apiKey, response, false)) {
            if (requestParams.getQ().isEmpty() && requestParams.getFormattedQuery().isEmpty()) {
                return null;
            }
            try {
                ServletOutputStream out = response.getOutputStream();
                this.downloadService.writeQueryToStream(requestParams, response, this.getIPAddress(request), this.getUserAgent(request), (OutputStream)new CloseShieldOutputStream((OutputStream)out), true, zip, this.executor);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @RequestMapping(value={"/occurrences/nearest"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> nearestOccurrence(SpatialSearchRequestParams requestParams) throws Exception {
        logger.debug((Object)String.format("Received lat: %f, lon:%f, radius:%f", requestParams.getLat(), requestParams.getLon(), requestParams.getRadius()));
        if (requestParams.getLat() == null || requestParams.getLon() == null) {
            return new HashMap<String, Object>();
        }
        requestParams.setDir("asc");
        requestParams.setFacet(Boolean.valueOf(false));
        SearchResultDTO searchResult = this.searchDAO.findByFulltextSpatialQuery(requestParams, false, null);
        List ocs = searchResult.getOccurrences();
        if (!ocs.isEmpty()) {
            HashMap<String, Object> results = new HashMap<String, Object>();
            OccurrenceIndex oc = (OccurrenceIndex)ocs.get(0);
            Double decimalLatitude = oc.getDecimalLatitude();
            Double decimalLongitude = oc.getDecimalLongitude();
            Double distance = this.distInMetres(Double.valueOf(requestParams.getLat().doubleValue()), Double.valueOf(requestParams.getLon().doubleValue()), decimalLatitude, decimalLongitude);
            results.put("distanceInMeters", distance);
            results.put("occurrence", oc);
            return results;
        }
        return new HashMap<String, Object>();
    }

    private Double distInMetres(Double lat1, Double lon1, Double lat2, Double lon2) {
        Double R = 6371000.0;
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1);
        double lat1Rad = Math.toRadians(lat1);
        double lat2Rad = Math.toRadians(lat2);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0) * Math.cos(lat1Rad) * Math.cos(lat2Rad);
        Double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return R * c;
    }

    @RequestMapping(value={"/occurrences/coordinates*"})
    public void dumpDistinctLatLongs(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        requestParams.setFacets(new String[]{"lat_long"});
        requestParams.setFacet(Boolean.valueOf(true));
        if (requestParams.getQ().length() < 1) {
            requestParams.setQ("*:*");
        }
        try {
            ServletOutputStream out = response.getOutputStream();
            this.searchDAO.writeCoordinatesToStream(requestParams, (OutputStream)out);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    @RequestMapping(value={"/occurrence/compare/{uuid}.json", "/occurrence/compare/{uuid}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object showOccurrence(@PathVariable(value="uuid") String uuid, HttpServletResponse response) throws Exception {
        SpatialSearchRequestParams idRequest = new SpatialSearchRequestParams();
        idRequest.setQ("id:\"" + uuid + "\"");
        idRequest.setFl(StringUtils.join(this.indexDao.getIndexedFieldsMap().keySet(), (String)","));
        idRequest.setFacet(Boolean.valueOf(false));
        SolrDocumentList sdl = this.searchDAO.findByFulltext(idRequest);
        if (sdl == null || sdl.isEmpty() || ((SolrDocument)sdl.get(0)).get((Object)"id") == null) {
            response.sendError(404, "Unrecognised ID");
            return null;
        }
        SolrDocument sd = (SolrDocument)sdl.get(0);
        Map fullRecord = this.mapAsFullRecord(sd, Boolean.valueOf(false), Boolean.valueOf(false));
        Map rawGroups = (Map)fullRecord.get("raw");
        Map processedGroups = (Map)fullRecord.get("processed");
        HashSet groupKeys = new HashSet();
        groupKeys.addAll(rawGroups.keySet());
        groupKeys.addAll(processedGroups.keySet());
        groupKeys.remove("el");
        groupKeys.remove("cl");
        groupKeys.remove("queryAssertions");
        groupKeys.remove("miscProperties");
        HashMap groups = new HashMap();
        for (Object groupKey : groupKeys) {
            Object raw = rawGroups.get(groupKey);
            Object processed = processedGroups.get(groupKey);
            if (raw == null || processed == null || !(raw instanceof Map) || !(processed instanceof Map)) continue;
            Map rawMap = (Map)raw;
            Map processedMap = (Map)processed;
            HashSet keys = new HashSet();
            keys.addAll(rawMap.keySet());
            keys.addAll(processedMap.keySet());
            ArrayList<Comparison> comparison = new ArrayList<Comparison>();
            for (Object key : keys) {
                Object r = rawMap.get(key);
                Object p = processedMap.get(key);
                if (r == null && p == null) continue;
                Comparison c = new Comparison();
                c.setName((String)key);
                if (r instanceof String && !StringUtils.isEmpty((String)((String)r))) {
                    c.setRaw(this.authService.substituteEmailAddress((String)r));
                } else if (r != null) {
                    c.setRaw(r.toString());
                } else {
                    c.setRaw("");
                }
                if (p instanceof String && !StringUtils.isEmpty((String)((String)p))) {
                    c.setProcessed(this.authService.substituteEmailAddress((String)p));
                } else if (p != null) {
                    c.setProcessed(p.toString());
                } else {
                    c.setProcessed("");
                }
                comparison.add(c);
            }
            groups.put(StringUtils.capitalize((String)((String)groupKey)), comparison);
        }
        return groups;
    }

    @RequestMapping(value={"/occurrence/compare*"}, method={RequestMethod.GET})
    @ResponseBody
    public Object compareOccurrenceVersions(@RequestParam(value="uuid", required=true) String uuid, HttpServletResponse response) throws Exception {
        return this.showOccurrence(uuid, response);
    }

    @RequestMapping(value={"/occurrence/deleted"}, method={RequestMethod.GET})
    @ResponseBody
    public String[] getDeleteOccurrences(@RequestParam(value="date", required=true) String fromDate, HttpServletResponse response) throws Exception {
        return new String[0];
    }

    private void sendCustomJSONResponse(HttpServletResponse response, int statusCode, Map<String, String> content) throws IOException {
        response.resetBuffer();
        response.setStatus(statusCode);
        response.setHeader("Content-Type", "application/json");
        response.getOutputStream().print(new ObjectMapper().writeValueAsString(content));
        response.flushBuffer();
    }

    @RequestMapping(value={"/occurrence/{uuid:.+}", "/occurrences/{uuid:.+}", "/occurrence/{uuid:.+}.json", "/occurrences/{uuid:.+}.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Object showOccurrence(@PathVariable(value="uuid") String uuid, @RequestParam(value="apiKey", required=false) String apiKey, @RequestParam(value="im", required=false) String im, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object responseObject = apiKey != null ? this.showSensitiveOccurrence(uuid, apiKey, im, request, response) : this.getOccurrenceInformation(uuid, im, request, false);
        if (responseObject == null) {
            this.sendCustomJSONResponse(response, 404, (Map)new /* Unavailable Anonymous Inner Class!! */);
        }
        return responseObject;
    }

    @RequestMapping(value={"/sensitive/occurrence/{uuid:.+}", "/sensitive/occurrences/{uuid:.+}", "/sensitive/occurrence/{uuid:.+}.json", "/senstive/occurrences/{uuid:.+}.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Object showSensitiveOccurrence(@PathVariable(value="uuid") String uuid, @RequestParam(value="apiKey", required=true) String apiKey, @RequestParam(value="im", required=false) String im, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.shouldPerformOperation(apiKey, response)) {
            return this.getOccurrenceInformation(uuid, im, request, true);
        }
        return null;
    }

    private Object getOccurrenceInformation(String uuid, String im, HttpServletRequest request, boolean includeSensitive) throws Exception {
        logger.debug((Object)("Retrieving occurrence record with guid: '" + uuid + "'"));
        String ip = this.getIPAddress(request);
        SpatialSearchRequestParams idRequest = new SpatialSearchRequestParams();
        idRequest.setQ("id:\"" + uuid + "\"");
        idRequest.setFacet(Boolean.valueOf(false));
        idRequest.setFl("*");
        SolrDocumentList sdl = this.searchDAO.findByFulltext(idRequest);
        if (sdl == null || sdl.isEmpty()) {
            return null;
        }
        SolrDocument sd = (SolrDocument)sdl.get(0);
        HashSet keys = new HashSet();
        keys.addAll(sd.keySet());
        for (String key : keys) {
            Object value = sd.getFieldValue(key);
            if (value == null) continue;
            boolean notJson = true;
            if (value instanceof String && ((String)value).startsWith("[")) {
                notJson = false;
                try {
                    String[] list = (String[])JSONArray.fromObject((Object)value).toArray((Object[])new String[0]);
                    boolean changed = false;
                    for (int i = 0; i < list.length; ++i) {
                        String v = list[i];
                        if (value.toString().contains("@")) {
                            list[i] = this.authService.substituteEmailAddress(value.toString());
                            changed = true;
                            continue;
                        }
                        if (!key.contains("user_id")) continue;
                        list[i] = this.authService.getDisplayNameFor(v);
                        changed = true;
                    }
                    if (changed) {
                        sd.setField(key, (Object)JSONArray.fromObject((Object)list).toString());
                    }
                }
                catch (Exception e) {
                    notJson = true;
                }
            }
            if (!notJson) continue;
            if (value.toString().contains("@") && (key.contains("recorded") || key.startsWith("_") || key.contains("collector"))) {
                sd.setField(key, (Object)this.authService.substituteEmailAddress(value.toString()));
                continue;
            }
            if (!(value instanceof String) || !key.contains("user_id")) continue;
            sd.setField(key, (Object)this.authService.getDisplayNameFor(value.toString()));
        }
        if (this.occurrenceLogEnabled) {
            this.logViewEvent(ip, sd, this.getUserAgent(request), null, "Viewing Occurrence Record " + uuid);
        }
        boolean includeImageMetadata = im == null || !im.equalsIgnoreCase("false");
        return this.mapAsFullRecord(sd, Boolean.valueOf(includeImageMetadata), Boolean.valueOf(includeSensitive));
    }

    private boolean isSensitive(SolrDocument doc) {
        String sensitiveValue = (String)doc.getFieldValue("sensitive");
        return sensitiveValue != null && (sensitiveValue.equals("generalised") || sensitiveValue.equals("alreadyGeneralised"));
    }

    private Map mapAsFullRecord(SolrDocument sd, Boolean includeImageMetadata, Boolean includeSensitive) throws Exception {
        Set schemaFields = this.indexDao.getSchemaFields();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Map raw = this.fullRecord(sd, fieldName -> schemaFields.contains(RAW_FIELD_PREFIX + fieldName) ? RAW_FIELD_PREFIX + fieldName : fieldName);
        Map processed = this.fullRecord(sd, fieldName -> schemaFields.contains(RAW_FIELD_PREFIX + fieldName) ? fieldName : null);
        this.addInstant(sd, raw, "lastModifiedTime", "lastLoadDate");
        this.addInstant(sd, processed, "lastModifiedTime", "lastProcessedDate");
        processed.put("el", this.extractLayerValues(sd, "el"));
        processed.put("cl", this.extractLayerValues(sd, "cl"));
        Map location = (Map)processed.get("location");
        location.put("marine", "Marine".equalsIgnoreCase(String.valueOf(sd.getFieldValue("biome"))));
        location.put("terrestrial", "Terrestrial".equalsIgnoreCase(String.valueOf(sd.getFieldValue("biome"))));
        Map occurrence = (Map)processed.get("occurrence");
        String duplicateStatus = (String)sd.getFieldValue("duplicateStatus");
        occurrence.put("duplicateStatus", duplicateStatus);
        if ("REPRESENTATIVE".equals(duplicateStatus)) {
            occurrence.put("duplicationStatus", LEGACY_REPRESENTATIVE_RECORD_VALUE);
        } else if ("ASSOCIATED".equals(duplicateStatus)) {
            occurrence.put("duplicationStatus", LEGACY_DUPLICATE_RECORD_VALUE);
        }
        Collection outlierLayer = sd.getFieldValues("outlierLayer");
        if (outlierLayer != null) {
            occurrence.put("outlierForLayers", outlierLayer);
        }
        raw.put("miscProperties", this.extractMiscProperties(sd));
        map.put("raw", raw);
        map.put("processed", processed);
        map.put("systemAssertions", this.systemAssertions(sd));
        map.put("userAssertions", this.userAssertions(sd));
        map.put("alaUserId", sd.getFieldValue("userId"));
        if (includeSensitive.booleanValue() && this.isSensitive(sd)) {
            Map rawLocation = (Map)raw.get("location");
            Map rawEvent = (Map)raw.get("event");
            this.addField(sd, rawLocation, "dataGeneralizations", "sensitive_dataGeneralizations");
            this.addField(sd, rawLocation, "decimalLatitude", "sensitive_decimalLatitude");
            this.addField(sd, rawLocation, "decimalLongitude", "sensitive_decimalLongitude");
            this.addField(sd, rawLocation, "footprintWKT", "sensitive_footprintWKT");
            this.addField(sd, rawLocation, "locality", "sensitive_locality");
            this.addField(sd, rawLocation, "locationRemarks", "sensitive_locationRemarks");
            this.addField(sd, rawLocation, "verbatimCoordinates", "sensitive_verbatimCoordinates");
            this.addField(sd, rawLocation, "verbatimLatitude", "sensitive_verbatimLatitude");
            this.addField(sd, rawLocation, "verbatimLocality", "sensitive_verbatimLocality");
            this.addField(sd, rawLocation, "verbatimLongitude", "sensitive_verbatimLongitude");
            this.addField(sd, rawEvent, "day", "sensitive_day");
            this.addField(sd, rawEvent, "eventDate", "sensitive_eventDate");
            this.addField(sd, rawEvent, "eventDate", "sensitive_eventDate");
            this.addField(sd, rawEvent, "eventID", "sensitive_eventID");
            this.addField(sd, rawEvent, "eventTime", "sensitive_eventTime");
            this.addField(sd, rawEvent, "month", "sensitive_month");
            this.addField(sd, rawEvent, "verbatimEventDate", "sensitive_verbatimEventDate");
        }
        this.addImages(sd, map, "imageIDs", "images", includeImageMetadata.booleanValue());
        this.addSounds(sd, map, "soundIDs", "sounds");
        return map;
    }

    private Map<String, Object> extractMiscProperties(SolrDocument sd) {
        HashMap<String, Object> miscProperties = new HashMap<String, Object>();
        try {
            ObjectMapper om = new ObjectMapper();
            Map jsonProperties = (Map)om.readValue((String)sd.getFieldValue(DwcTerm.dynamicProperties.simpleName()), Map.class);
            miscProperties.putAll(jsonProperties);
        }
        catch (Exception om) {
            // empty catch block
        }
        List dynamicProperties = sd.getFieldNames().stream().filter(fieldName -> fieldName.startsWith(DYNAMIC_PROPERTIES_PREFIX)).collect(Collectors.toList());
        for (String property : dynamicProperties) {
            String fieldName2 = property.replaceAll(DYNAMIC_PROPERTIES_PREFIX, "");
            miscProperties.put(fieldName2, sd.get((Object)property));
        }
        return miscProperties;
    }

    private Map extractLayerValues(SolrDocument sd, String key) {
        HashMap map = new HashMap();
        String regex = "^" + key + "[0-9]+$";
        for (Map.Entry es : sd.entrySet()) {
            if (!((String)es.getKey()).matches(regex)) continue;
            map.put(es.getKey(), es.getValue());
        }
        return map;
    }

    private void addField(SolrDocument sd, Map map, String fieldName, Function<String, String> getFieldName) {
        this.addField(sd, map, fieldName, getFieldName.apply(fieldName));
    }

    private void addField(SolrDocument sd, Map map, String fieldNameToUser, String fieldName) {
        map.put(fieldNameToUser, sd.getFieldValue(fieldName));
    }

    private void addAll(SolrDocument sd, Map map, String fieldName, Function<String, String> getFieldName) {
        map.put(fieldName, StringUtils.join((Collection)sd.getFieldValues(getFieldName.apply(fieldName)), (String)"|"));
    }

    private void addLocalDate(SolrDocument sd, Map map, String fieldName, Function<String, String> getFieldName) {
        this.addLocalDate(sd, map, fieldName, getFieldName.apply(fieldName));
    }

    private void addLocalDate(SolrDocument sd, Map map, String fieldNameToUse, String fieldName) {
        Object value = sd.getFieldValue(fieldName);
        if (value != null && value instanceof Date) {
            LocalDate localDate = ((Date)value).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            map.put(fieldNameToUse, localDate.toString());
        }
    }

    private void addInstant(SolrDocument sd, Map map, String fieldNameToUse, String fieldName) {
        Object value = sd.getFieldValue(fieldName);
        if (value != null && value instanceof Date) {
            Instant instant = ((Date)value).toInstant();
            map.put(fieldNameToUse, instant.toString());
        }
    }

    private void addSounds(SolrDocument sd, Map map, String srcKey, String dstKey) {
        Collection value = sd.getFieldValues(srcKey);
        if (value != null && !value.isEmpty()) {
            List strings = value.stream().map(object -> Objects.toString(object, null)).collect(Collectors.toList());
            if (value != null) {
                ArrayList<MediaDTO> mediaDTOs = new ArrayList<MediaDTO>();
                for (String soundID : strings) {
                    MediaDTO m = new MediaDTO();
                    m.getAlternativeFormats().put("audio/mpeg", this.remoteMediaStoreUrl + "/image/proxyImage?imageId=" + soundID);
                    mediaDTOs.add(m);
                }
                map.put(dstKey, mediaDTOs);
            }
        }
    }

    private void addImageUrls(SolrDocument sd, Map map, String srcKey, String dstKey) {
        Collection value = sd.getFieldValues(srcKey);
        if (value != null && !value.isEmpty()) {
            List imageIds = value.stream().map(object -> Objects.toString(object, null)).filter(str -> str != null).map(imageId -> this.remoteMediaStoreUrl + "/image/proxyImage?imageId=" + imageId).collect(Collectors.toList());
            map.put(dstKey, imageIds);
        }
    }

    private void addImages(SolrDocument sd, Map map, String srcKey, String dstKey, boolean lookupImageMetadata) {
        Collection value = sd.getFieldValues(srcKey);
        if (value != null && !value.isEmpty()) {
            List strings = value.stream().map(object -> Objects.toString(object, null)).collect(Collectors.toList());
            if (value != null) {
                String id = (String)sd.getFieldValue("id");
                List mediaDTOs = this.setupImageUrls(id, strings, lookupImageMetadata);
                map.put(dstKey, mediaDTOs);
            }
        }
    }

    private List<Map<String, Object>> userAssertions(SolrDocument sd) throws IOException {
        String occurrenceId = (String)sd.getFieldValue("id");
        UserAssertions userAssertions = this.assertionService.getAssertions(occurrenceId);
        if (userAssertions == null) {
            return new ArrayList<Map<String, Object>>();
        }
        return userAssertions.stream().map(qa -> {
            4 userAssertion = new /* Unavailable Anonymous Inner Class!! */;
            if (qa.getUserId().contains("@")) {
                String email = qa.getUserId();
                String userId = (String)this.authService.getMapOfEmailToId().get(email);
                userAssertion.put("userId", userId);
                userAssertion.put("userEmail", this.authService.substituteEmailAddress(email));
                userAssertion.put("userDisplayName", this.authService.getDisplayNameFor(userId));
            }
            return userAssertion;
        }).collect(Collectors.toList());
    }

    Map fullRecord(SolrDocument sd, Function<String, String> getFieldName) {
        LinkedHashMap<String, Object> fullRecord = new LinkedHashMap<String, Object>();
        fullRecord.put("rowKey", sd.getFieldValue("id"));
        fullRecord.put("uuid", sd.getFieldValue("id"));
        HashMap occurrence = new HashMap();
        fullRecord.put("occurrence", occurrence);
        this.addField(sd, occurrence, "occurrenceID", getFieldName);
        this.addField(sd, occurrence, "accessRights", getFieldName);
        this.addField(sd, occurrence, "associatedMedia", getFieldName);
        this.addField(sd, occurrence, "associatedOccurrences", getFieldName);
        this.addField(sd, occurrence, "associatedOrganisms", getFieldName);
        this.addField(sd, occurrence, "associatedReferences", getFieldName);
        this.addField(sd, occurrence, "associatedSequences", getFieldName);
        this.addField(sd, occurrence, "associatedTaxa", getFieldName);
        this.addField(sd, occurrence, "basisOfRecord", getFieldName);
        this.addField(sd, occurrence, "behavior", getFieldName);
        this.addField(sd, occurrence, "bibliographicCitation", getFieldName);
        this.addField(sd, occurrence, "catalogNumber", getFieldName);
        this.addField(sd, occurrence, "collectionCode", getFieldName);
        this.addField(sd, occurrence, "collectionID", getFieldName);
        this.addField(sd, occurrence, "dataGeneralizations", getFieldName);
        this.addField(sd, occurrence, "datasetID", getFieldName);
        this.addField(sd, occurrence, "datasetName", getFieldName);
        this.addField(sd, occurrence, "disposition", getFieldName);
        this.addField(sd, occurrence, "establishmentMeans", getFieldName);
        this.addField(sd, occurrence, "fieldNotes", getFieldName);
        this.addField(sd, occurrence, "fieldNumber", getFieldName);
        this.addField(sd, occurrence, "individualCount", getFieldName);
        this.addField(sd, occurrence, "informationWithheld", getFieldName);
        this.addField(sd, occurrence, "institutionCode", getFieldName);
        this.addField(sd, occurrence, "institutionID", getFieldName);
        this.addField(sd, occurrence, "language", getFieldName);
        this.addField(sd, occurrence, "lifeStage", getFieldName);
        this.addField(sd, occurrence, "modified", getFieldName);
        this.addField(sd, occurrence, "occurrenceAttributes", getFieldName);
        this.addField(sd, occurrence, "occurrenceDetails", getFieldName);
        this.addField(sd, occurrence, "occurrenceRemarks", getFieldName);
        this.addField(sd, occurrence, "occurrenceStatus", getFieldName);
        this.addField(sd, occurrence, "organismName", getFieldName);
        this.addField(sd, occurrence, "organismQuantity", getFieldName);
        this.addField(sd, occurrence, "organismQuantityType", getFieldName);
        this.addField(sd, occurrence, "organismRemarks", getFieldName);
        this.addField(sd, occurrence, "organismScope", getFieldName);
        this.addField(sd, occurrence, "organismID", getFieldName);
        this.addField(sd, occurrence, "otherCatalogNumbers", getFieldName);
        this.addField(sd, occurrence, "ownerInstitutionCode", getFieldName);
        this.addAll(sd, occurrence, "preparations", getFieldName);
        this.addField(sd, occurrence, "previousIdentifications", getFieldName);
        this.addField(sd, occurrence, "recordNumber", getFieldName);
        this.addField(sd, occurrence, "relatedResourceID", getFieldName);
        this.addField(sd, occurrence, "relationshipAccordingTo", getFieldName);
        this.addField(sd, occurrence, "relationshipEstablishedDate", getFieldName);
        this.addField(sd, occurrence, "relationshipOfResource", getFieldName);
        this.addField(sd, occurrence, "relationshipRemarks", getFieldName);
        this.addField(sd, occurrence, "reproductiveCondition", getFieldName);
        this.addField(sd, occurrence, "resourceID", getFieldName);
        this.addField(sd, occurrence, "resourceRelationshipID", getFieldName);
        this.addField(sd, occurrence, "rights", getFieldName);
        this.addField(sd, occurrence, "rightsHolder", getFieldName);
        this.addField(sd, occurrence, "samplingProtocol", getFieldName);
        this.addField(sd, occurrence, "samplingEffort", getFieldName);
        this.addField(sd, occurrence, "sex", getFieldName);
        this.addField(sd, occurrence, "source", getFieldName);
        this.addField(sd, occurrence, "userId", getFieldName);
        this.addField(sd, occurrence, "collectorFieldNumber", getFieldName);
        this.addField(sd, occurrence, "cultivated", getFieldName);
        this.addField(sd, occurrence, "duplicates", getFieldName);
        this.addField(sd, occurrence, "duplicatesOriginalInstitutionID", getFieldName);
        this.addField(sd, occurrence, "duplicatesOriginalUnitID", getFieldName);
        this.addField(sd, occurrence, "loanIdentifier", getFieldName);
        this.addField(sd, occurrence, "loanSequenceNumber", getFieldName);
        this.addField(sd, occurrence, "loanDestination", getFieldName);
        this.addField(sd, occurrence, "loanForBotanist", getFieldName);
        this.addField(sd, occurrence, "loanDate", getFieldName);
        this.addField(sd, occurrence, "loanReturnDate", getFieldName);
        this.addField(sd, occurrence, "phenology", getFieldName);
        this.addField(sd, occurrence, "preferredFlag", getFieldName);
        this.addField(sd, occurrence, "secondaryCollectors", getFieldName);
        this.addField(sd, occurrence, "naturalOccurrence", getFieldName);
        this.addField(sd, occurrence, "validDistribution", getFieldName);
        this.addField(sd, occurrence, "sounds", "soundIDs");
        this.addField(sd, occurrence, "videos", "videoIDs");
        this.addImageUrls(sd, occurrence, "imageIDs", "images");
        this.addField(sd, occurrence, "interactions", getFieldName);
        this.addField(sd, occurrence, "countryConservation", getFieldName);
        this.addField(sd, occurrence, "stateConservation", getFieldName);
        this.addField(sd, occurrence, "globalConservation", getFieldName);
        this.addField(sd, occurrence, "photographer", getFieldName);
        this.addField(sd, occurrence, "stateInvasive", getFieldName);
        this.addField(sd, occurrence, "countryInvasive", getFieldName);
        this.addAll(sd, occurrence, "recordedBy", getFieldName);
        this.addAll(sd, occurrence, "recordedByID", getFieldName);
        this.addAll(sd, occurrence, "identifiedByID", getFieldName);
        HashMap classification = new HashMap();
        fullRecord.put("classification", classification);
        this.addField(sd, classification, "scientificName", getFieldName);
        this.addField(sd, classification, "scientificNameAuthorship", getFieldName);
        this.addField(sd, classification, "scientificNameID", getFieldName);
        this.addField(sd, classification, "taxonConceptID", getFieldName);
        this.addField(sd, classification, "taxonID", getFieldName);
        this.addField(sd, classification, "kingdom", getFieldName);
        this.addField(sd, classification, "phylum", getFieldName);
        this.addField(sd, classification, "classs", getFieldName.apply("class"));
        this.addField(sd, classification, "order", getFieldName);
        this.addField(sd, classification, "superfamily", getFieldName);
        this.addField(sd, classification, "family", getFieldName);
        this.addField(sd, classification, "subfamily", getFieldName);
        this.addField(sd, classification, "genus", getFieldName);
        this.addField(sd, classification, "subgenus", getFieldName);
        this.addField(sd, classification, "species", getFieldName);
        this.addField(sd, classification, "specificEpithet", getFieldName);
        this.addField(sd, classification, "subspecies", getFieldName);
        this.addField(sd, classification, "infraspecificEpithet", getFieldName);
        this.addField(sd, classification, "infraspecificMarker", getFieldName);
        this.addField(sd, classification, "cultivarName", getFieldName);
        this.addField(sd, classification, "higherClassification", getFieldName);
        this.addField(sd, classification, "parentNameUsage", getFieldName);
        this.addField(sd, classification, "parentNameUsageID", getFieldName);
        this.addField(sd, classification, "acceptedNameUsage", getFieldName);
        this.addField(sd, classification, "acceptedNameUsageID", getFieldName);
        this.addField(sd, classification, "originalNameUsage", getFieldName);
        this.addField(sd, classification, "originalNameUsageID", getFieldName);
        this.addField(sd, classification, "taxonRank", getFieldName);
        this.addField(sd, classification, "taxonomicStatus", getFieldName);
        this.addField(sd, classification, "taxonRemarks", getFieldName);
        this.addField(sd, classification, "verbatimTaxonRank", getFieldName);
        this.addField(sd, classification, "vernacularName", getFieldName);
        this.addField(sd, classification, "nameAccordingTo", getFieldName);
        this.addField(sd, classification, "nameAccordingToID", getFieldName);
        this.addField(sd, classification, "namePublishedIn", getFieldName);
        this.addField(sd, classification, "namePublishedInYear", getFieldName);
        this.addField(sd, classification, "namePublishedInID", getFieldName);
        this.addField(sd, classification, "nomenclaturalCode", getFieldName);
        this.addField(sd, classification, "nomenclaturalStatus", getFieldName);
        this.addField(sd, classification, "scientificNameWithoutAuthor", getFieldName);
        this.addField(sd, classification, "scientificNameAddendum", getFieldName);
        this.addField(sd, classification, "taxonRankID", getFieldName);
        this.addField(sd, classification, "kingdomID", getFieldName);
        this.addField(sd, classification, "phylumID", getFieldName);
        this.addField(sd, classification, "classID", getFieldName);
        this.addField(sd, classification, "orderID", getFieldName);
        this.addField(sd, classification, "familyID", getFieldName);
        this.addField(sd, classification, "genusID", getFieldName);
        this.addField(sd, classification, "subgenusID", getFieldName);
        this.addField(sd, classification, "speciesID", getFieldName);
        this.addField(sd, classification, "subspeciesID", getFieldName);
        this.addField(sd, classification, "left", getFieldName.apply("lft"));
        this.addField(sd, classification, "right", getFieldName.apply("rgt"));
        this.addField(sd, classification, "speciesHabitats", getFieldName);
        this.addField(sd, classification, "speciesGroups", getFieldName);
        this.addField(sd, classification, "matchType", getFieldName);
        this.addField(sd, classification, "taxonomicIssues", getFieldName);
        this.addField(sd, classification, "nameType", getFieldName);
        HashMap<String, Boolean> location = new HashMap<String, Boolean>();
        fullRecord.put("location", location);
        this.addField(sd, location, "continent", getFieldName);
        this.addField(sd, location, "coordinatePrecision", getFieldName);
        this.addField(sd, location, "coordinateUncertaintyInMeters", getFieldName);
        this.addField(sd, location, "country", getFieldName);
        this.addField(sd, location, "countryCode", getFieldName);
        this.addField(sd, location, "county", getFieldName);
        this.addField(sd, location, "decimalLatitude", getFieldName);
        this.addField(sd, location, "decimalLongitude", getFieldName);
        this.addField(sd, location, "footprintSpatialFit", getFieldName);
        this.addField(sd, location, "footprintWKT", getFieldName);
        this.addField(sd, location, "footprintSRS", getFieldName);
        this.addField(sd, location, "geodeticDatum", getFieldName);
        this.addField(sd, location, "georeferencedBy", getFieldName);
        this.addField(sd, location, "georeferencedDate", getFieldName);
        this.addField(sd, location, "georeferenceProtocol", getFieldName);
        this.addField(sd, location, "georeferenceRemarks", getFieldName);
        this.addField(sd, location, "georeferenceSources", getFieldName);
        this.addField(sd, location, "georeferenceVerificationStatus", getFieldName);
        this.addField(sd, location, "habitat", getFieldName);
        this.addField(sd, location, "biome", getFieldName);
        this.addField(sd, location, "higherGeography", getFieldName);
        this.addField(sd, location, "higherGeographyID", getFieldName);
        this.addField(sd, location, "island", getFieldName);
        this.addField(sd, location, "islandGroup", getFieldName);
        this.addField(sd, location, "locality", getFieldName);
        this.addField(sd, location, "locationAccordingTo", getFieldName);
        this.addField(sd, location, "locationAttributes", getFieldName);
        this.addField(sd, location, "locationID", getFieldName);
        this.addField(sd, location, "locationRemarks", getFieldName);
        this.addField(sd, location, "maximumDepthInMeters", getFieldName);
        this.addField(sd, location, "maximumDistanceAboveSurfaceInMeters", getFieldName);
        this.addField(sd, location, "maximumElevationInMeters", getFieldName);
        this.addField(sd, location, "minimumDepthInMeters", getFieldName);
        this.addField(sd, location, "minimumDistanceAboveSurfaceInMeters", getFieldName);
        this.addField(sd, location, "minimumElevationInMeters", getFieldName);
        this.addField(sd, location, "municipality", getFieldName);
        this.addField(sd, location, "pointRadiusSpatialFit", getFieldName);
        this.addField(sd, location, "stateProvince", getFieldName);
        this.addField(sd, location, "verbatimCoordinates", getFieldName);
        this.addField(sd, location, "verbatimCoordinateSystem", getFieldName);
        this.addField(sd, location, "verbatimDepth", getFieldName);
        this.addField(sd, location, "verbatimElevation", getFieldName);
        this.addField(sd, location, "verbatimLatitude", getFieldName);
        this.addField(sd, location, "verbatimLocality", getFieldName);
        this.addField(sd, location, "verbatimLongitude", getFieldName);
        this.addField(sd, location, "verbatimSRS", getFieldName);
        this.addField(sd, location, "waterBody", getFieldName);
        this.addField(sd, location, "lga", getFieldName);
        this.addField(sd, location, "generalisedLocality", getFieldName);
        this.addField(sd, location, "nearNamedPlaceRelationTo", getFieldName);
        this.addField(sd, location, "australianHerbariumRegion", getFieldName);
        this.addField(sd, location, "distanceOutsideExpertRange", getFieldName);
        this.addField(sd, location, "easting", getFieldName);
        this.addField(sd, location, "northing", getFieldName);
        this.addField(sd, location, "zone", getFieldName);
        this.addField(sd, location, "gridReference", getFieldName);
        this.addField(sd, location, "bbox", getFieldName);
        location.put("marine", "Marine".equalsIgnoreCase(String.valueOf(sd.getFieldValue("biome"))));
        location.put("terrestrial", "Terrestrial".equalsIgnoreCase(String.valueOf(sd.getFieldValue("biome"))));
        HashMap event = new HashMap();
        fullRecord.put("event", event);
        this.addField(sd, event, "day", getFieldName);
        this.addField(sd, event, "endDayOfYear", getFieldName);
        this.addField(sd, event, "eventAttributes", getFieldName);
        this.addLocalDate(sd, event, "eventDate", getFieldName);
        this.addLocalDate(sd, event, "eventDateEnd", getFieldName);
        this.addField(sd, event, "eventRemarks", getFieldName);
        this.addField(sd, event, "eventTime", getFieldName);
        this.addField(sd, event, "verbatimEventDate", getFieldName);
        this.addField(sd, event, "year", getFieldName);
        this.addField(sd, event, "month", getFieldName);
        this.addField(sd, event, "startDayOfYear", getFieldName);
        this.addField(sd, event, "startYear", getFieldName);
        this.addField(sd, event, "endYear", getFieldName);
        this.addField(sd, event, "datePrecision", getFieldName);
        HashMap attribution = new HashMap();
        fullRecord.put("attribution", attribution);
        this.addField(sd, attribution, "dataResourceName", getFieldName);
        this.addField(sd, attribution, "dataResourceUid", "dataResourceUid");
        this.addField(sd, attribution, "dataProviderUid", getFieldName);
        this.addField(sd, attribution, "dataProviderName", getFieldName);
        this.addField(sd, attribution, "collectionUid", getFieldName);
        this.addField(sd, attribution, "institutionUid", getFieldName);
        this.addField(sd, attribution, "dataHubUid", getFieldName);
        this.addField(sd, attribution, "dataHubName", getFieldName);
        this.addField(sd, attribution, "institutionName", getFieldName);
        this.addField(sd, attribution, "collectionName", getFieldName);
        this.addField(sd, attribution, "citation", getFieldName);
        this.addField(sd, attribution, "provenance", getFieldName);
        this.addField(sd, attribution, "license", getFieldName);
        HashMap identification = new HashMap();
        fullRecord.put("identification", identification);
        this.addField(sd, identification, "dateIdentified", getFieldName);
        this.addField(sd, identification, "identificationAttributes", getFieldName);
        this.addField(sd, identification, "identificationID", getFieldName);
        this.addField(sd, identification, "identificationQualifier", getFieldName);
        this.addField(sd, identification, "identificationReferences", getFieldName);
        this.addField(sd, identification, "identificationRemarks", getFieldName);
        this.addField(sd, identification, "identificationVerificationStatus", getFieldName);
        this.addField(sd, identification, "identifiedBy", getFieldName);
        this.addField(sd, identification, "identifierRole", getFieldName);
        this.addField(sd, identification, "typeStatus", getFieldName);
        this.addField(sd, identification, "abcdTypeStatus", getFieldName);
        this.addField(sd, identification, "typeStatusQualifier", getFieldName);
        this.addField(sd, identification, "typifiedName", getFieldName);
        this.addField(sd, identification, "verbatimDateIdentified", getFieldName);
        this.addField(sd, identification, "verifier", getFieldName);
        this.addField(sd, identification, "verificationDate", getFieldName);
        this.addField(sd, identification, "verificationNotes", getFieldName);
        this.addField(sd, identification, "abcdIdentificationQualifier", getFieldName);
        this.addField(sd, identification, "abcdIdentificationQualifierInsertionPoint", getFieldName);
        HashMap measurement = new HashMap();
        fullRecord.put("measurement", measurement);
        this.addField(sd, measurement, "measurementAccuracy", getFieldName);
        this.addField(sd, measurement, "measurementDeterminedBy", getFieldName);
        this.addField(sd, measurement, "measurementDeterminedDate", getFieldName);
        this.addField(sd, measurement, "measurementID", getFieldName);
        this.addField(sd, measurement, "measurementMethod", getFieldName);
        this.addField(sd, measurement, "measurementRemarks", getFieldName);
        this.addField(sd, measurement, "measurementType", getFieldName);
        this.addField(sd, measurement, "measurementUnit", getFieldName);
        this.addField(sd, measurement, "measurementValue", getFieldName);
        this.addField(sd, fullRecord, "assertions", getFieldName);
        HashMap miscProperties = new HashMap();
        fullRecord.put("miscProperties", miscProperties);
        this.addField(sd, miscProperties, "references", getFieldName);
        this.addField(sd, miscProperties, "numIdentificationAgreements", getFieldName);
        HashMap queryAssertions = new HashMap();
        fullRecord.put("queryAssertions", queryAssertions);
        this.addField(sd, fullRecord, "userQualityAssertion", getFieldName);
        this.addField(sd, fullRecord, "hasUserAssertions", getFieldName);
        this.addField(sd, fullRecord, "userAssertionStatus", getFieldName.apply("userAssertions"));
        this.addField(sd, fullRecord, "assertionUserId", getFieldName);
        this.addField(sd, fullRecord, "locationDetermined", getFieldName);
        this.addField(sd, fullRecord, "defaultValuesUsed", getFieldName);
        this.addField(sd, fullRecord, "spatiallyValid", getFieldName);
        fullRecord.put("geospatiallyKosher", (Boolean)sd.getFieldValue("spatiallyValid"));
        fullRecord.put("taxonomicallyKosher", "");
        fullRecord.put("deleted", false);
        this.addField(sd, fullRecord, "userVerified", getFieldName);
        this.addInstant(sd, fullRecord, "firstLoaded", getFieldName.apply("firstLoadedDate"));
        this.addInstant(sd, fullRecord, "lastUserAssertionDate", getFieldName.apply("lastAssertionDate"));
        fullRecord.put("dateDeleted", "");
        return fullRecord;
    }

    private Map systemAssertions(SolrDocument sd) {
        List assertions = (List)sd.getFieldValue("assertions");
        ArrayList<ErrorCode> unchecked = new ArrayList<ErrorCode>();
        List<Object> warning = new ArrayList();
        List<Object> missing = new ArrayList<ErrorCode>();
        List<Object> passed = new ArrayList();
        ArrayList<ErrorCode> allErrorCodes = new ArrayList<ErrorCode>(Arrays.asList(AssertionCodes.getAll()));
        ArrayList<ErrorCode> flaggedErrors = new ArrayList<ErrorCode>();
        if (assertions != null) {
            for (Object assertion : assertions) {
                ErrorCode ec = AssertionCodes.getByName((String)((String)assertion));
                if (ec == null) continue;
                flaggedErrors.add(ec);
                if (ErrorCode.Category.Missing.toString().equalsIgnoreCase(ec.getCategory()) || ec.getName().toLowerCase(Locale.ROOT).startsWith("missing")) {
                    missing.add(ec);
                    continue;
                }
                warning.add(ec);
            }
        }
        for (ErrorCode errorCode : allErrorCodes) {
            if (flaggedErrors.contains(errorCode)) continue;
            if (this.hasRequiredTerms(errorCode, sd)) {
                passed.add(errorCode);
                continue;
            }
            unchecked.add(errorCode);
        }
        passed = passed.stream().sorted(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
        warning = warning.stream().sorted(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
        missing = missing.stream().sorted(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
        HashMap<String, List<Object>> systemAssertions = new HashMap<String, List<Object>>();
        systemAssertions.put("missing", missing);
        systemAssertions.put("passed", passed);
        systemAssertions.put("warning", warning);
        systemAssertions.put("unchecked", unchecked);
        return systemAssertions;
    }

    boolean hasRequiredTerms(ErrorCode errorCode, SolrDocument sd) {
        if (errorCode.getTermsRequiredToTest().isEmpty()) {
            return true;
        }
        for (String term : errorCode.getTermsRequiredToTest()) {
            Object termValue = sd.getFieldValue(term);
            Object rawTermValue = sd.getFieldValue(RAW_FIELD_PREFIX + term);
            if (Objects.nonNull(termValue) && termValue instanceof String) {
                if (StringUtils.isNotBlank((String)((String)termValue))) {
                    return true;
                }
                return true;
            }
            if (!Objects.nonNull(rawTermValue) || !(rawTermValue instanceof String)) continue;
            if (StringUtils.isNotBlank((String)((String)rawTermValue))) {
                return true;
            }
            return true;
        }
        return false;
    }

    private void logViewEvent(String ip, SolrDocument occ, String userAgent, String email, String reason) {
        ConcurrentHashMap<String, AtomicInteger> uidStats = new ConcurrentHashMap<String, AtomicInteger>();
        String collectionUid = (String)occ.getFieldValue("collectionUid");
        String institutionUid = (String)occ.getFieldValue("institutionUid");
        String dataProviderUid = (String)occ.getFieldValue("dataProviderUid");
        String dataResourceUid = (String)occ.getFieldValue("dataResourceUid");
        if (StringUtils.isNotEmpty((String)collectionUid)) {
            uidStats.put(collectionUid, new AtomicInteger(1));
        }
        if (StringUtils.isNotEmpty((String)institutionUid)) {
            uidStats.put(institutionUid, new AtomicInteger(1));
        }
        if (StringUtils.isNotEmpty((String)dataProviderUid)) {
            uidStats.put(dataProviderUid, new AtomicInteger(1));
        }
        if (StringUtils.isNotEmpty((String)dataResourceUid)) {
            uidStats.put(dataResourceUid, new AtomicInteger(1));
        }
        if (uidStats != null) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String key : uidStats.keySet()) {
                if (((AtomicInteger)uidStats.get(key)).get() >= 0) continue;
                toRemove.add(key);
            }
            for (String key : toRemove) {
                uidStats.remove(key);
            }
        }
        LogEventVO vo = new LogEventVO(LogEventType.OCCURRENCE_RECORDS_VIEWED, email, reason, ip, uidStats);
        vo.setUserAgent(userAgent);
        this.loggerService.logEvent(vo);
    }

    private String getValidationErrorMessage(BindingResult result) {
        StringBuilder sb = new StringBuilder();
        List errors = result.getAllErrors();
        for (ObjectError error : errors) {
            logger.debug((Object)("Code: " + error.getCode()));
            logger.debug((Object)StringUtils.join((Object[])error.getCodes(), (String)"@#$^"));
            String code = error.getCodes() != null && error.getCodes().length > 0 ? error.getCodes()[0] : null;
            logger.debug((Object)("The code in use:" + code));
            sb.append(this.messageSource.getMessage(code, null, error.getDefaultMessage(), null)).append("<br/>");
        }
        return sb.toString();
    }

    private List<MediaDTO> setupImageUrls(String uuid, List<String> imageIDs, boolean lookupImageMetadata) {
        if (imageIDs != null && !imageIDs.isEmpty()) {
            ArrayList<MediaDTO> ml = new ArrayList<MediaDTO>();
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            if (lookupImageMetadata) {
                try {
                    List list = (List)this.imageMetadataService.getImageMetadataForOccurrences(Arrays.asList(uuid)).get(uuid);
                    if (list != null) {
                        for (Object m : list) {
                            metadata.put(String.valueOf(m.get("imageId")), m);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (String fileNameOrID : imageIDs) {
                try {
                    Object m;
                    m = new MediaDTO();
                    Map urls = this.occurrenceUtils.getImageFormats(fileNameOrID);
                    m.getAlternativeFormats().put("thumbnailUrl", urls.get("thumb"));
                    m.getAlternativeFormats().put("smallImageUrl", urls.get("small"));
                    m.getAlternativeFormats().put("largeImageUrl", urls.get("large"));
                    m.getAlternativeFormats().put("imageUrl", urls.get("raw"));
                    m.setFilePath(fileNameOrID);
                    m.setMetadataUrl(this.imageMetadataService.getUrlFor(fileNameOrID));
                    if (metadata != null && metadata.get(fileNameOrID) != null) {
                        m.setMetadata((Map)metadata.get(fileNameOrID));
                    }
                    ml.add((MediaDTO)m);
                }
                catch (Exception ex) {
                    logger.warn((Object)("Unable to get image data for " + fileNameOrID + ": " + ex.getMessage()));
                }
            }
            return ml;
        }
        return null;
    }

    @Deprecated
    @RequestMapping(value={"occurrence/pivot"})
    @ResponseBody
    public List<FacetPivotResultDTO> searchPivot(SpatialSearchRequestParams searchParams, @RequestParam(value="apiKey", required=true) String apiKey, HttpServletResponse response) throws Exception {
        if (this.isValidKey(apiKey)) {
            return this.searchDAO.searchPivot(searchParams);
        }
        response.sendError(403, "An invalid API Key was provided.");
        return null;
    }

    @Deprecated
    @RequestMapping(value={"occurrences/facets/available"})
    @ResponseBody
    public List<String> listFacets(SpatialSearchRequestParams searchParams, @RequestParam(value="apiKey", required=true) String apiKey, HttpServletResponse response) throws Exception {
        if (this.isValidKey(apiKey)) {
            return this.searchDAO.listFacets(searchParams);
        }
        response.sendError(403, "An invalid API Key was provided.");
        return null;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

