/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.SpeciesGroupDTO;
import au.org.ala.biocache.dto.TaxaCountDTO;
import au.org.ala.biocache.util.QueryFormatUtils;
import com.ctc.wstx.util.URLUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.opengis.metadata.identification.CharacterSet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="exploreController")
public class ExploreController {
    private static final Logger logger = Logger.getLogger(ExploreController.class);
    @Inject
    protected SearchDAO searchDao;
    @Inject
    protected QueryFormatUtils queryFormatUtils;
    @Value(value="${species.subgroups.url:/data/biocache/config/subgroups.json}")
    protected String speciesSubgroupsUrl;
    private String speciesSubgroups = null;
    @Value(value="${species.groups.url:/data/biocache/config/groups.json}")
    protected String speciesGroupsUrl;
    private String speciesGroups = null;
    public static final HashMap<Float, Integer> radiusToZoomLevelMap = new HashMap();

    public String getSubgroupsConfig() {
        if (this.speciesSubgroups == null) {
            this.speciesSubgroups = this.getStringFromPath(this.speciesSubgroupsUrl);
        }
        return this.speciesSubgroups;
    }

    public String getGroupsConfig() {
        if (this.speciesGroups == null) {
            this.speciesGroups = this.getStringFromPath(this.speciesGroupsUrl);
        }
        return this.speciesGroups;
    }

    private String getStringFromPath(String path) {
        String result = null;
        try {
            result = path.startsWith("http") ? StreamUtils.copyToString((InputStream)URLUtil.inputStreamFromURL((URL)new URL(path)), (Charset)CharacterSet.UTF_8.toCharset()) : FileUtils.readFileToString((File)new File(path), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error((Object)("Exception reading from species.subgroups.url: " + this.speciesSubgroups), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/explore/hierarchy"}, method={RequestMethod.GET})
    public void getHierarchy(HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(this.getSubgroupsConfig().getBytes(StandardCharsets.UTF_8));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/explore/hierarchy/groups*"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<SpeciesGroupDTO> yourHierarchicalAreaView(SpatialSearchRequestParams requestParams, String speciesGroup) throws Exception {
        JSONArray ssgs = JSONArray.fromObject((Object)this.getSubgroupsConfig());
        LinkedHashMap<String, SpeciesGroupDTO> parentGroupMap = new LinkedHashMap<String, SpeciesGroupDTO>();
        HashMap parentLookup = new HashMap();
        ssgs.stream().forEach(sg -> ((JSONArray)((JSONObject)sg).get("taxa")).stream().forEach(ssg -> parentLookup.put(((JSONObject)ssg).getString("common").toLowerCase(), ((JSONObject)sg).getString("speciesGroup"))));
        requestParams.setFormattedQuery(null);
        requestParams.setFacets(new String[]{"speciesSubgroup"});
        requestParams.setFacet(Boolean.valueOf(true));
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFlimit(Integer.valueOf(-1));
        if (StringUtils.isNotBlank((String)speciesGroup)) {
            requestParams.setFq(new String[]{"speciesGroup:\"" + speciesGroup + "\""});
        }
        List speciesSubgroupCounts = this.searchDao.getFacetCounts(requestParams);
        HashMap<String, Long> occurrenceCounts = new HashMap<String, Long>();
        if (speciesSubgroupCounts.size() > 0) {
            for (FieldResultDTO fr : ((FacetResultDTO)speciesSubgroupCounts.get(0)).getFieldResult()) {
                occurrenceCounts.put(fr.getLabel(), fr.getCount());
            }
        }
        String taxonName = "scientificName";
        for (String ssg : occurrenceCounts.keySet()) {
            requestParams.setQ("speciesSubgroup:\"" + ssg + "\"");
            requestParams.setFormattedQuery(null);
            requestParams.setFacets(new String[]{taxonName});
            long count = this.searchDao.estimateUniqueValues(requestParams, taxonName);
            if (count <= 0L) continue;
            String parentName = (String)parentLookup.get(ssg.toLowerCase());
            SpeciesGroupDTO parentGroup = (SpeciesGroupDTO)parentGroupMap.get(parentName);
            if (parentGroup == null) {
                parentGroup = new SpeciesGroupDTO(parentName, 0L, 0L, 1);
                parentGroupMap.put(parentName, parentGroup);
            }
            if (parentGroup != null) {
                if (parentGroup.getChildGroups() == null) {
                    parentGroup.setChildGroups(new ArrayList());
                }
                parentGroup.getChildGroups().add(new SpeciesGroupDTO(ssg, count, ((Long)occurrenceCounts.get(ssg)).longValue(), 2));
                parentGroup.setSpeciesCount(parentGroup.getSpeciesCount() + count);
                parentGroup.setCount(parentGroup.getCount() + (Long)occurrenceCounts.get(ssg));
                continue;
            }
            logger.warn((Object)("Parent group lookup failed for: " + parentName + ", ssg: " + ssg));
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String parentName : parentGroupMap.keySet()) {
            if (((SpeciesGroupDTO)parentGroupMap.get(parentName)).getChildGroups() != null && ((SpeciesGroupDTO)parentGroupMap.get(parentName)).getChildGroups().size() != 0) continue;
            toRemove.add(parentName);
        }
        for (String key : toRemove) {
            parentGroupMap.remove(key);
        }
        return parentGroupMap.values();
    }

    @RequestMapping(value={"/explore/groups*"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SpeciesGroupDTO> yourAreaView(SpatialSearchRequestParams requestParams) throws Exception {
        JSONArray sgs = JSONArray.fromObject((Object)this.getGroupsConfig());
        ArrayList<SpeciesGroupDTO> speciesGroups = new ArrayList<SpeciesGroupDTO>();
        SpeciesGroupDTO all = new SpeciesGroupDTO();
        String[] originalFqs = requestParams.getFq();
        all.setName("ALL_SPECIES");
        all.setLevel(0);
        Integer[] counts = this.getYourAreaCount(requestParams, "ALL_SPECIES");
        all.setCount((long)counts[0].intValue());
        all.setSpeciesCount((long)counts[1].intValue());
        speciesGroups.add(all);
        String oldName = null;
        String kingdom = null;
        for (Object sg : sgs) {
            if (!(sg instanceof JSONObject) || !((JSONObject)sg).containsKey((Object)"name")) continue;
            String parent = null;
            if (((JSONObject)sg).containsKey((Object)"parent")) {
                parent = ((JSONObject)sg).getString("parent");
            }
            String name = ((JSONObject)sg).getString("name");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("name: " + name + " parent: " + parent));
            }
            int level = 3;
            SpeciesGroupDTO sdto = new SpeciesGroupDTO();
            sdto.setName(name);
            if (oldName != null && parent != null && parent.equals(kingdom)) {
                level = 2;
            }
            oldName = name;
            if (StringUtils.isBlank((String)parent) || "null".equalsIgnoreCase(parent)) {
                level = 1;
                kingdom = name;
            }
            sdto.setLevel(level);
            requestParams.setFq(originalFqs);
            counts = this.getYourAreaCount(requestParams, name);
            sdto.setCount((long)counts[0].intValue());
            sdto.setSpeciesCount((long)counts[1].intValue());
            speciesGroups.add(sdto);
        }
        return speciesGroups;
    }

    @RequestMapping(value={"/explore/counts/group/{group}*"}, method={RequestMethod.GET})
    @ResponseBody
    public Integer[] getYourAreaCount(SpatialSearchRequestParams requestParams, @PathVariable(value="group") String group) throws Exception {
        this.addGroupFilterToQuery(requestParams, group);
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacet(Boolean.valueOf(false));
        SearchResultDTO results = this.searchDao.findByFulltextSpatialQuery(requestParams, false, null);
        int speciesCount = (int)this.searchDao.estimateUniqueValues(requestParams, "scientificName");
        return new Integer[]{(int)results.getTotalRecords(), speciesCount};
    }

    private void addGroupFilterToQuery(SpatialSearchRequestParams requestParams, String group) {
        this.addFacetFilterToQuery(requestParams, "speciesGroup", group);
    }

    private void addFacetFilterToQuery(SpatialSearchRequestParams requestParams, String facetName, String facetValue) {
        if (!facetValue.equals("ALL_SPECIES")) {
            this.queryFormatUtils.addFqs(new String[]{facetName + ":" + facetValue}, requestParams);
        }
        this.queryFormatUtils.addFqs(new String[]{"taxonRankID:[7000 TO *]"}, requestParams);
        requestParams.setFormattedQuery(null);
    }

    private void applyFacetForCounts(SpatialSearchRequestParams requestParams, boolean useCommonName) {
        if (useCommonName) {
            requestParams.setFacets(new String[]{"common_name_and_lsid"});
        } else {
            requestParams.setFacets(new String[]{"names_and_lsid"});
        }
    }

    @RequestMapping(value={"/explore/group/{group}/download*"}, method={RequestMethod.GET})
    public void yourAreaDownload(DownloadRequestParams requestParams, @PathVariable(value="group") String group, @RequestParam(value="common", required=false, defaultValue="false") boolean common, HttpServletResponse response) throws Exception {
        String filename = requestParams.getFile() != null ? requestParams.getFile() : "data";
        logger.debug((Object)"Downloading the species in your area... ");
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "must-revalidate");
        response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        response.setContentType("application/vnd.ms-excel");
        this.addGroupFilterToQuery((SpatialSearchRequestParams)requestParams, group);
        this.applyFacetForCounts((SpatialSearchRequestParams)requestParams, common);
        try {
            ServletOutputStream out = response.getOutputStream();
            int count = this.searchDao.writeSpeciesCountByCircleToStream((SpatialSearchRequestParams)requestParams, group, out);
            logger.debug((Object)("Exported " + count + " species records in the requested area"));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/explore/group/{group}*"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TaxaCountDTO> listSpeciesForHigherTaxa(SpatialSearchRequestParams requestParams, @PathVariable(value="group") String group, @RequestParam(value="common", required=false, defaultValue="false") boolean common, Model model) throws Exception {
        this.addGroupFilterToQuery(requestParams, group);
        this.applyFacetForCounts(requestParams, common);
        requestParams.setFlimit(requestParams.getPageSize());
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFoffset(requestParams.getStart());
        requestParams.setFsort(requestParams.getSort());
        requestParams.setSort("");
        return this.searchDao.findAllSpecies(requestParams);
    }

    @RequestMapping(value={"/explore/counts/endemic*"}, method={RequestMethod.GET})
    @ResponseBody
    public int getSpeciesCountOnlyInWKT(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        List list = this.getSpeciesOnlyInWKT(requestParams, response);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    @RequestMapping(value={"/explore/endemic/species*"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldResultDTO> getSpeciesOnlyInWKT(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        SpatialSearchRequestParams superset = new SpatialSearchRequestParams();
        superset.setQ("decimalLongitude:[-180 TO 180]");
        superset.setFq(new String[]{"decimalLatitude:[-90 TO 90]"});
        this.prepareEndemicFacet(requestParams);
        this.prepareEndemicFacet(superset);
        return this.searchDao.getSubquerySpeciesOnly(requestParams, superset);
    }

    private void prepareEndemicFacet(SpatialSearchRequestParams parentQuery) {
        if (parentQuery.getFacets() == null || parentQuery.getFacets().length != 1) {
            parentQuery.setFacets(new String[]{"names_and_lsid"});
        }
    }

    @RequestMapping(value={"/explore/endemic/species/{subQueryQid}*"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldResultDTO> getSpeciesOnlyInOneQuery(SpatialSearchRequestParams parentQuery, @PathVariable(value="subQueryQid") Long subQueryQid, HttpServletResponse response) throws Exception {
        SpatialSearchRequestParams subQuery = new SpatialSearchRequestParams();
        subQuery.setQ("qid:" + subQueryQid);
        this.prepareEndemicFacet(parentQuery);
        subQuery.setFacets(parentQuery.getFacets());
        return this.searchDao.getSubquerySpeciesOnly(subQuery, parentQuery);
    }

    @RequestMapping(value={"/explore/endemic/speciescount/{subQueryQid}*"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getSpeciesOnlyInOneCountQuery(SpatialSearchRequestParams parentQuery, @PathVariable(value="subQueryQid") Long subQueryQid, HttpServletResponse response) throws Exception {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("count", this.getSpeciesOnlyInOneQuery(parentQuery, subQueryQid, response).size());
        return m;
    }

    @RequestMapping(value={"/explore/endemic/species.csv"}, method={RequestMethod.GET})
    public void getEndemicSpeciesCSV(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        requestParams.setFacets(new String[]{"names_and_lsid"});
        requestParams.setFq((String[])ArrayUtils.add((Object[])requestParams.getFq(), (Object)"speciesID:*"));
        List list = this.getSpeciesOnlyInWKT(requestParams, response);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/plain");
        PrintWriter writer = response.getWriter();
        writer.write("Family,Scientific name,Common name,Taxon rank,LSID,# Occurrences");
        for (FieldResultDTO item : list) {
            String[] values;
            String s = item.getLabel();
            if (s.startsWith("\"") && s.endsWith("\"") && s.length() > 2) {
                s = s.substring(1, s.length() - 1);
            }
            if ((values = s.split("\\|", 6)).length < 5) continue;
            writer.write("\n" + values[4] + ",\"" + values[0] + "\",\"" + values[2] + "\",," + values[1] + "," + item.getCount());
        }
        writer.flush();
        writer.close();
    }

    @RequestMapping(value={"/explore/endemic/species/{subQueryQid}.csv"}, method={RequestMethod.GET})
    public void getSpeciesOnlyInOneQueryCSV(SpatialSearchRequestParams parentQuery, @PathVariable(value="subQueryQid") Long subQueryQid, @RequestParam(value="count", required=false, defaultValue="false") boolean includeCount, @RequestParam(value="lookup", required=false, defaultValue="false") boolean lookupName, @RequestParam(value="synonym", required=false, defaultValue="false") boolean includeSynonyms, @RequestParam(value="lists", required=false, defaultValue="false") boolean includeLists, @RequestParam(value="file", required=false, defaultValue="") String file, HttpServletResponse response) throws Exception {
        SpatialSearchRequestParams subQuery = new SpatialSearchRequestParams();
        subQuery.setQ("qid:" + subQueryQid);
        this.prepareEndemicFacet(parentQuery);
        this.prepareEndemicFacet(subQuery);
        String filename = StringUtils.isNotEmpty((String)file) ? file : parentQuery.getFacets()[0];
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "must-revalidate");
        response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".csv");
        response.setContentType("text/csv");
        try {
            this.searchDao.writeEndemicFacetToStream(subQuery, parentQuery, includeCount, lookupName, includeSynonyms, includeLists, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static {
        radiusToZoomLevelMap.put(Float.valueOf(1.0f), 14);
        radiusToZoomLevelMap.put(Float.valueOf(5.0f), 12);
        radiusToZoomLevelMap.put(Float.valueOf(10.0f), 11);
        radiusToZoomLevelMap.put(Float.valueOf(50.0f), 9);
    }
}

