/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.common.SolrException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class CustomExceptionResolver
extends SimpleMappingExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        String viewName = this.determineViewName(ex, request);
        if (viewName != null) {
            Integer statusCode = this.determineStatusCode(request, viewName, ex);
            if (statusCode != null) {
                this.applyStatusCodeIfPossible(request, response, statusCode.intValue());
            }
            return this.getModelAndView(viewName, ex, request);
        }
        return null;
    }

    protected Integer determineStatusCode(HttpServletRequest request, String viewName, Exception ex) {
        if (ex instanceof SolrException) {
            return ((SolrException)((Object)ex)).code();
        }
        return this.determineStatusCode(request, viewName);
    }

    protected ModelAndView getModelAndView(String viewName, Exception ex) {
        ModelAndView mv = new ModelAndView(viewName);
        mv.addObject("message", (Object)ex.getMessage());
        mv.addObject("errorType", (Object)(ex instanceof SolrException ? "Solr error" : "Server error"));
        return mv;
    }
}

