/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util.solr;

import au.org.ala.biocache.util.solr.FieldMappedQueryResponse;
import au.org.ala.biocache.util.solr.FieldMappedSolrParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.response.ClusteringResponse;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.GroupResponse;
import org.apache.solr.client.solrj.response.IntervalFacet;
import org.apache.solr.client.solrj.response.PivotField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.client.solrj.response.SuggesterResponse;
import org.apache.solr.client.solrj.response.TermsResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;

public class FieldMappedQueryResponse
extends QueryResponse {
    private static final Logger logger = Logger.getLogger(FieldMappedQueryResponse.class);
    private final SolrClient solrClient;
    private final FieldMappedSolrParams solrParams;
    private final QueryResponse delegate;
    SolrDocumentList _results;
    private List<FacetField> _facetFields = null;
    private List<FacetField> _facetDates = null;
    private List<RangeFacet> _rangeFacets = null;
    private List<IntervalFacet> _intervalFacets = null;

    public FieldMappedQueryResponse(SolrClient solrClient, FieldMappedSolrParams solrParams, QueryResponse delegate) {
        this.solrClient = solrClient;
        this.solrParams = solrParams;
        this.delegate = delegate;
    }

    public void setResponse(NamedList<Object> res) {
        this.delegate.setResponse(res);
    }

    public void removeFacets() {
        this.delegate.removeFacets();
    }

    public NamedList<Object> getHeader() {
        return this.delegate.getHeader();
    }

    public SolrDocumentList getResults() {
        if (this._results == null) {
            if (this.delegate.getResults() == null) {
                return null;
            }
            SolrDocumentList results = this.delegate.getResults();
            Map flMappings = (Map)this.solrParams.paramsInverseTranslations.get("fl");
            if (flMappings == null) {
                logger.debug((Object)"no field list supplied, no result translation");
                this._results = results;
            } else {
                logger.debug((Object)("before results translation: " + results));
                this._results = new SolrDocumentList();
                this._results.setMaxScore(results.getMaxScore());
                this._results.setNumFound(results.getNumFound());
                this._results.setStart(results.getStart());
                results.forEach(solrDocument -> {
                    SolrDocument translatedSd = new SolrDocument();
                    for (String fieldName : solrDocument.getFieldNames()) {
                        String[] legacyFieldNames = (String[])flMappings.get(fieldName);
                        if (legacyFieldNames != null) {
                            for (String legacyFieldName : legacyFieldNames) {
                                translatedSd.setField(legacyFieldName, solrDocument.getFieldValue(fieldName));
                            }
                            continue;
                        }
                        translatedSd.setField(fieldName, solrDocument.getFieldValue(fieldName));
                    }
                    this._results.add((Object)translatedSd);
                });
                logger.debug((Object)("after results translation: " + this._results));
            }
        }
        return this._results;
    }

    public NamedList<ArrayList> getSortValues() {
        return this.delegate.getSortValues();
    }

    public Map<String, Object> getDebugMap() {
        return this.delegate.getDebugMap();
    }

    public Map<String, Object> getExplainMap() {
        return this.delegate.getExplainMap();
    }

    public Map<String, Integer> getFacetQuery() {
        return this.delegate.getFacetQuery();
    }

    public Map<String, SolrDocumentList> getExpandedResults() {
        return this.delegate.getExpandedResults();
    }

    public GroupResponse getGroupResponse() {
        return this.delegate.getGroupResponse();
    }

    public Map<String, Map<String, List<String>>> getHighlighting() {
        return this.delegate.getHighlighting();
    }

    public SpellCheckResponse getSpellCheckResponse() {
        return this.delegate.getSpellCheckResponse();
    }

    public ClusteringResponse getClusteringResponse() {
        return this.delegate.getClusteringResponse();
    }

    public SuggesterResponse getSuggesterResponse() {
        return this.delegate.getSuggesterResponse();
    }

    public TermsResponse getTermsResponse() {
        return this.delegate.getTermsResponse();
    }

    public NamedList<SolrDocumentList> getMoreLikeThis() {
        return this.delegate.getMoreLikeThis();
    }

    public List<FacetField> getFacetFields() {
        if (this._facetFields == null) {
            List facetFields = this.delegate.getFacetFields();
            if (facetFields == null) {
                return null;
            }
            this._facetFields = new ArrayList();
            Map facetMappings = (Map)this.solrParams.paramsInverseTranslations.get("facet.field");
            if (facetMappings != null) {
                for (FacetField facetField : facetFields) {
                    String[] legacyFacetNames;
                    String facetName = facetField.getName();
                    for (String legacyFacetName : legacyFacetNames = facetMappings.getOrDefault(facetName, new String[0])) {
                        if (facetName.equals(legacyFacetName)) {
                            this._facetFields.add(facetField);
                            continue;
                        }
                        if (legacyFacetName == null) continue;
                        FacetField legacyFacet = new FacetField(legacyFacetName);
                        for (FacetField.Count facetFieldCount : facetField.getValues()) {
                            legacyFacet.add(facetFieldCount.getName(), facetFieldCount.getCount());
                        }
                        this._facetFields.add(legacyFacet);
                    }
                }
            }
        }
        return this._facetFields;
    }

    public List<FacetField> getFacetDates() {
        if (this._facetDates == null) {
            List facetFields = this.delegate.getFacetDates();
            if (facetFields == null) {
                return null;
            }
            this._facetDates = new ArrayList();
            Map facetMappings = (Map)this.solrParams.paramsInverseTranslations.get("facet.field");
            if (facetMappings != null) {
                for (FacetField facetField : facetFields) {
                    String[] legacyFacetNames;
                    String facetName = facetField.getName();
                    for (String legacyFacetName : legacyFacetNames = facetMappings.getOrDefault(facetName, new String[0])) {
                        if (facetName.equals(legacyFacetName)) {
                            this._facetDates.add(facetField);
                            continue;
                        }
                        if (legacyFacetName == null) continue;
                        FacetField legacyFacet = new FacetField(legacyFacetName);
                        for (FacetField.Count facetFieldCount : facetField.getValues()) {
                            legacyFacet.add(facetFieldCount.getName(), facetFieldCount.getCount());
                        }
                        this._facetDates.add(legacyFacet);
                    }
                }
            }
        }
        return this._facetDates;
    }

    public List<RangeFacet> getFacetRanges() {
        if (this._rangeFacets == null) {
            List facetRanges = this.delegate.getFacetRanges();
            if (facetRanges == null) {
                return null;
            }
            this._rangeFacets = new ArrayList();
            Map facetMappings = (Map)this.solrParams.paramsInverseTranslations.get("facet.range");
            if (facetMappings != null) {
                for (RangeFacet rangeFacet : facetRanges) {
                    String[] legacyFacetNames;
                    String facetName = rangeFacet.getName();
                    for (String legacyFacetName : legacyFacetNames = facetMappings.getOrDefault(facetName, new String[0])) {
                        if (facetName.equals(legacyFacetName)) {
                            this._rangeFacets.add(rangeFacet);
                            continue;
                        }
                        if (legacyFacetName == null) continue;
                        WrappedRangeFacet legacyFacet = new WrappedRangeFacet(this, legacyFacetName, rangeFacet);
                        this._rangeFacets.add(legacyFacet);
                    }
                }
            }
        }
        return this._rangeFacets;
    }

    public NamedList<List<PivotField>> getFacetPivot() {
        return this.delegate.getFacetPivot();
    }

    public List<IntervalFacet> getIntervalFacets() {
        if (this._intervalFacets == null) {
            List intervalFacets = this.delegate.getIntervalFacets();
            if (intervalFacets == null) {
                return null;
            }
            this._intervalFacets = new ArrayList();
            Map facetMappings = (Map)this.solrParams.paramsInverseTranslations.get("facet.interval");
            if (facetMappings != null) {
                for (IntervalFacet intervalFacet : intervalFacets) {
                    String[] legacyFacetNames;
                    String facetName = intervalFacet.getField();
                    for (String legacyFacetName : legacyFacetNames = facetMappings.getOrDefault(facetName, new String[0])) {
                        if (facetName.equals(legacyFacetName)) {
                            this._intervalFacets.add(intervalFacet);
                            continue;
                        }
                        if (legacyFacetName == null) continue;
                    }
                }
            }
        }
        return this._intervalFacets;
    }

    public FacetField getFacetField(String name) {
        List facetFields = this.getFacetFields();
        if (facetFields == null || facetFields.isEmpty()) {
            return null;
        }
        return facetFields.stream().filter(ff -> ff.getName().equals(name)).findFirst().orElse(null);
    }

    public FacetField getFacetDate(String name) {
        List facetFields = this.getFacetDates();
        if (facetFields == null || facetFields.isEmpty()) {
            return null;
        }
        return facetFields.stream().filter(ff -> ff.getName().equals(name)).findFirst().orElse(null);
    }

    public List<FacetField> getLimitingFacets() {
        return this.delegate.getLimitingFacets();
    }

    public <T> List<T> getBeans(Class<T> type) {
        return this.solrClient == null ? new DocumentObjectBinder().getBeans(type, this.delegate.getResults()) : this.solrClient.getBinder().getBeans(type, this.delegate.getResults());
    }

    public Map<String, FieldStatsInfo> getFieldStatsInfo() {
        return this.delegate.getFieldStatsInfo();
    }

    public String getNextCursorMark() {
        return this.delegate.getNextCursorMark();
    }

    public long getElapsedTime() {
        return this.delegate.getElapsedTime();
    }

    public void setElapsedTime(long elapsedTime) {
        this.delegate.setElapsedTime(elapsedTime);
    }

    public NamedList<Object> getResponse() {
        return this.delegate.getResponse();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public NamedList getResponseHeader() {
        return this.delegate.getResponseHeader();
    }

    public int getStatus() {
        return this.delegate.getStatus();
    }

    public int getQTime() {
        return this.delegate.getQTime();
    }

    public String getRequestUrl() {
        return this.delegate.getRequestUrl();
    }

    public void setRequestUrl(String requestUrl) {
        this.delegate.setRequestUrl(requestUrl);
    }

    public static byte[] serializable(SolrResponse response) {
        return SolrResponse.serializable((SolrResponse)response);
    }

    public static SolrResponse deserialize(byte[] bytes) {
        return SolrResponse.deserialize((byte[])bytes);
    }
}

