/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WmsEnv {
    private static final Logger logger = Logger.getLogger(WmsEnv.class);
    public int red;
    public int green;
    public int blue;
    public int alpha;
    public int size;
    public int colour;
    public boolean uncertainty;
    public boolean gridlabels;
    public String colourMode;
    public String highlight;
    public String gridres;

    public WmsEnv(String env, String styles) {
        try {
            env = URLDecoder.decode(env, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.alpha = 0;
        this.blue = 0;
        this.green = 0;
        this.red = 0;
        this.size = 4;
        this.uncertainty = false;
        this.highlight = null;
        this.colourMode = "-1";
        this.colour = 0;
        if (StringUtils.trimToNull((String)env) == null && StringUtils.trimToNull((String)styles) == null) {
            env = "color:cd3844;size:10;opacity:1.0";
        }
        if (StringUtils.trimToNull((String)env) != null) {
            for (String s : env.split(";")) {
                String[] pair = s.split(":");
                pair[1] = s.substring(s.indexOf(":") + 1);
                if (pair[0].equals("color")) {
                    while (pair[1].length() < 6) {
                        pair[1] = "0" + pair[1];
                    }
                    this.red = Integer.parseInt(pair[1].substring(0, 2), 16);
                    this.green = Integer.parseInt(pair[1].substring(2, 4), 16);
                    this.blue = Integer.parseInt(pair[1].substring(4), 16);
                    continue;
                }
                if (pair[0].equals("size")) {
                    this.size = Integer.parseInt(pair[1]);
                    continue;
                }
                if (pair[0].equals("opacity")) {
                    this.alpha = (int)(255.0 * Double.parseDouble(pair[1]));
                    continue;
                }
                if (pair[0].equals("uncertainty")) {
                    this.uncertainty = true;
                    continue;
                }
                if (pair[0].equals("sel")) {
                    this.highlight = s.replace("sel:", "").replace("%3B", ";");
                    continue;
                }
                if (pair[0].equals("colormode")) {
                    this.colourMode = pair[1];
                    continue;
                }
                if (pair[0].equals("gridres")) {
                    this.gridres = pair[1];
                    continue;
                }
                if (!pair[0].equals("gridlabels")) continue;
                this.gridlabels = BooleanUtils.toBoolean((String)pair[1]);
            }
        } else if (StringUtils.trimToNull((String)styles) != null) {
            String firstStyle = styles.split(",")[0];
            String[] styleParts = firstStyle.split(";");
            this.red = Integer.parseInt(styleParts[0].substring(0, 2), 16);
            this.green = Integer.parseInt(styleParts[0].substring(2, 4), 16);
            this.blue = Integer.parseInt(styleParts[0].substring(4), 16);
            this.alpha = (int)(255.0 * Double.parseDouble(styleParts[1].substring(8)));
            this.size = Integer.parseInt(styleParts[2].substring(5));
        }
        this.colour = this.red << 16 | this.green << 8 | this.blue;
        this.colour |= this.alpha << 24;
    }
}

