/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="OccurrenceUtils")
public class OccurrenceUtils {
    private static final Logger logger = LoggerFactory.getLogger(OccurrenceUtils.class);
    @Inject
    protected SearchDAO searchDAO;
    @Value(value="${media.store.url:}")
    private String remoteMediaStoreUrl;

    private SolrDocument lookupRecordFromSolr(String uuid) {
        SpatialSearchRequestParams idRequest = new SpatialSearchRequestParams();
        idRequest.setQ("id:\"" + uuid + "\"");
        idRequest.setFacet(Boolean.valueOf(false));
        idRequest.setFl("*");
        idRequest.setPageSize(Integer.valueOf(1));
        SolrDocumentList list = null;
        try {
            list = this.searchDAO.findByFulltext(idRequest);
        }
        catch (Exception ignored) {
            logger.debug("Failed to find occurrence with id " + uuid);
        }
        return list != null && list.size() > 0 ? (SolrDocument)list.get(0) : null;
    }

    public SolrDocument getOcc(String uuid) {
        return this.lookupRecordFromSolr(uuid);
    }

    public Map<String, String> getImageFormats(String imageId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("thumb", this.remoteMediaStoreUrl + "/image/proxyImageThumbnail?imageId=" + imageId);
        map.put("small", this.remoteMediaStoreUrl + "/image/proxyImageThumbnail?imageId=" + imageId);
        map.put("large", this.remoteMediaStoreUrl + "/image/proxyImageThumbnailLarge?imageId=" + imageId);
        map.put("raw", this.remoteMediaStoreUrl + "/image/proxyImage?imageId=" + imageId);
        return map;
    }
}

