/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import org.apache.commons.math3.util.Precision;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.DefaultCoordinateOperationFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;

public class GISUtil {
    public static String WGS84_EPSG_Code = "EPSG:4326";

    static double[] reprojectCoordinatesToWGS84(Double coordinate1, Double coordinate2, String sourceCrsEpsgCode, Integer decimalPlacesToRoundTo) {
        try {
            DefaultGeographicCRS wgs84CRS = DefaultGeographicCRS.WGS84;
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceCrsEpsgCode);
            CoordinateOperation transformOp = new DefaultCoordinateOperationFactory().createOperation(sourceCRS, (CoordinateReferenceSystem)wgs84CRS);
            GeneralDirectPosition directPosition = new GeneralDirectPosition(coordinate1.doubleValue(), coordinate2.doubleValue());
            DirectPosition wgs84LatLong = transformOp.getMathTransform().transform((DirectPosition)directPosition, null);
            Double longitude = wgs84LatLong.getOrdinate(0);
            Double latitude = wgs84LatLong.getOrdinate(1);
            Double roundedLongitude = Precision.round((double)longitude, (int)decimalPlacesToRoundTo);
            Double roundedLatitude = Precision.round((double)latitude, (int)decimalPlacesToRoundTo);
            return new double[]{roundedLatitude, roundedLongitude};
        }
        catch (Exception e) {
            return null;
        }
    }
}

