/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.service.RestartDataService;
import au.org.ala.biocache.util.CollectionsCache;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="collectionsCache")
public class CollectionsCache {
    protected LinkedHashMap<String, String> dataResources = (LinkedHashMap)RestartDataService.get((Object)this, (String)"dataResources", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, LinkedHashMap.class);
    protected LinkedHashMap<String, String> dataProviders = (LinkedHashMap)RestartDataService.get((Object)this, (String)"dataProviders", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, LinkedHashMap.class);
    protected LinkedHashMap<String, String> tempDataResources = (LinkedHashMap)RestartDataService.get((Object)this, (String)"tempDataResources", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, LinkedHashMap.class);
    protected LinkedHashMap<String, Integer> downloadLimits = (LinkedHashMap)RestartDataService.get((Object)this, (String)"downloadLimits", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, LinkedHashMap.class);
    protected LinkedHashMap<String, String> institutions = (LinkedHashMap)RestartDataService.get((Object)this, (String)"institutions", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, LinkedHashMap.class);
    protected LinkedHashMap<String, String> collections = (LinkedHashMap)RestartDataService.get((Object)this, (String)"collections", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, LinkedHashMap.class);
    protected LinkedHashMap<String, String> dataHubs = (LinkedHashMap)RestartDataService.get((Object)this, (String)"dataHubs", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, LinkedHashMap.class);
    protected LinkedHashMap<String, String> combinedLookup = (LinkedHashMap)RestartDataService.get((Object)this, (String)"combinedLookup", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, LinkedHashMap.class);
    protected List<String> institution_uid = null;
    protected List<String> collection_uid = null;
    protected List<String> data_resource_uid = null;
    protected List<String> data_provider_uid = null;
    protected List<String> data_hub_uid = null;
    @Value(value="${registry.url:https://collections.ala.org.au/ws}")
    protected String registryUrl;
    @Value(value="${caches.collections.enabled:true}")
    protected Boolean enabled = null;
    @Inject
    private RestOperations restTemplate;
    private static final Logger logger = Logger.getLogger(CollectionsCache.class);

    public LinkedHashMap<String, String> getInstitutions() {
        return this.institutions;
    }

    public LinkedHashMap<String, String> getDataResources() {
        return this.dataResources;
    }

    public LinkedHashMap<String, String> getDataProviders() {
        return this.dataProviders;
    }

    public LinkedHashMap<String, String> getTempDataResources() {
        return this.tempDataResources;
    }

    public LinkedHashMap<String, String> getCollections() {
        return this.collections;
    }

    public LinkedHashMap<String, String> getDataHubs() {
        return this.dataHubs;
    }

    public LinkedHashMap<String, Integer> getDownloadLimits() {
        return this.downloadLimits;
    }

    @PostConstruct
    public void init() {
        this.updateCache();
    }

    public String getNameForCode(String code) {
        return (String)this.combinedLookup.get(code);
    }

    @Scheduled(fixedDelay=3600000L)
    public void updateCache() {
        9 thread = new /* Unavailable Anonymous Inner Class!! */;
        if (this.collections.size() > 0) {
            thread.start();
        } else {
            thread.run();
        }
    }

    protected LinkedHashMap<String, String> getCodesMap(ResourceType type, List<String> guids) {
        LinkedHashMap<String, String> entityMap = null;
        if (logger.isDebugEnabled()) {
            if (guids != null) {
                logger.debug((Object)("Updating code map with guids: " + guids));
            } else {
                logger.debug((Object)"Updating code map");
            }
        }
        try {
            Field f = CollectionsCache.class.getDeclaredField(type.getType() + "s");
            entityMap = (LinkedHashMap<String, String>)f.get(this);
            logger.debug((Object)("checking map size: " + entityMap.size()));
        }
        catch (Exception ex) {
            logger.error((Object)("Java reflection error: " + ex.getMessage()), (Throwable)ex);
        }
        try {
            entityMap = new LinkedHashMap<String, String>();
            String jsonUri = this.registryUrl + "/" + type.getType() + ".json";
            logger.debug((Object)("Requesting: " + jsonUri));
            List entities = (List)this.restTemplate.getForObject(jsonUri, List.class, new Object[0]);
            logger.debug((Object)("Number of entities = " + entities.size()));
            for (LinkedHashMap je : entities) {
                if (!this.addToCodeMap((String)je.get("uid"), guids)) continue;
                entityMap.put((String)je.get("uid"), (String)je.get("name"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
        }
        return entityMap;
    }

    private boolean addToCodeMap(String uid, List<String> guids) {
        if (guids != null) {
            return guids.contains(uid);
        }
        return true;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

