/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SensitiveOccurrenceIndex;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.stream.ProcessInterface;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.io.Tuple;

public class ProcessOcc
implements ProcessInterface {
    private static final Logger logger = Logger.getLogger(ProcessOcc.class);
    SearchResultDTO searchResult;
    SpatialSearchRequestParams requestParams;
    boolean includeSensitive;

    public ProcessOcc(SearchResultDTO searchResult, SpatialSearchRequestParams requestParams, boolean includeSensitive) {
        this.requestParams = requestParams;
        this.includeSensitive = includeSensitive;
        this.searchResult = searchResult;
    }

    public boolean process(Tuple tuple) {
        try {
            if (tuple != null && tuple.fieldNames.size() > 0) {
                Class resultClass = this.includeSensitive ? SensitiveOccurrenceIndex.class : OccurrenceIndex.class;
                OccurrenceIndex oi = (OccurrenceIndex)new ObjectMapper().convertValue((Object)tuple.getMap(), resultClass);
                this.updateImageUrls(oi);
                this.searchResult.getOccurrences().add(oi);
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Failed to convert tuple to OccurrenceIndex: " + e.getMessage()));
            return false;
        }
    }

    public boolean flush() {
        return true;
    }

    private void updateImageUrls(OccurrenceIndex oi) {
        if (!StringUtils.isNotBlank((String)oi.getImage())) {
            return;
        }
    }
}

