/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.SpeciesImageDTO;
import au.org.ala.biocache.dto.SpeciesImagesDTO;
import au.org.ala.biocache.service.RestartDataService;
import au.org.ala.biocache.service.SpeciesImageService;
import au.org.ala.biocache.util.solr.FieldMappingUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="SpeciesImageService")
public class SpeciesImageService {
    private static final Logger logger = Logger.getLogger(SpeciesImageService.class);
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    private FieldMappingUtil fieldMappingUtil;
    private Object cacheLock = new Object();
    private SpeciesImagesDTO cache = (SpeciesImagesDTO)RestartDataService.get((Object)this, (String)"cache", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, SpeciesImagesDTO.class);
    private boolean updatingCache = false;
    Thread updateCacheThread = new CacheThread(this);
    @Value(value="${autocomplete.species.images.enabled:true}")
    private Boolean enabled;

    @PostConstruct
    public void init() {
        this.resetCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpeciesImagesDTO getSpeciesImages() {
        if (!this.enabled.booleanValue()) {
            return null;
        }
        if (this.cache.getSpeciesImage() == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (!this.updatingCache && this.cache == null) {
                    this.updatingCache = true;
                    this.updateCacheThread.start();
                }
            }
        }
        return this.cache;
    }

    public SpeciesImageDTO get(long left, long right) {
        SpeciesImagesDTO speciesImages = this.getSpeciesImages();
        if (speciesImages == null || speciesImages.getLft() == null) {
            return null;
        }
        long[] lft = speciesImages.getLft();
        SpeciesImageDTO[] images = speciesImages.getSpeciesImage();
        int pos = Arrays.binarySearch(lft, left);
        if (pos < 0) {
            pos = -1 * pos - 1;
        }
        SpeciesImageDTO ret = null;
        if (pos < lft.length && lft[pos] < right) {
            ret = new SpeciesImageDTO(images[pos].getDataResourceUid(), images[pos].getImage());
        }
        long sum = 0L;
        while (pos < lft.length && lft[pos] < right) {
            sum += images[pos++].getCount();
        }
        if (ret != null && sum > 0L) {
            ret.setCount(sum);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        Object object = this.cacheLock;
        synchronized (object) {
            if (!this.updatingCache) {
                this.updatingCache = true;
                this.updateCacheThread = new CacheThread(this);
                this.updateCacheThread.start();
            }
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ Object access$100(SpeciesImageService x0) {
        return x0.cacheLock;
    }

    static /* synthetic */ boolean access$202(SpeciesImageService x0, boolean x1) {
        x0.updatingCache = x1;
        return x0.updatingCache;
    }

    static /* synthetic */ SpeciesImagesDTO access$302(SpeciesImageService x0, SpeciesImagesDTO x1) {
        x0.cache = x1;
        return x0.cache;
    }
}

