/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.dto.BreakdownRequestParams;
import au.org.ala.biocache.dto.DataProviderCountDTO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.FacetPivotResultDTO;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.FieldStatsItem;
import au.org.ala.biocache.dto.HeatmapDTO;
import au.org.ala.biocache.dto.OccurrencePoint;
import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.dto.RecordJackKnifeStats;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.TaxaCountDTO;
import au.org.ala.biocache.dto.TaxaRankCountDTO;
import au.org.ala.biocache.stream.ProcessInterface;
import au.org.ala.biocache.util.LegendItem;
import au.org.ala.biocache.util.QidMissingException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletOutputStream;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;

public interface SearchDAO {
    public List<FieldResultDTO> getSubquerySpeciesOnly(SpatialSearchRequestParams var1, SpatialSearchRequestParams var2) throws Exception;

    public SearchResultDTO findByFulltextSpatialQuery(SpatialSearchRequestParams var1, boolean var2, Map<String, String[]> var3);

    public int writeSpeciesCountByCircleToStream(SpatialSearchRequestParams var1, String var2, ServletOutputStream var3) throws Exception;

    public ConcurrentMap<String, AtomicInteger> writeResultsFromIndexToStream(DownloadRequestParams var1, OutputStream var2, boolean var3, DownloadDetailsDTO var4, boolean var5, ExecutorService var6) throws Exception;

    public void writeCoordinatesToStream(SpatialSearchRequestParams var1, OutputStream var2) throws Exception;

    public void writeFacetToStream(SpatialSearchRequestParams var1, boolean var2, boolean var3, boolean var4, boolean var5, OutputStream var6, DownloadDetailsDTO var7) throws Exception;

    public void writeEndemicFacetToStream(SpatialSearchRequestParams var1, SpatialSearchRequestParams var2, boolean var3, boolean var4, boolean var5, boolean var6, OutputStream var7) throws Exception;

    public List<OccurrencePoint> getFacetPoints(SpatialSearchRequestParams var1, PointType var2) throws Exception;

    public List<OccurrencePoint> findRecordsForLocation(SpatialSearchRequestParams var1, PointType var2) throws Exception;

    public void refreshCaches();

    public Map<String, Integer> getSourcesForQuery(SpatialSearchRequestParams var1) throws Exception;

    public TaxaRankCountDTO calculateBreakdown(BreakdownRequestParams var1) throws Exception;

    public Map<String, Integer> getOccurrenceCountsForTaxa(List<String> var1, String[] var2) throws Exception;

    public List<TaxaCountDTO> findAllSpecies(SpatialSearchRequestParams var1) throws Exception;

    public SolrDocumentList findByFulltext(SpatialSearchRequestParams var1) throws Exception;

    public List<LegendItem> getLegend(SpatialSearchRequestParams var1, String var2, String[] var3) throws Exception;

    public List<LegendItem> getLegend(SpatialSearchRequestParams var1, String var2, String[] var3, boolean var4) throws Exception;

    public List<DataProviderCountDTO> getDataProviderList(SpatialSearchRequestParams var1) throws Exception;

    public List<FacetResultDTO> getFacetCounts(SpatialSearchRequestParams var1) throws Exception;

    public QueryResponse searchGroupedFacets(SpatialSearchRequestParams var1) throws Exception;

    public List<FacetPivotResultDTO> searchPivot(SpatialSearchRequestParams var1) throws Exception;

    public List<FieldStatsItem> searchStat(SpatialSearchRequestParams var1, String var2, String var3, Collection<String> var4) throws Exception;

    public List<LegendItem> getColours(SpatialSearchRequestParams var1, String var2) throws Exception;

    public int getMaxBooleanClauses();

    public double[] getBBox(SpatialSearchRequestParams var1) throws Exception;

    public long estimateUniqueValues(SpatialSearchRequestParams var1, String var2) throws Exception;

    public List<String> listFacets(SpatialSearchRequestParams var1) throws Exception;

    public HeatmapDTO getHeatMap(String var1, String[] var2, Double var3, Double var4, Double var5, Double var6, List<LegendItem> var7, int var8) throws Exception;

    public List<RecordJackKnifeStats> getOutlierStatsFor(String var1) throws Exception;

    public int streamingQuery(SpatialSearchRequestParams var1, ProcessInterface var2, ProcessInterface var3) throws Exception;

    public SolrQuery initSolrQuery(SpatialSearchRequestParams var1, boolean var2, Map<String, String[]> var3) throws QidMissingException;
}

