/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.dao.CassandraStoreDAOImpl;
import au.org.ala.biocache.dao.StoreDAO;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="storeDao")
public class CassandraStoreDAOImpl
implements StoreDAO {
    private static final Logger logger = Logger.getLogger(CassandraStoreDAOImpl.class);
    private Cluster cluster;
    private Session session;
    @Value(value="${cassandra.hosts:localhost}")
    String host;
    @Value(value="${cassandra.port:9042}")
    Integer port;
    @Value(value="${cassandra.keyspace:biocache}")
    String keyspace;
    @Value(value="${cassandra.keyspace.default.cql:CREATE KEYSPACE biocache WITH replication = {'class': 'SimpleStrategy', 'replication_factor': '1'}  AND durable_writes = true;}")
    String createKeyspaceCql;
    Map<String, PreparedStatement> preparedStatementCache = new MapMaker().weakValues().makeMap();

    @PostConstruct
    public void init() throws Exception {
        logger.debug((Object)"Initialising CassandraStoreDAOImpl");
        Cluster.Builder builder = Cluster.builder().withoutJMXReporting().withReconnectionPolicy((ReconnectionPolicy)new ExponentialReconnectionPolicy(10000L, 60000L)).withCodecRegistry(CodecRegistry.DEFAULT_INSTANCE.register((TypeCodec)new TimestampAsStringCodec(this, TypeCodec.timestamp(), String.class)));
        List hosts = Arrays.stream(this.host.split(",")).map(h -> h.trim()).collect(Collectors.toList());
        for (String hostString : hosts) {
            String[] host_port = hostString.split(":");
            if (host_port.length > 1) {
                builder.withPort(Integer.parseInt(host_port[1])).addContactPoint(host_port[0]);
                continue;
            }
            builder.withPort(this.port.intValue()).addContactPoint(host_port[0]);
        }
        this.cluster = builder.build();
        if (this.cluster.getMetadata().getKeyspace(this.keyspace) == null) {
            logger.warn((Object)("Keyspace '" + this.keyspace + "' not found. Creating the keyspace with: " + this.createKeyspaceCql));
            this.cluster.connect().execute(this.createKeyspaceCql);
        }
        this.session = this.cluster.connect(this.keyspace);
    }

    public <T> Optional<T> get(Class<T> dataClass, String key) throws IOException {
        String className = dataClass.getSimpleName();
        Object result = null;
        PreparedStatement stmt = this.getPreparedStmt("SELECT * FROM " + className + " where key = ? ", className);
        BoundStatement boundStatement = stmt.bind(new Object[]{key});
        ResultSet rs = this.session.execute((Statement)boundStatement);
        Iterator rows = rs.iterator();
        if (rows.hasNext()) {
            Row row = (Row)rows.next();
            String jsonString = (String)row.get(1, String.class);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
            result = mapper.readValue(jsonString, dataClass);
        }
        return Optional.ofNullable(result);
    }

    public <T> Map<String, T> getAll(Class<T> dataClass) throws IOException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        ResultSet rs = this.session.execute("SELECT * FROM " + dataClass.getSimpleName());
        for (Row row : rs) {
            String uuid = (String)row.get(0, String.class);
            String jsonString = (String)row.get(1, String.class);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
            Object parsed = mapper.readValue(jsonString, dataClass);
            result.put(uuid, parsed);
        }
        return result;
    }

    public <T> void put(String key, T data) throws IOException {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setJsonPropertyFilter((source, name, val) -> val == null);
        String value = data instanceof Collection ? JSONArray.fromObject(data, (JsonConfig)jsonConfig).toString() : JSONObject.fromObject(data, (JsonConfig)jsonConfig).toString();
        String className = data.getClass().getSimpleName();
        try {
            BoundStatement boundStatement = this.createPutStatement(key, className, value);
            this.executeWithRetries(this.session, (Statement)boundStatement);
        }
        catch (Exception e) {
            logger.error((Object)("Problem persisting the following to " + className + " key=" + key + " value=" + value + " " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private ResultSet executeWithRetries(Session session, Statement statement) {
        int MAX_QUERY_RETRIES = 10;
        int retryCount = 0;
        boolean needToRetry = true;
        ResultSet resultSet = null;
        while (retryCount < MAX_QUERY_RETRIES && needToRetry) {
            try {
                resultSet = session.execute(statement);
                needToRetry = false;
                retryCount = 0;
            }
            catch (Exception e) {
                logger.error((Object)("Exception thrown during paging. Retry count $retryCount - " + e.getMessage()));
                ++retryCount;
                needToRetry = true;
                try {
                    if (retryCount > 5) {
                        logger.error((Object)("Backing off for 10 minutes. Retry count " + retryCount + ", " + e.getMessage()));
                        Thread.sleep(600000L);
                        continue;
                    }
                    logger.error((Object)("Backing off for 5 minutes. Retry count " + retryCount + ", " + e.getMessage()));
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.error((Object)("Failed to sleep. " + interruptedException.getMessage()));
                }
            }
        }
        return resultSet;
    }

    public <T> Boolean delete(Class<T> dataClass, String key) throws IOException {
        String className = dataClass.getSimpleName();
        PreparedStatement deleteStmt = this.getPreparedStmt("DELETE FROM " + className + " WHERE key = ?", className);
        BoundStatement boundStatement = deleteStmt.bind(new Object[]{key});
        ResultSet resultSet = this.session.execute((Statement)boundStatement);
        return resultSet != null;
    }

    @PreDestroy
    public void destroy() {
        this.session.close();
    }

    private PreparedStatement getPreparedStmt(String cql, String table) {
        boolean tryQuery = true;
        PreparedStatement result = null;
        while (tryQuery) {
            tryQuery = false;
            try {
                PreparedStatement preparedStatement = (PreparedStatement)this.preparedStatementCache.get(cql);
                if (preparedStatement == null) {
                    preparedStatement = this.session.prepare(cql);
                    this.preparedStatementCache.put(cql, preparedStatement);
                }
                return preparedStatement;
            }
            catch (InvalidQueryException e) {
                logger.info((Object)("Creating table " + table));
                try {
                    this.session.execute("CREATE TABLE " + table + "( key text PRIMARY KEY, value text );");
                    tryQuery = true;
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to create table " + table));
                }
            }
        }
        return result;
    }

    private BoundStatement createPutStatement(String key, String table, String value) {
        String cql = "INSERT INTO " + table + " (key,value) VALUES (?,?);";
        PreparedStatement statement = this.getPreparedStmt(cql, table);
        BoundStatement boundStatement = statement.bind(new Object[]{key, value});
        statement.setIdempotent(Boolean.valueOf(true));
        return boundStatement;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

