/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

public class LegendItem
implements Comparable<LegendItem> {
    String name;
    String i18nCode;
    String facetValue;
    long count;
    int colour;
    String fq;
    int red;
    int blue;
    int green;
    boolean remainder = false;

    public LegendItem(String name, String i18nCode, String facetValue, long count, String fq) {
        this.name = name != null ? name : "";
        this.facetValue = facetValue;
        this.i18nCode = i18nCode;
        this.count = count;
        this.fq = fq;
    }

    public LegendItem(String name, String i18nCode, String facetValue, long count, String fq, boolean remainder) {
        this.name = name != null ? name : "";
        this.i18nCode = i18nCode;
        this.facetValue = facetValue;
        this.count = count;
        this.fq = fq;
        this.remainder = remainder;
    }

    public void setRGB(int colour) {
        this.red = colour >> 16 & 0xFF;
        this.green = colour >> 8 & 0xFF;
        this.blue = colour & 0xFF;
    }

    public String getI18nCode() {
        return this.i18nCode;
    }

    public void setI18nCode(String i18nCode) {
        this.i18nCode = i18nCode;
    }

    public String getName() {
        return this.name;
    }

    public long getCount() {
        return this.count;
    }

    public String getFq() {
        return this.fq;
    }

    public void setColour(int colour) {
        this.colour = colour;
    }

    public int getColour() {
        return this.colour;
    }

    public int getRed() {
        return this.red;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getGreen() {
        return this.green;
    }

    public boolean isRemainder() {
        return this.remainder;
    }

    public void setRemainder(boolean remainder) {
        this.remainder = remainder;
    }

    public String getFacetValue() {
        return this.facetValue;
    }

    public void setFacetValue(String facetValue) {
        this.facetValue = facetValue;
    }

    @Override
    public int compareTo(LegendItem o) {
        if (this.remainder) {
            return 1000;
        }
        if (o.remainder) {
            return -1000;
        }
        long c = this.count - o.count;
        if (c == 0L) {
            if (this.name == null && o.name == null) {
                return 0;
            }
            if (this.name == null) {
                return 1;
            }
            if (o.name == null) {
                return -1;
            }
            return this.name.compareTo(o.name);
        }
        return c > 0L ? -1 : 1;
    }
}

