/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.dao.StoreDAO;
import au.org.ala.biocache.dto.ContactDTO;
import au.org.ala.biocache.dto.QualityAssertion;
import au.org.ala.biocache.dto.UserAssertions;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.util.ContactUtils;
import au.org.ala.biocache.util.OccurrenceUtils;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.solr.common.SolrDocument;
import org.springframework.stereotype.Component;

@Component(value="assertionUtils")
public class AssertionUtils {
    @Inject
    protected AuthService authService;
    @Inject
    protected ContactUtils contactUtils;
    @Inject
    protected OccurrenceUtils occurrenceUtils;
    @Inject
    protected StoreDAO storeDao;

    public UserAssertions getUserAssertions(String recordUuid, Double version) throws Exception {
        SolrDocument sd = this.occurrenceUtils.getOcc(recordUuid);
        return this.getUserAssertions(sd, version);
    }

    public UserAssertions getUserAssertions(SolrDocument sd, Double version) throws IOException {
        if (sd.containsKey((Object)"id")) {
            UserAssertions userAssertions = this.storeDao.get(UserAssertions.class, (String)sd.getFieldValue("id")).orElse(new UserAssertions());
            for (QualityAssertion ua : userAssertions) {
                ua.setSnapshot(null);
                if (ua.getUserId().contains("@")) {
                    String email = ua.getUserId();
                    String userId = (String)this.authService.getMapOfEmailToId().get(email);
                    ua.setUserEmail(email);
                    ua.setUserId(userId);
                }
                this.enhanceQA(sd, ua, version);
            }
            return userAssertions;
        }
        return null;
    }

    public QualityAssertion enhanceQA(SolrDocument sd, QualityAssertion ua, Double version) {
        String collectionUid = "collectionUid";
        String collectionName = "collectionName";
        String email = ua.getUserEmail();
        ContactDTO contact = this.contactUtils.getContactForEmailAndUid(email, (String)sd.getFieldValue(collectionUid));
        if (contact != null) {
            ua.setUserRole(contact.getRole());
            ua.setUserEntityName((String)sd.getFieldValue(collectionName));
            ua.setUserEntityUid((String)sd.getFieldValue(collectionUid));
        }
        return ua;
    }

    public QualityAssertion enhanceQA(String recordUuid, QualityAssertion ua, Double version) throws Exception {
        SolrDocument sd = this.occurrenceUtils.getOcc(recordUuid);
        return this.enhanceQA(sd, ua, version);
    }
}

