/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util.solr;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="fieldMappingUtil")
public class FieldMappingUtil {
    private Map<String, String> fieldMappings = new Hashtable();
    private Map<String, Map<String, String>> enumValueMappings = new Hashtable();
    static Consumer<Pair<String, String>> NOOP_TRANSLATION = m -> {};
    static final String DEPRECATED_PREFIX = "deprecated_";
    static final Pattern ENUM_VALUE_PATTERN = Pattern.compile("(\\w+)");
    static final Pattern QUERY_TERM_PATTERN = Pattern.compile("(^|\\s|[-\\+!]|\\(|[-\\+!]\\(|\\([-\\+!])(\\w+):");

    @Value(value="${solr.pipelines.field.config:/data/biocache/config/pipelines-field-config.json}")
    void setPipelinesFieldConfig(String pipelinesFieldConfig) throws IOException {
        if (pipelinesFieldConfig != null && new File(pipelinesFieldConfig).exists()) {
            ObjectMapper om = new ObjectMapper();
            Map fieldConfig = (Map)om.readValue(new File(pipelinesFieldConfig), HashMap.class);
            this.fieldMappings = (Map)fieldConfig.get("fieldNameMapping");
            this.enumValueMappings = (Map)fieldConfig.get("fieldValueMapping");
        }
    }

    public Stream<Pair<String, String>> getFieldMappingStream() {
        return this.fieldMappings.entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue()));
    }

    public Stream<Pair<String, String>> getFieldValueMappingStream(String fieldName) {
        return ((Map)this.enumValueMappings.getOrDefault(fieldName, new HashMap())).entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue()));
    }

    public String translateQueryFields(String query) {
        return this.translateQueryFields(NOOP_TRANSLATION, query);
    }

    public String translateQueryFields(Consumer<Pair<String, String>> translation, String query) {
        if (query == null) {
            return null;
        }
        Matcher matcher = QUERY_TERM_PATTERN.matcher(query);
        boolean result = matcher.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            String prevTerm = null;
            int prevEnd = 0;
            do {
                String prefix = matcher.group(1);
                String queryTerm = matcher.group(2);
                String translatedFieldName = this.translateFieldName(translation, queryTerm);
                if (matcher.start() > 0 && prevTerm == null) {
                    sb.append(query.substring(0, matcher.start()));
                }
                if (prevTerm != null) {
                    String value = query.substring(prevEnd, matcher.start());
                    sb.append(this.translateFieldValue(prevTerm, value));
                }
                sb.append(prefix);
                sb.append(translatedFieldName);
                sb.append(":");
                prevTerm = translatedFieldName;
                prevEnd = matcher.end();
            } while (result = matcher.find());
            String value = query.substring(prevEnd);
            sb.append(this.translateFieldValue(prevTerm, value));
            return sb.toString();
        }
        return query;
    }

    public String translateFieldValue(String term, String value) {
        Matcher matcher;
        boolean result;
        if (this.enumValueMappings == null || term == null || value == null) {
            return value;
        }
        Map enumValueMapping = (Map)this.enumValueMappings.get(term);
        if (enumValueMapping != null && (result = (matcher = ENUM_VALUE_PATTERN.matcher(value)).find())) {
            StringBuffer sb = new StringBuffer();
            do {
                String enumValue;
                String translatedEnumValue;
                if ((translatedEnumValue = (String)enumValueMapping.get(enumValue = matcher.group(1))) == null) {
                    matcher.appendReplacement(sb, enumValue);
                    continue;
                }
                matcher.appendReplacement(sb, translatedEnumValue);
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return value;
    }

    public String translateFieldName(String fieldName) {
        return this.translateFieldName(NOOP_TRANSLATION, fieldName);
    }

    public String translateFieldName(Consumer<Pair<String, String>> translation, String fieldName) {
        if (fieldName == null) {
            return null;
        }
        if (this.fieldMappings == null) {
            translation.accept((Pair<String, String>)Pair.of((Object)fieldName, (Object)fieldName));
            return fieldName;
        }
        String translatedFieldName = this.fieldMappings.getOrDefault(fieldName, "\u0000");
        if (translatedFieldName == null) {
            translation.accept((Pair<String, String>)Pair.of((Object)fieldName, null));
            return DEPRECATED_PREFIX + fieldName;
        }
        if (!"\u0000".equals(translatedFieldName)) {
            translation.accept((Pair<String, String>)Pair.of((Object)fieldName, (Object)translatedFieldName));
            return translatedFieldName;
        }
        translation.accept((Pair<String, String>)Pair.of((Object)fieldName, (Object)fieldName));
        return fieldName;
    }

    public String[] translateFieldList(String ... fls) {
        return this.translateFieldList(NOOP_TRANSLATION, fls);
    }

    public String[] translateFieldList(Consumer<Pair<String, String>> translation, String ... fls) {
        if (fls == null) {
            return null;
        }
        return (String[])Arrays.stream(fls).map(fl -> String.join((CharSequence)",", this.translateFieldArray(translation, fl.split(",")))).toArray(String[]::new);
    }

    public String[] translateFieldArray(String ... fields) {
        return this.translateFieldArray(NOOP_TRANSLATION, fields);
    }

    public String[] translateFieldArray(Consumer<Pair<String, String>> translation, String ... fields) {
        if (fields == null) {
            return null;
        }
        return (String[])Arrays.stream(fields).filter(field -> field != null && !field.equals("")).map(field -> this.translateFieldName(translation, field)).toArray(String[]::new);
    }
}

