/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.util.DwcTermDetails;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DwCTerms {
    private static final Logger logger = Logger.getLogger(DwCTerms.class);
    private static DwCTerms instance = null;
    Map<String, DwcTermDetails> collectedTerms = null;

    protected DwCTerms() {
    }

    public static DwCTerms getInstance() {
        if (instance == null) {
            instance = new DwCTerms();
        }
        return instance;
    }

    public DwcTermDetails getDwCTermDetails(String simpleName) {
        if (this.collectedTerms == null) {
            try {
                XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
                factory.setNamespaceAware(true);
                XmlPullParser xpp = factory.newPullParser();
                InputStream input = DwCTerms.class.getResourceAsStream("/dwcterms.rdf");
                xpp.setInput(input, "UTF-8");
                this.collectedTerms = DwCTerms.processDocument((XmlPullParser)xpp);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to parse local copy of dwcterms.rdf", (Throwable)e);
            }
        }
        return (DwcTermDetails)this.collectedTerms.get(simpleName);
    }

    private static Map<String, DwcTermDetails> processDocument(XmlPullParser xpp) throws XmlPullParserException, IOException {
        HashMap<String, DwcTermDetails> collectedTerms = new HashMap<String, DwcTermDetails>();
        int eventType = xpp.getEventType();
        String currentElement = null;
        DwcTermDetails dwCTermDetails = null;
        do {
            if (eventType == 2) {
                String name = xpp.getName();
                if ("Description".equalsIgnoreCase(name)) {
                    if (dwCTermDetails != null) {
                        collectedTerms.put(dwCTermDetails.term, dwCTermDetails);
                    }
                    dwCTermDetails = new DwcTermDetails();
                    dwCTermDetails.uri = xpp.getAttributeValue(0);
                    dwCTermDetails.term = dwCTermDetails.uri.lastIndexOf("/") > 0 ? dwCTermDetails.uri.substring(dwCTermDetails.uri.lastIndexOf("/") + 1) : dwCTermDetails.uri;
                }
                currentElement = name;
            } else if (eventType == 4) {
                String value;
                if ("label".equalsIgnoreCase(currentElement) && (value = StringUtils.trimToNull((String)xpp.getText())) != null) {
                    dwCTermDetails.label = value;
                }
                if ("comment".equalsIgnoreCase(currentElement) && (value = StringUtils.trimToNull((String)xpp.getText())) != null) {
                    dwCTermDetails.comment = value;
                }
            }
            eventType = xpp.next();
        } while (eventType != 1);
        return collectedTerms;
    }
}

