/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.org.ala.biocache.stream.ProcessInterface;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.io.Tuple;

public class ScatterplotSearch
implements ProcessInterface {
    private static final Logger logger = Logger.getLogger(ScatterplotSearch.class);
    int tmpCount = 0;
    AtomicInteger count;
    double[][] data;
    String x;
    String y;
    double lasta = 0.0;
    double lastb = 0.0;

    public ScatterplotSearch(double[][] data, String x, String y, AtomicInteger count) {
        this.data = data;
        this.x = x;
        this.y = y;
        this.count = count;
    }

    public boolean process(Tuple tuple) {
        if (tuple != null && tuple.fields != null && tuple.fields.size() >= 2) {
            try {
                Double a = tuple.getDouble((Object)this.y);
                Double b = tuple.getDouble((Object)this.x);
                if (this.tmpCount == 0 || this.lasta != a || this.lastb != b) {
                    this.data[0][this.tmpCount] = a;
                    this.data[1][this.tmpCount] = b;
                    this.lasta = a;
                    this.lastb = b;
                    ++this.tmpCount;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean flush() {
        this.count.set(this.tmpCount);
        int size = this.data[0].length;
        for (int i = this.tmpCount; i < size; ++i) {
            this.data[0][i] = Double.NaN;
            this.data[1][i] = Double.NaN;
        }
        return true;
    }
}

