/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.stream.ProcessInterface;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.io.Tuple;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.util.CollectionUtils;

public class ProcessFacet
implements ProcessInterface {
    private static final Logger logger = Logger.getLogger(ProcessFacet.class);
    SearchResultDTO searchResult;
    SpatialSearchRequestParams requestParams;
    SearchDAOImpl searchDao;
    AbstractMessageSource messageSource;
    FacetResultDTO currentFacet;
    Queue<String> facetNames;
    String facetName = null;
    private List<FieldResultDTO> currentFieldList;

    public ProcessFacet(SearchResultDTO searchResult, SpatialSearchRequestParams requestParams, SearchDAOImpl searchDao) {
        this.requestParams = requestParams;
        this.searchResult = searchResult;
        this.searchDao = searchDao;
        this.messageSource = searchDao.messageSource;
        this.facetNames = new LinkedList(CollectionUtils.arrayToList((Object)requestParams.getFacets()));
        this.searchResult.setFacetResults(new ArrayList());
    }

    public boolean process(Tuple tuple) {
        this.initField();
        try {
            long entryCount;
            if (tuple != null && tuple.fieldNames.size() > 0 && (entryCount = tuple.getLong((Object)"count(*)").longValue()) > 0L) {
                String countEntryName = tuple.getString((Object)"name");
                if (StringUtils.isEmpty((String)countEntryName)) {
                    String label = "";
                    if (this.messageSource != null) {
                        label = this.messageSource.getMessage(this.facetName + ".novalue", null, "Not supplied", null);
                    }
                    this.currentFieldList.add(new FieldResultDTO(label, this.facetName + ".novalue", entryCount, "-" + this.facetName + ":*"));
                } else if (countEntryName.equals("before")) {
                    // empty if block
                }
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Failed to convert tuple to OccurrenceIndex: " + e.getMessage()));
            return false;
        }
    }

    public boolean flush() {
        this.facetName = null;
        return true;
    }

    private void initField() {
        if (this.facetName == null) {
            this.facetName = (String)this.facetNames.poll();
            this.currentFacet = new FacetResultDTO(this.facetName, new ArrayList());
            this.currentFieldList = this.currentFacet.getFieldResult();
            this.searchResult.getFacetResults().add(this.currentFacet);
        }
    }
}

