/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadHeaders;
import au.org.ala.biocache.dto.Kvp;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.ListsService;
import au.org.ala.biocache.stream.ProcessInterface;
import au.org.ala.biocache.util.RecordWriter;
import au.org.ala.biocache.util.SearchUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.io.Tuple;

public class ProcessDownload
implements ProcessInterface {
    protected static final Logger logger = Logger.getLogger(ProcessDownload.class);
    static final int MAX_BATCH_SIZE = 1000;
    ConcurrentMap<String, AtomicInteger> uidStats;
    RecordWriter recordWriter;
    DownloadDetailsDTO downloadDetails;
    boolean checkLimit;
    AtomicLong resultsCount;
    long maxDownloadSize;
    List<String> miscFields;
    DownloadHeaders headers;
    ListsService listsService;
    LayersService layersService;
    boolean includeMultivalues;
    boolean includeMisc;
    List<String[]> batch = new ArrayList();
    double[][] points = new double[1000][2];
    String[] values = new String[0];
    long startTime = 0L;

    public ProcessDownload(ConcurrentMap<String, AtomicInteger> uidStats, DownloadHeaders headers, RecordWriter recordWriter, DownloadDetailsDTO downloadDetails, boolean checkLimit, long maxDownloadSize, ListsService listsService, LayersService layersService) {
        this.uidStats = uidStats;
        this.headers = headers;
        this.recordWriter = recordWriter;
        this.downloadDetails = downloadDetails;
        this.checkLimit = checkLimit;
        this.resultsCount = downloadDetails.getRecordsDownloaded();
        this.maxDownloadSize = maxDownloadSize;
        this.miscFields = headers.miscLabels;
        this.listsService = listsService;
        this.layersService = layersService;
        this.includeMultivalues = downloadDetails == null || downloadDetails.getRequestParams() == null || downloadDetails.getRequestParams().getIncludeMultivalues() == null || downloadDetails.getRequestParams().getIncludeMultivalues() == false;
        this.includeMisc = downloadDetails != null && downloadDetails.getRequestParams() != null && downloadDetails.getRequestParams().getIncludeMisc() != false;
    }

    public boolean flush() {
        this.intersectAnalysisLayers();
        this.downloadDetails.updateCounts(this.batch.size());
        this.batch.forEach(row -> this.recordWriter.write(row));
        this.batch.clear();
        return true;
    }

    public boolean process(Tuple tuple) {
        boolean finished = false;
        if (tuple.get((Object)"dataResourceUid") != null && (!this.checkLimit || this.checkLimit && (long)this.resultsCount.intValue() < this.maxDownloadSize)) {
            long count = this.resultsCount.getAndIncrement();
            int numColumns = this.headers.labels.length + this.headers.analysisIds.length + this.headers.speciesListIds.length + this.headers.qaLabels.length + this.headers.miscLabels.size();
            if (this.values.length < numColumns) {
                this.values = new String[numColumns];
            }
            if (count % 10000L == 0L) {
                if (count > 0L) {
                    logger.info((Object)("Download: " + 10000000L / (System.currentTimeMillis() - this.startTime) + " records/s, " + numColumns + " columns"));
                }
                this.startTime = System.currentTimeMillis();
            }
            this.appendColumns(tuple, this.values);
            if (this.headers.speciesListIds.length > 0) {
                this.appendSpeciesListColumns(tuple, this.values, this.headers.labels.length + this.headers.analysisIds.length);
            }
            if (this.headers.qaLabels.length > 0) {
                this.appendQaColumns(tuple, this.values, this.headers.labels.length + this.headers.analysisIds.length + this.headers.speciesListIds.length);
            }
            if (this.includeMisc) {
                this.values = this.appendMiscColumns(tuple, this.values, this.headers.labels.length + this.headers.analysisIds.length + this.headers.speciesListIds.length + this.headers.qaLabels.length);
            }
            SearchDAOImpl.incrementCount((ConcurrentMap)this.uidStats, (Object)tuple.get((Object)"institutionUid"));
            SearchDAOImpl.incrementCount((ConcurrentMap)this.uidStats, (Object)tuple.get((Object)"collectionUid"));
            SearchDAOImpl.incrementCount((ConcurrentMap)this.uidStats, (Object)tuple.get((Object)"dataProviderUid"));
            SearchDAOImpl.incrementCount((ConcurrentMap)this.uidStats, (Object)tuple.get((Object)"dataResourceUid"));
            if (this.headers.analysisIds.length > 0) {
                this.recordCoordinates(tuple);
                this.batch.add(this.values);
                if (this.batch.size() > 1000) {
                    this.flush();
                }
            } else {
                this.recordWriter.write(this.values);
            }
        } else {
            finished = true;
        }
        return finished;
    }

    private void appendQaColumns(Tuple tuple, String[] values, int offset) {
        List assertions = tuple.getStrings((Object)"assertions");
        if (assertions == null) {
            assertions = Collections.EMPTY_LIST;
        }
        for (int k = 0; k < this.headers.qaIds.length; ++k) {
            values[offset + k] = Boolean.toString(assertions.contains(this.headers.qaIds[k]));
        }
    }

    private void appendColumns(Tuple tuple, String[] values) {
        block0: for (int j = 0; j < this.headers.labels.length; ++j) {
            Object obj = tuple.get((Object)this.headers.included[j]);
            if (obj == null) {
                values[j] = "";
                continue;
            }
            if (obj instanceof Collection) {
                for (Object value : (Collection)obj) {
                    if (values[j] != null && values[j].length() > 0) {
                        int n = j;
                        values[n] = values[n] + "|";
                    }
                    values[j] = SearchUtils.formatValue(value);
                    if (this.includeMultivalues) continue;
                    continue block0;
                }
                continue;
            }
            values[j] = SearchUtils.formatValue((Object)obj);
        }
    }

    private void appendSpeciesListColumns(Tuple tuple, String[] values, int offset) {
        String lftString = String.valueOf(tuple.getString((Object)"lft"));
        String rgtString = String.valueOf(tuple.getString((Object)"rgt"));
        if (StringUtils.isNumeric((String)lftString)) {
            long lft = Long.parseLong(lftString);
            long rgt = Long.parseLong(rgtString);
            Kvp lftrgt = new Kvp(lft, rgt);
            String drDot = ".";
            String dr = "";
            int fieldIdx = 0;
            for (int i = 0; i < this.headers.speciesListIds.length; ++i) {
                if (this.headers.speciesListIds[i].startsWith(drDot)) {
                    ++fieldIdx;
                } else {
                    dr = this.headers.speciesListIds[i].split("\\.", 2)[0];
                    drDot = dr + ".";
                    fieldIdx = 0;
                }
                values[offset + i] = this.listsService.getKvpValue(fieldIdx, this.listsService.getKvp(dr), lftrgt);
            }
        }
    }

    private void intersectAnalysisLayers() {
        String layersServiceUrl = this.downloadDetails.getRequestParams().getLayersServiceUrl();
        if (this.batch.size() > 0 && StringUtils.isNotEmpty((String)layersServiceUrl) && this.headers.analysisIds.length > 0) {
            List intersection = new ArrayList();
            try {
                int i = 0;
                for (i = 0; i < this.batch.size() && this.points[i][0] == -2.147483648E9; ++i) {
                }
                if (i < this.batch.size()) {
                    Reader reader = this.layersService.sample(this.headers.analysisIds, this.points, null);
                    CSVReader csv = new CSVReader(reader);
                    intersection = csv.readAll();
                    csv.close();
                    for (int j = 0; j < this.batch.size(); ++j) {
                        String[] sampling;
                        if (j <= this.batch.size() || (sampling = (String[])intersection.get(j + 1)) == null || sampling.length != this.headers.analysisIds.length + 2) continue;
                        System.arraycopy(sampling, 2, this.batch.get(j), this.headers.labels.length, sampling.length - 2);
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)"Failed to intersect analysis layers", (Throwable)e);
            }
        }
    }

    private void recordCoordinates(Tuple tuple) {
        try {
            Object lon = null;
            Object lat = null;
            lon = tuple.get((Object)"sensitive_decimalLongitude");
            if (lon == null || (lat = tuple.get((Object)"sensitive_decimalLatitude")) == null) {
                lon = tuple.get((Object)"decimalLongitude");
                lat = tuple.get((Object)"decimalLatitude");
            }
            if (lon == null || lat == null) {
                this.points[this.batch.size()][0] = -2.147483648E9;
                this.points[this.batch.size()][1] = -2.147483648E9;
            } else {
                this.points[this.batch.size()][0] = (Double)lon;
                this.points[this.batch.size()][1] = (Double)lat;
            }
        }
        catch (Exception e) {
            this.points[this.batch.size()][0] = -2.147483648E9;
            this.points[this.batch.size()][1] = -2.147483648E9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] appendMiscColumns(Tuple tuple, String[] values, int offset) {
        ArrayList<String> miscValues = new ArrayList<String>(this.miscFields.size());
        List list = this.miscFields;
        synchronized (list) {
            String json = SearchUtils.formatValue((Object)tuple.getString((Object)"dynamicProperties"));
            if (StringUtils.isNotEmpty((String)json)) {
                JSONObject jo = JSONObject.fromObject((Object)json);
                int pos = offset;
                for (String f : this.miscFields) {
                    values[offset] = SearchUtils.formatValue((Object)jo.get(f));
                    ++offset;
                    jo.remove(f);
                }
                for (Object entry : jo.entrySet()) {
                    String value = SearchUtils.formatValue(((Map.Entry)entry).getValue());
                    if (!StringUtils.isNotEmpty((String)value)) continue;
                    miscValues.add(value);
                    this.miscFields.add((String)((Map.Entry)entry).getKey());
                }
            }
        }
        if (miscValues.size() > 0) {
            String[] newValues = new String[miscValues.size() + values.length];
            System.arraycopy(values, 0, newValues, 0, values.length);
            for (int i = 0; i < miscValues.size(); ++i) {
                newValues[values.length + i] = (String)miscValues.get(i);
            }
            values = newValues;
        }
        return values;
    }
}

