/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util.thread;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class EndemicCallable
implements Callable<List<FieldResultDTO>> {
    private static final Logger logger = Logger.getLogger(EndemicCallable.class);
    private SpatialSearchRequestParams srp;
    private int batch;
    private SearchDAO searchDAO;

    public EndemicCallable(SpatialSearchRequestParams requestParams, int batch, SearchDAO searchDAO) {
        this.srp = requestParams;
        this.batch = batch;
        this.searchDAO = searchDAO;
    }

    @Override
    public List<FieldResultDTO> call() {
        try {
            logger.debug((Object)("Starting the endemic callable for " + this.batch));
            List results = this.searchDAO.getValuesForFacet(this.srp);
            logger.debug((Object)("Finished endemic callable for " + this.batch + " (" + results.size() + ")"));
            return results;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get facets for the endemic call ", (Throwable)e);
            return null;
        }
    }
}

