/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum MimeType {
    HTML("text/html", "html"),
    XML("text/xml", "xml"),
    TEXT("text/plain", "txt"),
    RDF("application/rdf+xml", "xml"),
    JSON("application/json", "json"),
    PDF("application/pdf", "pdf"),
    JPEG("image/jpeg", "jpg"),
    PJPEG("image/pjpeg", "jpg"),
    CITRIX_PJPEG("image/x-citrix-pjpeg", "jpg"),
    GIF("image/gif", "gif"),
    TIF("image/tiff", "tif"),
    BMP("image/bmp", "bmp"),
    PNG("image/png", "png"),
    MP3("audio/mpeg", "mp3"),
    OGG("audio/ogg", "ogg"),
    WAV("audio/wav", "wav");

    private String mimeType;
    private String[] fileExtensions;
    private static final Map<String, MimeType> mimeTypeLookup;
    private static final Map<String, MimeType> fileExtensionLookup;

    private MimeType(String mimeType, String fileExtension) {
        this.mimeType = mimeType;
        this.fileExtensions = new String[]{fileExtension};
    }

    private MimeType(String mimeType, String ... fileExtensions) {
        this.mimeType = mimeType;
        this.fileExtensions = fileExtensions;
    }

    public static String getFileExtension(String mimetype) {
        String[] fileExtensions;
        MimeType mimeType = MimeType.getForMimeType((String)mimetype);
        if (mimeType != null && (fileExtensions = mimeType.getFileExtensions()).length > 0) {
            return fileExtensions[0];
        }
        return "";
    }

    public static MimeType getForMimeType(String mimetype) {
        return (MimeType)mimeTypeLookup.get(mimetype);
    }

    public static MimeType getForFileExtension(String fileExtension) {
        return (MimeType)fileExtensionLookup.get(FilenameUtils.getExtension((String)fileExtension).toLowerCase());
    }

    public static List<String> getAllMimeTypes() {
        ArrayList<String> allMimeTypes = new ArrayList<String>();
        for (MimeType mt : EnumSet.allOf(MimeType.class)) {
            allMimeTypes.add(mt.getMimeType());
        }
        return allMimeTypes;
    }

    public static List<String> getImageMimeTypes() {
        ArrayList<String> allMimeTypes = new ArrayList<String>();
        for (MimeType mt : EnumSet.allOf(MimeType.class)) {
            if (!mt.getMimeType().startsWith("image")) continue;
            allMimeTypes.add(mt.getMimeType());
        }
        return allMimeTypes;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String toString() {
        return this.mimeType;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    static {
        mimeTypeLookup = new HashMap();
        fileExtensionLookup = new HashMap();
        for (MimeType mt : EnumSet.allOf(MimeType.class)) {
            mimeTypeLookup.put(mt.getMimeType(), mt);
            for (String fileExtension : mt.getFileExtensions()) {
                fileExtensionLookup.put(fileExtension, mt);
            }
        }
    }
}

