/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dto.SpeciesCountDTO;
import au.org.ala.biocache.dto.SpeciesImageDTO;
import au.org.ala.biocache.service.ImageMetadataService;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.ListsService;
import au.org.ala.biocache.service.SpeciesCountsService;
import au.org.ala.biocache.service.SpeciesImageService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.util.OccurrenceUtils;
import au.org.ala.names.ws.api.NameUsageMatch;
import au.org.ala.names.ws.client.ALANameUsageMatchServiceClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.springframework.context.support.AbstractMessageSource;

public class NameMatchSpeciesLookupService
implements SpeciesLookupService {
    private static final Logger logger = Logger.getLogger(NameMatchSpeciesLookupService.class);
    private AbstractMessageSource messageSource;
    @Inject
    protected SpeciesCountsService speciesCountsService;
    @Inject
    protected SpeciesImageService speciesImageService;
    @Inject
    protected ImageMetadataService imageMetadataService;
    @Inject
    protected OccurrenceUtils occurrenceUtils;
    @Inject
    protected ListsService listsService;
    @Inject
    protected LayersService layersService;
    @Inject
    private ALANameUsageMatchServiceClient nameUsageMatchService = null;

    public String getGuidForName(String name) {
        String lsid = null;
        try {
            lsid = this.nameUsageMatchService.searchForLSID(name);
        }
        catch (Exception e) {
            logger.debug((Object)("Error searching for name: " + name + " -  " + e.getMessage()), (Throwable)e);
        }
        return lsid;
    }

    public String getAcceptedNameForGuid(String guid) {
        NameUsageMatch nsr = this.nameUsageMatchService.match(guid);
        if (nsr != null) {
            return nsr.getScientificName();
        }
        return null;
    }

    public List<String> getNamesForGuids(List<String> guids) {
        ArrayList<String> results = new ArrayList<String>(guids.size());
        int idx = 0;
        for (String guid : guids) {
            results.add(idx, this.getAcceptedNameForGuid(guid));
            ++idx;
        }
        return results;
    }

    public List<String[]> getSpeciesDetails(List<String> guids, List<Long> counts, boolean includeCounts, boolean includeSynonyms, boolean includeLists) {
        ArrayList<String[]> results = new ArrayList<String[]>(guids.size());
        int idx = 0;
        for (String guid : guids) {
            NameUsageMatch nsr = this.nameUsageMatchService.match(guid);
            if (nsr == null) {
                String lsid = this.nameUsageMatchService.searchForLSID(guid);
                if (lsid != null) {
                    nsr = this.nameUsageMatchService.match(lsid);
                } else if (guid != null && StringUtils.countMatches((CharSequence)guid, (CharSequence)"|") == 4) {
                    if (guid.startsWith("\"") && guid.endsWith("\"") && guid.length() > 2) {
                        guid = guid.substring(1, guid.length() - 1);
                    }
                    lsid = guid.split("\\|", 6)[1];
                    nsr = this.nameUsageMatchService.match(lsid);
                }
            }
            Object[] result = null;
            ArrayList<String> lsids = new ArrayList<String>();
            if (nsr != null) {
                lsids.add(nsr.getGenusID());
                lsids.add(nsr.getFamilyID());
                lsids.add(nsr.getSpeciesID());
                result = new String[]{nsr.getScientificName(), nsr.getScientificNameAuthorship(), nsr.getKingdom(), nsr.getPhylum(), nsr.getClasss(), nsr.getOrder(), nsr.getFamily(), nsr.getGenus(), nsr.getSpecies(), nsr.getRankID() != null && nsr.getRankID() < 7000 ? nsr.getTaxonConceptID() : null};
            } else if (StringUtils.countMatches((CharSequence)guid, (CharSequence)"|") == 4) {
                if (guid.startsWith("\"") && guid.endsWith("\"") && guid.length() > 2) {
                    guid = guid.substring(1, guid.length() - 1);
                }
                String[] split = guid.split("\\|", 6);
                lsids.add(split[1]);
                result = new String[]{split[0], "", split[3], "", "", "", split[4], "", "", ""};
            } else {
                result = new String[]{"unmatched", "", "", "", "", "", "", "", "", ""};
            }
            if (includeCounts) {
                result = (String[])ArrayUtils.add((Object[])result, (Object)counts.get(idx).toString());
            }
            if (includeLists) {
                List types = this.listsService.getTypes();
                String[] row = new String[result.length + types.size()];
                System.arraycopy(result, 0, row, 0, result.length);
                HashSet matches = new HashSet();
                for (int j = 0; j < types.size(); ++j) {
                    matches.clear();
                    for (String lsid : lsids) {
                        Set found = this.listsService.get(types.get(j).toString(), lsid);
                        if (found == null) continue;
                        matches.addAll(found);
                    }
                    result[result.length - types.size() + j] = "";
                    for (String match : matches) {
                        if (((String)result[result.length - types.size() + j]).length() > 0) {
                            int n = result.length - types.size() + j;
                            result[n] = (String)result[n] + "|";
                        }
                        int n = result.length - types.size() + j;
                        result[n] = (String)result[n] + match;
                    }
                }
                result = row;
            }
            results.add((String[])result);
            ++idx;
        }
        return results;
    }

    public String[] getHeaderDetails(String field, boolean includeCounts, boolean includeSynonyms) {
        Object[] baseHeader = new String[]{this.messageSource.getMessage("species.name", null, "Species Name", null), this.messageSource.getMessage("species.author", null, "Scientific Name Author", null), this.messageSource.getMessage("species.kingdom", null, "Kingdom", null), this.messageSource.getMessage("species.phylum", null, "Phylum", null), this.messageSource.getMessage("species.class", null, "Class", null), this.messageSource.getMessage("species.order", null, "Order", null), this.messageSource.getMessage("species.family", null, "Family", null), this.messageSource.getMessage("species.genus", null, "Genus", null), this.messageSource.getMessage("species.species", null, "Species", null), this.messageSource.getMessage("species.subspecies", null, "Subspecies", null)};
        if (includeCounts) {
            return (String[])ArrayUtils.add((Object[])baseHeader, (Object)this.messageSource.getMessage("species.count", null, "Number of Records", null));
        }
        return baseHeader;
    }

    public List<String> getGuidsForTaxa(List<String> taxaQueries) {
        return this.nameUsageMatchService.getGuidsForTaxa(taxaQueries);
    }

    public void setMessageSource(AbstractMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public Map search(String query, String[] filterQuery, int max, boolean includeSynonyms, boolean includeAll, boolean includeCounts) {
        int maxFind = includeAll ? max : max + 1000;
        List results = this.nameUsageMatchService.autocomplete(ClientUtils.escapeQueryChars((String)query), Integer.valueOf(maxFind), Boolean.valueOf(includeSynonyms));
        ArrayList<Object> output = new ArrayList<Object>();
        SpeciesCountDTO countlist = includeCounts ? this.speciesCountsService.getCounts(filterQuery) : null;
        Collections.sort(results, new /* Unavailable Anonymous Inner Class!! */);
        int resultsTotal = 0;
        for (int i = 0; i < results.size(); ++i) {
            Map nsr = (Map)results.get(i);
            try {
                long l;
                long l2 = l = includeCounts ? this.speciesCountsService.getCount(countlist, Long.parseLong(nsr.get("left").toString()), Long.parseLong(nsr.get("right").toString())) : 0L;
                if (this.speciesCountsService.isEnabled() && includeCounts) {
                    if (l <= 0L && !includeAll) continue;
                    if (includeCounts) {
                        nsr.put("count", l);
                        nsr.put("distributionsCount", this.layersService.getDistributionsCount(nsr.get("lsid").toString()));
                        nsr.put("checklistsCount", this.layersService.getChecklistsCount(nsr.get("lsid").toString()));
                        nsr.put("tracksCount", this.layersService.getTracksCount(nsr.get("lsid").toString()));
                    }
                    nsr.put("images", this.speciesImageService.get(Long.parseLong((String)nsr.get("left")), Long.parseLong((String)nsr.get("right"))));
                    if (output.size() <= max) {
                        output.add(nsr);
                    }
                    ++resultsTotal;
                    continue;
                }
                ++resultsTotal;
                output.add(nsr);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)("Error thrown in autocomplete: " + exception.getMessage()), (Throwable)exception);
            }
        }
        ArrayList<Map> formatted = new ArrayList<Map>();
        for (Map map : output) {
            formatted.add(this.format(map, query));
        }
        HashMap<String, Object> wrapper = new HashMap<String, Object>();
        wrapper.put("pageSize", max);
        wrapper.put("startIndex", 0);
        wrapper.put("totalRecords", resultsTotal);
        wrapper.put("sort", "score");
        wrapper.put("dir", "desc");
        wrapper.put("status", "OK");
        wrapper.put("query", query);
        wrapper.put("results", formatted);
        HashMap<String, HashMap<String, Object>> hashMap = new HashMap<String, HashMap<String, Object>>();
        hashMap.put("searchResults", wrapper);
        return hashMap;
    }

    private Map format(Map m, String searchTerm) {
        Set commonNames;
        int pos;
        String highlight;
        HashMap<String, Object> formatted = new HashMap<String, Object>();
        String guid = (String)m.get("lsid");
        formatted.put("guid", guid);
        formatted.put("linkIdentifier", guid);
        formatted.put("name", m.get("name"));
        formatted.put("idxType", "TAXON");
        formatted.put("score", m.get("score"));
        formatted.put("left", m.get("left"));
        formatted.put("right", m.get("right"));
        Map cl = (Map)m.get("cl");
        String parentUid = null;
        if (cl != null) {
            if (guid.equals(cl.get("sid"))) {
                parentUid = (String)cl.get("gid");
            }
            if (guid.equals(cl.get("gid"))) {
                parentUid = (String)cl.get("fid");
            }
            if (guid.equals(cl.get("fid"))) {
                parentUid = (String)cl.get("oid");
            }
            if (guid.equals(cl.get("oid"))) {
                parentUid = (String)cl.get("cid");
            }
            if (guid.equals(cl.get("cid"))) {
                parentUid = (String)cl.get("pid");
            }
            if (guid.equals(cl.get("pid"))) {
                parentUid = (String)cl.get("kid");
            }
            formatted.put("parentGuid", parentUid);
            formatted.put("kingdom", cl.get("kingdom"));
            formatted.put("phylum", cl.get("phylum"));
            formatted.put("classs", cl.get("klass"));
            formatted.put("order", cl.get("order"));
            formatted.put("family", cl.get("family"));
            formatted.put("genus", cl.get("genus"));
            formatted.put("author", cl.get("authorship"));
        }
        formatted.put("hasChildren", false);
        formatted.put("rank", m.get("rank").toString().toLowerCase());
        formatted.put("rankId", m.get("rankId"));
        formatted.put("rawRank", m.get("rank"));
        formatted.put("isAustralian", "recorded");
        boolean scientificNameMatch = "scientificName".equals(m.get("match"));
        String string = highlight = scientificNameMatch ? (String)m.get("name") : (String)m.get("commonname");
        if (highlight == null) {
            Map syn;
            Iterator iterator = ((List)m.get("synonymMatch")).iterator();
            while (iterator.hasNext() && (highlight = (scientificNameMatch = "scientificName".equals((syn = (Map)iterator.next()).get("match"))) ? (String)syn.get("name") : (String)syn.get("commonname")) == null) {
            }
        }
        if (highlight != null && (pos = highlight.toLowerCase().indexOf(searchTerm.toLowerCase())) >= 0) {
            highlight = highlight.substring(0, pos) + "<strong>" + highlight.substring(pos, pos + searchTerm.length()) + "</strong>" + highlight.substring(pos + searchTerm.length(), highlight.length());
        }
        formatted.put("highlight", highlight);
        if (m.get("commonname") == null && !(commonNames = this.nameUsageMatchService.getCommonNamesForLSID((String)m.get("lsid"), Integer.valueOf(1000))).isEmpty()) {
            m.put("commonname", commonNames.iterator().next());
            m.put("commonnames", commonNames);
        }
        if (m.get("commonname") != null) {
            formatted.put("commonName", m.get("commonnames"));
            formatted.put("commonNameSingle", m.get("commonname"));
        }
        formatted.put("nameComplete", m.get("name"));
        formatted.put("occCount", m.get("count"));
        formatted.put("distributionsCount", m.get("distributionsCount"));
        formatted.put("checklistsCount", m.get("checklistsCount"));
        formatted.put("tracksCount", m.get("tracksCount"));
        SpeciesImageDTO speciesImage = (SpeciesImageDTO)m.get("images");
        if (speciesImage != null && speciesImage.getImage() != null) {
            try {
                Map im = this.occurrenceUtils.getImageFormats(speciesImage.getImage());
                formatted.put("imageSource", speciesImage.getDataResourceUid());
                formatted.put("imageCount", speciesImage.getCount());
                formatted.put("image", im.get("raw"));
                formatted.put("thumbnail", im.get("thumbnail"));
                formatted.put("imageUrl", im.get("raw"));
                formatted.put("smallImageUrl", im.get("small"));
                formatted.put("largeImageUrl", im.get("large"));
                formatted.put("thumbnailUrl", im.get("thumbnail"));
                formatted.put("imageMetadataUrl", this.imageMetadataService.getUrlFor(speciesImage.getImage()));
            }
            catch (Exception ex) {
                logger.warn((Object)("Unable to get image formats for " + speciesImage.getImage() + ": " + ex.getMessage()));
                formatted.put("imageCount", 0);
            }
        } else {
            formatted.put("imageCount", 0);
        }
        formatted.put("isExcluded", false);
        return formatted;
    }
}

