/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dao.IndexDAO;
import au.org.ala.biocache.dao.StoreDAO;
import au.org.ala.biocache.dto.AssertionCodes;
import au.org.ala.biocache.dto.AssertionStatus;
import au.org.ala.biocache.dto.QualityAssertion;
import au.org.ala.biocache.dto.UserAssertions;
import au.org.ala.biocache.util.OccurrenceUtils;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.solr.common.SolrDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AssertionService {
    private static final Logger logger = LoggerFactory.getLogger(AssertionService.class);
    @Inject
    private OccurrenceUtils occurrenceUtils;
    @Inject
    private StoreDAO store;
    @Inject
    private IndexDAO indexDao;
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public Optional<QualityAssertion> addAssertion(String recordUuid, String code, String comment, String userId, String userDisplayName, String userAssertionStatus, String assertionUuid) throws IOException {
        logger.debug("Adding assertion to: " + recordUuid + ", code: " + code + ", comment: " + comment + ", userId: " + userId + ", userDisplayName: " + userDisplayName + ", relatedRecordId: , userAssertionStatus: " + userAssertionStatus + ", assertionUuid: " + assertionUuid);
        SolrDocument sd = this.occurrenceUtils.getOcc(recordUuid);
        if (sd != null) {
            QualityAssertion qa = new QualityAssertion();
            qa.setCode(Integer.valueOf(Integer.parseInt(code)));
            qa.setComment(comment);
            qa.setUserId(userId);
            qa.setUserDisplayName(userDisplayName);
            qa.setReferenceRowKey(recordUuid);
            if (code.equals(Integer.toString(AssertionCodes.VERIFIED.getCode()))) {
                qa.setRelatedUuid(assertionUuid);
                qa.setQaStatus(Integer.valueOf(Integer.parseInt(userAssertionStatus)));
            } else {
                qa.setQaStatus(AssertionStatus.QA_UNCONFIRMED);
            }
            qa.setDataResourceUid((String)sd.getFieldValue("dataResourceUid"));
            UserAssertions existingAssertions = this.store.get(UserAssertions.class, recordUuid).orElse(new UserAssertions());
            UserAssertions newAssertions = new UserAssertions();
            newAssertions.add((Object)qa);
            UserAssertions combinedAssertions = this.getCombinedAssertions(existingAssertions, newAssertions);
            this.updateUserAssertions(recordUuid, combinedAssertions);
            return Optional.of(qa);
        }
        return Optional.empty();
    }

    public boolean deleteAssertion(String recordUuid, String assertionUuid) throws IOException {
        UserAssertions userAssertions;
        SolrDocument sd = this.occurrenceUtils.getOcc(recordUuid);
        if (sd != null && (userAssertions = this.store.get(UserAssertions.class, recordUuid).orElse(new UserAssertions())).deleteUuid(assertionUuid)) {
            this.updateUserAssertions(recordUuid, userAssertions);
            return true;
        }
        return false;
    }

    public QualityAssertion getAssertion(String recordUuid, String assertionUuid) throws IOException {
        UserAssertions userAssertions = this.store.get(UserAssertions.class, recordUuid).orElse(new UserAssertions());
        for (QualityAssertion qa : userAssertions) {
            if (!qa.getUuid().equals(assertionUuid)) continue;
            qa.setSnapshot(null);
            return qa;
        }
        return null;
    }

    public UserAssertions getAssertions(String recordUuid) throws IOException {
        UserAssertions userAssertions = this.store.get(UserAssertions.class, recordUuid).orElse(new UserAssertions());
        for (QualityAssertion qa : userAssertions) {
            qa.setSnapshot(null);
        }
        return userAssertions;
    }

    public boolean bulkAddAssertions(String recordUuid, UserAssertions userAssertions) throws IOException {
        SolrDocument sd = this.occurrenceUtils.getOcc(recordUuid);
        if (sd != null) {
            UserAssertions existingAssertions = this.store.get(UserAssertions.class, recordUuid).orElse(new UserAssertions());
            UserAssertions combinedAssertions = this.getCombinedAssertions(existingAssertions, userAssertions);
            if (!combinedAssertions.isEmpty()) {
                this.updateUserAssertions(recordUuid, combinedAssertions);
            }
            return true;
        }
        return false;
    }

    private UserAssertions getCombinedAssertions(UserAssertions existingAssertions, UserAssertions newAssertions) {
        Map<Integer, QualityAssertion> existingAssertionsMap = existingAssertions.stream().filter(qa -> !qa.getCode().equals(AssertionCodes.VERIFIED.getCode())).collect(Collectors.toMap(qa -> Objects.hash(qa.getReferenceRowKey(), qa.getCode(), qa.getUserId()), qa -> qa));
        Map<String, QualityAssertion> existingVerificationMap = existingAssertions.stream().filter(qa -> qa.getCode().equals(AssertionCodes.VERIFIED.getCode())).collect(Collectors.toMap(QualityAssertion::getRelatedUuid, qa -> qa));
        UserAssertions combined = new UserAssertions();
        List newAssertionsList = newAssertions.stream().filter(qa -> !qa.getCode().equals(AssertionCodes.VERIFIED.getCode())).collect(Collectors.toList());
        List newVerificationList = newAssertions.stream().filter(qa -> qa.getCode().equals(AssertionCodes.VERIFIED.getCode())).collect(Collectors.toList());
        for (QualityAssertion qa2 : newAssertionsList) {
            int hash = Objects.hash(qa2.getReferenceRowKey(), qa2.getCode(), qa2.getUserId());
            if (!existingAssertionsMap.containsKey(hash)) {
                combined.add((Object)qa2);
                continue;
            }
            existingAssertionsMap.put(hash, qa2);
        }
        combined.addAll(existingAssertionsMap.values());
        for (QualityAssertion verification : newVerificationList) {
            String relatedUuid = verification.getRelatedUuid();
            if (!existingVerificationMap.containsKey(relatedUuid)) {
                combined.add((Object)verification);
                continue;
            }
            existingVerificationMap.put(relatedUuid, verification);
        }
        combined.addAll(existingVerificationMap.values());
        return combined;
    }

    private void updateUserAssertions(String recordUuid, UserAssertions userAssertions) throws IOException {
        List assertionUserIds;
        if (!userAssertions.isEmpty()) {
            this.store.put(recordUuid, (Object)userAssertions);
        } else {
            this.store.delete(UserAssertions.class, recordUuid);
        }
        HashMap<String, Object> indexMap = new HashMap<String, Object>();
        Integer assertionStatus = AssertionStatus.QA_NONE;
        List assertions = userAssertions.stream().filter(qa -> !qa.getCode().equals(AssertionCodes.VERIFIED.getCode())).collect(Collectors.toList());
        List verifications = userAssertions.stream().filter(qa -> qa.getCode().equals(AssertionCodes.VERIFIED.getCode())).collect(Collectors.toList());
        List assertionIds = assertions.stream().map(QualityAssertion::getUuid).collect(Collectors.toList());
        List verifiedIds = verifications.stream().map(QualityAssertion::getRelatedUuid).collect(Collectors.toList());
        assertionIds.removeAll(verifiedIds);
        if (!assertionIds.isEmpty()) {
            assertionStatus = AssertionStatus.QA_UNCONFIRMED;
        } else if (!verifications.isEmpty()) {
            if (verifications.stream().anyMatch(qa -> qa.getQaStatus().equals(AssertionStatus.QA_OPEN_ISSUE))) {
                assertionStatus = AssertionStatus.QA_OPEN_ISSUE;
            } else {
                verifications.sort((qa1, qa2) -> {
                    try {
                        Date qa2Date = this.simpleDateFormat.parse(qa2.getCreated());
                        Date qa1Date = this.simpleDateFormat.parse(qa1.getCreated());
                        return qa2Date.compareTo(qa1Date);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        throw new IllegalArgumentException(e);
                    }
                });
                assertionStatus = ((QualityAssertion)verifications.get(0)).getQaStatus();
            }
        }
        indexMap.put("userAssertions", String.valueOf(assertionStatus));
        indexMap.put("hasUserAssertions", !assertions.isEmpty());
        if (!userAssertions.isEmpty()) {
            userAssertions.sort((qa1, qa2) -> {
                try {
                    Date date1 = this.simpleDateFormat.parse(qa1.getCreated());
                    Date date2 = this.simpleDateFormat.parse(qa2.getCreated());
                    return date2.compareTo(date1);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException(e);
                }
            });
            Date lastDate = null;
            try {
                lastDate = this.simpleDateFormat.parse(((QualityAssertion)userAssertions.get(0)).getCreated());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            indexMap.put("lastAssertionDate", lastDate);
        }
        if (!(assertionUserIds = assertions.stream().map(QualityAssertion::getUserId).distinct().collect(Collectors.toList())).isEmpty()) {
            indexMap.put("assertionUserId", assertionUserIds);
        }
        try {
            this.indexDao.indexFromMap(recordUuid, indexMap);
        }
        catch (Exception e) {
            logger.error("Failed to update Solr index, e = " + e.getMessage());
        }
    }
}

