/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum OccurrenceSource {
    NON_CITIZEN("[0 TO 2]", "Published datasets"),
    CITZEN("[2 TO *]", "Individual sightings");

    private String range;
    private String displayName;
    public static final String FACET_NAME = "SOURCES";
    private static final Map<String, OccurrenceSource> displayNameLookup;
    private static final Map<String, OccurrenceSource> rangeLookup;

    private OccurrenceSource(String r, String d) {
        this.range = r;
        this.displayName = d;
    }

    public String getRange() {
        return this.range;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static OccurrenceSource getForDisplayName(String name) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        return (OccurrenceSource)displayNameLookup.get(name.toLowerCase());
    }

    public static OccurrenceSource getForRange(String range) {
        if (StringUtils.isBlank((String)range)) {
            return null;
        }
        return (OccurrenceSource)rangeLookup.get(range);
    }

    static {
        displayNameLookup = new HashMap();
        rangeLookup = new HashMap();
        for (OccurrenceSource os : EnumSet.allOf(OccurrenceSource.class)) {
            displayNameLookup.put(os.getDisplayName().toLowerCase(), os);
            rangeLookup.put(os.getRange(), os);
        }
    }
}

