/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.dao.IndexDAO;
import au.org.ala.biocache.dao.SolrIndexDAOImpl;
import au.org.ala.biocache.dto.AssertionStatus;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.dto.SearchRequestParams;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.StatsIndexFieldDTO;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.RestartDataService;
import au.org.ala.biocache.util.DwCTerms;
import au.org.ala.biocache.util.DwcTermDetails;
import au.org.ala.biocache.util.QueryFormatUtils;
import au.org.ala.biocache.util.solr.FieldMappedSolrClient;
import au.org.ala.biocache.util.solr.FieldMappingUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.gbif.common.shaded.com.google.common.collect.Streams;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;

@Component(value="indexDao")
public class SolrIndexDAOImpl
implements IndexDAO {
    private static final Logger logger = Logger.getLogger(SolrIndexDAOImpl.class);
    @Inject
    protected LayersService layersService;
    private volatile long solrIndexVersion = 0L;
    private volatile long solrIndexVersionTime = 0L;
    private final Object solrIndexVersionLock = new Object();
    @Inject
    private FieldMappingUtil fieldMappingUtil;
    private final List<String> header = Arrays.asList("userAssertions", "hasUserAssertions", "lastAssertionDate");
    private final Map<String, Object[]> fieldProperties = new /* Unavailable Anonymous Inner Class!! */;
    @Value(value="${index.fields.tohide:_root_,_version_,collector_text,location_determined,row_key,matched_name,decimal_latitudelatitude,collectors,default_values_used,generalisation_to_apply_in_metres,geohash,ibra_subregion,identifier_by,occurrence_details,text,photo_page_url,photographer,places,portal_id,quad,rem_text,occurrence_status_s,identification_qualifier_s}")
    protected String indexFieldsToHide;
    protected Pattern layersPattern = Pattern.compile("(el|cl)[0-9abc]+");
    @Inject
    protected QueryFormatUtils queryFormatUtils;
    @Value(value="${dwc.url:http://rs.tdwg.org/dwc/terms/}")
    protected String dwcUrl = "http://rs.tdwg.org/dwc/terms/";
    @Value(value="${solr.usehttp2:false}")
    protected Boolean usehttp2;
    @Value(value="${solr.server.retry.max:6}")
    protected int maxRetries = 6;
    @Value(value="${solr.server.retry.wait:50}")
    protected long retryWait = 50L;
    @Value(value="${solr.collection:biocache}")
    protected String solrCollection;
    @Value(value="${solr.connection.pool.size:50}")
    protected Integer solrConnectionPoolSize;
    @Value(value="${solr.connection.maxperroute:50}")
    protected Integer solrConnectionMaxPerRoute;
    @Value(value="${solr.connection.connecttimeout:30000}")
    private Integer solrConnectionConnectTimeout;
    @Value(value="${solr.connection.requesttimeout:30000}")
    private Integer solrConnectionRequestTimeout;
    @Value(value="${solr.connection.sockettimeout:30000}")
    private Integer solrConnectionSocketTimeout;
    @Value(value="${solr.connection.cache.entries:500}")
    private Integer solrConnectionCacheEntries;
    @Value(value="${solr.connection.cache.object.size:262144}")
    private Integer solrConnectionCacheObjectSize;
    @Value(value="${biocache.useragent:Biocache}")
    private String userAgent;
    @Value(value="${solr.update.threads:4}")
    Integer solrUpdateThreads;
    @Value(value="${solr.batch.size:1000}")
    Integer solrBatchSize;
    @Value(value="${solr.legacyFieldNameSupport:true}")
    Boolean legacyFieldNameSupport;
    @Value(value="${solr.server.indexVersion.refresh:300000}")
    protected int solrIndexVersionRefreshTime = 300000;
    @Value(value="${solr.home:}")
    protected String solrHome;
    SolrClient solrClient;
    CloseableHttpClient httpClient;
    HttpClientConnectionManager connectionPoolManager;
    private final Map<String, StatsIndexFieldDTO> rangeFieldCache = new HashMap();
    private volatile Set<IndexFieldDTO> indexFields = new ConcurrentHashSet();
    private volatile Map<String, IndexFieldDTO> indexFieldMap = (Map)RestartDataService.get((Object)this, (String)"indexFieldMap", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);
    private volatile Set<String> schemaFields = new HashSet();
    @Inject
    protected AbstractMessageSource messageSource;

    @PostConstruct
    public void init() {
        if (this.solrClient == null) {
            Http2SolrClient solrClient = null;
            if (this.usehttp2.booleanValue()) {
                if (!this.solrHome.startsWith("http")) {
                    String[] zkHosts = this.solrHome.split(",");
                    ArrayList<String> hosts = new ArrayList<String>();
                    for (String zkHost : zkHosts) {
                        hosts.add(zkHost.trim());
                    }
                    CloudHttp2SolrClient.Builder builder = new CloudHttp2SolrClient.Builder(hosts, Optional.empty());
                    CloudHttp2SolrClient client = builder.build();
                    client.setDefaultCollection(this.solrCollection);
                    solrClient = client;
                } else {
                    Http2SolrClient.Builder builder = new Http2SolrClient.Builder(this.solrHome);
                    builder.connectionTimeout(this.solrConnectionConnectTimeout.intValue());
                    builder.maxConnectionsPerHost(this.solrConnectionMaxPerRoute.intValue());
                    solrClient = builder.build();
                }
            } else {
                logger.info((Object)("Initialising the solr server " + this.solrHome));
                PoolingHttpClientConnectionManager poolingConnectionPoolManager = new PoolingHttpClientConnectionManager();
                poolingConnectionPoolManager.setMaxTotal(this.solrConnectionPoolSize.intValue());
                poolingConnectionPoolManager.setDefaultMaxPerRoute(this.solrConnectionMaxPerRoute.intValue());
                CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(this.solrConnectionCacheEntries.intValue()).setMaxObjectSize((long)this.solrConnectionCacheObjectSize.intValue()).setSharedCache(false).build();
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.solrConnectionConnectTimeout.intValue()).setConnectionRequestTimeout(this.solrConnectionRequestTimeout.intValue()).setSocketTimeout(this.solrConnectionSocketTimeout.intValue()).build();
                this.httpClient = CachingHttpClientBuilder.create().setCacheConfig(cacheConfig).setDefaultRequestConfig(requestConfig).setConnectionManager(this.connectionPoolManager).setUserAgent(this.userAgent).useSystemProperties().build();
                if (!this.solrHome.startsWith("http://")) {
                    if (this.solrHome.contains(":")) {
                        CloudSolrClient cloudServer = ((CloudSolrClient.Builder)new CloudSolrClient.Builder().withZkHost(this.solrHome).withHttpClient((HttpClient)this.httpClient)).build();
                        cloudServer.setDefaultCollection(this.solrCollection);
                        solrClient = cloudServer;
                        try {
                            solrClient.ping();
                        }
                        catch (Exception e) {
                            logger.error((Object)"ping failed", (Throwable)e);
                        }
                    } else {
                        logger.error((Object)("Failed to initialise connection to SOLR server with solrHome: " + this.solrHome));
                    }
                } else {
                    logger.info((Object)("Initialising connection to SOLR server..... with solrHome:  " + this.solrHome));
                    solrClient = new ConcurrentUpdateSolrClient.Builder(this.solrHome).withThreadCount(this.solrUpdateThreads.intValue()).withQueueSize(this.solrBatchSize.intValue()).build();
                    logger.info((Object)"Initialising connection to SOLR server - done.");
                }
            }
            if (solrClient != null) {
                this.solrClient = new FieldMappedSolrClient(this.fieldMappingUtil, (SolrClient)solrClient);
            }
        }
    }

    public void destroy() {
        try {
            this.solrClient.close();
        }
        catch (IOException e) {
            logger.error((Object)"failed to close solrClient", (Throwable)e);
        }
    }

    public QueryResponse query(SolrParams query) throws Exception {
        int retry = 0;
        QueryResponse qr = null;
        while (retry < this.maxRetries && qr == null) {
            ++retry;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("SOLR query:" + query.toString()));
                }
                qr = this.solrClient.query(query, SolrRequest.METHOD.POST);
            }
            catch (SolrServerException e) {
                if (retry < this.maxRetries && (e.getMessage().contains("IOException") || e.getMessage().contains("Proxy Error"))) {
                    if (this.retryWait <= 0L) continue;
                    try {
                        Thread.sleep(this.retryWait);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                }
                throw e;
            }
            catch (SolrException e) {
                if (this.solrClient instanceof CloudSolrClient && e.getMessage().contains("Could not load collection")) {
                    this.logError(query, "query failed, attempting to reconnect: ", e.getMessage());
                    try {
                        ((CloudSolrClient)this.solrClient).getClusterStateProvider().close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    ((CloudSolrClient)this.solrClient).getClusterStateProvider().connect();
                    try {
                        this.solrClient.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    ((CloudSolrClient)this.solrClient).connect();
                    if (retry < this.maxRetries) {
                        if (this.retryWait <= 0L) continue;
                        try {
                            Thread.sleep(this.retryWait);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                    }
                    throw e;
                }
                this.logError(query, "query failed-1: ", e.getMessage());
                throw e;
            }
            catch (IOException ioe) {
                this.logError(query, "query failed-IOException: ", ioe.getMessage());
                throw new SolrServerException((Throwable)ioe);
            }
            catch (Exception ioe) {
                this.logError(query, "query failed-SolrServerException: ", ioe.getMessage());
                throw new SolrServerException((Throwable)ioe);
            }
        }
        return qr;
    }

    private void logError(SolrParams query, String s, String message) {
        String requestID = MDC.get((String)"X-Request-ID");
        if (requestID != null) {
            logger.error((Object)("RequestID:" + requestID + ", " + s + query.toString() + ", Error : " + message));
        } else {
            logger.error((Object)(s + query.toString() + " : " + message));
        }
    }

    private Set<IndexFieldDTO> parseLukeResponse(String str, boolean includeCounts) {
        Pattern indexVersion = Pattern.compile("(?:version=)([0-9]{1,})");
        try {
            Matcher indexVersionMatcher = indexVersion.matcher(str);
            if (indexVersionMatcher.find(0)) {
                this.solrIndexVersion = Long.parseLong(indexVersionMatcher.group(1));
                this.solrIndexVersionTime = System.currentTimeMillis();
            }
        }
        catch (Exception indexVersionMatcher) {
            // empty catch block
        }
        AbstractSet fieldList = includeCounts ? new LinkedHashSet() : new TreeSet();
        Pattern typePattern = Pattern.compile("(?:type=)([a-z]{1,})");
        Pattern schemaPattern = Pattern.compile("(?:schema=)([a-zA-Z\\-]{1,})");
        Pattern distinctPattern = Pattern.compile("(?:distinct=)([0-9]{1,})");
        String[] fieldsStr = str.split("fields=\\{");
        Map indexToJsonMap = new OccurrenceIndex().indexToJsonMap();
        for (String fieldStr : fieldsStr) {
            if (fieldStr == null || "".equals(fieldStr)) continue;
            Object[] fields = includeCounts ? fieldStr.split("\\}\\},") : fieldStr.split("\\},");
            Arrays.sort(fields);
            for (Object field : fields) {
                this.formatIndexField((String)field, null, (Set)fieldList, typePattern, schemaPattern, indexToJsonMap, distinctPattern);
            }
        }
        this.fieldMappingUtil.getFieldMappingStream().forEach(fieldMapping -> {
            IndexFieldDTO deprecatedFields = new IndexFieldDTO();
            deprecatedFields.setName((String)fieldMapping.getKey());
            deprecatedFields.setDeprecated(true);
            if (fieldMapping.getValue() != null) {
                deprecatedFields.setNewFieldName((String)fieldMapping.getValue());
            }
            fieldList.add(deprecatedFields);
        });
        List<Object> toIgnore = new ArrayList();
        HashSet<IndexFieldDTO> filteredFieldList = new HashSet<IndexFieldDTO>();
        if (this.indexFieldsToHide != null) {
            toIgnore = Arrays.asList(this.indexFieldsToHide.split(","));
        }
        for (IndexFieldDTO indexedField : fieldList) {
            if (toIgnore.contains(indexedField.getName())) continue;
            filteredFieldList.add(indexedField);
        }
        return filteredFieldList;
    }

    public Set<IndexFieldDTO> getIndexFieldDetails(String ... fields) throws Exception {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("qt", new String[]{"/admin/luke"});
        params.set("tr", new String[]{"luke.xsl"});
        if (fields != null) {
            params.set("fl", new String[]{String.join((CharSequence)",", fields)});
            params.set("numTerms", new String[]{"1"});
        } else {
            params.set("numTerms", new String[]{"0"});
        }
        QueryResponse response = this.query((SolrParams)params);
        return this.parseLukeResponse(response.toString(), fields != null);
    }

    public Set<String> getSchemaFields() throws Exception {
        return this.getSchemaFields(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSchemaFields(boolean update) throws Exception {
        Set result = this.schemaFields;
        if (result.size() == 0 || update) {
            Object object = this.solrIndexVersionLock;
            synchronized (object) {
                result = this.schemaFields;
                if (result.size() == 0 || update) {
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("qt", new String[]{"/admin/luke"});
                    params.set("show", new String[]{"schema"});
                    QueryResponse response = this.query((SolrParams)params);
                    NamedList schemaFields = (NamedList)((NamedList)response.getResponse().get("schema")).get("fields");
                    result = Streams.stream((Iterator)schemaFields.iterator()).map(Map.Entry::getKey).collect(Collectors.toSet());
                    if (result != null && result.size() > 0) {
                        this.schemaFields = result;
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getIndexVersion(Boolean force) {
        2 t = null;
        Object object = this.solrIndexVersionLock;
        synchronized (object) {
            boolean immediately;
            boolean bl = immediately = this.solrIndexVersionTime == 0L;
            if (force.booleanValue() || this.solrIndexVersionTime < System.currentTimeMillis() - (long)this.solrIndexVersionRefreshTime) {
                this.solrIndexVersionTime = System.currentTimeMillis();
                t = new /* Unavailable Anonymous Inner Class!! */;
                if (immediately) {
                    t.start();
                    try {
                        t.join();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.error((Object)"Failed to update solrIndexVersion", (Throwable)e);
                    }
                } else if (!force.booleanValue()) {
                    t.start();
                }
            }
        }
        if (force.booleanValue() && t != null) {
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Failed to update solrIndexVersion", (Throwable)e);
            }
        }
        return this.solrIndexVersion;
    }

    public StatsIndexFieldDTO getRangeFieldDetails(String field) {
        StatsIndexFieldDTO details;
        block5: {
            details = (StatsIndexFieldDTO)this.rangeFieldCache.get(field);
            Map nextIndexFieldMap = this.indexFieldMap;
            if (details == null && nextIndexFieldMap != null) {
                SpatialSearchRequestParams searchParams = new SpatialSearchRequestParams();
                searchParams.setQ("*:*");
                searchParams.setFacets(new String[]{field});
                try {
                    Map stats = this.getStatistics(searchParams);
                    if (stats == null) break block5;
                    IndexFieldDTO ifdto = (IndexFieldDTO)nextIndexFieldMap.get(field);
                    if (ifdto != null) {
                        String type = ifdto.getDataType();
                        details = new StatsIndexFieldDTO((FieldStatsInfo)stats.get(field), type);
                        this.rangeFieldCache.put(field, details);
                        break block5;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unable to locate field:  " + field));
                    }
                    return null;
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to obtain range from cache.", (Throwable)e);
                    details = null;
                }
            }
        }
        return details;
    }

    private void formatIndexField(String indexField, String cassandraField, Set<IndexFieldDTO> fieldList, Pattern typePattern, Pattern schemaPattern, Map indexToJsonMap, Pattern distinctPattern) {
        if (indexField != null && !"".equals(indexField)) {
            Matcher distinctMatcher;
            Matcher schemaMatcher;
            IndexFieldDTO f = new IndexFieldDTO();
            String fieldName = indexField.split("=")[0];
            String type = null;
            String schema = null;
            Matcher typeMatcher = typePattern.matcher(indexField);
            if (typeMatcher.find(0)) {
                type = typeMatcher.group(1);
            }
            if ((schemaMatcher = schemaPattern.matcher(indexField)).find(0)) {
                schema = schemaMatcher.group(1);
            }
            if (StringUtils.isNotEmpty((String)fieldName) && !fieldName.startsWith("sensitive_") && (cassandraField != null || schema != null)) {
                f.setName(fieldName);
                if (type != null) {
                    f.setDataType(type);
                } else {
                    f.setDataType("string");
                }
                if (schema != null) {
                    f.setIndexed(schema.contains("I"));
                    f.setStored(schema.contains("S"));
                    f.setMultivalue(schema.contains("M"));
                    f.setDocvalue(schema.contains("D"));
                }
                if (this.layersPattern.matcher(fieldName).matches()) {
                    f.setDownloadName(fieldName);
                    String description = (String)this.layersService.getLayerNameMap().get(fieldName);
                    f.setDescription(description);
                    f.setDownloadDescription(description);
                    f.setInfo(this.layersService.getLayersServiceUrl() + "/layers/view/more/" + fieldName);
                    if (fieldName.startsWith("el")) {
                        f.setClasss("Environmental");
                    } else {
                        f.setClasss("Contextual");
                    }
                } else {
                    String classs;
                    String i18nValues;
                    String json;
                    String description;
                    String downloadField = fieldName;
                    if (cassandraField != null) {
                        downloadField = cassandraField;
                    }
                    if (downloadField != null) {
                        f.setDownloadName(downloadField);
                    }
                    fieldName = this.fieldMappingUtil.translateFieldName(fieldName);
                    String downloadFieldDescription = this.messageSource.getMessage(downloadField = this.fieldMappingUtil.translateFieldName(downloadField), null, "", Locale.getDefault());
                    if (downloadFieldDescription.length() > 0) {
                        f.setDownloadDescription(downloadFieldDescription);
                        f.setDescription(downloadFieldDescription);
                    }
                    if ((description = this.messageSource.getMessage("facet." + fieldName, null, "", Locale.getDefault())).length() > 0) {
                        f.setDescription(description);
                    } else if (downloadField != null && (description = this.messageSource.getMessage(downloadField, null, "", Locale.getDefault())).length() > 0) {
                        f.setDescription(description);
                    }
                    String info = this.messageSource.getMessage("description." + fieldName, null, "", Locale.getDefault());
                    if (info.length() > 0) {
                        f.setInfo(info);
                    } else if (downloadField != null && (info = this.messageSource.getMessage("description." + downloadField, null, "", Locale.getDefault())).length() > 0) {
                        f.setInfo(info);
                    }
                    DwcTerm term = null;
                    try {
                        term = DwcTerm.valueOf((String)fieldName);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    boolean dcterm = false;
                    try {
                        term = DcTerm.valueOf((String)fieldName);
                        dcterm = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (term == null) {
                        String dwcTerm = this.messageSource.getMessage("dwc." + fieldName, null, "", Locale.getDefault());
                        if (downloadField != null) {
                            dwcTerm = this.messageSource.getMessage("dwc." + downloadField, null, "", Locale.getDefault());
                        }
                        if (dwcTerm.length() > 0) {
                            f.setDwcTerm(dwcTerm);
                            try {
                                DwcTermDetails dwcTermDetails;
                                term = DwcTerm.valueOf((String)dwcTerm);
                                if (term != null) {
                                    f.setClasss(term.getGroup());
                                }
                                if ((dwcTermDetails = DwCTerms.getInstance().getDwCTermDetails(term.simpleName())) != null) {
                                    if (f.getInfo() == null) {
                                        f.setInfo(dwcTermDetails.comment);
                                    }
                                    if (f.getDescription() == null) {
                                        f.setDescription(dwcTermDetails.label);
                                    }
                                }
                            }
                            catch (IllegalArgumentException dwcTermDetails) {}
                        }
                    } else {
                        f.setDwcTerm(term.simpleName());
                        if (term instanceof DwcTerm) {
                            f.setClasss(term.getGroup());
                        } else {
                            f.setClasss("Record");
                            f.setDwcTerm("dcterms:" + term.simpleName());
                        }
                        DwcTermDetails dwcTermDetails = DwCTerms.getInstance().getDwCTermDetails(term.simpleName());
                        if (dwcTermDetails != null) {
                            if (f.getInfo() == null) {
                                f.setInfo(dwcTermDetails.comment);
                            }
                            if (f.getDescription() == null) {
                                f.setDescription(dwcTermDetails.label);
                            }
                        }
                    }
                    if (!dcterm && f.getDwcTerm() != null && !f.getDwcTerm().isEmpty() && StringUtils.isNotEmpty((String)this.dwcUrl)) {
                        if (info.length() > 0) {
                            info = info + " ";
                        }
                        f.setInfo(info + this.dwcUrl + f.getDwcTerm());
                    }
                    if ((json = (String)indexToJsonMap.get(fieldName)) != null) {
                        f.setJsonName(json);
                    }
                    if ((i18nValues = this.messageSource.getMessage("i18nvalues." + fieldName, null, "", Locale.getDefault())).length() > 0) {
                        f.setI18nValues(Boolean.valueOf("true".equalsIgnoreCase(i18nValues)));
                    }
                    if ((classs = this.messageSource.getMessage("class." + fieldName, null, "", Locale.getDefault())).length() > 0) {
                        f.setClasss(classs);
                    }
                }
                fieldList.add(f);
            }
            if ((distinctMatcher = distinctPattern.matcher(indexField)).find(0)) {
                Integer distinct = Integer.parseInt(distinctMatcher.group(1));
                f.setNumberDistinctValues(distinct);
            }
        }
    }

    public Set<IndexFieldDTO> getIndexedFields() throws Exception {
        return this.getIndexedFields(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IndexFieldDTO> getIndexedFields(boolean update) throws Exception {
        Set result = this.indexFields;
        if (result.size() == 0 || update) {
            Object object = this.solrIndexVersionLock;
            synchronized (object) {
                result = this.indexFields;
                if ((result.size() == 0 || update) && (result = this.getIndexFieldDetails(null)) != null && result.size() > 0) {
                    HashMap<String, IndexFieldDTO> resultMap = new HashMap<String, IndexFieldDTO>();
                    for (IndexFieldDTO field : result) {
                        resultMap.put(field.getName(), field);
                    }
                    this.indexFields = result;
                    this.indexFieldMap = resultMap;
                }
            }
        }
        return result;
    }

    public Map<String, IndexFieldDTO> getIndexedFieldsMap() throws Exception {
        this.getIndexedFields();
        return this.indexFieldMap;
    }

    public Map<String, FieldStatsInfo> getStatistics(SpatialSearchRequestParams searchParams) throws Exception {
        try {
            this.queryFormatUtils.formatSearchQuery(searchParams);
            String queryString = searchParams.getFormattedQuery();
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(queryString);
            for (String field : searchParams.getFacets()) {
                solrQuery.setGetFieldStatistics(field);
            }
            QueryResponse qr = this.runSolrQuery(solrQuery, (SearchRequestParams)searchParams);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)qr.getFieldStatsInfo());
            }
            return qr.getFieldStatsInfo();
        }
        catch (SolrServerException ex) {
            String requestID = MDC.get((String)"X-Request-ID");
            if (requestID != null) {
                logger.error((Object)("Problem communicating with SOLR server. RequestID:" + requestID + " Error:" + ex.getMessage()), (Throwable)ex);
            } else {
                logger.error((Object)("Problem communicating with SOLR server. Error:" + ex.getMessage()), (Throwable)ex);
            }
            return null;
        }
    }

    public QueryResponse runSolrQuery(SolrQuery solrQuery, SearchRequestParams requestParams) throws Exception {
        if (MDC.get((String)"X-Request-ID") != null) {
            solrQuery.add("XRequestID", new String[]{MDC.get((String)"X-Request-ID")});
        }
        if (requestParams.getFormattedFq() != null) {
            for (String fq : requestParams.getFormattedFq()) {
                if (!StringUtils.isNotEmpty((String)fq)) continue;
                solrQuery.addFilterQuery(new String[]{fq});
            }
        }
        if (MDC.get((String)"X-Request-ID") != null) {
            solrQuery.setParam("XRequestID", new String[]{MDC.get((String)"X-Request-ID")});
        }
        solrQuery.setFacetMissing(Boolean.valueOf(true));
        solrQuery.setRows(requestParams.getPageSize());
        solrQuery.setStart(requestParams.getStart());
        if (StringUtils.isNotEmpty((String)requestParams.getDir())) {
            solrQuery.setSort(requestParams.getSort(), SolrQuery.ORDER.valueOf((String)requestParams.getDir()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Solr query: " + solrQuery.toString()));
        }
        QueryResponse qr = this.query((SolrParams)solrQuery);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("qtime:" + qr.getQTime()));
            if (qr.getResults() == null) {
                logger.debug((Object)"no results");
            } else {
                logger.debug((Object)("Matched records: " + qr.getResults().getNumFound()));
            }
        }
        return qr;
    }

    private List<Object> getValues(Map<String, Object> map) {
        String userAssertionStatus = (String)map.getOrDefault("userAssertions", String.valueOf(AssertionStatus.QA_NONE));
        if (userAssertionStatus.equals(String.valueOf(AssertionStatus.QA_NONE))) {
            userAssertionStatus = "";
        }
        boolean hasUserAssertions = (Boolean)map.getOrDefault("hasUserAssertions", false);
        Date lastAssertionDate = map.getOrDefault("lastAssertionDate", null);
        return Arrays.asList(userAssertionStatus, hasUserAssertions, lastAssertionDate);
    }

    public void indexFromMap(String guid, Map<String, Object> map) throws IOException, SolrServerException {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.addField("id", (Object)guid);
        List values = this.getValues(map);
        if (values.size() > 0 && values.size() != this.header.size()) {
            logger.error((Object)"Values don't match headers");
            return;
        }
        for (int i = 0; i < this.header.size(); ++i) {
            String key = (String)this.header.get(i);
            Object value = values.get(i);
            doc.addField(key, (Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        doc.addField("assertionUserId", (Object)new /* Unavailable Anonymous Inner Class!! */);
        this.syncDocFieldsWithSOLR(doc);
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, false);
        updateRequest.add(doc);
        try {
            updateRequest.process(this.solrClient);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to update solr doc, id: " + guid + ", error message: " + e.getMessage()), (Throwable)e);
        }
    }

    private void syncDocFieldsWithSOLR(SolrInputDocument doc) {
        doc.getFieldNames().forEach(fieldName -> {
            if (!this.schemaFields.contains(fieldName)) {
                Object[] properties = (Object[])this.fieldProperties.get(fieldName);
                this.addFieldToSolr(fieldName, (String)properties[0], (Boolean)properties[1], (Boolean)properties[2], (Boolean)properties[3], (Boolean)properties[4]);
                this.schemaFields.add(fieldName);
            }
        });
    }

    private void addFieldToSolr(String name, String fieldType, Boolean multiValued, Boolean docValues, Boolean indexed, Boolean stored) {
        try {
            SchemaRequest.Field fieldRequest = new SchemaRequest.Field(name);
            fieldRequest.process(this.solrClient);
        }
        catch (Exception e) {
            logger.info((Object)("Field not in schema: " + name));
            HashMap<String, Object> field = new HashMap<String, Object>();
            field.put("name", name);
            field.put("type", fieldType);
            field.put("multiValued", multiValued);
            field.put("docValues", docValues);
            field.put("indexed", indexed);
            field.put("stored", stored);
            SchemaRequest.AddField addField = new SchemaRequest.AddField(field);
            try {
                logger.info((Object)("Adding field: " + name));
                addField.process(this.solrClient);
            }
            catch (Exception e1) {
                logger.error((Object)("Failed to add a new field '" + name + "' to SOLR schema. " + e1.getMessage()));
            }
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

