/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Store;
import au.org.ala.biocache.dto.Facet;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.model.Qid;
import au.org.ala.biocache.parser.AdHocParser;
import au.org.ala.biocache.util.QueryFormatUtils;
import au.org.ala.biocache.web.AbstractSecureController;
import au.org.ala.biocache.web.UploaderThread;
import au.org.ala.biocache.web.UserUpload;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UploadController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(UploadController.class);
    @Value(value="${registry.url:https://collections.ala.org.au/ws}")
    protected String registryUrl;
    @Value(value="${upload.status:/data/biocache-upload/status}")
    protected String uploadStatusDir;
    @Value(value="${upload.temp:/data/biocache-upload/temp}")
    protected String uploadTempDir;
    @Value(value="${upload.threads:4}")
    protected Integer uploadThreads;
    @Value(value="${webservices.root:https://biocache-ws.ala.org.au/ws}")
    protected String webservicesRoot;
    @Value(value="${registry.api.key:ABAABABABABABABABAABABABBABA}")
    protected String apiKey;
    @Inject
    protected QueryFormatUtils queryFormatUtils;
    private Pattern dataResourceUidP = Pattern.compile("data_resource_uid:([\\\"]{0,1}[a-z]{2,3}[0-9]{1,}[\\\"]{0,1})");
    protected static List<String> alreadyIndexedFields = Arrays.asList("eventDate", "scientificName", "commonName", "isoCountryCode", "country", "kingdom", "phylum", "class", "order", "family", "genus", "species", "stateProvince", "places", "decimalLatitude", "decimalLongitude", "year", "month", "basisOfRecord", "typeStatus", "collector", "establishmentMeans", "coordinateUncertaintyInMeters", "decimalLatitude", "decimalLongitude");

    @RequestMapping(value={"/upload/status/{tempDataResourceUid}.json", "/upload/status/{tempDataResourceUid}"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> uploadStatus(@PathVariable String tempDataResourceUid, HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        File file = new File(this.uploadStatusDir + File.separator + tempDataResourceUid);
        for (int retries = 5; file.exists() && retries > 0; --retries) {
            try {
                String value = FileUtils.readFileToString((File)file);
                ObjectMapper om = new ObjectMapper();
                return (Map)om.readValue(value, Map.class);
            }
            catch (Exception e) {
                Thread.sleep(50L);
                continue;
            }
        }
        response.sendError(404);
        return null;
    }

    @RequestMapping(value={"/upload/charts/{tempDataResourceUid}"}, method={RequestMethod.POST})
    public void saveChartOptions(@PathVariable String tempDataResourceUid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        List chartOptions = (List)mapper.readValue((Reader)request.getReader(), List.class);
        String checkedString = mapper.writeValueAsString((Object)chartOptions);
        Store.storeCustomChartOptions((String)tempDataResourceUid, (String)checkedString);
        response.setStatus(201);
    }

    @RequestMapping(value={"/upload/charts/{tempDataResourceUid}", "/upload/charts/{tempDataResourceUid}.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getChartOptions(@PathVariable String tempDataResourceUid, HttpServletResponse response) throws Exception {
        String json = Store.retrieveCustomChartOptions((String)tempDataResourceUid);
        response.setContentType("application/json");
        ObjectMapper om = new ObjectMapper();
        List list = (List)om.readValue(json, List.class);
        if (list.isEmpty()) {
            String[] fields;
            for (String field : fields = Store.retrieveCustomIndexFields((String)tempDataResourceUid)) {
                HashMap<String, Object> chartConfig = new HashMap<String, Object>();
                chartConfig.put("field", field);
                chartConfig.put("format", "pie");
                chartConfig.put("visible", true);
                list.add(chartConfig);
            }
        }
        return list;
    }

    @RequestMapping(value={"/upload/layers/{tempDataResourceUid}"}, method={RequestMethod.POST})
    public void saveLayerOptions(@PathVariable String tempDataResourceUid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        List layerOptions = (List)mapper.readValue((Reader)request.getReader(), List.class);
        String checkedString = mapper.writeValueAsString((Object)layerOptions);
        Store.storeLayerOptions((String)tempDataResourceUid, (String)checkedString);
        response.setStatus(201);
    }

    @RequestMapping(value={"/upload/layers/{tempDataResourceUid}", "/upload/layers/{tempDataResourceUid}.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getLayerOptions(@PathVariable String tempDataResourceUid, HttpServletResponse response) throws Exception {
        String json = Store.retrieveLayerOptions((String)tempDataResourceUid);
        response.setContentType("application/json");
        ObjectMapper om = new ObjectMapper();
        List list = (List)om.readValue(json, List.class);
        return list;
    }

    @RequestMapping(value={"/upload/customIndexes/{tempDataResourceUid}.json", "/upload/customIndexes/{tempDataResourceUid}"}, method={RequestMethod.GET})
    @ResponseBody
    public String[] customIndexes(@PathVariable String tempDataResourceUid, HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        return Store.retrieveCustomIndexFields((String)tempDataResourceUid);
    }

    List<String> getDrsFromQuery(String queryExpression) {
        ArrayList<String> drs = new ArrayList<String>();
        if (queryExpression.contains("qid:")) {
            Qid qid = this.queryFormatUtils.extractQid(queryExpression);
            drs.addAll(this.extractDrsFromExpression(qid.getQ()));
            if (qid.getFqs() != null) {
                for (String fq : qid.getFqs()) {
                    drs.addAll(this.extractDrsFromExpression(fq));
                }
            }
        } else if (queryExpression != null) {
            drs.addAll(this.extractDrsFromExpression(queryExpression));
        }
        return drs;
    }

    List<String> extractDrsFromExpression(String queryExpression) {
        ArrayList<String> drs = new ArrayList<String>();
        Matcher m = this.dataResourceUidP.matcher(queryExpression);
        while (m.find()) {
            for (int x = 0; x < m.groupCount(); ++x) {
                drs.add(m.group(x).replaceAll("data_resource_uid:", "").replaceAll("\\\"", ""));
            }
        }
        return drs;
    }

    @RequestMapping(value={"/upload/dynamicFacets"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Facet> dynamicFacets(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        ArrayList drs = new ArrayList();
        drs.addAll(this.getDrsFromQuery(requestParams.getQ()));
        drs.addAll(this.getDrsFromQuery(requestParams.getQc()));
        for (String fq : requestParams.getFq()) {
            drs.addAll(this.getDrsFromQuery(fq));
        }
        response.setContentType("application/json");
        ArrayList<Facet> fs = new ArrayList<Facet>();
        for (String dr : drs) {
            String[] facetsRaw;
            String[] stringArray = facetsRaw = Store.retrieveCustomIndexFields((String)dr);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String f;
                String displayName = f = stringArray[i];
                boolean isRange = false;
                if (displayName.endsWith("_s")) {
                    displayName = displayName.substring(0, displayName.length() - 2);
                } else if (displayName.endsWith("_i") || displayName.endsWith("_d")) {
                    displayName = displayName.substring(0, displayName.length() - 2);
                    isRange = true;
                }
                displayName = displayName.replaceAll("_", " ");
                fs.add(new Facet(f, StringUtils.capitalize((String)displayName)));
                if (!isRange) continue;
                fs.add(new Facet(f + "_RNG", StringUtils.capitalize((String)displayName) + "(Range)"));
            }
        }
        return fs;
    }

    List<String> filterCustomIndexFields(List<String> suppliedHeaders) {
        ArrayList<String> customIndexFields = new ArrayList<String>();
        for (String hdr : suppliedHeaders) {
            if (alreadyIndexedFields.contains(hdr)) continue;
            customIndexFields.add(hdr);
        }
        return customIndexFields;
    }

    List<String> filterByMaxColumnLengths(String[] headers, CSVReader csvReader, int maxColumnLength) throws Exception {
        int[] columnLengths = new int[headers.length];
        for (int i = 0; i < columnLengths.length; ++i) {
            columnLengths[i] = 0;
        }
        String[] fields = csvReader.readNext();
        while (fields != null) {
            for (int j = 0; j < columnLengths.length; ++j) {
                if (fields.length <= j || columnLengths[j] >= fields[j].length()) continue;
                columnLengths[j] = fields[j].length();
            }
            fields = csvReader.readNext();
        }
        ArrayList<String> filterList = new ArrayList<String>();
        for (int k = 0; k < columnLengths.length; ++k) {
            logger.debug((Object)("Column length: " + headers[k] + " = " + columnLengths[k]));
            if (columnLengths[k] > maxColumnLength) continue;
            filterList.add(headers[k]);
        }
        return filterList;
    }

    void mkWorkingDirs() throws Exception {
        File uploadTempDirF;
        File uploadStatusDirF = new File(this.uploadStatusDir);
        if (!uploadStatusDirF.exists()) {
            FileUtils.forceMkdir((File)uploadStatusDirF);
        }
        if (!(uploadTempDirF = new File(this.uploadTempDir)).exists()) {
            FileUtils.forceMkdir((File)uploadTempDirF);
        }
    }

    String[] getHeaders(HttpServletRequest request) {
        String headers = request.getParameter("headers");
        String[] headerUnmatched = this.cleanUpHeaders(headers.split(","));
        return AdHocParser.mapOrReturnColumnHeadersArray((String[])headerUnmatched);
    }

    String[] cleanUpHeaders(String[] headers) {
        int i = 0;
        for (String hdr : headers) {
            headers[i] = hdr.replaceAll("[^a-zA-Z0-9]+", "_");
            ++i;
        }
        return headers;
    }

    @RequestMapping(value={"/upload/{tempDataResourceUid}"}, method={RequestMethod.DELETE})
    public void deleteResource(@PathVariable String tempDataResourceUid, @RequestParam(value="apiKey", required=true) String apiKey, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean apiKeyValid = this.shouldPerformOperation(request, response);
        if (!apiKeyValid) {
            response.sendError(401, "Supplied API key not recognised");
            return;
        }
        boolean success = this.deleteTempResource(tempDataResourceUid);
        try {
            Store.deleteRecords((String)tempDataResourceUid, null, (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            logger.error((Object)("Error thrown deleting resource: " + e.getMessage()), (Throwable)e);
            response.sendError(500, "Unable to delete data from index/database.");
            return;
        }
        if (success) {
            response.setStatus(200);
        } else {
            response.sendError(500, "Unable to remove reference from the registry.");
        }
    }

    @RequestMapping(value={"/upload/post", "/upload/"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> uploadOccurrenceData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String dataResourceUid = request.getParameter("dataResourceUid");
        String urlToZippedData = request.getParameter("csvZippedUrl");
        String csvDataAsString = request.getParameter("csvData");
        String datasetName = request.getParameter("datasetName");
        String alaId = request.getParameter("alaId");
        String uiUrl = request.getParameter("uiUrl");
        String colheaders = request.getParameter("headers");
        if (StringUtils.isEmpty((String)urlToZippedData) && StringUtils.isEmpty((String)csvDataAsString)) {
            response.sendError(400, "Must supply 'csvZippedUrl' or 'csvData'");
            return null;
        }
        if (StringUtils.isEmpty((String)datasetName) && StringUtils.isEmpty((String)dataResourceUid)) {
            response.sendError(400, "Must supply 'datasetName' or a 'dataResourceUid'");
            return null;
        }
        if (StringUtils.isEmpty((String)colheaders)) {
            response.sendError(400, "Must supply column headers in 'headers' request param");
            return null;
        }
        try {
            Throwable throwable;
            CSVReader readerForCol;
            this.mkWorkingDirs();
            String[] headers = this.getHeaders(request);
            boolean firstLineIsData = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"firstLineIsData");
            String[] customIndexFields = null;
            int lineCount = -1;
            CSVReader csvData = null;
            if (urlToZippedData != null) {
                File csvFile = this.downloadCSV(urlToZippedData);
                lineCount = this.doLineCount(csvFile);
                logger.debug((Object)("Line count: " + lineCount));
                readerForCol = new CSVReader((Reader)new FileReader(csvFile), ',', '\"');
                throwable = null;
                try {
                    List filteredHeaders = this.filterByMaxColumnLengths(headers, readerForCol, 50);
                    filteredHeaders = this.filterCustomIndexFields(filteredHeaders);
                    customIndexFields = filteredHeaders.toArray(new String[0]);
                }
                catch (Throwable filteredHeaders) {
                    throwable = filteredHeaders;
                    throw filteredHeaders;
                }
                finally {
                    if (readerForCol != null) {
                        if (throwable != null) {
                            try {
                                readerForCol.close();
                            }
                            catch (Throwable filteredHeaders) {
                                throwable.addSuppressed(filteredHeaders);
                            }
                        } else {
                            readerForCol.close();
                        }
                    }
                }
                csvData = new CSVReader((Reader)new FileReader(csvFile), ',', '\"');
            } else {
                char separatorChar = this.getSeparatorChar(request);
                lineCount = this.doLineCount(csvDataAsString);
                readerForCol = new CSVReader((Reader)new StringReader(csvDataAsString), separatorChar, '\"');
                throwable = null;
                try {
                    List filteredHeaders = this.filterByMaxColumnLengths(headers, readerForCol, 50);
                    filteredHeaders = this.filterCustomIndexFields(filteredHeaders);
                    customIndexFields = filteredHeaders.toArray(new String[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (readerForCol != null) {
                        if (throwable != null) {
                            try {
                                readerForCol.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            readerForCol.close();
                        }
                    }
                }
                csvData = new CSVReader((Reader)new StringReader(csvDataAsString), separatorChar, '\"');
            }
            boolean reload = false;
            if (StringUtils.isNotBlank((String)dataResourceUid)) {
                logger.info((Object)"Data resource UID supplied, will attempt reload...");
                this.updateTempResource(dataResourceUid, datasetName, lineCount, alaId, uiUrl);
                reload = true;
            } else {
                logger.info((Object)"Data resource UID NOT supplied, will create a temp resource....");
                dataResourceUid = this.createTempResource(datasetName, lineCount, alaId, uiUrl);
                logger.info((Object)("Temp data resource created with UID: " + dataResourceUid));
            }
            UploaderThread ut = new UploaderThread();
            ut.reload = reload;
            ut.headers = headers;
            ut.datasetName = datasetName;
            ut.firstLineIsData = firstLineIsData;
            ut.csvData = csvData;
            ut.lineCount = lineCount;
            ut.uploadStatusDir = this.uploadStatusDir;
            ut.recordsToLoad = lineCount;
            ut.tempUid = dataResourceUid;
            ut.customIndexFields = customIndexFields;
            ut.threads = this.uploadThreads;
            ut.alaId = alaId;
            new Thread((Runnable)ut).start();
            logger.debug((Object)("Temporary UID being returned...." + dataResourceUid));
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("uid", dataResourceUid);
            return details;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private int doLineCount(String csvDataAsString) throws IOException {
        int lineCount = 0;
        try (BufferedReader reader = new BufferedReader(new StringReader(csvDataAsString));){
            while (reader.readLine() != null) {
                ++lineCount;
            }
        }
        return lineCount;
    }

    private char getSeparatorChar(HttpServletRequest request) {
        int separatorChar = 44;
        String separator = request.getParameter("separator");
        if (separator != null && "TAB".equalsIgnoreCase(separator)) {
            separatorChar = 9;
        }
        return (char)separatorChar;
    }

    private int doLineCount(File csvFile) throws IOException {
        int lineCount = 0;
        try (FileReader fr = new FileReader(csvFile);
             BufferedReader reader = new BufferedReader(fr);){
            while (reader.readLine() != null) {
                ++lineCount;
            }
        }
        return lineCount;
    }

    private File downloadCSV(String urlToZippedData) throws IOException {
        Throwable throwable;
        long fileId = System.currentTimeMillis();
        String zipFilePath = this.uploadTempDir + File.separator + fileId + ".zip";
        String unzippedFilePath = this.uploadTempDir + File.separator + fileId + ".csv";
        try (InputStream input = new URL(urlToZippedData).openStream();){
            throwable = null;
            try (FileOutputStream output = new FileOutputStream(zipFilePath);){
                IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var7_6 = null;
        try (FileInputStream fis = new FileInputStream(zipFilePath);){
            throwable = null;
            try (ZipInputStream zis = new ZipInputStream(fis);){
                ZipEntry ze = zis.getNextEntry();
                byte[] buffer = new byte[10240];
                try (FileOutputStream fos = new FileOutputStream(unzippedFilePath);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.flush();
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var7_6 = throwable4;
            throw throwable4;
        }
        return new File(unzippedFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean deleteTempResource(String datasetUid) throws IOException {
        DeleteMethod delete = new DeleteMethod(this.registryUrl + "/tempDataResource/" + datasetUid);
        delete.setRequestHeader("Authorization", this.apiKey);
        HttpClient httpClient = new HttpClient();
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)delete);
            Boolean bl = statusCode == 200 || statusCode == 204;
            return bl;
        }
        finally {
            try {
                delete.releaseConnection();
            }
            finally {
                httpClient.getHttpConnectionManager().closeIdleConnections(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTempResource(String datasetName, int lineCount, String alaId, String uiUrl) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        UserUpload uu = new UserUpload();
        uu.setNumberOfRecords(Integer.valueOf(lineCount));
        uu.setName(datasetName);
        uu.setAlaId(alaId);
        uu.setWebserviceUrl(this.webservicesRoot);
        uu.setUiUrl(uiUrl);
        uu.setApi_key(this.apiKey);
        String json = mapper.writeValueAsString((Object)uu);
        PostMethod post = new PostMethod(this.registryUrl + "/tempDataResource");
        post.setRequestHeader("Authorization", this.apiKey);
        post.setRequestBody(json);
        HttpClient httpClient = new HttpClient();
        try {
            httpClient.executeMethod((HttpMethod)post);
            logger.info((Object)("Retrieved: " + post.getResponseHeader("location").getValue()));
            String collectoryUrl = post.getResponseHeader("location").getValue();
            String string = collectoryUrl.substring(collectoryUrl.lastIndexOf(47) + 1);
            return string;
        }
        finally {
            try {
                post.releaseConnection();
            }
            finally {
                httpClient.getHttpConnectionManager().closeIdleConnections(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean updateTempResource(String uid, String datasetName, int lineCount, String alaId, String uiUrl) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        UserUpload uu = new UserUpload();
        uu.setNumberOfRecords(Integer.valueOf(lineCount));
        uu.setName(datasetName);
        uu.setAlaId(alaId);
        uu.setWebserviceUrl(this.webservicesRoot);
        uu.setUiUrl(uiUrl);
        uu.setApi_key(this.apiKey);
        String json = mapper.writeValueAsString((Object)uu);
        PostMethod post = new PostMethod(this.registryUrl + "/tempDataResource/" + uid);
        post.setRequestHeader("Authorization", this.apiKey);
        post.setRequestBody(json);
        HttpClient httpClient = new HttpClient();
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)post);
            Boolean bl = statusCode == 200 || statusCode == 201;
            return bl;
        }
        finally {
            try {
                post.releaseConnection();
            }
            finally {
                httpClient.getHttpConnectionManager().closeIdleConnections(0L);
            }
        }
    }
}

