/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.Store;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.web.util.matcher.IpAddressMatcher;
import org.springframework.web.client.RestOperations;

public class AbstractSecureController {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSecureController.class);
    protected Supplier<Stream<IpAddressMatcher>> excludedNetworkStream;
    protected Supplier<Stream<IpAddressMatcher>> includedNetworkStream;
    @Value(value="${ratelimit.window.seconds:300}")
    protected int rateLimitWindowSeconds;
    @Value(value="${ratelimit.count:5}")
    protected int rateLimitCount;
    @Value(value="${apikey.check.url:https://auth.ala.org.au/apikey/ws/check?apikey=}")
    protected String apiCheckUrl;
    @Value(value="${apikey.check.enabled:true}")
    protected Boolean apiKeyCheckedEnabled = true;
    @Inject
    protected RestOperations restTemplate;
    @Inject
    protected CacheManager cacheManager;

    @Value(value="${ratelimit.network.exclude:#{null}}")
    void setExcludedNetworks(String[] networks) {
        if (networks != null) {
            this.excludedNetworkStream = () -> Arrays.stream(networks).map(IpAddressMatcher::new);
        }
    }

    @Value(value="${ratelimit.network.include:#{null}}")
    void setIncludedNetworks(String[] networks) {
        if (networks != null) {
            this.includedNetworkStream = () -> Arrays.stream(networks).map(IpAddressMatcher::new);
        }
    }

    protected String getIPAddress(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-Forwarded-For");
        return ipAddress == null ? request.getRemoteAddr() : ipAddress;
    }

    protected String getUserAgent(HttpServletRequest request) {
        return request.getHeader("user-agent");
    }

    public boolean rateLimitRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String ipAddress = this.getIPAddress(request);
        boolean ratelimitIp = true;
        if (this.excludedNetworkStream != null) {
            ratelimitIp &= ((Stream)this.excludedNetworkStream.get()).noneMatch(networkMatcher -> networkMatcher.matches(ipAddress));
        }
        if (this.includedNetworkStream != null) {
            ratelimitIp |= ((Stream)this.includedNetworkStream.get()).anyMatch(networkMatcher -> networkMatcher.matches(ipAddress));
        }
        if (!ratelimitIp) {
            return false;
        }
        if (this.rateLimitWindowSeconds > 0 && this.rateLimitCount > 0) {
            ArrayDeque accessTimes;
            Cache cache = this.cacheManager.getCache("rateLimit");
            Element element = cache.get((Serializable)((Object)ipAddress));
            if (element == null) {
                accessTimes = new ArrayDeque();
            } else {
                accessTimes = (ArrayDeque)element.getValue();
                Instant windowStart = Instant.now().minusSeconds(this.rateLimitWindowSeconds);
                Instant oldestAccessTime = (Instant)accessTimes.getFirst();
                while (oldestAccessTime != null && oldestAccessTime.isBefore(windowStart)) {
                    accessTimes.removeFirst();
                    oldestAccessTime = (Instant)accessTimes.getFirst();
                }
            }
            if (accessTimes.size() < this.rateLimitCount) {
                accessTimes.addLast(Instant.now());
                element = new Element((Object)ipAddress, (Object)accessTimes, Boolean.valueOf(false), Integer.valueOf(this.rateLimitWindowSeconds), Integer.valueOf(0));
                cache.put(element);
                return false;
            }
        }
        return true;
    }

    public boolean shouldPerformOperation(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String apiKey = request.getParameter("apiKey");
        return this.shouldPerformOperation(apiKey, response, true);
    }

    public boolean shouldPerformOperation(String apiKey, HttpServletResponse response) throws Exception {
        return this.shouldPerformOperation(apiKey, response, true);
    }

    public boolean isValidKey(String keyToTest) {
        if (!this.apiKeyCheckedEnabled.booleanValue()) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)keyToTest)) {
            return false;
        }
        Cache cache = this.cacheManager.getCache("apiKeys");
        Element element = cache.get((Serializable)((Object)keyToTest));
        if (element != null && ((Boolean)element.getValue()).booleanValue()) {
            return true;
        }
        try {
            logger.debug("Checking api key: {}", (Object)keyToTest);
            String url = this.apiCheckUrl + keyToTest;
            Map response = (Map)this.restTemplate.getForObject(url, Map.class, new Object[0]);
            boolean isValid = (Boolean)response.get("valid");
            logger.debug("Checking api key: {}, valid: {}", (Object)keyToTest, (Object)isValid);
            if (isValid) {
                cache.put(new Element((Serializable)((Object)keyToTest), (Serializable)Boolean.valueOf(true)));
            }
            return isValid;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean shouldPerformOperation(String apiKey, HttpServletResponse response, boolean checkReadOnly) throws Exception {
        if (checkReadOnly && Store.isReadOnly()) {
            response.sendError(409, "Server is in read only mode.  Try again later.");
            return false;
        }
        if (!this.isValidKey(apiKey)) {
            response.sendError(403, "An invalid API Key was provided.");
            return false;
        }
        return !response.isCommitted();
    }
}

