/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="speciesListCache")
public class SpeciesListCache {
    private static final Logger logger = Logger.getLogger(SpeciesListCache.class);
    @Value(value="${list.tool.url:https://lists.ala.org.au}")
    protected String listToolUrl = null;
    @Inject
    private RestOperations restTemplate;

    public String getDisplayNameForList(String drUid) {
        if (StringUtils.isEmpty((CharSequence)drUid)) {
            return drUid;
        }
        try {
            String cleanedUid = drUid.replaceAll("\"", "");
            Map entity = (Map)this.restTemplate.getForObject(this.listToolUrl + "/ws/speciesList/" + cleanedUid, Map.class, new Object[0]);
            return (String)entity.get("listName");
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to lookup species list name: " + e.getMessage()));
            return drUid;
        }
    }
}

